proc get_subscribed {} {
    global GroupTable NumGroups GroupIndex 
    global ActiveTable NumActive NewsrcTime
    global Resources
    global Version Socket UnreadArticles VisibleGroups
    
    log_comm get_subscribed "" 1
    if {[info exists ActiveTable]} {unset ActiveTable}
    if {[info exists GroupTable]} {unset GroupTable}
    set NumGroups 0
    write_scroll "Getting list of active newsgroups..."
    if {[info exists Resources(NNTPSERVER)]} { 
	LoadActiveList $Socket nntp
    } else {
	set tmpfile [open $Resources(NEWSACTIVEFILE) "r"]
	LoadActiveList $tmpfile spool
	close $tmpfile
    }
    set i [catch {set file [open $Resources(NEWSRCFILE) r]}]
    if {$i} {
	set file [open $Resources(NEWSRCFILE) w]
	close $file
	set file [open $Resources(NEWSRCFILE) r]
    } 
    write_brief "Scanning newsrc file..."
    set i [catch {LoadNewsrc $Resources(NEWSRCFILE)}]
    if {$i} {return}
    set UnreadArticles 0
    set VisibleGroups 0
    for {set i 0} {$i < $NumGroups} {incr i} {
	set GroupTable($i,unread) \
	    [get_unread $GroupTable($i,name)]
	if {$GroupTable($i,unread) > 0} {
	    incr UnreadArticles $GroupTable($i,unread)
	    incr VisibleGroups
	}
    }
    set GroupIndex 0
    refresh_grouplist
    set GroupIndex [find_next_group]
    select_index $GroupIndex
    set NewsrcTime [get_access_time $Resources(NEWSRCFILE)]
    write_status 
    set_menu_state
}

proc enter_group {group} {
    global InterfaceBusy
    global GroupIndex GroupTable 
    global ArticleTable NumArticles CurrentArticle ArticleList
    global Mode Resources
    
    if {$InterfaceBusy} {return}
    log_comm enter_group "$group" 1
    interface_state busy
    clear_metainfo
    clear_text
    write_scroll "Getting article list for $group."
    set NumArticles 0
    set ArticleList {}
    set GroupIndex [group_index $group]
    if {$GroupIndex == -1} {
	puts stdout "Cannot find group $group"
    }
    set_mode "Articles"
    set Mode "Articles"
    set GroupTable($GroupIndex,irange) \
	[trim_range $GroupTable($GroupIndex,irange) $Resources(maxGrab)]
    set GroupTable($GroupIndex,range) \
	[adjust_range -1 \
	 $GroupTable($GroupIndex,last) \
	     [compute_inverse_range $GroupTable($GroupIndex,irange) \
	      $GroupTable($GroupIndex,last)]]
    
    load_article_list $group $GroupTable($GroupIndex,irange) \
	"{subject} {from}"
    if {$ArticleList == {}} {
	# no articles available... goto the last article available in the group.
	load_article_list $group $GroupTable($GroupIndex,last) "{subject} {from}"
    } else {
	foreach article $ArticleList {
	    set ArticleTable($article,status) "u"
	}
    }
    if {$ArticleList == {}} {
	# no articles are available for this group.... set up some defaults
	set b $GroupTable($GroupIndex,last)
	set ArticleTable($b,subject) "<<< Cancelled >>>"
	set ArticleTable($b,status) "r"
	set ArticleTable($b,number) $b
	set ArticleTable($b,from) "   "
	set ArticleTable($b,date) "Thu Jan 1 1971"
	set ArticleTable($b,lines) -1
	set ArticleTable($b,name) " "
	set NumArticles 1
	lappend ArticleList $b
	set ArticleList [lsort $ArticleList]
    }
    set CurrentArticle [lindex $ArticleList 0]
    if {![info exists CurrentArticle]} {
	puts stdout "WHAT THE HECK?"
	interface_state normal
	return
    }
    refresh_articlelist
    select_index 0
    set_menu_state
    interface_state normal
    if {$Resources(autoHelp)} {
	help_show articles_mode
    } else {
	goto_article $CurrentArticle
    }
}


proc quit_mode {} {
    global Mode InterfaceBusy OldListboxGeometry GroupIndex Resources

    if {$InterfaceBusy} {return}
    if {$Mode == "Groups"} {return}
    log_comm quit_mode "" 0
    if {$Mode == "Articles"} {
	# straighten up our group table...
	exit_current_group
	set_menu_state
    }
    if {$Mode == "GroupList" || $Mode == "NewGroups"} {
	if {[info commands .agcom] != {}} {
	    pack before .agcom .menubar {top fillx}
	    destroy .agcom
	}
	set Mode "Groups"
	refresh_grouplist
	.metainfo.listbox configure -geometry $OldListboxGeometry
	select_index $GroupIndex
	set_menu_state
	if {$Resources(autoHelp)} {
	    help_show groups_mode
	}
    }
}

proc exit_current_group {} {
    global GroupTable GroupIndex ArticleTable ArticleList NumArticles
    global Mode InterfaceBusy Resources

    if {$InterfaceBusy} {return}
    log_comm exit_current_group "" 0
    set GroupTable($GroupIndex,irange) [adjust_range -1 \
					    $GroupTable($GroupIndex,last)\
					    [compute_new_range]]
    set GroupTable($GroupIndex,range) \
	[adjust_range -1 \
	     $GroupTable($GroupIndex,last) \
	     [compute_inverse_range $GroupTable($GroupIndex,irange) \
	      $GroupTable($GroupIndex,last)]]
    
    set GroupTable($GroupIndex,unread) \
	[get_unread $GroupTable($GroupIndex,name)] 
    unset ArticleTable
    unset ArticleList
    clear_text
    set Mode "Groups"
    refresh_grouplist
    set i [find_next_group]
    if {$i == -1} {
	write_scroll "No more unread articles in subscribed newsgroups..."
    } else {
	select_index $i
	set GroupIndex $i
    }
    if {$Resources(autoHelp)} {
	help_show groups_mode
    }
}
    
proc goto_article {number} {
    global GroupTable GroupIndex ArticleTable ArticleList CurrentArticle
    global NumArticles InterfaceBusy CurrentUnread

    if {$InterfaceBusy} {return}
    log_comm goto_article "$number" 1
    interface_state busy
    write_scroll "Fetching article $number"
    if {![info exists ArticleTable($number,status)]} {
	set text "\n\n\n\n\n\nThis article is not available because it was cancelled."
    } else {
	set text [get_article $GroupTable($GroupIndex,name) $number]
    }
    if {$text == ""} {
	interface_state normal
	return -1
    }
    set_text $text
    set CurrentArticle $number
    if {[lsearch $ArticleList $number] == -1} {
	insert_article $number
    } else {
	if {$ArticleTable($number,status) == "u"} {
	    set ArticleTable($number,status) "r"
	    incr CurrentUnread -1
	}
	update_articlelist $number
    }
    set i [lsearch $ArticleList $number]
    select_index $i
    update idletasks
    write_status
    interface_state normal
}


proc goto_current_selection {} {
    global Mode GroupTable GroupIndex ArticleTable ArticleList
    global InterfaceBusy

    if {$InterfaceBusy} {return}
    if {[.metainfo.listbox curselection] == ""} {
	return
    }
    if {$Mode == "Groups"} {
	set Newsgroup [lindex [get_current_selection 1] 0]
	set Newsgroup [string range $Newsgroup 5 end]
	enter_group $Newsgroup
	return;
    } 
    if {$Mode == "Articles"} {
	set number [lindex $ArticleList \
		    [lindex [.metainfo.listbox curselection] 0]]
	goto_article $number
    }
    if {$Mode == "GroupList" || $Mode == "NewGroups"} {
	set_group_status toggle
    }
} 


proc do_the_right_thing {} {
    global Mode InterfaceBusy

    if {$InterfaceBusy} {return}
    if {$Mode == "Groups"} {
	goto_current_selection
	return
    }
    if {$Mode == "Articles"} {
	if {[view_action text pagedown] != -1} {
	    return
	}
	set new_article [find_next_unread forward 1]
	if {$new_article == -1} {
	    quit_mode
	} else {
	    goto_article $new_article
	}
    }
    if {$Mode == "GroupList" || $Mode == "NewGroups"} {
	set_group_status toggle
    }
}


proc view_action {which action} {
    global InterfaceBusy

    if {$InterfaceBusy} {return}
    if {$which == "metainfo"} {
	set s ".metainfo.vertical"
    } else {
	set s ".info.vertical"
    }
    set list [$s get]
    set total [lindex $list 0]
    set units [lindex $list 1]
    set top [lindex $list 2]
    set bottom [lindex $list 3]
    set command [lindex [$s config -command] 4]
    
    if {$action == "pagedown"} {
        set pos [expr [expr "$top + $units"]-3]
    } 
    if {$action == "pageup"} {
        set pos [expr [expr "$top - $units"]+3]
    }
    if {$action == "lineup"} {
        incr top -1
        set pos $top
    }
    if {$action == "linedown"} {
        incr top
        set pos $top
    }
    if {$action == "top"} {
	set pos 0
    }
    if {$pos > $total } {
        return -1
    }
    if {$pos < 0} {
        set pos 0
    }
    $s set $total $units $pos [expr "$pos + $units - 1"]
    [lindex $command 0] [lindex $command 1] $pos
    return $pos
}


proc select_action {flag} {
    global InterfaceBusy

    if {$InterfaceBusy} {return}
    set a [.metainfo.listbox curselection]
    if {$a == ""} {
	return
    }
    set b [lindex $a 0]
    set c [.metainfo.listbox size]
    set list [.metainfo.vertical get]
    if {$flag == "restore"} {
    }
    if {$flag == "lineup"} {
	incr b -1
    }
    if {$flag == "linedown"} {
	incr b 1
    }
    if {$flag == "pagedown"} {
	incr b [lindex $list 1]
    }
    if {$flag == "pageup"} {
	incr b -[lindex $list 1]
    }
    if {$b >= $c} {
	set b [expr $c-1]
    }
    if {$b < 0} {
	set b 0
    }
    set_view metainfo $b
    
    .metainfo.listbox select from $b
    .metainfo.listbox select to $b
}



proc article_action {action} {
    global Mode NumGroups 
    global InterfaceBusy

    if {$InterfaceBusy} {return}
    log_comm article_action "$action" 1
    if {$Mode != "Articles"} {
	return
    }
    interface_state wait	
    if {$action == "Next"} {
	if {$Mode == "Articles"} {
	    set determiner "next_article"
	    set failmessage "No further articles found..."
	} else {
	    set determiner "group_find all next"
	    set failmessage "No further groups found..."
	}
    }
    if {$action == "Previous"} {
	if {$Mode == "Articles"} {
	    set determiner "prev_article"
	    set failmessage "No previous article found..."
	} else {
	    set determiner "group_find all previous"
	    set failmessage "No previous group found..."
	}
    }
    if {$action == "NextUnread"} {
	if {$Mode == "Articles"} {
	    set determiner "find_next_unread forward 0"
	    set failmessage ""
	} else {
	    set determiner "group_find unread next"
	    set failmessage "No further groups with unread articles found..."
	}
    } 
    if {$action == "PrevUnread"} {
	if {$Mode == "Articles"} {
	    set determiner "find_next_unread backward 0"
	    set failmessage "No unread articles preceding this one..."
	} else {
	    set determiner "group_find unread previous"
	    set failmessage "No previous groups with unread articles found..."
	}
    }
    if {$action == "NextSubject"} {
	set determiner "find_next_subject forward"
	if {$Mode == "Groups"} {
	    # no equivalent for this command in group mode
	    interface_state normal
	    return -1;
	}
	set failmessage "No next article found with same subject..."
    }
    if {$action == "PrevSubject"} {
	set determiner "find_next_subject backward"
	if {$Mode == "Groups"} {
	    # no equivalent for this command in group mode.
	    interface_state normal
	    return -1;
	}
	set failmessage "No previous article found with same subject..."
    }
    set answer [eval $determiner]
    interface_state normal
    if {$answer != -1} {
	# goto the article/group the determiner found.
	if {$Mode == "Articles"} {
	    goto_article $answer
	} else {
	    enter_group $answer
	}
	interface_state normal
	return 
    }
    if {$failmessage == ""} {
	quit_mode
    } else {
	write_brief $failmessage
    }
    return
}

proc send_interrupt {} {
    global ControlC

    set ControlC 1
}


proc catch_up {} {
    global ArticleTable ArticleList NumArticles
    global GroupTable GroupIndex NumGroups GroupList
    global Mode InterfaceBusy ViewUnread

    if {$InterfaceBusy} {return}
    log_comm catch_up "" 1
    if {$Mode == "Groups"} {
	set list [.metainfo.listbox curselection]
	set offset 0
	foreach group $list {
	    if {!$ViewUnread} {
		# convert listbox index into actual GroupTable index.
		# Note that when we are dealing with a multiple-selection
		# in the listbox, we need to increase the offset for each group
		# that we mark as read.... otherwise the indices will be off.
		incr group $offset
		set group [group_index [group_name $group]]
		incr offset -1
	    }
	    set index [lindex $GroupList $group]
	    set GroupTable($index,unread) 0
	    set GroupTable($index,range) "1-$GroupTable($index,last)"
	    set GroupTable($index,irange) ""
	}
	refresh_grouplist
	set i [lindex $list 0]
	if {$i >= [.metainfo.listbox size]} {
	    set i [expr [.metainfo.listbox size]-1]
	}
	select_index $i
	return
    }
    if {$Mode == "Articles"} {
	foreach article $ArticleList {
	    set ArticleTable($article,status) "r"
	}
	quit_mode
	return
    }
}


proc mark_article {mark} {
    global ArticleTable ArticleList NumArticles
    global Mode InterfaceBusy CurrentUnread
    
    if {$InterfaceBusy} {return}
    if {$Mode != "Articles"} {return}
    set list [.metainfo.listbox curselection]
    foreach item $list {
	set number [lindex $ArticleList $item]
	if {($mark == "u") || ($mark == "r")} {
	    set ArticleTable($number,status) "$mark"
	    if {$mark == "u"} {
		incr CurrentUnread 1
	    } else {
		incr CurrentUnread -1
	    }
	} else {
	    if {$ArticleTable($number,status) == "u"} {
		set ArticleTable($number,status) "r"
		incr CurrentUnread -1
	    } else {
		if {$ArticleTable($number,status) == "r"} {
		    set ArticleTable($number,status) "u"
		    incr CurrentUnread 1
		}
	    }
	}
	update_articlelist $number
    }
    .metainfo.listbox select from [lindex $list 0]
    .metainfo.listbox select to [lindex $list [expr [llength $list]-1]]
    write_status
}


proc save_newsrc {} {
    global GroupTable NumGroups NewsrcTime InterfaceBusy
    global Resources

    if {$InterfaceBusy} {return}
    log_comm save_newsrc "" 1
    interface_state busy
    if {$NewsrcTime != -1} {
	if {$NewsrcTime != [get_access_time $Resources(NEWSRCFILE)]} {
	    #write_brief "Someone updated the newsrc underneath us!!!!"
	}
    }
    set tmpfile [new_tmp_file tmpnewsrc]
    write_scroll "Saving newsrc file..."
    set file [open $tmpfile "w"]
    for {set i 0} {$i < $NumGroups} {incr i} {
	if {$GroupTable($i,status) == "u"} {	
	    puts $file "$GroupTable($i,name)! $GroupTable($i,range)"
	} else 	{
	    puts $file "$GroupTable($i,name): $GroupTable($i,range)"
	}
    }
    close $file
    catch {SaveNewsrc $Resources(NEWSRCFILE) $tmpfile}
    write_status
    interface_state normal
}



proc post_article {type} {
    global GroupTable GroupIndex ArticleTable ArticleList CurrentArticle
    global Mode env Socket 
    global PostingList InterfaceBusy Options Resources

    if {$Options(Gce)} {
	set editorcomm $Resources(gceEditor)
    } else {
	set editorcomm $Resources(EDITOR_COMMAND)
    }
    if {$InterfaceBusy} {return}
    if {$type == "followup" || $type == "Followup"} {
	if {$Mode != "Articles"} {
	    write_scroll "No current article to followup to..."
	    return
	}
    }
    # 
    # Make sure all of the article's fields have been loaded in.
    # This won't be the case if we are using nntp... this is because
    # we don't get all of the article fields unless we need them -like now.
    #
    ensure_article $CurrentArticle
    write_scroll "Loading editor for posting..."
    log_comm post_article "$type" 1
    set headerfile "/tmp/.tkhead-[get_access_time /tmp]"
    set file [open $headerfile "w"]
    if {[info exists ArticleTable($CurrentArticle,followup-to)]} {
	if {[string length $ArticleTable($CurrentArticle,followup-to)] > 4} {
	    puts $file "Newsgroups: $ArticleTable($CurrentArticle,followup-to)"
	} else {
	    puts $file "Newsgroups: $GroupTable($GroupIndex,name)"
	}
    } else {
	puts $file "Newsgroups: $GroupTable($GroupIndex,name)"
    }
    if {$type == "followup" || $type == "Followup"} {
	if {[regexp "^Re\:" $ArticleTable($CurrentArticle,subject) junk]} {
	    puts $file "Subject: $ArticleTable($CurrentArticle,subject)"
	} else { 
	    puts $file "Subject: Re: $ArticleTable($CurrentArticle,subject)"
	}
    } else {
	puts $file "Subject: "
    }
    if {[string first "inews" $Resources(POSTINGPROG)] == -1} {
	if {[info exists Resources(NAME)]} {
	    puts $file "From: $Resources(USER)@$Resources(HOSTADDR) ($Resources(NAME))"
	} else {
	    puts $file "From: $Resources(USER)@$Resources(HOSTADDR)"
	}
    }
    puts $file "Summary: "
    if {$type == "followup" || $type == "Followup"} {
	if {$ArticleTable($CurrentArticle,references) != "???"} {
	    puts $file "References: $ArticleTable($CurrentArticle,references) $ArticleTable($CurrentArticle,message-id)"
	} else {
	    puts $file "References: $ArticleTable($CurrentArticle,message-id)"
	}
    }
    puts $file "Followup-To: "
    puts $file "Distribution: "
    puts $file "Organization: $Resources(ORGANIZATION)" 
    puts $file "Keywords: \n"
    if {$type == "Followup"} {
	set count 1
	# Prepend the quoted text with an attribution
	puts $file "     $ArticleTable($CurrentArticle,name) wrote in article $ArticleTable($CurrentArticle,message-id) :"
	set text [.info.text get $count.0 end]
	set list [split $text "\n"]
	set header_done 0
	foreach line $list {
	    if {$line == {}} {
		set header_done 1
	    }
	    if {$header_done} {
		puts $file ">$line"
	    }
	}
    }
    close $file
    if {[info exists Resources(NNTPPOST)] || \
	[info exists Resources(NNTPSERVER)] \
	    || [info exists Resources(POSTINGPROG)]} {
	    # Call up an editor with the header file as the final
	    # argument and have a "flag" environment variable be set
	    # when the editor is done.  We'll check it periodically
	    exec /bin/sh -c "($editorcomm $headerfile ; /usr/bin/touch $headerfile.done) &" &
	    if {$PostingList == {}} {
		after 3000 check_for_posts
	    }
	    if {$type == "original"} {
		lappend PostingList \
		    "{post} {$GroupTable($GroupIndex,name)} {original} {$headerfile}"
	    } else {
		lappend PostingList \
		    "{post} {$GroupTable($GroupIndex,name)} {$CurrentArticle} {$headerfile}"
	    }	    
	}
}



proc mail_article {type} {
    global CurrentArticle GroupIndex GroupTable ArticleTable 
    global env PostingList InterfaceBusy
    global Mode Options Resources

    if {$Options(Gce)} {
	set editorcomm "$Resources(gceMailer) -i"
    } else {
	set editorcomm $Resources(EDITOR_COMMAND)
    }
    if {$InterfaceBusy} {return}
    if {$Mode != "Articles" && $type != "compose"} {
	write_brief "No article to mail a response to."
	return
    }
    # 
    # Make sure all of the article's fields have been loaded in.
    # This won't be the case if we are using nntp... this is because
    # we don't get all of the article fields unless we need them -like now.
    #
    ensure_article $CurrentArticle
    write_scroll "Loading editor for mailing..."
    log_comm mail_article "$type" 1
    set headerfile "/tmp/.tkhead-[get_access_time /tmp]"
    set file [open $headerfile "w"]
    if {$type != "compose"} {
	puts $file "To: $ArticleTable($CurrentArticle,email)"
	puts $file "Cc: "
	puts $file "Bcc: "
	if {[regexp "^Re\:" $ArticleTable($CurrentArticle,subject) junk]} {
	    puts $file "Subject: $ArticleTable($CurrentArticle,subject)"
	} else { 
	    puts $file "Subject: Re: $ArticleTable($CurrentArticle,subject)\n"
	}
    } else {
	puts $file "To: "
	puts $file "Cc: "
	puts $file "Bcc: "
	puts $file "Subject: \n"
    }
    if {$type == "Reply"} {
	set count 1
	set text [.info.text get $count.0 end]
	set list [split $text "\n"]
	set header_done 0
	foreach line $list {
	    if {$line == {}} {
		set header_done 1
	    }
	    if {$header_done} {
		puts $file ">$line"
	    }
	}
    }
    close $file
    if {$Options(Gce)} {
	exec /bin/sh -c "$editorcomm $headerfile &" &
    } else {
	exec /bin/sh -c "($editorcomm $headerfile ; /usr/bin/touch $headerfile.done) &" &
	if {$PostingList == {}} {
	    after 3000 check_for_posts
	} 
	if {$type != "compose"} {
	    lappend PostingList "{mail} {$GroupTable($GroupIndex,name)} {$CurrentArticle} {$headerfile}"
	} else {
	    lappend PostingList "{mail} {NA} {NA} {$headerfile}"
	}
    }
}


proc save_article {} {
    global ArticleTable CurrentArticle GroupTable GroupIndex
    global ArticleList InterfaceBusy Mode LastSaveName

    if {$InterfaceBusy} {return}
    if {$Mode != "Articles"} {
	write_brief "No article available to save..."
	return
    }
    log_comm save_article "" 1
    set filename [prompt_dialog .save_file 800 "Filename Prompt" "Please enter filename to save article(s) to:\nDefault directory is ~/News." $GroupTable($GroupIndex,name)]
    if {$filename == ""} {
	return
    }
    set i [string first "/" $filename]
    if {$i == -1} {
	# make the file go in the user's News directory in their home directory...
	set filename "~/News/$filename"
    }
    if {[file exists $filename]} {
	set appending 1
    } else {
	set appending 0
    }
    set i [catch {set file [open $filename "a+"]}]
    if {$i} {
	# problem opening file 
	if {![file isdirectory ~/News]} {
	    catch "exec mkdir [glob ~/News]"
	    set i [catch {set file [open $filename "a+"]}]
	}
	if {$i} {
	    write_scroll "Unable to open file $filename for writing..."
	    return
	}
    }
    interface_state wait
    set catch_ret [catch {exec date} date]
    if {$catch_ret != 0} {
	# just set the date to the turn of the century
	set date "Mon Jan 1 00:00:01 2000"
    }
    set list [.metainfo.listbox curselection]
    foreach index $list {
	set number [lindex $ArticleList $index]
	set text [get_article $GroupTable($GroupIndex,name) $number]
	if {$text != ""} {
	    # Inform the user of the save....
	    if {$appending} {
		write_brief "Article $number appended to file $filename..."
	    } else {
		write_brief "Saving article $number to new file $filename..."
	    }
	    # Make sure that the From: field is first...
	    puts $file "From $ArticleTable($number,email) $date"
	    set lines [split $text "\n"]
	    foreach line $lines {
		if {[string range "$line" 0 4] != "From:"} {  
		    puts $file "$line"
		}
	    } 
	}
    }
    close $file
    interface_state normal
}


proc rescan {save} {
    global GroupTable NumGroups
    global InterfaceBusy Mode

    if {$InterfaceBusy} {return -1}
    if {$Mode != "Groups" && $Mode != "GroupList" && $Mode != "NewGroups"} {
	write_scroll "Cannot rescan when in a newsgroup..."
	return -1
    }
    log_comm rescan "$save" 1
    if {$save} {
	save_newsrc
    }
    interface_state busy
    get_subscribed
    interface_state normal
    return 
}



proc add_newsgroup {enter} {
    global Resources
    global GroupTable NumGroups ActiveTable
    global InterfaceBusy Mode
    
    if {$InterfaceBusy} {return}
    if {$Mode != "Groups"} {
	write_brief "Cannot use this command in $Mode mode"
	return
    }
    interface_state wait
    log_comm add_newsgroup "$enter" 1
    set groupname [prompt_dialog .goto 800 "Newsgroup Prompt" "Please enter destination newsgroup:" ""]
    if {$groupname == ""} {
	# user cancelled.
	interface_state normal
	return
    }
    set i [group_index $groupname]
    if {$i == -1} {
	set file [open $Resources(NEWSRCFILE) "r"]
	set newsrcline [FileGetLine $file $groupname]
	close $file
	set i [string first " " $newsrcline]
	if {$newsrcline == "" || $i == -1} {
	    set range ""
	} else {
	    set range [string range $newsrcline [expr $i+1] end]
	}

	# now that we know the range of articles that we've read for this 
	# group, we need to get the groups statistics.  If the ActiveTable
	# is in memory, then we can just get it from there, otherwise we'll
	# have to stat the group to obtain the information we need.

	if {[info exists ActiveTable($groupname,name)]} {
	    set first $ActiveTable($groupname,first)
	    set last $ActiveTable($groupname,last)
	} else {
	    set list [stat_group $groupname]
	    set first [lindex $list 1]
	    set last [lindex $list 2]
	}
	append_newsgroup $groupname $first $last $range
    }
    interface_state normal
    if {$enter} {
	enter_group $groupname
    } else {
	refresh_grouplist
    }
}




proc all_groups {new} {
    global Mode GroupTable GroupIndex NumGroups 
    global ActiveTable NumActive Socket InterfaceBusy 
    global OldListboxGeometry SubscribeList UnsubscribeList NumActive
    global Resources

    if {$InterfaceBusy} {return}
    if {$Mode != "Groups"} {
	write_brief "Command cannot be used in $Mode mode..."
	return -1
    }
    log_comm all_groups "$new" 1
    interface_state busy
    set OldListboxGeometry [lindex [.metainfo.listbox configure -geometry] 4]
    if {$new} {
	set Mode "NewGroups"
    } else {
	set Mode "GroupList"
    }
    clear_metainfo
    set UnsubscribeList ""
    set SubscribeList ""
    for {set i 0} {$i < $NumGroups} {incr i} {
	lappend SubscribeList $GroupTable($i,name)
    }
    if {$new} {
	write_scroll "Checking for new newsgroups..."
    } else {
	write_scroll "Loading list of newsgroups..."
    }
    if {$new} {
	set ans [load_new_groups]
    } else {
	set ans [load_active_groups]
    }
    if {$ans == {}} {
	interface_state normal
	write_status
	quit_mode 
	return -1
    }
    select_index 0
    if {!$new} {
	.metainfo.listbox configure -geometry 2000x2000
    }
    ag_command_frame
    pack before .menubar .agcom {top fillx}
    pack unpack .menubar
    if {$Resources(autoHelp)} {
	help_show grouplist_mode
    }
    interface_state normal
    write_status
    return 1
}


proc set_group_status {val} {
    global SubscribeList Mode UnsubscribeList

    if {$Mode != "GroupList" && $Mode != "NewGroups"} {
	write_brief "Command not valid in mode $Mode..."
	return
    }
    set list [.metainfo.listbox curselection]
    foreach sel $list {
	set line [.metainfo.listbox get $sel]
	set group [string range $line 16 end]
	if {$val == "toggle"} {
	    set i [string first " " $line]
	    set status [string range $line 0 [expr $i-1]]
	    if {$status == "subscribed"} {
		set i [lsearch $SubscribeList $group]
		if {$i != -1} {
		    # remove this group from the SubscribeList
		    set SubscribeList [lreplace $SubscribeList $i $i]
		    lappend UnsubscribeList $group
		}
		set line "unsubscribed    $group"
	    } else {
		lappend SubscribeList $group
		set line "subscribed      $group"
	    }
	}
	if {$val == "subscribe"} {
	    set i [lsearch $SubscribeList $group]
	    if {$i == -1} {
		lappend SubscribeList $group
	    } 
	    set line "subscribed      $group"
	}
	if {$val == "unsubscribe"} {
	    set i [lsearch $SubscribeList $group]
	    if {$i != -1} {
		set SubscribeList [lreplace $SubscribeList $i $i]
	    }
	    lappend UnsubscribeList $group
	    set line "unsubscribed    $group"
	}
	.metainfo.listbox delete $sel
	.metainfo.listbox insert $sel $line
    }
    .metainfo.listbox select from [lindex $list 0]
    .metainfo.listbox select to [lindex $list [expr [llength $list]-1]]
    write_status
}



proc unsubscribe {} {
    global Mode InterfaceBusy
    global GroupTable NumGroups GroupName2Index GroupIndex

    if {$InterfaceBusy} {return}
    interface_state wait
    log_comm unsubscribe "" 1
    if {$Mode == "Groups"} {
	set list [.metainfo.listbox curselection]
	set offset 0
	foreach sel $list {
	    incr sel $offset
	    set name [group_name $sel]
	    write_scroll "Unsubscribing to $name..."
	    delete_group $name
	    if {$GroupIndex >= $NumGroups} {
		incr GroupIndex -1
	    }
	    if {$GroupIndex < 0} {
		set GroupIndex 0
	    }
	    incr offset -1
	}
	refresh_grouplist
	select_index [lindex $list 0]
	interface_state normal
    }
    if {$Mode == "Articles"} {
	interface_state normal
	set i $GroupIndex
	quit_mode
	interface_state busy
	delete_group $GroupTable($i,name)
	set GroupIndex $i
	if {$GroupIndex >= $NumGroups} {
	    incr GroupIndex -1
	}
	if {$GroupIndex < 0} {
	    set GroupIndex 0
	}
	refresh_grouplist
	set i [find_next_group]
	if {$i == -1} {
	    write_scroll "No more unread articles in subscribed newsgroups..."
	} else {
	    select_index $i
	    set GroupIndex $i
	}
	interface_state normal
    }
} 

	      
proc preferences {} {
    global LIBRARY_DIR 
    
    exec $LIBRARY_DIR/resedit $LIBRARY_DIR/prefs [winfo name .] \
	resedit_apply &
}

proc save_tknewsrc {} {
    global InterfaceOrientation Resources

    interface_state busy
    write_scroll "Saving tknewsrc file..."
    set twidth [lindex [.info.text configure -width] 4]
    set theight [lindex [.info.text configure -height] 4]
    set lgeom [lindex [.metainfo.listbox configure -geometry] 4]
    set list ""
    lappend list "metainfo.listbox.geometry $lgeom"
    lappend list "info.text.width $twidth"
    lappend list "info.text.height $theight"
    lappend list "windowGeometry [wm geometry .]"
    lappend list "layout $InterfaceOrientation"
    lappend list "rescanDelay [expr $Resources(rescanDelay)/60000]"
    lappend list "maxGrab $Resources(maxGrab)"
    lappend list "autoHelp $Resources(autoHelp)"
    lappend list "followupFont $Resources(followupFont)"
    lappend list "followupExpr $Resources(followupExpr)"
    lappend list "highlightExpr $Resources(highlightExpr)"
    lappend list "highlightBorderWidth $Resources(highlightBorderWidth)"
    lappend list "disableKeyboard $Resources(disableKeyboard)"
    if {$Resources(textFont) != ""} {
	lappend list "textFont $Resources(textFont)"
    }
    if {$Resources(infoFont) != ""} {
	lappend list "infoFont $Resources(infoFont)"
    }
    set_tknewsrc $list
    interface_state normal
}

    
proc list_old {} {
    global InterfaceBusy Mode GroupTable GroupIndex ArticleTable
    global ArticleList

    if {$InterfaceBusy} {return}
    if {$Mode != "Articles"} {
	return
    }
    interface_state busy
    set gnum [expr [lindex $ArticleList 0]-$GroupTable($GroupIndex,first)]
    set num [prompt_dialog .howmany 800 "List Old" "Grab how many old articles? ($gnum apparently available)" "80"]
    
    if {[catch {set i [expr $num+1]}]} {
	interface_state normal
	return
    }
    if {$num < 0 || $num > $gnum} {
	interface_state normal
	return
    }
    set first [lindex $ArticleList 0]
    write_scroll "Loading $num articles for $GroupTable($GroupIndex,name).  This may take a while..."
    if {[info exists ArticleList]} {
	load_article_list $GroupTable($GroupIndex,name) \
	    "[expr [lindex $ArticleList 0]-$num]-[lindex $ArticleList 0]" \
	    "{subject} {from}"
    }
    set j $first
    for {set i 0} {$i < $num} {incr i} {
	incr j -1
	if {[info exists ArticleTable($j,status)]} {
	    set ArticleTable($j,status) "r"
	}
    }
    refresh_articlelist
    interface_state normal
}
