/* xsmath.c - xscheme built-in arithmetic functions */
/*	Copyright (c) 1988, by David Michael Betz
	All Rights Reserved
	Permission is granted for unrestricted non-commercial use	*/

#include "xscheme.h"
#include <math.h>

/* external variables */
extern LVAL true;

/* forward declarations */
#ifdef __STDC__
static LVAL binary(int fcn);
static LVAL unary(int fcn);
static LVAL predicate(int fcn);
static LVAL compare(int fcn);
static FLOTYPE toflotype(LVAL val);
static void checkizero(FIXTYPE iarg);
static void checkineg(FIXTYPE iarg);
static void checkfzero(FLOTYPE farg);
static void checkfneg(FLOTYPE farg);
static void badiop(void);
static void badfop(void);
#else
static LVAL unary();
static LVAL binary();
static LVAL predicate();
static LVAL compare();
static FLOTYPE toflotype();
#endif

/* xexactp - built-in function 'exact?' */
/**** THIS IS REALLY JUST A STUB FOR NOW ****/
LVAL xexactp()
{
    (void)xlganumber();
    xllastarg();
    return (NIL);
}

/* xinexactp - built-in function 'inexact?' */
/**** THIS IS REALLY JUST A STUB FOR NOW ****/
LVAL xinexactp()
{
    (void)xlganumber();
    xllastarg();
    return (true);
}

/* xatan - built-in function 'atan' */
LVAL xatan()
{
    LVAL arg,arg2;
    FLOTYPE val;
    
    /* get the first argument */
    arg = xlganumber();
    
    /* handle two argument (atan y x) */
    if (moreargs()) {
	arg2 = xlganumber();
	xllastarg();
	val = atan2(toflotype(arg),toflotype(arg2));
    }
    
    /* handle one argument (atan x) */
    else
	val = atan(toflotype(arg));

    /* return the resulting flonum */
    return (cvflonum(val));
}

/* xfloor - built-in function 'floor' */
LVAL xfloor()
{
    LVAL arg;

    /* get the argument */
    arg = xlgetarg();
    xllastarg();

    /* check its type */
    if (fixp(arg))
	return (arg);
    else if (floatp(arg))
	return (cvfixnum((FIXTYPE)floor(getflonum(arg))));
    xlbadtype(arg);
    return (NIL); /* never reached */
}

/* xceiling - built-in function 'ceiling' */
LVAL xceiling()
{
    LVAL arg;

    /* get the argument */
    arg = xlgetarg();
    xllastarg();

    /* check its type */
    if (fixp(arg))
	return (arg);
    else if (floatp(arg))
	return (cvfixnum((FIXTYPE)ceil(getflonum(arg))));
    xlbadtype(arg);
    return (NIL); /* never reached */
}

/* xround - built-in function 'round' */
LVAL xround()
{
    FLOTYPE x,y,z;
    LVAL arg;

    /* get the argument */
    arg = xlgetarg();
    xllastarg();

    /* check its type */
    if (fixp(arg))
	return (arg);
    else if (floatp(arg)) {
	x = getflonum(arg);
	y = floo                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             