/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/FKind_.h"
#include "inc/NodTyp_.h"
#include "inc/ParseKind_.h"
#include "inc/RunSpc.h"
#include "inc/Str.h"


int		LogLevel;
tp_FileName	LogFileName;
tp_FilDsc	LogFD;


Init_Log()
{
   LogLevel = 3;
   LogFD = StdOutFD;
   LogFileName = "1";
   }/*Init_Log*/;


Set_LogLevel(NewLevel)
   int NewLevel;
{
   if (NewLevel < 1 || NewLevel > 6) {
      Writeln(StdOutFD, "** Log Level must be between 1 and 6 **");
      return; }/*if*/;
   LogLevel = NewLevel;
   }/*Set_LogLevel*/;


Set_LogFile(FileName)
   tp_FileName FileName;
{
   tp_FilDsc FilDsc;

   if (FileName == LogFileName || strcmp(FileName, LogFileName) == 0) {
      LogFileName = FileName;
      return; }/*if*/;

   /*select*/{
      if (strcmp(FileName, "1") == 0) {
	 FilDsc = StdOutFD;
      }else if (strcmp(FileName, "2") == 0) {
	 FilDsc = StdErrFD;
      }else{
	 FilDsc = FileName_WFilDsc(FileName);
	 if (FilDsc == ERROR) {
	    return; }/*if*/; };}/*select*/;
   if (LogFD != StdOutFD && LogFD != StdErrFD) Close(LogFD);
   LogFileName = FileName;
   LogFD = FilDsc;
   }/*Set_LogFile*/;


Do_Log(Message, FilHdr)
   tp_Str Message;
   tp_FilHdr FilHdr;
{
   tps_Str OdinName;

   Write(LogFD, "** ");
   Write(LogFD, Message);
   Write(LogFD, " ");
   FilHdr_OdinName(OdinName, FilHdr);
   Writeln(LogFD, OdinName);
   }/*Do_Log*/;


tp_FilHdr
OdinName_FilHdr(OdinName)
   tp_Str OdinName;
{
   tp_Nod DS_Nod;
   tp_PrmFHdr PrmFHdr;
   tp_FilHdr FilHdr;
   tp_Prms Prms;

   DS_Nod = Parse(FILE_PARSE, OdinName);
   PrmFHdr = Nod_PrmFHdr(DS_Nod);
   Ret_Nod(DS_Nod);
   Use_PrmFHdr(&FilHdr, &Prms, PrmFHdr);
   return FilHdr;
   }/*OdinName_FilHdr*/;


WriteStruct(FilDsc, FilHdr)
   tp_FilDsc FilDsc;
   tp_FilHdr FilHdr;
{
   tps_RunSpc _RunSpc; tp_RunSpc RunSpc = &_RunSpc;
   int i;

   FilHdr_RunSpc(RunSpc, FilHdr);
   for (i=0; i<RunSpc->NumOuts; i++) {
      WriteOdinName(FilDsc, RunSpc->OutFilHdrs[i]); }/*for*/;
   Ret_RunSpc(RunSpc);
   }/*WriteStruct*/;


WriteOdinName(FilDsc, FilHdr)
   tp_FilDsc FilDsc;
   tp_FilHdr FilHdr;
{
   tps_Str OdinName;

   FilHdr_OdinName(OdinName, FilHdr);
   Writeln(FilDsc, OdinName);
   }/*WriteOdinName*/;


WritePrmOdinName(FilDsc, FilHdr, Prms)
   tp_FilDsc FilDsc;
   tp_FilHdr FilHdr;
   tp_Prms Prms;
{
   tps_Str OdinName;

   FilHdr_OdinName(OdinName, FilHdr);
   Prms_Str(Tail(OdinName), Prms);
   Writeln(FilDsc, OdinName);
   }/*WritePrmOdinName*/;


Do_Export()
{
   tps_FileName ExportFileName;
   tp_FilHdr FilHdr;
   tp_Signal Signal;

   Get_ExportFileName(ExportFileName);
   if (!Exists(ExportFileName) || Empty(ExportFileName)) {
      return; }/*if*/;

   FilHdr = Get_Drv(HostFN_FilHdr(ExportFileName),
		    FK_User, CompoundFilTyp, DfltPrms, DfltIdent);
   GetAllReqs(&Signal, FilHdr);
   Ret_FilHdr(FilHdr);
   }/*Do_Export*/;


