/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Str.h"
#include "inc/TClass_.h"
#include "inc/Tool.h"


tp_TClass
Tool_TClass(Tool) tp_Tool Tool;{ return Tool->TClass;};


tp_InpEdg
Tool_InpEdg(Tool) tp_Tool Tool;{ return Tool->InpEdg;};


tp_PrmFTLst
Tool_PrmFTLst(Tool) tp_Tool Tool;{ return Tool->PrmFTLst;};


boolean
IsSource_Tool(Tool)
   tp_Tool Tool;
{
   FORBIDDEN(Tool == ERROR);
   return (Tool->TClass == TC_Source);
   }/*IsSource_Tool*/;


boolean
IsParameter_Tool(Tool)
   tp_Tool Tool;
{
   FORBIDDEN(Tool == ERROR);
   return (Tool->TClass == TC_Parameter);
   }/*IsParameter_Tool*/;


boolean
IsSentinel_Tool(Tool)
   tp_Tool Tool;
{
   FORBIDDEN(Tool == ERROR);
   return (Tool->TClass == TC_Sentinel);
   }/*IsSentinel_Tool*/;


boolean
IsSystem_Tool(Tool)
   tp_Tool Tool;
{
   FORBIDDEN(Tool == ERROR);
   return (!(Tool->TClass == TC_User || Tool->TClass == TC_Browser
	     || Tool->TClass == TC_Hook));
   }/*IsSystem_Tool*/;


boolean
IsBrowser_Tool(Tool)
   tp_Tool Tool;
{
   return (Tool->TClass == TC_Browser);
   }/*IsBrowser_Tool*/;


tp_Prms
GetToolPrms(Tool, Prms)
   tp_Tool Tool;
   tp_Prms Prms;
{
   tp_Prms NewPrms;

   NewPrms = Strip_Prms(Prms, Tool->PrmFTLst);
   return NewPrms;
   }/*GetToolPrms*/;



