/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/Str.h"
#include "inc/Signal_.h"
#include "inc/Status_.h"

extern tp_FilDsc	ErrFD;


tp_FileName		HookFileName = ERROR;


ExpandHooks(SignalPtr, OutFD, InFD, Prms, IsNested)
   tp_Signal *SignalPtr;
   tp_FilDsc InFD, OutFD;
   tp_Prms Prms;
   boolean IsNested;
{
   int i;

   i = Readch(InFD);
   while (!EndOfFile(InFD)) {
      ;/*select*/{
	 if ((char)i == '(') {
	    i = Readch(InFD);
	    ;/*select*/{
	       if ((char)i == '|') {
		  ExpandHook(SignalPtr, OutFD, InFD, Prms);
		  if (*SignalPtr != NIL) {
		     return; }/*if*/;
		  i = Readch(InFD);
	       }else{
		  Writech(OutFD, '('); };}/*select*/;
	 }else if (IsNested && (char)i == '|') {
	    i = Readch(InFD);
	    ;/*select*/{
	       if ((char)i == ')') {
		  return;
	       }else{
		  Writech(OutFD, '|'); };}/*select*/;
	 }else if ((char)i == '\\') {
	    i = Readch(InFD);
	    ;/*select*/{
	       if ((char)i == '(') {
		  ;/*select*/{
		     if ((char)i == '|') {
			Write(OutFD, "(|");
			i = Readch(InFD);
		     }else{
			Write(OutFD, "\\("); };}/*select*/;
	       }else if (IsNested && (char)i == '|') {
		  ;/*select*/{
		     if ((char)i == ')') {
			Write(OutFD, "|)");
			i = Readch(InFD);
		     }else{
			Write(OutFD, "\\|"); };}/*select*/;
	       }else{
		  Writech(OutFD, '\\'); };}/*select*/;
	 }else{
	    Writech(OutFD, (char)i);
	    i = Readch(InFD); };}/*select*/; }/*while*/;
   if (IsNested && EndOfFile(InFD)) {
      SystemError(SystemErrorFD(), "** Error: Hook terminated by EOF\n");
      Writeln(OutFD, "** Error: Hook terminated by EOF\n"); }/*if*/;
   }/*ExpandHooks*/;


ExpandHook(SignalPtr, OutFD, InFD, Prms)
   tp_Signal *SignalPtr;
   tp_FilDsc OutFD, InFD;
   tp_Prms Prms;
{
   int i, iStr;
   tps_Str StrBuf;
   tps_FileName TmpFileName, ExpandHookFileName;
   tp_FileName OldHookFileName;
   tp_FilHdr FilHdr;
   tp_FilTyp HookFilTyp;
   tp_DrvPth DrvPth;
   tp_FilDsc HookFD, ExpandHookFD;
   tp_Prms HookPrms;

   i = Readch(InFD);
   iStr = 0;
   while ((char)i != ':' && !EndOfFile(InFD)) {
      StrBuf[iStr] = (char)i;
      iStr += 1;
      i = Readch(InFD); }/*while*/;
   StrBuf[iStr] = 0;
   FilHdr = DataFileName_FilHdr(StrBuf);
   if (FilHdr == ERROR) {
      SystemError(SystemErrorFD(), "Bad Hook FileName : <%s>.\n", StrBuf);
      *SignalPtr = SIGNAL_HookError;
      return; }/*if*/;

   i = Readch(InFD);
   iStr = 0;
   while ((char)i != ':' && !EndOfFile(InFD)) {
      StrBuf[iStr] = (char)i;
      iStr += 1;
      i = Readch(InFD); }/*while*/;
   StrBuf[iStr] = 0;
   if (EndOfFile(InFD)) {
      SystemError(SystemErrorFD(), "** Error: Hook terminated by EOF\n");
      Ret_FilHdr(FilHdr);
      *SignalPtr = SIGNAL_HookError;
      return; }/*if*/;
   HookFilTyp = FTName_FilTyp(StrBuf);
   if (HookFilTyp == ERROR) {
      SystemError(SystemErrorFD(), "Bad Hook Type : <%s>.\n", StrBuf);
      Ret_FilHdr(FilHdr);
      *SignalPtr = SIGNAL_HookError;
      return; }/*if*/;

   Get_TmpFileName(TmpFileName);
   HookFD = FileName_WFilDsc(TmpFileName);
   ExpandHooks(SignalPtr, HookFD, InFD, Prms, TRUE);
   Close(HookFD);
   if (*SignalPtr != NIL) {
      Ret_FilHdr(FilHdr);
      Ret_TmpFileName(TmpFileName);
      return; }/*if*/;

   HookPrms = Prms;
   DrvPth = Get_DrvPth(FilHdr, HookFilTyp);
   while (DrvPth == ERROR) {
      if (IsSource(FilHdr)) {
	 Ret_FilHdr(FilHdr);
	 HookFD = FileName_RFilDsc(TmpFileName);
	 ExpandHooks(SignalPtr, OutFD, HookFD, Prms, FALSE);
	 Close(HookFD);
	 Ret_TmpFileName(TmpFileName);
	 return; }/*if*/;
      HookPrms = Union_Prms(HookPrms, FilHdr_Prms(FilHdr));
      FilHdr = FilHdr_Head(FilHdr);
      DrvPth = Get_DrvPth(FilHdr, HookFilTyp); }/*while*/;
   FilHdr = Do_DrvPth(FilHdr, HookPrms, DfltPrms, DrvPth);
   Ret_DrvPth(DrvPth);

   if (!IsHook_FilTyp(FilHdr_FilTyp(FilHdr))) {
      FilHdr_Error("<%s> must be a hook.\n", FilHdr);
      Ret_FilHdr(FilHdr);
      Ret_TmpFileName(TmpFileName);
      *SignalPtr = SIGNAL_HookError;
      return; }/*if*/;

   OldHookFileName = HookFileName;
   HookFileName = TmpFileName;
   GetFile(SignalPtr, FilHdr);
   HookFileName = OldHookFileName;
   if (*SignalPtr != NIL) {
      Ret_FilHdr(FilHdr);
      Ret_TmpFileName(TmpFileName);
      return; }/*if*/;

   if (FilHdr_MinStatus(FilHdr) <= STAT_Error) {
      FilHdr_Error("--- Errors detected while computing <%s> :\n.", FilHdr);
      GetReport(FilHdr, STAT_Error, ErrFD);
      Ret_FilHdr(FilHdr);
      Ret_TmpFileName(TmpFileName);
      *SignalPtr = SIGNAL_HookError;
      return; }/*if*/;
   FilHdr_DataFileName(ExpandHookFileName, FilHdr);
   Ret_FilHdr(FilHdr);

   ExpandHookFD = FileName_RFilDsc(ExpandHookFileName);
   HookFD = FileName_WFilDsc(TmpFileName);
   FileCopy(HookFD, ExpandHookFD);
   Close(ExpandHookFD); Close(HookFD);

   HookFD = FileName_RFilDsc(TmpFileName);
   ExpandHooks(SignalPtr, OutFD, HookFD, Prms, FALSE);
   Close(HookFD);
   Ret_TmpFileName(TmpFileName);
   }/*ExpandHook*/;


	 
