
/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/FilElm.h"
#include "inc/ElmInf.h"



int		num_FilElmS = 0;

#define		MAX_HashFilElmS 512
tp_FilElm	HashFilElmS [MAX_HashFilElmS];

tps_FilElm _UsedFilElm;
tp_FilElm		UsedFilElm = &_UsedFilElm;
tps_FilElm _FreeFilElm;
tp_FilElm		FreeFilElm = &_FreeFilElm;
tp_FilElm		ModFilElm = NIL;


Init_FilElms()
{
   UsedFilElm->PrevFree = UsedFilElm;
   UsedFilElm->NextFree = UsedFilElm;

   FreeFilElm->PrevFree = FreeFilElm;
   FreeFilElm->NextFree = FreeFilElm;
   }/*Init_FilElms*/;


/*private*/ int
LocElm_HashVal(LocElm)
   tp_LocElm LocElm;
{
   return (LocElm / sizeof(tps_FilElm)) % MAX_HashFilElmS;
   }/*LocElm_HashVal*/;


Transfer_FilElm(FilElm, FilElmList)
   tp_FilElm FilElm, FilElmList;
{
   FilElm->PrevFree->NextFree = FilElm->NextFree;
   FilElm->NextFree->PrevFree = FilElm->PrevFree;
   FilElm->PrevFree = FilElmList->PrevFree;
   FilElm->NextFree = FilElmList;
   FilElm->PrevFree->NextFree = FilElm;
   FilElm->NextFree->PrevFree = FilElm;
   }/*Transfer_FilElm*/;


/*private*/ tp_FilElm
Copy_FilElm(FilElm)
   tp_FilElm FilElm;
{
   if (FilElm == ERROR) return ERROR;
   if (FilElm->Cnt == 0) {
      Transfer_FilElm(FilElm, UsedFilElm); }/*if*/;
   FilElm->Cnt += 1;
   return FilElm;
   }/*Copy_FilElm*/;


Ret_FilElm(FilElm)
   tp_FilElm FilElm;
{
   if (FilElm == ERROR) return;
   FilElm->Cnt -= 1;
   FORBIDDEN(FilElm->Cnt < 0);
   }/*Ret_FilElm*/;


Free_FilElms()
{
   tp_FilElm FilElm, NextFilElm;

   NextFilElm = UsedFilElm->NextFree;
   while (NextFilElm != UsedFilElm) {
      FilElm = NextFilElm;
      NextFilElm = NextFilElm->NextFree;
      if (FilElm->Cnt == 0) {
	 Transfer_FilElm(FilElm, FreeFilElm); }/*if*/; }/*while*/;
   }/*Free_FilElms*/;


/*private*/ tp_FilElm
New_FilElm(LocElm)
   tp_LocElm LocElm;
{
   tp_FilElm FilElm;
   tp_ElmInf ElmInf;
   int HashVal;

   FilElm = FreeFilElm->NextFree;
   /*select*/{
      if (FilElm == FreeFilElm) {
	 FilElm = (tp_FilElm)malloc(sizeof(tps_FilElm));
	 num_FilElmS += 1;
	 ElmInf = &(FilElm->ElmInf);
	 ElmInf->LocHdr = 0;
	 ElmInf->BackLink = 0;
	 ElmInf->Link = 0;
	 ElmInf->LocPrm = 0;
	 ElmInf->CmpdLocHdr = 0;
	 ElmInf->Next = 0;
	 
	 FilElm->LocElm = 0;
	 FilElm->Prms = ERROR;
	 FilElm->Cnt = 0;
	 FilElm->Modified = FALSE;
	 FilElm->PrevFree = FreeFilElm->PrevFree;
	 FilElm->NextFree = FreeFilElm;
	 FilElm->PrevFree->NextFree = FilElm;
	 FilElm->NextFree->PrevFree = FilElm;
      }else if (FilElm->LocElm != 0) {
	 FORBIDDEN(FilElm->Cnt != 0);
	 if (FilElm->Modified) WriteFilElms();
	 FORBIDDEN(FilElm->Modified);
	 UnHash_FilElm(FilElm); };}/*select*/;
   FilElm->LocElm = LocElm;

   HashVal = LocElm_HashVal(LocElm);
   FilElm->NextHash = HashFilElmS[HashVal];
   HashFilElmS[HashVal] = FilElm;
   return Copy_FilElm(FilElm);
   }/*New_FilElm*/;


/*private*/ tp_FilElm
Lookup_FilElm(LocElm)
   tp_LocElm LocElm;
{
   tp_FilElm FilElm;

   FilElm = HashFilElmS[LocElm_HashVal(LocElm)];
   while (FilElm != 0) {
      if (FilElm->LocElm == LocElm) {
	 return Copy_FilElm(FilElm); }/*if*/;
      FilElm = FilElm->NextHash; }/*while*/;
   return ERROR;
   }/*Lookup_FilElm*/;


tp_FilElm
LocElm_FilElm(LocElm)
   tp_LocElm LocElm;
{
   tp_FilElm FilElm;
   tp_ElmInf ElmInf;

   if (LocElm == ERROR) {
      return ERROR; }/*if*/;

   FilElm = Lookup_FilElm(LocElm);
   if (FilElm != ERROR) {
      return FilElm; }/*if*/;

   FilElm = New_FilElm(LocElm);
   ElmInf = &(FilElm->ElmInf);
   ReadElmInf(ElmInf, LocElm);
   return FilElm;
   }/*LocElm_FilElm*/;


UnHash_FilElm(FilElm)
   tp_FilElm FilElm;
{
   int HashVal;
   tp_FilElm PrevFilElm;

   HashVal = LocElm_HashVal(FilElm->LocElm);
   FilElm->LocElm = 0;
   FilElm->Prms = ERROR;
   PrevFilElm = HashFilElmS[HashVal];
   if (PrevFilElm == FilElm) {
      HashFilElmS[HashVal] = FilElm->NextHash;
      return; }/*if*/;
   FORBIDDEN(PrevFilElm == 0);
   while (PrevFilElm->NextHash != FilElm) {
      PrevFilElm = PrevFilElm->NextHash;
      FORBIDDEN(PrevFilElm == 0); }/*while*/;
   PrevFilElm->NextHash = FilElm->NextHash;
   }/*UnHash_FilElm*/;


SetFilElmModified(FilElm)
   tp_FilElm FilElm;
{
   if (FilElm->Modified) return;
   FilElm->Modified = TRUE;
   FilElm->NextMod = ModFilElm;
   ModFilElm = FilElm;
   }/*SetFilElmModified*/;


WriteFilElms()
{
   while (ModFilElm != NIL) {
      FORBIDDEN(!ModFilElm->Modified);
      ModFilElm->Modified = FALSE;
      WriteFilElm(ModFilElm);
      ModFilElm = ModFilElm->NextMod; }/*while*/;
   }/*WriteFilElms*/;


WriteFilElm(FilElm)
   tp_FilElm FilElm;
{
   WriteElmInf(&(FilElm->ElmInf), FilElm->LocElm);
   }/*WriteFilElm*/;


Update_FilElms()
{
   tp_FilElm FilElm;

   FORBIDDEN(ModFilElm != NIL);
   Free_FilElms();
   FilElm = UsedFilElm->NextFree;
   while (FilElm != UsedFilElm) {
      ReadElmInf(&FilElm->ElmInf, FilElm->LocElm);
      FilElm = FilElm->NextFree; }/*while*/;
   FilElm = FreeFilElm->NextFree;
   while (FilElm != FreeFilElm) {
      if (FilElm->LocElm != 0) UnHash_FilElm(FilElm);
      FilElm = FilElm->NextFree; }/*while*/;
   }/*Update_FilElms*/;


tp_FilElm
Alloc_ElmInf()
{
   tp_FilElm FilElm;
   tp_LocPrm LocElm;

   if (FreeLocElm != 0) {
      LocElm = FreeLocElm;
      FilElm = LocElm_FilElm(LocElm);
      FORBIDDEN(FilElm->ElmInf.CmpdLocHdr != 0);
      FreeLocElm = FilElm->ElmInf.Next;
      FilElm->ElmInf.Next = 0;
      SetFilElmModified(FilElm);
      if (DebugLocElm) Debug_Alloc_ElmInf(LocElm, FreeLocElm);
      return FilElm; }/*if*/;
   return New_FilElm((tp_LocElm)Alloc(sizeof(tps_ElmInf)));
   }/*Alloc_ElmInf*/;


DeAlloc_ElmInf(LocElm)
   tp_LocElm LocElm;
{
   tp_FilElm FilElm;
   tp_ElmInf ElmInf;
   tp_LocElm TmpLocElm, LastLocElm;

   if (LocElm == 0) {
      return; }/*if*/;
   TmpLocElm = LocElm;
   LastLocElm = LocElm;
   while (TmpLocElm != 0) {
      if (DebugLocElm) Debug_Ret_ElmInf(TmpLocElm);
      Unlink_LocElm(TmpLocElm);
      FilElm = LocElm_FilElm(TmpLocElm);
      ElmInf = &FilElm->ElmInf;
      FORBIDDEN(ElmInf->CmpdLocHdr == 0);
      ElmInf->LocPrm = DfltLocPrm;
      ElmInf->CmpdLocHdr = 0;
      SetFilElmModified(FilElm);
      LastLocElm = TmpLocElm;
      TmpLocElm = ElmInf->Next;
      Ret_FilElm(FilElm); }/*while*/;
   FilElm = LocElm_FilElm(LastLocElm);
   ElmInf->Next = FreeLocElm;
   SetFilElmModified(FilElm);
   Ret_FilElm(FilElm);
   FreeLocElm = LocElm;
   }/*DeAlloc_ElmInf*/;


boolean
FilElms_InUse()
{
   tp_FilElm FilElm;

   FilElm = UsedFilElm->NextFree;
   while (FilElm != UsedFilElm) {
      Write(StdOutFD, "LocElm=");
      WriteInt(StdOutFD, (int)FilElm->LocElm);
      Write(StdOutFD, ", Cnt=");
      WriteInt(StdOutFD, FilElm->Cnt);
      Writeln(StdOutFD, "");
      FilElm = FilElm->NextFree; }/*while*/;
   return (UsedFilElm->NextFree != UsedFilElm);
   }/*FilElms_InUse*/;


tp_LocHdr
FilElm_LocHdr(FilElm)
   tp_FilElm FilElm;
{
   return FilElm->ElmInf.LocHdr;
   }/*FilElm_LocHdr*/;


tp_FilHdr
FilElm_FilHdr(FilElm)
   tp_FilElm FilElm;
{
   tp_FilHdr FilHdr;

   FilHdr = LocHdr_FilHdr(FilElm->ElmInf.LocHdr);
   return FilHdr;
   }/*FilElm_FilHdr*/;


tp_LocHdr
FilElm_CmpdLocHdr(FilElm)
   tp_FilElm FilElm;
{
   return FilElm->ElmInf.CmpdLocHdr;
   }/*FilElm_CmpdLocHdr*/;


tp_FilHdr
FilElm_CmpdFilHdr(FilElm)
   tp_FilElm FilElm;
{
   tp_FilHdr FilHdr;

   FilHdr = LocHdr_FilHdr(FilElm->ElmInf.CmpdLocHdr);
   return FilHdr;
   }/*FilElm_CmpdFilHdr*/;


tp_Prms
FilElm_Prms(FilElm)
   tp_FilElm FilElm;
{
   FORBIDDEN(FilElm == ERROR);
   if (FilElm->Prms == 0) FilElm->Prms = LocPrm_Prms(FilElm->ElmInf.LocPrm);
   FORBIDDEN(FilElm->Prms == ERROR);
   return FilElm->Prms;
   }/*FilElm_Prms*/;


tp_LocElm
FilElm_Next(FilElm)
   tp_FilElm FilElm;
{
   FORBIDDEN(FilElm == ERROR);
   return FilElm->ElmInf.Next;
   }/*FilElm_Next*/;


tp_LocElm
FilElm_Link(FilElm)
   tp_FilElm FilElm;
{
   return FilElm->ElmInf.Link;
   }/*FilElm_Link*/;


Link_LocElm(LocElm, FilHdr)
   tp_LocElm LocElm;
   tp_FilHdr FilHdr;
{
   tp_FilElm FilElm, RiteFilElm, LeftFilElm;
   tp_ElmInf ElmInf;
   tp_LocElm RiteLocElm, LeftLocElm;

   RiteLocElm = FilHdr_ElmLink(FilHdr);
   /*select*/{
      if (RiteLocElm == 0) {
	 Set_ElmLink(FilHdr, LocElm);
	 LeftLocElm = LocElm;
	 RiteLocElm = LocElm;
      }else{
	 RiteFilElm = LocElm_FilElm(RiteLocElm);
	 FORBIDDEN(RiteFilElm->ElmInf.LocHdr != FilHdr_LocHdr(FilHdr));
	 LeftLocElm = RiteFilElm->ElmInf.BackLink;
	 RiteFilElm->ElmInf.BackLink = LocElm;
	 SetFilElmModified(RiteFilElm);
	 Ret_FilElm(RiteFilElm);

	 LeftFilElm = LocElm_FilElm(LeftLocElm);
	 LeftFilElm->ElmInf.Link = LocElm;
	 SetFilElmModified(LeftFilElm);
	 Ret_FilElm(LeftFilElm);
	 };}/*select*/;
   FilElm = LocElm_FilElm(LocElm);
   ElmInf = &(FilElm->ElmInf);
   FORBIDDEN(ElmInf->LocHdr != ERROR);
   FORBIDDEN(ElmInf->BackLink != 0 || ElmInf->Link != 0);
   ElmInf->LocHdr = FilHdr_LocHdr(FilHdr);
   ElmInf->BackLink = LeftLocElm;
   ElmInf->Link = RiteLocElm;
   FORBIDDEN(ElmInf->LocHdr == ERROR);
   FORBIDDEN(ElmInf->BackLink == 0 || ElmInf->Link == 0);
   SetFilElmModified(FilElm);
   Ret_FilElm(FilElm);
   }/*Link_LocElm*/;


Unlink_LocElm(LocElm)
   tp_LocElm LocElm;
{
   tp_FilElm FilElm, LeftFilElm, RiteFilElm;
   tp_ElmInf ElmInf;
   tp_FilHdr FilHdr;
   tp_LocHdr LocHdr;
   tp_LocElm LeftLocElm, RiteLocElm;

   FilElm = LocElm_FilElm(LocElm);
   ElmInf = &(FilElm->ElmInf);
   LocHdr = ElmInf->LocHdr;
   LeftLocElm = ElmInf->BackLink;
   RiteLocElm = ElmInf->Link;
   ElmInf->LocHdr = ERROR;
   ElmInf->BackLink = 0;
   ElmInf->Link = 0;
   SetFilElmModified(FilElm);
   Ret_FilElm(FilElm);
   FORBIDDEN(LeftLocElm == 0 || RiteLocElm == 0 || LocHdr == ERROR);

   FilHdr = LocHdr_FilHdr(LocHdr);
   /*select*/{
      if (LeftLocElm == LocElm) {
	 FORBIDDEN(RiteLocElm != LocElm);
	 Set_ElmLink(FilHdr, (tp_LocElm)0);
      }else{
	 if (FilHdr_ElmLink(FilHdr) == LocElm) {
	    Set_ElmLink(FilHdr, LeftLocElm); }/*if*/;

	 LeftFilElm = LocElm_FilElm(LeftLocElm);
	 LeftFilElm->ElmInf.Link = RiteLocElm;
	 SetFilElmModified(LeftFilElm);
	 Ret_FilElm(LeftFilElm);

	 RiteFilElm = LocElm_FilElm(RiteLocElm);
	 RiteFilElm->ElmInf.BackLink = LeftLocElm;
	 SetFilElmModified(RiteFilElm);
	 Ret_FilElm(RiteFilElm);
	 };}/*select*/;
   Ret_FilHdr(FilHdr);
   }/*Unlink_LocElm*/;


tp_LocElm
Make_LocElm(FilHdr, Prms, CmpdFilHdr)
   tp_FilHdr FilHdr;
   tp_Prms Prms;
   tp_FilHdr CmpdFilHdr;
{
   tp_FilElm FilElm;
   tp_ElmInf ElmInf;
   tp_LocElm LocElm;

   FORBIDDEN(FilHdr == ERROR || Prms == ERROR || CmpdFilHdr == ERROR);

   FilElm = Alloc_ElmInf();
   LocElm = FilElm->LocElm;
   FilElm->Prms = Prms;
   ElmInf = &(FilElm->ElmInf);
   ElmInf->LocHdr = ERROR;
   ElmInf->BackLink = 0;
   ElmInf->Link = 0;
   ElmInf->LocPrm = Prms_LocPrm(Prms);
   ElmInf->CmpdLocHdr = FilHdr_LocHdr(CmpdFilHdr);
   ElmInf->Next = 0;

   SetFilElmModified(FilElm);
   Ret_FilElm(FilElm);

   Link_LocElm(LocElm, FilHdr);

   return LocElm;
   }/*Make_LocElm*/;


Chain_LocElms(FirstLocElmPtr, LastLocElmPtr, LocElm)
   tp_LocElm *FirstLocElmPtr, *LastLocElmPtr;
   tp_LocElm LocElm;
{
   tp_FilElm PrvFilElm;

   FORBIDDEN(LocElm == 0);
   if (*FirstLocElmPtr == 0) {
      FORBIDDEN(*LastLocElmPtr != 0);
      *FirstLocElmPtr = LocElm;
      *LastLocElmPtr = LocElm;
      return; }/*if*/;
   PrvFilElm = LocElm_FilElm(*LastLocElmPtr);
   PrvFilElm->ElmInf.Next = LocElm;
   SetFilElmModified(PrvFilElm);
   Ret_FilElm(PrvFilElm);
   *LastLocElmPtr = LocElm;
   }/*Chain_LocElms*/;


tp_LocElm
Copy_LocElm(OldLocElm, CmpdFilHdr)
   tp_LocElm OldLocElm;
   tp_FilHdr CmpdFilHdr;
{
   tp_FilElm FilElm;
   tp_FilHdr ElmFilHdr;
   tp_Prms Prms;
   tp_LocElm LocElm, FirstLocElm, LastLocElm, NxtLocElm, NewLocElm;

   if (OldLocElm == 0) {
      return 0; }/*if*/;

   LocElm = OldLocElm;
   FirstLocElm = 0; LastLocElm = 0;
   while (LocElm != 0) {
      FilElm = LocElm_FilElm(LocElm);
      ElmFilHdr = FilElm_FilHdr(FilElm);
      Prms = FilElm_Prms(FilElm);
      NxtLocElm = FilElm_Next(FilElm);
      Ret_FilElm(FilElm);

      NewLocElm = Make_LocElm(ElmFilHdr, Prms, CmpdFilHdr);
      Ret_FilHdr(ElmFilHdr);
      Chain_LocElms(&FirstLocElm, &LastLocElm, NewLocElm);
      LocElm = NxtLocElm; }/*while*/;

   return FirstLocElm;
   }/*Copy_LocElm*/;


boolean
IsEquiv_LocElms(LocElm1, LocElm2)
   tp_LocElm LocElm1, LocElm2;
{
   tp_LocElm LocElmA, LocElmB;
   tp_FilElm FilElmA, FilElmB;
   tp_Prms PrmsA, PrmsB;

   if (LocElm1 == LocElm2) {
      return TRUE; }/*if*/;

   LocElmA = LocElm1; LocElmB = LocElm2;
   while (LocElmA != 0 && LocElmB != 0) {
      FilElmA = LocElm_FilElm(LocElmA); FilElmB = LocElm_FilElm(LocElmB);
      FORBIDDEN(FilElmA->ElmInf.CmpdLocHdr != FilElmB->ElmInf.CmpdLocHdr);
      if (FilElmA->ElmInf.LocHdr != FilElmB->ElmInf.LocHdr) {
	 Ret_FilElm(FilElmA); Ret_FilElm(FilElmB);
	 return FALSE; }/*if*/;
      PrmsA = LocPrm_Prms(FilElmA->ElmInf.LocPrm);
      PrmsB = LocPrm_Prms(FilElmB->ElmInf.LocPrm);
      FORBIDDEN(PrmsA == ERROR || PrmsB == ERROR);
      if (!Equal_Prms(PrmsA, PrmsB)) {
	 Ret_FilElm(FilElmA); Ret_FilElm(FilElmB);
	 return FALSE; }/*if*/;
      LocElmA = FilElm_Next(FilElmA); LocElmB = FilElm_Next(FilElmB);
      Ret_FilElm(FilElmA); Ret_FilElm(FilElmB); }/*while*/;

   return (LocElmA == LocElmB);
   }/*IsEquiv_LocElms*/;


tp_LocElm
Append_LocElm(LocElm1, LocElm2)
   tp_LocElm LocElm1, LocElm2;
{
   tp_LocElm LocElm;
   tp_FilElm FilElm;

   if (LocElm2 == 0) {
      return LocElm1; }/*if*/;

   if (LocElm1 == 0) {
      return LocElm2; }/*if*/;

   LocElm = LocElm1;
   FilElm = LocElm_FilElm(LocElm);
   while (FilElm->ElmInf.Next != 0) {
      LocElm = FilElm->ElmInf.Next;
      Ret_FilElm(FilElm);
      FilElm = LocElm_FilElm(LocElm); }/*while*/;
   FilElm->ElmInf.Next = LocElm2;
   SetFilElmModified(FilElm);
   Ret_FilElm(FilElm);
   return LocElm1;
   }/*Append_LocElm*/;


