/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/FilHdr.h"
#include "inc/FilTyp.h"
#include "inc/FKind_.h"
#include "inc/Parm.h"
#include "inc/Status_.h"
#include "inc/Str.h"


Make_RootHdrInf(HdrInf, LocHdr)
   tp_HdrInf HdrInf;
   tp_LocHdr LocHdr;
{
   HdrInf->LocHdr = LocHdr;
   HdrInf->Older = LocHdr;
   HdrInf->Newer = LocHdr;

   HdrInf->FKind = FK_Src;
   HdrInf->IFilTyp = NullFilTyp->IFilTyp;
   HdrInf->ModDate = 1;
   HdrInf->Status = STAT_OK;
   HdrInf->LocPrm = DfltLocPrm;
   HdrInf->LocIdent = LocNilStr;
   }/*Make_RootHdrInf*/;


tp_FilHdr
ExtendFilHdr(BaseFilHdr, FKind, FilTyp, Prms, IdentStr)
   tp_FilHdr BaseFilHdr;
   tp_FKind FKind;
   tp_FilTyp FilTyp;
   tp_Prms Prms;
   tp_Str IdentStr;
{
   tp_FilHdr FilHdr;
   tp_LocHdr LocHdr, NewLocHdr;
   tp_Ident Ident;

   FilHdr = ERROR;
   if (BaseFilHdr == ERROR || FilTyp == ERROR || Prms == ERROR) {
      goto done; }/*if*/;

   Ident = Sym_Str(Str_Sym(IdentStr));
   if (HasKey_FKind(FKind) && Ident == NIL) {
      FilHdr_Error("Element of <%s> must have a key.\n", BaseFilHdr);
      goto done; }/*if*/;

   LocHdr = BaseFilHdr->HdrInf.Son;
   while (LocHdr != NIL) {
      FilHdr = LocHdr_FilHdr(LocHdr);
      if (FilHdr->FilTyp == FilTyp
	  && (Ident == NIL || FilHdr->Ident == Ident)
	  && (FilHdr->HdrInf.FKind == FKind
	      || (IsSource_FKind(FilHdr->HdrInf.FKind)
		  && IsSource_FKind(FKind)))
	  && Equal_Prms(FilHdr->Prms, Prms)) {
	 goto done; }/*if*/;
      LocHdr = FilHdr->HdrInf.Brother;
      Ret_FilHdr(FilHdr); }/*while*/;

   NewLocHdr = Alloc_HdrInf();
   FilHdr = New_FilHdr(NewLocHdr);
   Init_HdrInf(&FilHdr->HdrInf);
   SetModified(FilHdr);
   FilHdr->HdrInf.LocHdr = NewLocHdr;
   FilHdr->HdrInf.Father = BaseFilHdr->HdrInf.LocHdr;
   FilHdr->HdrInf.Brother = BaseFilHdr->HdrInf.Son;
   BaseFilHdr->HdrInf.Son = NewLocHdr;
   SetModified(BaseFilHdr);
   FilHdr->HdrInf.Older = NewLocHdr;
   FilHdr->HdrInf.Newer = NewLocHdr;

   FilHdr->HdrInf.FKind = FKind;
   FilHdr->FilTyp = FilTyp;
   FilHdr->HdrInf.IFilTyp = FilHdr->FilTyp->IFilTyp;
   FilHdr->Ident = (Ident==NIL ? BaseFilHdr->Ident : Ident);
   FilHdr->HdrInf.LocIdent = (Ident==NIL ? BaseFilHdr->HdrInf.LocIdent : WriteStr(Ident));
   FilHdr->Prms = Prms;
   FilHdr->HdrInf.LocPrm = Prms_LocPrm(Prms);
   FilHdr->HdrInf.ModDate = CurrentDate;
   if (!IsSource_FKind(FKind)) {
      FilHdr->HdrInf.LocInp = Get_LocInp(FilHdr);
      SetModified(FilHdr); }/*if*/;
done:;
   Ret_FilHdr(BaseFilHdr);
   return FilHdr;
   }/*ExtendFilHdr*/;


tp_FilHdr
FilHdr_TestFilHdr(FilHdr, CheckFilHdr)
   tp_FilHdr FilHdr;
   tp_FilHdr CheckFilHdr;
{
   tp_Prms Prms;
   tps_Parm _Parm; tp_Parm Parm = &_Parm;
   tp_FilHdr TestFilHdr;

   if (FilHdr == ERROR || CheckFilHdr == ERROR) {
      Ret_FilHdr(FilHdr);
      return ERROR; }/*if*/;

   FORBIDDEN(FilHdr == CheckFilHdr);
   FORBIDDEN(FilHdr->HdrInf.CheckLocHdr != 0);

   Prms = Make_TestPrms(FilHdr_Prms(FilHdr), CheckFilHdr);
   Prms = Union_Parm(Prms, PrmFTFile_Parm(Parm, CheckPrmFT,
					   CheckFilHdr, DfltPrms));
   TestFilHdr = Get_Drv(FilHdr_BaseFilHdr(FilHdr), FilHdr->HdrInf.FKind,
			FilHdr->FilTyp, Prms, FilHdr->Ident);

   if (TestFilHdr->HdrInf.CheckLocHdr == NIL) {
      TestFilHdr->HdrInf.CheckLocHdr = CheckFilHdr->HdrInf.LocHdr;
      TestFilHdr->HdrInf.LocInp = Get_LocInp(TestFilHdr);
      Make_TestLocInp(TestFilHdr->HdrInf.LocInp, CheckFilHdr); }/*if*/;

   return TestFilHdr;
   }/*FilHdr_TestFilHdr*/;


tp_FilHdr
FilHdr_SrcTestFilHdr(DstFilHdr, OrgFilHdr, CheckFilHdr)
   tp_FilHdr DstFilHdr;
   tp_FilHdr OrgFilHdr;
   tp_FilHdr CheckFilHdr;
{
   tp_Prms Prms;
   tps_Parm _Parm; tp_Parm Parm = &_Parm;
   tp_FilHdr TestFilHdr, OldOrgFilHdr;
   tp_LocElm OldLocElm;
   tp_FilElm OldFilElm;

   FORBIDDEN(DstFilHdr == ERROR || OrgFilHdr == ERROR || CheckFilHdr == ERROR);

   FORBIDDEN(!(IsSource(DstFilHdr) && IsAtmc(DstFilHdr)));
   FORBIDDEN(!IsAtmc(OrgFilHdr));

   Prms = Union_Parm(DfltPrms, PrmFTFile_Parm(Parm, CheckPrmFT,
					       CheckFilHdr, DfltPrms));
   TestFilHdr = Get_Drv(FilHdr_BaseFilHdr(DstFilHdr), DstFilHdr->HdrInf.FKind,
			DstFilHdr->FilTyp, Prms, DstFilHdr->Ident);

   if (TestFilHdr->HdrInf.CheckLocHdr != NIL) {
      OldLocElm = TestFilHdr->HdrInf.LocElm;
      OldFilElm = LocElm_FilElm(OldLocElm);
      FORBIDDEN(OldFilElm == NIL);
      OldOrgFilHdr = FilElm_FilHdr(OldFilElm);
      Ret_FilElm(OldFilElm);
      if (OldOrgFilHdr != OrgFilHdr) {
	 DeAlloc_ElmInf(OldLocElm);
	 TestFilHdr->HdrInf.LocElm
	  = Make_LocElm(OrgFilHdr, DfltPrms, TestFilHdr);
	 TestFilHdr->HdrInf.OldLocElm = TestFilHdr->HdrInf.LocElm;
	 Set_ModDate(TestFilHdr);
	 Set_Status(TestFilHdr, STAT_OK); }/*if*/;
      Ret_FilHdr(OldOrgFilHdr);
      return TestFilHdr; }/*if*/;

   TestFilHdr->HdrInf.FKind = FK_RplPntr;
   TestFilHdr->HdrInf.LocInp = 0;
   TestFilHdr->HdrInf.LocElm = Make_LocElm(OrgFilHdr, DfltPrms, TestFilHdr);
   TestFilHdr->HdrInf.CheckLocHdr = CheckFilHdr->HdrInf.LocHdr;

   Set_ModDate(TestFilHdr);
   Set_Status(TestFilHdr, STAT_OK);

   return TestFilHdr;
   }/*Make_SrcTestFilHdr*/;


tp_FilHdr
Get_Drv(BaseFilHdr, FKind, FilTyp, Prms, Ident)
   tp_FilHdr BaseFilHdr;
   tp_FKind FKind;
   tp_FilTyp FilTyp;
   tp_Prms Prms;
   tp_Ident Ident;
{
   tp_FilHdr FilHdr, CheckFilHdr, GenericFilHdr;
   tps_Str NewIdent;
   tp_FilTyp NewFilTyp;

   if (BaseFilHdr==ERROR || FilTyp==ERROR || Prms==ERROR) {
      Ret_FilHdr(BaseFilHdr);
      return ERROR; }/*if*/;
   FORBIDDEN(FKind == ERROR);

   CheckFilHdr = FilHdr_CheckFilHdr(Copy_FilHdr(BaseFilHdr));
   if (CheckFilHdr != ERROR) BaseFilHdr = FilHdr_Head(BaseFilHdr);
   if (FKind == FK_ImHo && IsPntr(BaseFilHdr)) FKind = FK_PntrHo;
   FilHdr = ExtendFilHdr(BaseFilHdr, FKind, FilTyp, Prms, Ident);
   if (IsGeneric(FilHdr)) {
      GenericFilHdr = Copy_FilHdr(FilHdr);
      FORBIDDEN(FilHdr->HdrInf.FKind != FK_User);
      (void)strcpy(NewIdent, FilHdr->Ident);
      NewIdent[strlen(NewIdent)-1] = 0;
      Split_Key(NewIdent, &NewFilTyp, NewIdent);
      FilHdr = ExtendFilHdr(FilHdr, FK_Instance, NewFilTyp, DfltPrms, NewIdent);
      Set_LocElm(FilHdr, Make_LocElm(GenericFilHdr, DfltPrms, FilHdr));
      Ret_FilHdr(GenericFilHdr); }/*if*/;
   if (CheckFilHdr != ERROR) FilHdr = FilHdr_TestFilHdr(FilHdr, CheckFilHdr);

   Ret_FilHdr(CheckFilHdr);
   return FilHdr;
   }/*Get_Drv*/;


