/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/FilHdr.h"
#include "inc/HdrInf.h"
#include "inc/FilTyp.h"
#include "inc/Status_.h"
#include "inc/Filename.h"


int			num_FilHdrS = 0;

#define			MAX_HashS 512
tp_FilHdr		HashFilHdrS [MAX_HashS];

tps_FilHdr _UsedFilHdr;
tp_FilHdr		UsedFilHdr = &_UsedFilHdr;
tps_FilHdr _FreeFilHdr;
tp_FilHdr		FreeFilHdr = &_FreeFilHdr;
tp_FilHdr		ModFilHdr = NIL;

tp_FilHdr		RootFilHdr;
tp_FilHdr		HogFilHdr;
tp_FilHdr		OdinDirFilHdr;
tp_FilHdr		CacheDirFilHdr;

tp_Ident		DfltIdent = NIL;


Init_FilHdrs()
{
   UsedFilHdr->PrevFree = UsedFilHdr;
   UsedFilHdr->NextFree = UsedFilHdr;

   FreeFilHdr->PrevFree = FreeFilHdr;
   FreeFilHdr->NextFree = FreeFilHdr;
   ModFilHdr = NIL;
   }/*Init_FilHdrs*/;


Init_FilHdrTree()
{
   RootFilHdr = LocHdr_FilHdr(RootLocHdr);
   HogFilHdr = LocHdr_FilHdr(HogLocHdr);

   OdinDirFilHdr = HostFN_FilHdr(OdinDirName);
   CacheDirFilHdr = HostFN_FilHdr(CacheDirName);
   }/*Init_FilHdrTree*/;


tp_LocHdr
Alloc_HdrInf()
{
   return (tp_LocHdr) Alloc(sizeof(tps_HdrInf));
   }/*Alloc_HdrInf*/;


/*private*/ int
LocHdr_HashVal(LocHdr)
   tp_LocHdr LocHdr;
{
   return (LocHdr / sizeof(tps_FilHdr)) % MAX_HashS;
   }/*LocHdr_HashVal*/;


Transfer_FilHdr(FilHdr, FilHdrList)
   tp_FilHdr FilHdr, FilHdrList;
{
   FilHdr->PrevFree->NextFree = FilHdr->NextFree;
   FilHdr->NextFree->PrevFree = FilHdr->PrevFree;
   FilHdr->PrevFree = FilHdrList->PrevFree;
   FilHdr->NextFree = FilHdrList;
   FilHdr->PrevFree->NextFree = FilHdr;
   FilHdr->NextFree->PrevFree = FilHdr;
   }/*Transfer_FilHdr*/;


tp_FilHdr
Copy_FilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return ERROR;
   if (FilHdr->Cnt == 0 && FilHdr->Flag == 0 && FilHdr->Tag == 0
       && FilHdr->TestLocHdr == 0) {
      Transfer_FilHdr(FilHdr, UsedFilHdr); }/*if*/;
   FilHdr->Cnt += 1;
   return FilHdr;
   }/*Copy_FilHdr*/;


Ret_FilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr == ERROR) return;
   FilHdr->Cnt -= 1;
   FORBIDDEN(FilHdr->Cnt < 0);
   }/*Ret_FilHdr*/;


Free_FilHdrs()
{
   tp_FilHdr FilHdr, NextFilHdr;

   NextFilHdr = UsedFilHdr->NextFree;
   while (NextFilHdr != UsedFilHdr) {
      FilHdr = NextFilHdr;
      NextFilHdr = NextFilHdr->NextFree;
      if (FilHdr->Cnt == 0 && FilHdr->Flag == 0 && FilHdr->Tag == 0
	  && FilHdr->TestLocHdr == 0) {
	 FORBIDDEN(FilHdr->SCC != NIL);
	 Transfer_FilHdr(FilHdr, FreeFilHdr); }/*if*/; }/*while*/;
   }/*Free_FilHdrs*/;


tp_FilHdr
New_FilHdr(LocHdr)
   tp_LocHdr LocHdr;
{
   tp_FilHdr FilHdr;
   int HashVal;

   FilHdr = FreeFilHdr->NextFree;
   /*select*/{
      if (FilHdr == FreeFilHdr) {
	 FilHdr = (tp_FilHdr)malloc(sizeof(tps_FilHdr));
	 num_FilHdrS += 1;
	 Init_HdrInf(&FilHdr->HdrInf);
	 FilHdr->FilTyp = ERROR;
	 FilHdr->Prms = ERROR;
	 FilHdr->Ident = ERROR;
	 FilHdr->Flag = NIL;
	 FilHdr->Tag = NIL;
	 FilHdr->SCC = (tp_FilHdr)NIL;
	 FilHdr->TestLocHdr = NIL;
	 FilHdr->Cnt = 0;
	 FilHdr->Modified = FALSE;
	 FilHdr->PrevFree = FreeFilHdr->PrevFree;
	 FilHdr->NextFree = FreeFilHdr;
	 FilHdr->PrevFree->NextFree = FilHdr;
	 FilHdr->NextFree->PrevFree = FilHdr;
      }else if (FilHdr->HdrInf.LocHdr != 0) {
	 FORBIDDEN(FilHdr->Cnt != 0);
	 if (FilHdr->Modified) WriteFilHdrs();
	 FORBIDDEN(FilHdr->Modified);
	 UnHash(FilHdr); };}/*select*/;
   FilHdr->HdrInf.LocHdr = LocHdr;
   FilHdr->VerifyDate = 0;
   FilHdr->ElmNameVerifyDate = 0;
   FilHdr->ElmVerifyDate = 0;

   HashVal = LocHdr_HashVal(LocHdr);
   FilHdr->NextHash = HashFilHdrS[HashVal];
   HashFilHdrS[HashVal] = FilHdr;
   return Copy_FilHdr(FilHdr);
   }/*New_FilHdr*/;


/*private*/ tp_FilHdr
Lookup_FilHdr(LocHdr)
   tp_LocHdr LocHdr;
{
   int HashVal;
   tp_FilHdr FilHdr;

   HashVal = LocHdr_HashVal(LocHdr);
   FilHdr = HashFilHdrS[HashVal];
   while (FilHdr != 0) {
      if (FilHdr->HdrInf.LocHdr == LocHdr) {
	 return Copy_FilHdr(FilHdr); }/*if*/;
      FilHdr = FilHdr->NextHash; }/*while*/;

   return ERROR;
   }/*Lookup_FilHdr*/;


tp_FilHdr
LocHdr_FilHdr(LocHdr)
   tp_LocHdr LocHdr;
{
   tp_FilHdr FilHdr;
   tp_HdrInf HdrInf;
   tp_FilTyp FilTyp;

   FORBIDDEN(LocHdr == ERROR);

   FilHdr = Lookup_FilHdr(LocHdr);
   if (FilHdr != ERROR) {
      return FilHdr; }/*if*/;

   FilHdr = New_FilHdr(LocHdr);
   HdrInf = &(FilHdr->HdrInf);
   ReadHdrInf(HdrInf, LocHdr);

   FilTyp = IFilTyp_FilTyp(HdrInf->IFilTyp);
   FORBIDDEN(FilTyp == ERROR);
   FilHdr->FilTyp = FilTyp;
   FilHdr->Ident = ReadStr(HdrInf->LocIdent);
   FilHdr->Prms = LocPrm_Prms(HdrInf->LocPrm);
   FORBIDDEN(FilHdr->Prms == ERROR);
   return FilHdr;
   }/*LocHdr_FilHdr*/;


UnHash(FilHdr)
   tp_FilHdr FilHdr;
{
   int HashVal;
   tp_FilHdr PrevFilHdr;

   FORBIDDEN(FilHdr->Modified);
   HashVal = LocHdr_HashVal(FilHdr->HdrInf.LocHdr);
   FilHdr->HdrInf.LocHdr = 0;
   FilHdr->Prms = ERROR;
   PrevFilHdr = HashFilHdrS[HashVal];
   if (PrevFilHdr == FilHdr) {
      HashFilHdrS[HashVal] = FilHdr->NextHash;
      return; }/*if*/;
   FORBIDDEN(PrevFilHdr == 0);
   while (PrevFilHdr->NextHash != FilHdr) {
      PrevFilHdr = PrevFilHdr->NextHash;
      FORBIDDEN(PrevFilHdr == 0); }/*while*/;
   PrevFilHdr->NextHash = FilHdr->NextHash;
   }/*UnHash*/;


Init_HdrInf(HdrInf)
   tp_HdrInf HdrInf;
{
   HdrInf->LocHdr = 0;
   HdrInf->DataNum = 0;
   HdrInf->LocInp = NIL;
   HdrInf->Father = NIL;
   HdrInf->Brother = NIL;
   HdrInf->Son = NIL;

   HdrInf->LocElm = NIL;
   HdrInf->OldLocElm = NIL;
   HdrInf->InpLink = NIL;
   HdrInf->ElmLink = NIL;

   HdrInf->FKind = ERROR;
   HdrInf->LocIdent = 0;
   HdrInf->OldStatus = STAT_SysAbort;
   HdrInf->Status = STAT_Unknown;
   HdrInf->ElmNameStatus = STAT_Unknown;
   HdrInf->ElmStatus = STAT_Unknown;
   HdrInf->SysModTime = 0;
   HdrInf->ModDate = 0;
   HdrInf->ElmNameModDate = 0;
   HdrInf->ElmModDate = 0;
   HdrInf->ConfirmDate = 0;
   HdrInf->ElmNameConfirmDate = 0;
   HdrInf->ElmConfirmDate = 0;
   HdrInf->Purged = TRUE;
   HdrInf->TransPurged = TRUE;
   HdrInf->Size = 0;
   HdrInf->CheckLocHdr = 0;
   HdrInf->OriginLocHdr = 0;
   }/*Init_FilHdr*/;


MakeNewest(FilHdr)
   tp_FilHdr FilHdr;
{
   tp_FilHdr Older, Newer, Newest;

   if (IsSource(FilHdr)) return;

   if (FilHdr->HdrInf.Newer != NIL) {
      Older = LocHdr_FilHdr(FilHdr->HdrInf.Older);
      Newer = LocHdr_FilHdr(FilHdr->HdrInf.Newer);
      Set_Newer(Older, Newer->HdrInf.LocHdr);
      Set_Older(Newer, Older->HdrInf.LocHdr);
      Ret_FilHdr(Older); Ret_FilHdr(Newer); }/*if*/;

   /*select*/{
      if (FilHdr->HdrInf.Size > HogSize) {
	 Newest = LocHdr_FilHdr(HogFilHdr->HdrInf.Older);
	 
	 Set_Newer(Newest, FilHdr->HdrInf.LocHdr);
	 Set_Older(FilHdr, Newest->HdrInf.LocHdr);

	 Set_Newer(FilHdr, HogFilHdr->HdrInf.LocHdr);
	 Set_Older(HogFilHdr, FilHdr->HdrInf.LocHdr);
	 
	 Ret_FilHdr(Newest);
      }else if (FilHdr->HdrInf.Size != 0) {
	 Newest = LocHdr_FilHdr(RootFilHdr->HdrInf.Older);
	 
	 Set_Newer(Newest, FilHdr->HdrInf.LocHdr);
	 Set_Older(FilHdr, Newest->HdrInf.LocHdr);

	 Set_Newer(FilHdr, RootFilHdr->HdrInf.LocHdr);
	 Set_Older(RootFilHdr, FilHdr->HdrInf.LocHdr);
	 
	 Ret_FilHdr(Newest);
      }else if (FilHdr->HdrInf.Older != NIL) {
	 FilHdr->HdrInf.Older = NIL;
	 FilHdr->HdrInf.Newer = NIL;
	 SetModified(FilHdr); };}/*select*/;
   }/*MakeNewest*/;


SetModified(FilHdr)
   tp_FilHdr FilHdr;
{
   if (FilHdr->Modified) return;
   FilHdr->Modified = TRUE;
   FilHdr->NextMod = ModFilHdr;
   ModFilHdr = FilHdr;
   }/*SetModified*/;


WriteFilHdrs()
{
   while (ModFilHdr != NIL) {
      FORBIDDEN(!ModFilHdr->Modified);
      ModFilHdr->Modified = FALSE;
      WriteFilHdr(ModFilHdr);
      ModFilHdr = ModFilHdr->NextMod; }/*while*/;
   }/*WriteFilHdrs*/;


WriteFilHdr(FilHdr)
   tp_FilHdr FilHdr;
{
   WriteHdrInf(&(FilHdr->HdrInf), FilHdr->HdrInf.LocHdr);
   }/*WriteFilHdr*/;


Update_FilHdrs()
{
   tp_FilHdr FilHdr;

   FORBIDDEN(ModFilHdr != NIL);
   Free_FilHdrs();
   FilHdr = UsedFilHdr->NextFree;
   while (FilHdr != UsedFilHdr) {
      ReadHdrInf(&FilHdr->HdrInf, FilHdr->HdrInf.LocHdr);
      FilHdr = FilHdr->NextFree; }/*while*/;
   Clear_FreeFilHdrs();
   }/*Update_FilHdrs*/;


Clear_FreeFilHdrs()
{
   tp_FilHdr FilHdr;

   WriteFilHdrs();
   FilHdr = FreeFilHdr->NextFree;
   while (FilHdr != FreeFilHdr) {
      if (FilHdr->HdrInf.LocHdr != 0) UnHash(FilHdr);
      FilHdr = FilHdr->NextFree; }/*while*/;
   }/*Clear_FreeFilHdrs*/;


boolean
FilHdrs_InUse()
{
   tp_FilHdr FilHdr;

   Free_FilHdrs();
   FilHdr = UsedFilHdr->NextFree;
   while (FilHdr != UsedFilHdr) {
      Write(StdOutFD, "LocHdr=");
      WriteInt(StdOutFD, (int)FilHdr->HdrInf.LocHdr);
      Write(StdOutFD, ", Cnt=");
      WriteInt(StdOutFD, FilHdr->Cnt);
      Write(StdOutFD, ", Flag=");
      WriteInt(StdOutFD, FilHdr->Flag);
      Writeln(StdOutFD, "");
      FilHdr = FilHdr->NextFree; }/*while*/;
   return (UsedFilHdr->NextFree != UsedFilHdr);
   }/*FilHdrs_InUse*/;

