/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/Filename.h"
#include "inc/IOTyp.h"
#include "inc/Str.h"

/* Environment variables with their default values:
 * DUMPCORE	no
 * ODIN		Odin home directory
 * SHOWTIMES	no
 */

#ifndef ODIN
#define ODIN "/usr/local/lib/Odin/ODIN"
#endif


tp_FileName		OdinDirName;

tp_FileName		CacheDirName;
tp_FileName		LocalDirName;
tp_FileName		RunDirName;
tp_FileName		PrmsDirName;
tp_FileName		LinkedInputDirName;
tp_FileName		RunFileName;
tp_FileName		WorkDirDirName;
tp_FileName		WorkDirName;
tp_FileName		WarningFN;
tp_FileName		ErrorFN;

int			num_StrS = 0;


tp_Str
Malloc_Str(Str)
   tp_Str Str;
{
   num_StrS += 1;
   return strcpy(malloc((unsigned)strlen(Str)+1), Str);
   }/*Malloc_Str*/;


Get_DGFileName(FileName)
   tp_FileName FileName;
{
   (void)strcpy(FileName, OdinDirName);
   (void)strcat(FileName, "/local.dg.tab");
   }/*Get_DGFileName*/;


Get_CmdFileName(FileName, FTName)
   tp_FileName FileName;
   tp_FTName FTName;
{
   (void)sprintf(FileName, "%s/Cmd/%s.cmd", OdinDirName, FTName);
   }/*Get_CmdFileName*/;


Get_InfoFileName(FileName)
   tp_FileName FileName;
{
   (void)strcpy(FileName, OdinDirName);
   (void)strcat(FileName, "/INFO");
   }/*Get_InfoFileName*/;


Get_SentinelFileName(FileName)
   tp_FileName FileName;
{
   (void)strcpy(FileName, OdinDirName);
   (void)strcat(FileName, "/Sentinel");
   }/*Get_SentinelFileName*/;


Get_ExportFileName(FileName)
   tp_FileName FileName;
{
   (void)strcpy(FileName, OdinDirName);
   (void)strcat(FileName, "/Export");
   }/*Get_ExportFileName*/;


Get_DebugFileName(FileName)
   tp_FileName FileName;
{
   (void)strcpy(FileName, OdinDirName);
   (void)strcat(FileName, "/DEBUG");
   }/*Get_DebugFileName*/;


Get_HistoryFileName(FileName)
   tp_FileName FileName;
{
   (void)strcpy(FileName, LocalDirName);
   (void)strcat(FileName, "/HISTORY");
   }/*Get_HistoryFileName*/;


I_WorkFileName(WorkFileName, I)
   tp_FileName WorkFileName;
   int I;
{
   (void)strcpy(WorkFileName, WorkDirName);
   (void)sprintf(Tail(WorkFileName), "/file%d", I);
   }/*I_WorkFileName*/;


I_WorkDirFileName(WorkDirFileName, I)
   tp_FileName WorkDirFileName;
   int I;
{
   (void)sprintf(WorkDirFileName, "%s/dir%d", WorkDirDirName, I);
   }/*I_WorkDirFileName*/;


Get_LinkedInputDirName(DirName, I)
   tp_FileName DirName;
   int I;
{
   (void)sprintf(DirName, "%s/%d", LinkedInputDirName, I);
   }/*Get_LinkedInputDirName*/;


Get_LinkedPrmInputDirName(DirName, FTName)
   tp_FileName DirName;
   tp_FTName FTName;
{
   (void)sprintf(DirName, "%s/%s", LinkedInputDirName, FTName);
   }/*Get_LinkedPrmInputDirName*/;


Get_PrmFileName(DirName, FTName)
   tp_FileName DirName;
   tp_FTName FTName;
{
   (void)sprintf(DirName, "%s/%s", PrmsDirName, FTName);
   }/*Get_PrmFileName*/;


int TmpNesting = 0;

Get_TmpFileName(FileName)
   tp_FileName FileName;
{
   TmpNesting += 1;
   (void)sprintf(FileName, "%s/TMP%d", LocalDirName, TmpNesting);
   }/*Get_TmpFileName*/;

Ret_TmpFileName(FileName)
   tp_FileName FileName;
{
   tps_FileName TmpFileName;

   (void)sprintf(TmpFileName, "%s/TMP%d", LocalDirName, TmpNesting);
   FORBIDDEN(strcmp(TmpFileName, FileName) != 0);
   TmpNesting -= 1;
   }/*Ret_TmpFileName*/;


Init_Env()
{
   tps_FileName CurrentDir;
   tps_Str Str;
   boolean Abort;

   (void)umask(0);

   DumpCore = (getenv("DUMPCORE") != NIL);
   ShowTimes = (getenv("SHOWTIMES") != NIL);

   OdinDirName = getenv("ODIN");
   if (OdinDirName == NIL) OdinDirName = ODIN;
   if (!IsDirectory_FileName(OdinDirName)) {
      SystemError(SystemErrorFD(), "Odin root <%s> does not exist.\n", OdinDirName);
      FatalError("");}/*if*/;
   GetWorkingDir(CurrentDir);
   ChangeDir(&Abort, OdinDirName); FORBIDDEN(Abort);
   GetWorkingDir(Str);
   OdinDirName = Malloc_Str(Str);
   ChangeDir(&Abort, CurrentDir); FORBIDDEN(Abort);

   CacheDirName = Malloc_Str(strcat(strcpy(Str, OdinDirName), "/FILES"));
   MakeDirFile(CacheDirName, &Abort);
   if (Abort) FatalError("cannot create odin files dir");

   (void)sprintf(Str, "%s/LOCAL/%d", OdinDirName, getpid());
   LocalDirName = Malloc_Str(Str);
   MakeDirFile(LocalDirName, &Abort);
   if (Abort) FatalError("cannot create odin local dir");

   RunDirName = Malloc_Str(strcat(strcpy(Str, LocalDirName), "/RUN"));
   MakeDirFile(RunDirName, &Abort);
   if (Abort) FatalError("cannot create run dir");

   RunFileName = Malloc_Str(strcat(strcpy(Str, LocalDirName), "/CMDFIL"));
   MakeExecFile(RunFileName);

   LinkedInputDirName = Malloc_Str(strcat(strcpy(Str, LocalDirName), "/INPUTS"));
   MakeDirFile(LinkedInputDirName, &Abort);
   if (Abort) FatalError("cannot create parameters dir");

   WorkDirDirName = Malloc_Str(strcat(strcpy(Str, LocalDirName), "/WORKDIR"));
   MakeDirFile(WorkDirDirName, &Abort);
   if (Abort) FatalError("cannot create work dir");

   WorkDirName = Malloc_Str(strcat(strcpy(Str, LocalDirName), "/WORK"));
   MakeDirFile(WorkDirName, &Abort);
   if (Abort) FatalError("cannot create work dir");

   PrmsDirName = WorkDirName;
   WarningFN = Malloc_Str(strcat(strcpy(Str, WorkDirName), "/WARNING"));
   ErrorFN = Malloc_Str(strcat(strcpy(Str, WorkDirName), "/ERROR"));
   }/*Init_Env*/;


Do_OdinRC()
{
   tps_FileName RCFileName;
   tp_FilDsc FilDsc;
   tp_Str Str;
   tps_Str StrBuf;
   boolean Abort;

   (void)strcpy(RCFileName, ".odinrc");
   if (Exists(RCFileName)) {
      FilDsc = FileName_RFilDsc(RCFileName);
      if (FilDsc == ERROR) {
	 SystemError(SystemErrorFD(), "Could not read <%s>.\n", RCFileName);
	 return; }/*if*/;
      Str = ReadLine(StrBuf, FilDsc);
      while (Str != ERROR) {
	 CommandInterpreter(&Abort, Str);
	 Str = ReadLine(StrBuf, FilDsc); }/*while*/;
      Close(FilDsc);
      return; }/*if*/;
   (void)strcpy(RCFileName, getenv("HOME"));
   (void)strcat(RCFileName, "/.odinrc");
   if (Exists(RCFileName)) {
      FilDsc = FileName_RFilDsc(RCFileName);
      if (FilDsc == ERROR) {
	 SystemError(SystemErrorFD(), "Could not read <%s>.\n", RCFileName);
	 return; }/*if*/;
      Str = ReadLine(StrBuf, FilDsc);
      while (Str != ERROR) {
	 CommandInterpreter(&Abort, Str);
	 Str = ReadLine(StrBuf, FilDsc); }/*while*/;
      Close(FilDsc); }/*if*/;
   }/*Do_OdinRC*/;


CleanUp()
{
   int i;
   tps_FileName DirName;

   Compact();
   Pop_CWDFilHdr();
   Ret_FilHdr(RootFilHdr);
   Ret_FilHdr(HogFilHdr);
   Ret_FilHdr(OdinDirFilHdr);
   Ret_FilHdr(CacheDirFilHdr);
   Ret_FilHdr(SentinelFilHdr);
   Close_Info();
   Close_History();
   FORBIDDEN(PrmFHdrs_InUse());
   FORBIDDEN(FilHdrs_InUse());
   FORBIDDEN(FilInps_InUse());
   FORBIDDEN(FilElms_InUse());

   /* a simple recursive delete is considered too dangerous */

   for (i=0; i<MAX_IOTyps; i++) {
      I_WorkDirFileName(DirName, i);
      if (Exists(DirName)) {
	 ClearDir(DirName); RemoveDir(DirName); }/*if*/; }/*for*/;
   ClearDir(WorkDirDirName); RemoveDir(WorkDirDirName);
   ClearDir(WorkDirName); RemoveDir(WorkDirName);
   ClearDirDirs(LinkedInputDirName); RemoveDir(LinkedInputDirName);
   ClearDir(RunDirName); RemoveDir(RunDirName);
   ClearDir(LocalDirName); RemoveDir(LocalDirName);
   }/*CleanUp*/;


