/*	Copyright (c) 1991 Geoffrey M. Clemm	*/
/*	geoff@boulder.colorado.edu		*/

#include "inc/GMC.h"
#include "inc/CastEdg.h"
#include "inc/DrvEdg.h"
#include "inc/EqvEdg.h"
#include "inc/MemEdg.h"
#include "inc/InpEdg.h"
#include "inc/InpKind_.h"


tp_FilTyp
DrvEdg_FilTyp(DrvEdg)
   tp_DrvEdg DrvEdg;
{
   FORBIDDEN(DrvEdg == ERROR);
   return DrvEdg->FilTyp;
   }/*DrvEdg_FilTyp*/;


tp_PrmFTLst
DrvEdg_PrmFTLst(DrvEdg)
   tp_DrvEdg DrvEdg;
{
   FORBIDDEN(DrvEdg == ERROR);
   return DrvEdg->PrmFTLst;
   }/*DrvEdg_PrmFTLst*/;


tp_FilTyp
InpEdg_FilTyp(InpEdg)
   tp_InpEdg InpEdg;
{
   FORBIDDEN(InpEdg == ERROR);
   return InpEdg->FilTyp;
   }/*InpEdg_FilTyp*/;


tp_HomSpc
InpEdg_HomSpc(InpEdg)
   tp_InpEdg InpEdg;
{
   FORBIDDEN(InpEdg == ERROR);
   return InpEdg->HomSpc;
   }/*InpEdg_HomSpc*/;


tp_InpKind
InpEdg_InpKind(InpEdg)
   tp_InpEdg InpEdg;
{
   FORBIDDEN(InpEdg == ERROR);
   return InpEdg->InpKind;
   }/*InpEdg_InpKind*/;


tp_InpEdg
InpEdg_Next(InpEdg)
   tp_InpEdg InpEdg;
{
   FORBIDDEN(InpEdg == ERROR);
   return InpEdg->Next;
   }/*InpEdg_Next*/;


boolean
InpKind_IsName(InpKind)
   tp_InpKind InpKind;
{
   return (InpKind == IK_Name);
   }/*InpKind_IsName*/;


boolean
InpKind_IsPntr(InpKind)
   tp_InpKind InpKind;
{
   return (InpKind == IK_Pntr);
   }/*InpKind_IsPntr*/;


boolean
InpKind_IsTrans(InpKind)
   tp_InpKind InpKind;
{
   return (InpKind == IK_Trans || InpKind == IK_AnyOK);
   }/*InpKind_IsTrans*/;


boolean
InpKind_IsTransName(InpKind)
   tp_InpKind InpKind;
{
   return (InpKind == IK_TransName);
   }/*InpKind_IsTransName*/;


boolean
InpKind_IsAnyOK(InpKind)
   tp_InpKind InpKind;
{
   return (InpKind == IK_AnyOK);
   }/*InpKind_IsAnyOK*/;


boolean
NeedsData(FilHdr, InpKind)
   tp_FilHdr FilHdr;
   tp_InpKind InpKind;
{
   return !(InpKind_IsName(InpKind)
	    || (InpKind_IsTransName(InpKind) && !IsRef(FilHdr)));
   }/*NeedsData*/;


boolean
NeedsElmsData(FilHdr, InpKind)
   tp_FilHdr FilHdr;
   tp_InpKind InpKind;
{
   return (InpKind_IsTrans(InpKind) || IsLink(FilHdr)
	   || (IsPntr(FilHdr) && InpKind != IK_Pntr));
   }/*NeedsElmsData*/;


GetInpTyps(FilTyp, InpTyps, NumInputs)
   tp_FilTyp FilTyp;
   tp_InpTyps InpTyps;
   int *NumInputs;
{
   int i;
   tp_InpEdg InpEdg;

   i = 0;
   InpEdg = Tool_InpEdg(FilTyp_Tool(FilTyp));
   while (InpEdg != 0) {
      InpTyps[i] = InpEdg->FilTyp;
      i++;
      InpEdg = InpEdg->Next; }/*while*/;
   *NumInputs = i;
   }/*GetInpTyps*/;


GetOutTyps(FilTyp, OutTyps, NumOutputsPtr)
   tp_FilTyp FilTyp;
   tp_OutTyps OutTyps;
   int *NumOutputsPtr;
{
   int i;
   tp_MemEdg MemEdg;

   if (!IsStruct_FilTyp(FilTyp)) {
      OutTyps[0] = FilTyp;
      *NumOutputsPtr = 1;
      return; }/*if*/;

   i = 0;
   MemEdg = FilTyp_MemEdg(FilTyp);
   while (MemEdg != 0) {
      OutTyps[i] = MemEdg->FilTyp;
      i++;
      MemEdg = MemEdg->Next; }/*while*/;
   *NumOutputsPtr = i;
   }/*GetOutTyps*/;


SetEqvEdg_Marks(EqvEdg, PrmFTFlag)
   tp_EqvEdg EqvEdg;
   boolean PrmFTFlag;
{
   tp_EqvEdg TmpEqvEdg;

   TmpEqvEdg = EqvEdg;
   while (TmpEqvEdg != 0) {
      if (!PrmFTFlag) SetFilTyp_Mark(TmpEqvEdg->FilTyp);
      SetFilTyp_Marks(TmpEqvEdg->FilTyp, PrmFTFlag);
      TmpEqvEdg = TmpEqvEdg->Next; }/*while*/;
   }/*SetEqvEdg_Marks*/;


SetCastEdg_Marks(CastEdg, PrmFTFlag)
   tp_CastEdg CastEdg;
   boolean PrmFTFlag;
{
   tp_CastEdg TmpCastEdg;

   TmpCastEdg = CastEdg;
   while (TmpCastEdg != 0) {
      SetFilTyp_Marks(TmpCastEdg->FilTyp, PrmFTFlag);
      SetCastEdg_Marks(FilTyp_CastEdg(TmpCastEdg->FilTyp), PrmFTFlag);
      TmpCastEdg = TmpCastEdg->Next; }/*while*/;
   }/*SetCastEdg_Marks*/;


SetDrvEdg_Marks(DrvEdg, PrmFTFlag)
   tp_DrvEdg DrvEdg;
   boolean PrmFTFlag;
{
   tp_DrvEdg TmpDrvEdg;

   TmpDrvEdg = DrvEdg;
   while (TmpDrvEdg != 0) {
      if (!PrmFTFlag) SetFilTyp_Mark(TmpDrvEdg->FilTyp);
      if (PrmFTFlag) SetPrmFTLst_Marks(TmpDrvEdg->PrmFTLst);
      SetFilTyp_Marks(TmpDrvEdg->FilTyp, PrmFTFlag);
      TmpDrvEdg = TmpDrvEdg->Next; }/*while*/;
   }/*SetDrvEdg_Marks*/;



