static char RCSid[] = "$Id: transl.c,v 1.7 1992/10/30 19:51:44 waite Exp $";
/* Copyright 1989, The Regents of the University of Colorado */

#include <stdio.h>
#include <stdlib.h>

#if defined(__cplusplus) || defined(__STDC__)
int
main(int argc, char **argv)
#else
int
main(argc,argv)
int argc; char **argv;
#endif
{
   char line[BUFSIZ], *text[BUFSIZ], *p;
   int code, i, j, l, key[BUFSIZ], newkey[BUFSIZ], next;
   FILE *f;

   if (argc != 2) {
      (void)fprintf(stderr,"Usage %s newCodes\n", *argv);
      exit(1);
   }
   if ((f = fopen(argv[1], "r")) == NULL) {
      (void)fprintf(stderr, "%s: Cannot open file %s\n", *argv, argv[1]);
      exit(1);
   }

   for (i = 0; i < BUFSIZ; i++) key[i] = i;   /* Default is same code */

   next = 0;
   while (fscanf(f, "%d %d %d %d", &code, &i, &j, &l) != EOF) {
      (void)getc(f);   /* Skip the space that precedes the symbol */
      if (code == 5 && i == 1) {
         /* Symbol exists only in the concrete grammar */
         newkey[next] = j;
         text[next] = (char *)malloc((unsigned) (l+1));
         p = text[next];
         do *p = getc(f); while (*p++ != '\n');
         *(p-1) = '\0';
         next++;
      } else {
         /* Symbol found in the abstract grammar */
         key[i] = j;
         while (l--) (void)getc(f);
      }
   }

   while (scanf(" %d %d", &i, &l) != EOF) {
      (void)fgets(line, BUFSIZ, stdin);
      if (line[strlen(line)-1] != '\n') {
         (void)fprintf(stderr, "%s: \"%d %d%s\" too long\n", *argv, i, l, line);
         exit(1);
      }
      (void)printf("%d %d%s", key[i], l, line);
   }

   while (next-- > 0) {
      (void)printf("%d %d %s\n",
            newkey[next], strlen(text[next]), text[next]);
   }

   return 0;
}
