static char rcsid[] = "$Id: typeout.c,v 1.3 1991/07/04 17:23:48 waite Exp $";

#include <curses.h>
#include "info.h"
#include "typeout.h"

/* Windows */
extern WINDOW *terminal_window, *echo_area;

static char *message;
static int length, texttop, textbot;

/**/
static void
type(offset)
int offset;
/* Type a portion of the text
 *    On entry-
 *       s=string containing the typeout area
 *       offset indexes the first character of the text to be typed
 *    On exit-
 *       texttop indexes the first character of the text actually typed
 *       textbot indexes the first character beyond the text actually typed
 **/
{
	int i;

	textbot = forward_lines(LINES-4, offset);
	texttop = back_lines(LINES-4, textbot);

	wmove(terminal_window, 0, 0);
	for (i = texttop; i < textbot; i++)
		waddch(terminal_window, message[i]);

	if (texttop == 0 && textbot == length) {
		int i;
		for (i = 0; i < COLS; i++) (void)waddch(terminal_window, '-');
	} else {
		if (textbot == length) waddstr(terminal_window, "[Done]");
		else waddstr(terminal_window, "[More]");
		wclrtoeol(terminal_window);
	}
	wrefresh(terminal_window);
}

/***/
void
typeout(s)
char *s;
/* Type out a string to the terminal window
 *    On entry-
 *       s=string to be typed out (must end with \n)
 ***/
{
	int character;
	WINDOW *help;

	message = s; length = strlen(s);
	set_search_constraints(s, length);

	type(0);
	if (textbot == length) return;

	help = newwin(1, COLS, LINES-1, 0);
	waddstr(help, "SPACE=advance, DEL=back up, Q=end display\n");

	for (;;) {
		character = getch();
		switch (to_upper(character)) {
		case SPACE:
			if (textbot == length) { putchar(CTRL('G')); break; }
			type(back_lines(2, textbot));
			break;
		case DELETE:
			if (texttop == 0) { putchar(CTRL('G')); break; }
			type(back_lines(LINES-6, texttop));
			break;
		case 'Q':
			delwin(help);
			return;
		default:
			putchar(CTRL('G'));
			wrefresh(help);
			touchwin(echo_area);
		}
	}
}
