#!/bin/sh
# $Id: all_info.cmd,v 1.5 1992/02/14 15:53:01 waite Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

#all_info <
#   doc_info(.none) "Hypertext for the documents"*
#   index_info "Hypertext for the index to all of the documents"*
#   > "Hypertext for a set of documents"* :
#	USER
#		: (:level_0_specs +typekey=tnf :extract)
#		: (:level_0_specs +typekey=tnf :extract ::info_data)

cd (|<RUNDIR|)

cat (|<(:level_0_specs +typekey=tnf :extract ::info_data)|) > (|>doc_info|)

# Build a special info file representing the merged indexes of the others

cat <<END > gindex.tnf
\input texinfo   @c -*-texinfo-*-
@comment Copyright, 1989, The Regents of the University of Colorado
@comment %**start of header
@setfilename gindex
@settitle Global Index
@setchapternewpage odd
@comment %**end of header

@node top, , , (dir)
@unnumbered Global Index
@menu
END

# Note: The character "|" used in two places below must be a character
# that is otherwise guaranteed not to appear in the index entries.

touch tmp
for i in `cat (|<(:level_0_specs +typekey=tnf :extract)|)`
do
	j=`basename $i .tnf`
	sed -n -e '/^[ 	]*@node/{
			s/^[ 	]*@node[ 	]*\([^,]*\).*$/('$j')\1/
			h
		}
		/^@.index/{
			s/ *$//
			G
			s/^@.index *\(.*\)\n\(.*\)/* \1| \2/p
		}' $i >> tmp
done

# This mucking about sorts the index and arranges for duplicate entries to
# have unique numbers appended to them to make them selectable.
cat <<\END >awkscr
BEGIN{FS="|";last="";count=1}
{ if (last == $1)
    printf("%s %d:%s.\n", $1, count++, $2);
  else {
    printf("%s:%s.\n", $1, $2);
    count = 1;
    last = $1;
  }
} 
END
sort -u tmp | awk -f awkscr >>gindex.tnf

# End the menu.
cat <<END >> gindex.tnf
@end menu
@bye
END

# Turn gindex.tnf into the gindex info file

(|$/Tool/texinfo/makeinfo|) gindex.tnf > /dev/null 2> Report

if [ -s (|<RUNDIR|)/Report ]
then
	grep 'Warning' Report > (|>WARNING|)
	grep -v 'Warning' Report > (|>ERROR|)
fi

# Add gindex to the output list

cat (|<RUNDIR|)/gindex > (|>index_info|)

exit 0


