static char rcsid[] = "$Id: fmt.c,v 1.3 1993/01/23 19:15:25 kadhim Exp $";
/* Copyright 1993, The Regents of the University of Colorado */

#include <stdio.h>

#define LIMIT 70

/**/
void
OutSeg(first, limit)
char *first, *limit;
/* Output a saved segment
 *   On entry-
 *     first points to the first character to be output
 *     limit points to the character beyond the last character to be output
 *   On exit-
 *     The segment has been added to the current line
 **/
{ while (first != limit) (void)putchar(*first++); }

/***/
int
main()
/* Assemble lines not exceeding LIMIT characters
 *   On entry-
 *     stdin = input text to be assembled
 *   On exit-
 *     stdout = sequence of assembled lines
 *     If a line is longer than LIMIT then it has no internal white space
 ***/
{
  char Segment[LIMIT], *p;
  int Current, State = 0, Count;

  while ((Current = getchar()) != EOF) {
    switch (State) {
    case 0:	/* No information */
      if (Current > ' ') { Count = 0; p = Segment; State = 1; }
      else break;
    case 1:	/* Holding initial segment */
      if (Current > ' ') {
        Count++; *p++ = Current;
        if (Count == LIMIT) { OutSeg(Segment, p); p = Segment; }
        break;
      } else { OutSeg(Segment, p); State = 2; }
    case 2:	/* Inter-segment white space */
      if (Current == '\n') { (void)putchar('\n'); State = 0; break; }
      else if (Current > ' ') { Count++; p = Segment; State = 3; }
      else break;
    case 3:	/* Holding non-initial segment */
      if (Current > ' ') {
        Count++; *p++ = Current;
        if (Count == LIMIT) {
          (void)putchar('\n'); Count = (p - Segment); State = 1;
        }
      } else { (void)putchar(' '); OutSeg(Segment, p); State = 2; }
    }
  }
  if (State) (void)putchar('\n');

  return 0;
}
