
#include "HEAD.h"

#include "node.h"

#include "visitprocs.h"

#include "gsdescr.h"

extern void free();

extern char *malloc();

#include "obstack.h"

static struct obstack TreeSpace;

#define obstack_chunk_alloc malloc

#define obstack_chunk_free free

char* TreeNodeAlloc(size) int size;

{return (obstack_alloc(&TreeSpace, size));}

void InitTree() { obstack_init(&TreeSpace); }

NODEPTR MkxIdent(_coordref,_tr1)
POSITION *_coordref;
int _tr1;
{
_TSPxIdent n;
n = (_TSPxIdent) TreeNodeAlloc (sizeof (struct _TSxIdent));
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;

n->_ATid=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkxNumbTree(_coordref,_tr1)
POSITION *_coordref;
int _tr1;
{
_TSPxNumbTree n;
n = (_TSPxNumbTree) TreeNodeAlloc (sizeof (struct _TSxNumbTree));
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;

n->_ATval=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkxString(_coordref,_tr1)
POSITION *_coordref;
int _tr1;
{
_TSPxString n;
n = (_TSPxString) TreeNodeAlloc (sizeof (struct _TSxString));
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;

n->_ATstr=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkpPTG(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpPTG n;
n = (_TPPpPTG) TreeNodeAlloc (sizeof (struct _TPpPTG));
n->_proc =_VS1pPTG;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRules)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpRules(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpRules n;
n = (_TPPpRules) TreeNodeAlloc (sizeof (struct _TPpRules));
n->_proc =_VS1pRules;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRules)_tr1;
n->_desc2= (_TSPxRule)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpRule(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpRule n;
n = (_TPPpRule) TreeNodeAlloc (sizeof (struct _TPpRule));
n->_proc =_VS1pRule;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRule)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpNode(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpNode n;
n = (_TPPpNode) TreeNodeAlloc (sizeof (struct _TPpNode));
n->_proc =_VS1pNode;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxNodeName)_tr1;
n->_desc2= (_TSPxItems)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpNodeName(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpNodeName n;
n = (_TPPpNodeName) TreeNodeAlloc (sizeof (struct _TPpNodeName));
n->_proc =_VS1pNodeName;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpItems(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpItems n;
n = (_TPPpItems) TreeNodeAlloc (sizeof (struct _TPpItems));
n->_proc =_VS1pItems;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxItems)_tr1;
n->_desc2= (_TSPxItem)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpnoItem(_coordref)
POSITION *_coordref;
{_TPPpnoItem n;
n = (_TPPpnoItem) TreeNodeAlloc (sizeof (struct _TPpnoItem));
n->_proc =_VS1pnoItem;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpTree(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpTree n;
n = (_TPPpTree) TreeNodeAlloc (sizeof (struct _TPpTree));
n->_proc =_VS1pTree;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTreeNum)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpTreeNum(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpTreeNum n;
n = (_TPPpTreeNum) TreeNodeAlloc (sizeof (struct _TPpTreeNum));
n->_proc =_VS1pTreeNum;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxNumbTree)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpNoTreeNum(_coordref)
POSITION *_coordref;
{_TPPpNoTreeNum n;
n = (_TPPpNoTreeNum) TreeNodeAlloc (sizeof (struct _TPpNoTreeNum));
n->_proc =_VS1pNoTreeNum;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpStrItem(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpStrItem n;
n = (_TPPpStrItem) TreeNodeAlloc (sizeof (struct _TPpStrItem));
n->_proc =_VS1pStrItem;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxString)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpRFct(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpRFct n;
n = (_TPPpRFct) TreeNodeAlloc (sizeof (struct _TPpRFct));
n->_proc =_VS1pRFct;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpLeaf(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPpLeaf n;
n = (_TPPpLeaf) TreeNodeAlloc (sizeof (struct _TPpLeaf));
n->_proc =_VS1pLeaf;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxNodeName)_tr1;
n->_desc2= (_TSPxTypes)_tr2;
n->_desc3= (_TSPxUserFct)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkpLFct(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpLFct n;
n = (_TPPpLFct) TreeNodeAlloc (sizeof (struct _TPpLFct));
n->_proc =_VS1pLFct;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpnoLFct(_coordref)
POSITION *_coordref;
{_TPPpnoLFct n;
n = (_TPPpnoLFct) TreeNodeAlloc (sizeof (struct _TPpnoLFct));
n->_proc =_VS1pnoLFct;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpTypes(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpTypes n;
n = (_TPPpTypes) TreeNodeAlloc (sizeof (struct _TPpTypes));
n->_proc =_VS1pTypes;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTypes)_tr1;
n->_desc2= (_TSPxType)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpType(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpType n;
n = (_TPPpType) TreeNodeAlloc (sizeof (struct _TPpType));
n->_proc =_VS1pType;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxType)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpInt(_coordref)
POSITION *_coordref;
{_TPPpInt n;
n = (_TPPpInt) TreeNodeAlloc (sizeof (struct _TPpInt));
n->_proc =_VS1pInt;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpString(_coordref)
POSITION *_coordref;
{_TPPpString n;
n = (_TPPpString) TreeNodeAlloc (sizeof (struct _TPpString));
n->_proc =_VS1pString;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpPointer(_coordref)
POSITION *_coordref;
{_TPPpPointer n;
n = (_TPPpPointer) TreeNodeAlloc (sizeof (struct _TPpPointer));
n->_proc =_VS1pPointer;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

#ifndef GETxIdentid
#define GETxIdentid(x) (x)
#endif

#ifndef GETxNumbTreeval
#define GETxNumbTreeval(x) (x)
#endif

#ifndef GETxStringstr
#define GETxStringstr(x) (x)
#endif

void SourceLeaf(d) GRUNDSYMBOLDESKRIPTOR *d;
{_incrnodestack ();
switch (d->SyntaxCode) {

case 2: _nst[_nsp] =MkxIdent(&(d->Pos),GETxIdentid (d->Attr)); break;

case 3: _nst[_nsp] =MkxNumbTree(&(d->Pos),GETxNumbTreeval (d->Attr)); break;

case 4: _nst[_nsp] =MkxString(&(d->Pos),GETxStringstr (d->Attr)); break;
}}

