/* $Id: func.h,v 1.4 1992/12/09 22:15:13 kadhim Exp $ */
/* Exported definitions for function output generation */
/* Copyright (c) 1992, The Regents of the University of Colorado */

#ifndef FUNC_H
#define FUNC_H

#include "envmod.h"
#include "ptg_gen.h"

#define nullptgnode()         PTGNULL
#define creatptgnode(x)       x
#define concatptgnode(x,y)    PTGSeq((x),(y))

/* node structs and funclists are used to build up a list of operations */
/* associated with a type or property key */
typedef struct node {
	DefTableKey key;
	struct node *next;
} node;

typedef node *funclist;

typedef char *pchar;

typedef struct {
	PTGNode rettype;
	PTGNode opname;
	PTGNode paramlist;
	PTGNode paramdecls;
	PTGNode text;
} OpOutput;

/* A dummyfunclist should guarantee not to cause allocation of new space */
/* as opposed to nullfunclist - this can vary according to how the list */
/* is represented */
#define dummyfunclist     ((funclist) 0)

/* exported functions */

#if defined(__cplusplus) || defined(__STDC__)
extern void addfunclist(DefTableKey key, funclist list);
extern funclist nullfunclist();
extern funclist concatfunclist(DefTableKey key, funclist list);
extern DefTableKey FindOpKey(Environment env, int ident);
extern PTGNode GenFunctions(DefTableKey key, int type, 
                            Environment env, funclist list);
extern void PrIdent();
extern OpOutput BuildOperationSpec(PTGNode type, PTGNode opname,
				   PTGNode paramlist, PTGNode paramdecls,
				   PTGNode text);
#else
extern void addfunclist();
extern funclist nullfunclist();
extern funclist concatfunclist();
extern DefTableKey FindOpKey();
extern PTGNode GenFunctions();
extern void PrIdent();
extern OpOutput BuildOperationSpec();
#endif

#endif
