
program GAGPGM (output
            );

#include "vsfile.ext.h"
#include "frame.h"
#include "attr.h"
#include "tree.h"
#include "dbgen.ext.h"

(* $Id: dbgen.pp,v 1.8 90/04/04 17:38:37 waite Exp $ *)
(* Copyright, 1989, The Regents of the University of Colorado *)


#include "deftbl.ext.h"

(* $Id: deftbl.pp,v 1.2 89/10/20 13:21:49 waite Exp $ *)
(* Copyright, 1989, The Regents of the University of Colorado *)
#include "envmod.ext.h"

(* $Id: envmod.pp,v 1.3 89/10/20 13:53:53 waite Exp $ *)
(* Copyright, 1989, The Regents of the University of Colorado *)



const
(*&INCLUDE ATTR_CONST_LOC*)

 (*  ERROR MESSAGES ACCORDING TO <USER>.C.SCANTAB:  *)
   CONDFAILSMSG       =   2; (* attr eval *)
   SYSTEMERRORMSG     =   6; (* attr eval *)
   HEADFAILSMSG       =   8; (* attr eval *)
   LASTFAILSMSG       =   9; (* attr eval *)
   KEYFAILSMSG        =  10; (* attr eval *)
   VSTABLEWRONGMSG    =  11; (* attr eval *)
   GENSYMBFULLMSG     =  22; (* attr eval *)


     
     C100MININT=-2147483647;
     C101MAXINT=2147483647;
     C181tDef=0;
     C270eParamRef=1;
     C271eSpecTypeRef=2;
     C363eClassRef=0;
     
(*&END GEN INCLUDE*)

(*&END INCLUDE*)



type


filename = packed array [1..100] of char; (* File name parameter *)



var



   filearg: filename;




dbInitDummy: boolean;  (* result from dbInit *)




#include "cstsupp.h"


procedure errtoken (T : integer; var ATTR : integer);
(*================*)
(* Create attribute of a generated symbol
   on entry-
      T=Code for the created symbol
   on exit-
      ATTR contains the attribute value if any
*)
begin
  ATTR := 0;          (* change to appropriate values *)
end; (* errtoken *)
(*===============*)




{
   Get/Set<Property> Functions
}
function GetaKind(key: exttKey; default: atptObjKind): atptObjKind; external;
function SetaKind(key: exttKey; added, changed: atptObjKind): atptObjKind; external;

function GetaTypeKind(key: exttKey; default: atptTypeKind): atptTypeKind; external;
function SetaTypeKind(key: exttKey; added, changed: atptTypeKind): atptTypeKind; external;

function GetaOpKind(key: exttKey; default: atptOpKind): atptOpKind; external;
function SetaOpKind(key: exttKey; added, changed: atptOpKind): atptOpKind; external;

function GetaValue(key: exttKey; default: atpINT): atpINT; external;
function SetaValue(key: exttKey; added, changed: atpINT): atpINT; external;

function GetaClassId(key: exttKey; default: atptOilClass): atptOilClass; external;
function SetaClassId(key: exttKey; added, changed: atptOilClass): atptOilClass; external;

function GetaTypeId(key: exttKey; default: atptOilType): atptOilType; external;
function SetaTypeId(key: exttKey; added, changed: atptOilType): atptOilType; external;

function GetaOpId(key: exttKey; default: atptOilOp): atptOilOp; external;
function SetaOpId(key: exttKey; added, changed: atptOilOp): atptOilOp; external;

function GetaSetValue(key: exttKey; default: atptStructTypeSet): atptStructTypeSet; external;
function SetaSetValue(key: exttKey; added, changed: atptStructTypeSet): atptStructTypeSet; external;

{
   Add a tuple to a relation
}
{
   Delete a tuple from a relation
}

function OilNewArgSig(dummy:boolean):tOilArgSig; external;	(* a zero length signature *)

function OilAddArgSig( arg:tOilType; sig:tOilArgSig ):tOilArgSig; external;

function OilNewSetSig(dummy:boolean):tOilArgSig; external ; (* no args *)
function OilAddSetSig( arg:tOilTypeSet; sig:tOilArgSig ):tOilArgSig; external;

function OilNewOp(
        id:oilName;
	cost:integer;
	sig:tOilArgSig
	):tOilOp;external;

function OilErrorOp:tOilOp; external;



function OilAddIdentification( id, op:tOilOp ):boolean;external; 



function OilNewType( id:oilName ):tOilType;external;

function OilErrorType:tOilType;external;

(* define a new type of class 'c' with element type 'et' with name 'id' *)
function OilNewTypeInClass(
	c:tOilClass;
	as:tOilArgSig;
	id:oilName
	):tOilType;external;

(* validate that type 't2' is in the type set 't1'	*)
function  OilSetIncludes(
	t1:tOilTypeSet;
	t2:tOilType
	):boolean;external;
function OilEmptyTS( ts:tOilTypeSet ):boolean;external;
function OilHeadTS( ts:tOilTypeSet ):tOilType;external;
function OilTailTS( ts:tOilTypeSet ):tOilTypeSet;external;

function OilIsCoercibleTo( t1,t2: tOilType ):boolean;external;

(* Check the sets of possible actual argument types to see if they might
	be coerced to the corresponding formal type *)
function OilCanIdSigs(
	src:tOilSetSig;
	dest:tOilArgSig
	):boolean;external;

(* check for valid coercion*)
function OilIsValidCS( ccs:tOilCoercionSeq ):boolean;external;

function OilErrorCS:tOilCoercionSeq;external;

(* check for valid operator*)
function OilIsValidOp( op:tOilOp ):boolean;external;

(* return coercion sequence for coercing 't1' to 't2'*)
function OilCoerce( t1, t2:tOilType ):tOilCoercionSeq;external;

function OilAddCoercion( op:tOilOp ):boolean;external;

function OilEmptyCS( cs:tOilCoercionSeq ):boolean;external;

function OilHeadCS( cs:tOilCoercionSeq ):tOilOp;external;

function OilTailCS( cs:tOilCoercionSeq ):tOilCoercionSeq;external;



(* find all possible result types which might be indicated by 'ind'
	with arguments 'setsig' *)
function OilIdResultSet(
	ind:tOilOp;
	setsig:tOilSetSig
	):tOilTypeSet;external;

function OilTypeToSet( t:tOilType ):tOilTypeSet;external;

function OilBalance( ts1, ts2:tOilTypeSet ):tOilType; external;
 

function OilNewClass(
	id:oilName;
	argNum:integer
	):tOilClass;external;


function OilNewClassSigArg( dummy: boolean ):tOilClassArgSig;external;

function OilAddClassSigArg(
	td:tOilClassSigArgDesc;
	st:tOilType;
	pi:integer;
	cs:tOilClassArgSig
	):tOilClassArgSig;external;


function OilAddClassOp(
	id:oilName;
	sig:tOilClassArgSig;
	cost:integer;
	class:tOilClass
	):tOilClassOp; external;

function OilAddClassOpId(
	ind:tOilOp;
	op:tOilClassOp
	):boolean;external;


function OilAddClassCoercion(
	op:tOilClassOp
	):boolean;external;


(* Get type of argument #n of operator 'op' *)
function OilGetArgType(
	op:tOilOp;  n:integer
	):tOilType; external;


	(* the end of oiladt2a.pp *)
(*              begin OIL.pp PROC               *)

(************************************************
  InitCompilerAdt - init compiler's ADT
  EmitCompilerAdt - output the Compiler's tables
  *)
procedure InitCompilerAdt;external;
procedure EmitCompilerAdt;external;



(**************************************************
  cErrorType, cErrorOp -
	define the error handling values
  ****************)
function cErrorType: tOilType; external;
function cErrorOp: tOilOp; external;
function cErrorClass: tOilClass; external;



(**************************************************
  DefClass, DefType, DefOp, DefClassOp -
	Calls the OilAdt to construct the object and adds it to the
	corresponding local table.
  ****************)

function DefClass( name:integer; numArgs:integer ): tOilClass; external;

function DefType( name:integer ): tOilType; external;

function DefOp(
	name:integer;
	sig:tOilArgSig;
	cost:integer
	): tOilOp; external;

function DefClassOp(
	name:integer;
	sig:tOilClassArgSig;
	cost:integer; 
	class:tOilClass
	): tOilClassOp; external;

function DefSetOp(
	name:integer;
	sig:tOilArgSig;
	cost:integer
	): tOilOp; external;


(*              end of OIL.pp PROC              *)



procedure Zerteiler; external;

(*&INCLUDE ATTR_PROC_LOC*)

(*===============================================================*)


procedure ATTREVAL;
        (*========*)
const

   ANCESTORVISIT = 0;         (* VS-CODE OF VISIT TO THE ANCESTOR *)

var

FIRSTTIME     : Boolean;

GENSYMBCOUNTER: integer;
GENNUMCOUNTER : integer;

AUXPTR        : NODEPTR;
AUXELEMPTR,
FIRSTELEM,
LASTELEM      : TPLISTELEMPTR;
EMPTY         : TPLIST;


(* VARIABLES TO MEASURE PERFORMANCE: *)

MC            : integer;  (* COUNTS MARK/RELEASE AROUND CONDITIONS *)
LCOUNT,LPOPCOUNT,         (* COUNTS LIST LINK RECORDS ALLOCATED    *)
STCOUNT,STPOPCOUNT,       (* COUNTS STACK PORTIONS ALLOCATED       *)
BCOUNT,                   (* COUNTS LIST NODES                     *)
SCPCOUNT,                 (* COUNTS ELIM. SEM. CHAIN PRODUCTIONS   *)
ECOUNT        : integer;  (* COUNTS EMPTY NODES                    *)
(* END OF PERFORMANCE DATA *)

(* VARIABLES TO MEASURE HEAP STORAGE: *)
HEAPPOINTER   : ^ integer;
HEAPPOINTER1, HEAPPOINTER2 : record case WHAT : Boolean of
                             true : (PPI : ^ integer);
                             false: (PI  : integer  )
                             end;


     A350162key:T144tKey;
     A338162key:ATARRAYTYPE;
     Q338162key:SPRANGE;
     A314205numArgs:T87INT;
     A343208sig:T231tArgSig;
     A337208sig:T231tArgSig;
     A342210cost:ATARRAYTYPE;
     Q342210cost:SPRANGE;
     A347233value:T232tTypeSet;
     A329233value:ATARRAYTYPE;
     Q329233value:SPRANGE;
     A351249indication:T158tOilOp;
     A350253id:T90SYMB;
     A342305defEnv:T307tEnv;
     A337311identification:T88BOOL;
     A350320okind:T147tObjKind;
     A350324tkind:T149tTypeKind;
     A338324tkind:ATARRAYTYPE;
     Q338324tkind:SPRANGE;
     A329330definingId:ATARRAYTYPE;
     Q329330definingId:SPRANGE;
     A343339sigDesc:T230tTypeKindSet;
     A337339sigDesc:T230tTypeKindSet;
     A337340oid:T245tAnyOp;
     A345346setOp:ATARRAYTYPE;
     Q345346setOp:SPRANGE;
     A338348tid:T156tOilType;
     A351461GEN:T452GEN;
     C182dbNull:T144tKey;
     C284cErrorTypeSet:T160tStructTypeSet;
     

     
(*&END GEN INCLUDE*)


function COMPAREUNION (U1,U2:UNIONTYPE): Boolean;
forward;


function COMPARELIST (L1,L2 : TPLIST): Boolean;

var WEITER, RESULT : Boolean;
    P1, P2 : TPLISTELEMPTR;

begin

   if (L1.HEAD = L2.HEAD) and (L1.LAST = L2.LAST)
   then RESULT := true
   else begin
      P1 := L1.HEAD;
      P2 := L2.HEAD;
      WEITER := true;
      while (P1 <> nil) and (P2 <> nil) and WEITER do
      begin
         if P1^.ELEMENT = P2^.ELEMENT
         then WEITER := true
         else WEITER := COMPAREUNION(P1^.ELEMENT^,P2^.ELEMENT^);
         if P1 = L1.LAST
         then P1 := nil
         else P1 := P1^.NEXT;
         if P2 = L2.LAST
         then P2 := nil
         else P2 := P2^.NEXT;
     end;

     RESULT := WEITER and (P1 = nil) and (P2 = nil);
  end;

  COMPARELIST  :=  RESULT;

end; (*COMPARELIST*)



     function E144tKey(U1,U2:T144tKey):Boolean;
     forward;
     
     function E154tOilClass(U1,U2:T154tOilClass):Boolean;
     forward;
     
     function E156tOilType(U1,U2:T156tOilType):Boolean;
     forward;
     
     function E158tOilOp(U1,U2:T158tOilOp):Boolean;
     forward;
     
     function E160tStructTypeSet(U1,U2:T160tStructTypeSet):Boolean;
     forward;
     
     function E184tKeyList(U1,U2:T184tKeyList):Boolean;
     forward;
     
     function E209tOilArgSig(U1,U2:T209tOilArgSig):Boolean;
     forward;
     
     function E213tOilClassArgSig(U1,U2:T213tOilClassArgSig):Boolean
     ;
     forward;
     
     function E215tOilClassOp(U1,U2:T215tOilClassOp):Boolean;
     forward;
     
     function E245tAnyOp(U1,U2:T245tAnyOp):Boolean;
     forward;
     
     function E247tIdentPair(U1,U2:T247tIdentPair):Boolean;
     forward;
     
     function E277tArgSetValue(U1,U2:T277tArgSetValue):Boolean;
     forward;
     
     function E290tArgValue(U1,U2:T290tArgValue):Boolean;
     forward;
     
     function E307tEnv(U1,U2:T307tEnv):Boolean;
     forward;
     
     function E356tOilSetSig(U1,U2:T356tOilSetSig):Boolean;
     forward;
     
     function E357tOilTypeSet(U1,U2:T357tOilTypeSet):Boolean;
     forward;
     
     function E361tOilClassOpId(U1,U2:T361tOilClassOpId):Boolean;
     forward;
     
     function E362tOilClassCoercion(U1,U2:T362tOilClassCoercion):
     Boolean;
     forward;
     
     function E364tOilCoercionSeq(U1,U2:T364tOilCoercionSeq):Boolean
     ;
     forward;
     
     function COMPAREUNION(*(U1,U2:UNIONTYPE):Boolean*);
     
     var RESULT:Boolean;
     begin
          if U1.DISCR=U2.DISCR
          then case U1.DISCR of
          U87INT:RESULT:=U1.C87INT=U2.C87INT;
          U88BOOL:RESULT:=U1.C88BOOL=U2.C88BOOL;
          U89CHAR:RESULT:=U1.C89CHAR=U2.C89CHAR;
          U90SYMB:RESULT:=U1.C90SYMB=U2.C90SYMB;
          U91STRING:RESULT:=U1.C91STRING=U2.C91STRING;
          U144tKey:RESULT:=E144tKey(U1.C144tKey,U2.C144tKey);
          U147tObjKind:RESULT:=U1.C147tObjKind=U2.C147tObjKind;
          U149tTypeKind:RESULT:=U1.C149tTypeKind=U2.C149tTypeKind;
          U151tOpKind:RESULT:=U1.C151tOpKind=U2.C151tOpKind;
          U154tOilClass:RESULT:=E154tOilClass(U1.C154tOilClass,U2.
          C154tOilClass);
          U156tOilType:RESULT:=E156tOilType(U1.C156tOilType,U2.
          C156tOilType);
          U158tOilOp:RESULT:=E158tOilOp(U1.C158tOilOp,U2.
          C158tOilOp);
          U160tStructTypeSet:RESULT:=E160tStructTypeSet(U1.
          C160tStructTypeSet,U2.C160tStructTypeSet);
          U184tKeyList:RESULT:=E184tKeyList(U1.C184tKeyList,U2.
          C184tKeyList);
          U209tOilArgSig:RESULT:=E209tOilArgSig(U1.C209tOilArgSig,
          U2.C209tOilArgSig);
          U213tOilClassArgSig:RESULT:=E213tOilClassArgSig(U1.
          C213tOilClassArgSig,U2.C213tOilClassArgSig);
          U215tOilClassOp:RESULT:=E215tOilClassOp(U1.
          C215tOilClassOp,U2.C215tOilClassOp);
          U230tTypeKindSet:RESULT:=U1.C230tTypeKindSet=U2.
          C230tTypeKindSet;
          U234tTypeSetOp:RESULT:=U1.C234tTypeSetOp=U2.
          C234tTypeSetOp;
          U245tAnyOp:RESULT:=E245tAnyOp(U1.C245tAnyOp,U2.
          C245tAnyOp);
          U247tIdentPair:RESULT:=E247tIdentPair(U1.C247tIdentPair,
          U2.C247tIdentPair);
          U277tArgSetValue:RESULT:=E277tArgSetValue(U1.
          C277tArgSetValue,U2.C277tArgSetValue);
          U290tArgValue:RESULT:=E290tArgValue(U1.C290tArgValue,U2.
          C290tArgValue);
          U307tEnv:RESULT:=E307tEnv(U1.C307tEnv,U2.C307tEnv);
          U356tOilSetSig:RESULT:=E356tOilSetSig(U1.C356tOilSetSig,
          U2.C356tOilSetSig);
          U357tOilTypeSet:RESULT:=E357tOilTypeSet(U1.
          C357tOilTypeSet,U2.C357tOilTypeSet);
          U361tOilClassOpId:RESULT:=E361tOilClassOpId(U1.
          C361tOilClassOpId,U2.C361tOilClassOpId);
          U362tOilClassCoercion:RESULT:=E362tOilClassCoercion(U1.
          C362tOilClassCoercion,U2.C362tOilClassCoercion);
          U364tOilCoercionSeq:RESULT:=E364tOilCoercionSeq(U1.
          C364tOilCoercionSeq,U2.C364tOilCoercionSeq);
          U92LIST,U231tArgSig,U232tTypeSet,U246tSetOp,
          U250tIdentMap,U275tSetSig,U276tArgSetValues,
          U289tArgValues,U291tArgValueList,U452GEN,U453GEN,
          U454GEN:RESULT:=COMPARELIST(U1.COLIST,U2.COLIST);
          end else RESULT:=false;
          COMPAREUNION:=RESULT;
     end;
     
     function E144tKey(*(U1,U2:T144tKey):Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E144tKey:=RESULT
     end;
     
     function E154tOilClass(*(U1,U2:T154tOilClass):Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E154tOilClass:=RESULT
     end;
     
     function E156tOilType(*(U1,U2:T156tOilType):Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E156tOilType:=RESULT
     end;
     
     function E158tOilOp(*(U1,U2:T158tOilOp):Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E158tOilOp:=RESULT
     end;
     
     function E160tStructTypeSet(*(U1,U2:T160tStructTypeSet):Boolean
     *);
     var RESULT:Boolean;
     begin
          if U1=U2 then RESULT:=true
          else begin
            RESULT:=COMPARELIST(U1^.L233value,U2^.L233value)
            
          end;
          E160tStructTypeSet:=RESULT
     end;
     
     function E184tKeyList(*(U1,U2:T184tKeyList):Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E184tKeyList:=RESULT
     end;
     
     function E209tOilArgSig(*(U1,U2:T209tOilArgSig):Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E209tOilArgSig:=RESULT
     end;
     
     function E213tOilClassArgSig(*(U1,U2:T213tOilClassArgSig):
     Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E213tOilClassArgSig:=RESULT
     end;
     
     function E215tOilClassOp(*(U1,U2:T215tOilClassOp):Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E215tOilClassOp:=RESULT
     end;
     
     function E245tAnyOp(*(U1,U2:T245tAnyOp):Boolean*);
     var RESULT:Boolean;
     begin
          if U1=U2 then RESULT:=true
          else if U1^.DISCR=U2^.DISCR
          then case U1^.DISCR of
          U158tOilOp:RESULT:=E158tOilOp(U1^.C158tOilOp,U2^.
          C158tOilOp);
          U215tOilClassOp:RESULT:=E215tOilClassOp(U1^.
          C215tOilClassOp,U2^.C215tOilClassOp);
          U246tSetOp:RESULT:=COMPARELIST(U1^.C246tSetOp,U2^.
          C246tSetOp);
          end
          else RESULT:=false;
          E245tAnyOp:=RESULT
     end;
     
     function E247tIdentPair(*(U1,U2:T247tIdentPair):Boolean*);
     var RESULT:Boolean;
     begin
          if U1=U2 then RESULT:=true
          else begin
            RESULT:=false;
            if(U1^.L248op=U2^.L248op)then
            if E158tOilOp(U1^.L249indication,U2^.L249indication)
            then
            RESULT:=true
          end;
          E247tIdentPair:=RESULT
     end;
     
     function E277tArgSetValue(*(U1,U2:T277tArgSetValue):Boolean*);
     var RESULT:Boolean;
     begin
          if U1=U2 then RESULT:=true
          else begin
            RESULT:=false;
            if E144tKey(U1^.L253id,U2^.L253id)then
            if COMPARELIST(U1^.L233value,U2^.L233value)then
            RESULT:=true
          end;
          E277tArgSetValue:=RESULT
     end;
     
     function E290tArgValue(*(U1,U2:T290tArgValue):Boolean*);
     var RESULT:Boolean;
     begin
          if U1=U2 then RESULT:=true
          else begin
            RESULT:=false;
            if E144tKey(U1^.L253id,U2^.L253id)then
            if E156tOilType(U1^.L233value,U2^.L233value)then
            RESULT:=true
          end;
          E290tArgValue:=RESULT
     end;
     
     function E307tEnv(*(U1,U2:T307tEnv):Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E307tEnv:=RESULT
     end;
     
     function E356tOilSetSig(*(U1,U2:T356tOilSetSig):Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E356tOilSetSig:=RESULT
     end;
     
     function E357tOilTypeSet(*(U1,U2:T357tOilTypeSet):Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E357tOilTypeSet:=RESULT
     end;
     
     function E361tOilClassOpId(*(U1,U2:T361tOilClassOpId):Boolean*)
     ;
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E361tOilClassOpId:=RESULT
     end;
     
     function E362tOilClassCoercion(*(U1,U2:T362tOilClassCoercion):
     Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E362tOilClassCoercion:=RESULT
     end;
     
     function E364tOilCoercionSeq(*(U1,U2:T364tOilCoercionSeq):
     Boolean*);
     var RESULT:Boolean;
     begin
          RESULT:=U1=U2;E364tOilCoercionSeq:=RESULT
     end;
     
     
(*&END GEN INCLUDE*)

(* OPERATIONS PUSH AND POP ON ATTRIBUTE STACKS *)

procedure ATPUSH ( HIVAR : UNIONTYPE;
                   var SP: SPRANGE;
                   var AT: ATARRAYTYPE );
begin
  if AT = nil
  then begin
    new(AT);
    AT^[LINK].COARRAY := nil;
    AT^[0].COARRAY := nil;
    SP := 1;
  end else
  if SP = MAXSTACK
  then begin
    if AT^[LINK].COARRAY = nil
    then begin
      new(AT^[LINK].COARRAY);
      with AT^[LINK] do
      begin
        COARRAY^[0].COARRAY := AT; 
        COARRAY^[LINK].COARRAY := nil;
      end;
    end;
    AT := AT^[LINK].COARRAY;
    SP := 1;
  end
  else SP := SP + 1;
  AT^[SP] := HIVAR;
end; (* ATPUSH *)

procedure ATPOP ( var SP : SPRANGE; var AT : ATARRAYTYPE );

begin
  if (AT=nil) or (SP<=0)
  then MESSAGE(SYSERROR,SYSTEMERRORMSG,0,GLOBPOS.LINE,GLOBPOS.COL)
  else
  if SP = 1
  then if AT^[0].COARRAY = nil
       then SP := 0
       else begin
         AT := AT^[0].COARRAY;
         SP := MAXSTACK;
       end
  else SP := SP - 1 ;
end;



(* GENERAL INITIALIZATION *)

procedure INIT;
        (*====*)
begin

(* PERFORMANCE MEASUREMENT *)
MC := 0;
ECOUNT := 0;
BCOUNT := 0;
SCPCOUNT := 0;
STCOUNT := 0;  STPOPCOUNT := 0;
LCOUNT := 0;   LPOPCOUNT := 0;

GENNUMCOUNTER := 0;

EMPTY.HEAD := nil;  EMPTY.LAST := nil;


     
       A338162key:=nil;
       A342210cost:=nil;
       A329233value:=nil;
       A338324tkind:=nil;
       A329330definingId:=nil;
       A345346setOp:=nil;
       
     
     
(*&END GEN INCLUDE*)


end; (*INIT*)


(* functions for ALADIN list processing *)

procedure COPYLIST (L : TPLIST; var RES : TPLIST);
        (*========*)

var
     AUXL1, AUXL2 : TPLISTELEMPTR;


begin

   (* ASSERT(L.HEAD <> NIL) *)

   new(RES.HEAD);
   AUXL1 := RES.HEAD;
   AUXL2 := L.HEAD;
   AUXL1^.ELEMENT := AUXL2^.ELEMENT;
   while AUXL2 <> L.LAST do
   begin
      AUXL2 := AUXL2^.NEXT;
      new(AUXL1^.NEXT);
      AUXL1 := AUXL1^.NEXT;
      AUXL1^.ELEMENT := AUXL2^.ELEMENT;
   end;

   AUXL1^.NEXT := nil;
   RES.LAST := AUXL1;


end; (* COPYLIST *)


procedure CONCATELIST ( L1,L2 : TPLIST; var RES : TPLIST);
        (*===========*)
        (* RES := L1 + L2 *)

var LL          : TPLIST;
    CONT        : Boolean;
    AUXL1, AUXL2: TPLISTELEMPTR;

begin

  if L1.HEAD = nil
  then RES := L2  else
  if L2.HEAD = nil
  then RES := L1
  else begin
    LL := L1;  (* DEFAULT FIRST OPERAND (IF NO COPY NECESSARY) *)
    CONT := false;
    if L1.LAST^.NEXT <> nil
    then if L1.LAST^.NEXT <> L2.HEAD (* CONTINUATION IMPOSSIBLE *)
         then COPYLIST( L1,LL )
         else CONT := true
    else CONT := true;
    if CONT
    then begin                (* CHECK CYCLES *)
      AUXL1 := L1.HEAD;
      AUXL2 := L2.LAST;       (* COMPARE ELEMENT *)
      while AUXL1 <> nil do
      begin
        if AUXL1 = AUXL2
        then begin            (* CYCLE! *)
          COPYLIST( L1,LL );
          AUXL1 := nil;       (* STOP LOOP *)
        end else
        if AUXL1 = L1.LAST
        then AUXL1 := nil     (* STOP *)
        else AUXL1 := AUXL1^.NEXT;
      end (* WHILE AUXL1 *)
    end; (* IF CONT *)
    (* NOW LL HOLDS THE CORRECT FIRST OPERAND OF CONCATE *)

    LL.LAST^.NEXT := L2.HEAD;
    RES.HEAD := LL.HEAD;
    RES.LAST := L2.LAST
  end

end; (* CONCATELIST *)


procedure CONCATESTRING (S1,S2  : STRING; var RES : STRING);
        (*=============*)
begin

   RES := S1; (* NOT_YET_IMPLEMENTED; *)

end;


procedure LINLIST (L1 : TPLIST; var RES : TPLIST);
        (*=======*)

var AUXLISTPTR : TPLISTELEMPTR;
    AUXLIST    : TPLIST;

begin

   RES.HEAD := nil;
   RES.LAST := nil;

   AUXLISTPTR := L1.HEAD;

   while AUXLISTPTR <> nil do
   begin

     (* ASSERT(AUXLISTPTR^.ELEMENT^.DISCR IN [HI_LIST,... ] *)

     (* FALLS NOETIG, TEIL-LISTE KOPIEREN, DAMIT NICHT *)
     (* SPAETER DIE GANZE LISTE KOPIERT WERDEN MUSS    *)

     with AUXLISTPTR^.ELEMENT^ do
     if (COLIST.HEAD <> nil) and
     (* (COLIST.LAST <> NIL) AND *)
        (AUXLISTPTR <> L1.LAST)
     then if COLIST.LAST^.NEXT <> nil
          then if COLIST.LAST^.NEXT <>
                  AUXLISTPTR^.NEXT^.ELEMENT^.COLIST.HEAD
               then  COPYLIST(COLIST,AUXLIST)
               else AUXLIST := COLIST
          else  AUXLIST := COLIST
     else  AUXLIST := COLIST;

     CONCATELIST (RES, AUXLIST, RES) ;
     if AUXLISTPTR = L1.LAST
     then AUXLISTPTR := nil
     else AUXLISTPTR := AUXLISTPTR^.NEXT;

   end; (* WHILE *)

end; (* LINLIST *)


procedure HEAD (L:TPLIST ; var FTHEAD: UNIONTYPE);
forward;

procedure LAST (L:TPLIST ; var FTLAST: UNIONTYPE);
forward;

procedure FRONT (L:TPLIST ; var FTFRONT: UNIONTYPE);
forward;

procedure TAIL (L:TPLIST ; var FTTAIL: UNIONTYPE);
forward;

function LENGTH (L:TPLIST ) : integer;
forward;

(*FUNCTION EMPTY (L:TPLIST ) : Boolean;
FORWARD; ------- BUILT IN!    *)

function ELEMINLIST (E :UNIONTYPE; L : TPLIST ) : Boolean;
forward;

function LISTINCLUSION  (L1,L2 :TPLIST ) : Boolean;
forward;

function UNIQUEELEMS  (L :TPLIST ) : Boolean;
forward;


procedure HEAD (* (L :TPLIST ;
                   VAR FTHEAD:UNIONTYPE) *) ;
begin

  if L.HEAD = nil
  then MESSAGE(IMPLCONDFAILS,HEADFAILSMSG,0,GLOBPOS.LINE,GLOBPOS.COL)
  else FTHEAD := L.HEAD^.ELEMENT^
  (* ELEMENT IS OF ^UNIONTYPE *)

end  (*HEAD*);



procedure LAST (* (L: TPLIST ;
                   VAR FTLAST:UNIONTYPE) *) ;
begin

  if L.LAST = nil
  then MESSAGE(IMPLCONDFAILS,LASTFAILSMSG,0,GLOBPOS.LINE,GLOBPOS.COL)
  else FTLAST := L.LAST^.ELEMENT^
  (* ELEMENT IS OF ^UNIONTYPE *)

end  (*LAST*);



procedure FRONT (* (L: TPLIST ;
                    VAR FTFRONT:UNIONTYPE) *);
var LPTR : TPLISTELEMPTR;

begin

  if L.HEAD = L.LAST
  then begin
    FTFRONT.COLIST.HEAD := nil;
    FTFRONT.COLIST.LAST := nil;
  end
  else begin
    FTFRONT.COLIST.HEAD := L.HEAD;
    LPTR := L.HEAD;
    while LPTR^.NEXT <> L.LAST do LPTR := LPTR^.NEXT;
    FTFRONT.COLIST.LAST := LPTR
  end;
  (* ALADIN-TYP VON FTFRONT IST TPLIST => KEINE DISCR NOETIG *)

end (*FRONT*) ;


procedure TAIL (* (L: TPLIST ;
                   VAR FTTAIL:UNIONTYPE) *) ;
begin

  if L.HEAD = L.LAST
  then begin
    FTTAIL.COLIST.HEAD := nil;
    FTTAIL.COLIST.LAST := nil
  end
  else begin
    FTTAIL.COLIST.HEAD := L.HEAD^.NEXT;
    FTTAIL.COLIST.LAST := L.LAST
  end;
  (* ALADIN-TYP VON FTTAIL IST TPLIST => KEINE DISCR NOETIG *)

end  (*TAIL*) ;


function LENGTH (* (L: TPLIST ):INTEGER *) ;

var LPTR: TPLISTELEMPTR; LE: integer;

begin

  if L.HEAD = nil then LENGTH := 0
                  else
  begin
    LPTR := L.HEAD;
    LE := 1;
    while LPTR <> L.LAST do
    begin
      LE := LE + 1;
      LPTR := LPTR^.NEXT
    end;
    LENGTH := LE
  end

end (*LENGTH*);

(*FUNCTION EMPTY    (L: TPLIST ):Boolean *)
(*BEGIN  EMPTY := L.HEAD=NIL  END;       *)


function ELEMINLIST (* (E:UNIONTYPE; L:TPLIST ):Boolean *) ;
var LL : TPLISTELEMPTR; FOUND : Boolean;

begin

  FOUND := false; LL := L.HEAD;
  while (LL <> nil) and not FOUND do
    if COMPAREUNION(LL^.ELEMENT^,E)
    then FOUND := true
    else if LL = L.LAST
         then LL := nil
         else LL := LL^.NEXT;
  ELEMINLIST := FOUND

end (*ELEMINLIST*);


function LISTINCLUSION(*(L1: TPLIST; L2: TPLIST ): Boolean *) ;
var HIVAR1,HIVAR2: Boolean; LL1,LL2 : TPLISTELEMPTR;

begin

   LL1 := L1.HEAD; HIVAR1 := true;
   while (LL1 <> nil) and HIVAR1 do
   begin
     LL2 := L2.HEAD; HIVAR2 := false;
     while (LL2 <> nil) and not HIVAR2 do
       if COMPAREUNION(LL1^.ELEMENT^,LL2^.ELEMENT^)
       then HIVAR2 := true
       else if LL2 = L2.LAST
            then LL2 := nil
            else LL2 := LL2^.NEXT;
     HIVAR1 := HIVAR2;
     if LL1 = L1.LAST then LL1 := nil
     else LL1 := LL1^.NEXT
   end;
   LISTINCLUSION:=HIVAR1;

end(*LIST_INCLUSION*);


function UNIQUEELEMS(*(L: TPLIST ):Boolean;*);

var LL,LLT : TPLISTELEMPTR; HIVAR0: Boolean;

begin

   LL := L.HEAD; HIVAR0 := true;
   while (LL <> nil) and HIVAR0 do
   begin
     if LL = L.LAST then LL := nil
     else begin
       LLT := LL^.NEXT;
       while (LLT <> nil) and HIVAR0 do
       begin
         if COMPAREUNION(LL^.ELEMENT^,LLT^.ELEMENT^)
         then HIVAR0 := false
         else if LLT = L.LAST
         then LLT := nil else LLT := LLT^.NEXT
       end;
       if HIVAR0 then LL := LL^.NEXT
     end;
   end;
   UNIQUEELEMS := HIVAR0

end(*UNIQUE_ELEMS*);

(*KEY functions*)

function KEYINLIST  (LK: UNIONTYPE; L: TPLIST;
                     KEYDISCR : ALLTYPES) :       Boolean;

var LL : TPLISTELEMPTR; HIVAR1: UNIONTYPE; FOUND : Boolean;

begin
  LL := L.HEAD; FOUND := false;
  while (LL <> nil) and not FOUND do
  begin
    HIVAR1 := LL^.ELEMENT^;
    (* CASE KEYDISCR OF <ALL KEYLISTS> *)


case KEYDISCR of
U250tIdentMap:begin
   HIVAR1.C90SYMB:=HIVAR1.C247tIdentPair^.L248op;
   HIVAR1.DISCR:=U90SYMB;
end;
U276tArgSetValues:begin
   HIVAR1.C144tKey:=HIVAR1.C277tArgSetValue^.L253id;
   HIVAR1.DISCR:=U144tKey;
end;
U289tArgValues:begin
   HIVAR1.C144tKey:=HIVAR1.C290tArgValue^.L253id;
   HIVAR1.DISCR:=U144tKey;
end;
end;

(*&END GEN INCLUDE*)

    if COMPAREUNION(HIVAR1,LK) then FOUND := true
    else if LL = L.LAST
         then LL := nil else LL := LL^.NEXT
  end;
  KEYINLIST := FOUND;
end;


procedure SELECTBYKEY ( LK: UNIONTYPE; L: TPLIST; KEYDISCR : ALLTYPES;
                        var FTSELECTBYKEY: UNIONTYPE) ;
var LL: TPLISTELEMPTR; HIVAR1: UNIONTYPE;
    FOUND : Boolean;

begin
 LL := L.HEAD; FOUND := false;
 while (LL <> nil) and not FOUND do
 begin
   HIVAR1 := LL^.ELEMENT^;
   (* CASE KEYDISCR OF <ALL KEYLISTS> *)


case KEYDISCR of
U250tIdentMap:begin
   HIVAR1.C90SYMB:=HIVAR1.C247tIdentPair^.L248op;
   HIVAR1.DISCR:=U90SYMB;
end;
U276tArgSetValues:begin
   HIVAR1.C144tKey:=HIVAR1.C277tArgSetValue^.L253id;
   HIVAR1.DISCR:=U144tKey;
end;
U289tArgValues:begin
   HIVAR1.C144tKey:=HIVAR1.C290tArgValue^.L253id;
   HIVAR1.DISCR:=U144tKey;
end;
end;

(*&END GEN INCLUDE*)

   if COMPAREUNION(HIVAR1,LK) then FOUND := true
   else if LL = L.LAST
        then LL := nil else LL := LL^.NEXT;
 end;
 if FOUND then FTSELECTBYKEY := LL^.ELEMENT^
 else MESSAGE(IMPLCONDFAILS,KEYFAILSMSG,0,GLOBPOS.LINE,GLOBPOS.COL);

end;

function UNIQUEKEYS (L:TPLIST; KEYDISCR : ALLTYPES) : Boolean ;
var UNIQUE: Boolean; HIVAR1 : UNIONTYPE; LL: TPLISTELEMPTR;
    L2 : TPLIST;
begin
  L2 := L;
  LL := L.HEAD; UNIQUE := true;
  while (LL <> nil) and UNIQUE do
  begin
    if LL = L.LAST then LL := nil
    else begin
      HIVAR1 := LL^.ELEMENT^;
      LL := LL^.NEXT;
      (* CASE KEYDISCR OF <ALL KEYLISTS> *)


case KEYDISCR of
U250tIdentMap:begin
   HIVAR1.C90SYMB:=HIVAR1.C247tIdentPair^.L248op;
   HIVAR1.DISCR:=U90SYMB;
end;
U276tArgSetValues:begin
   HIVAR1.C144tKey:=HIVAR1.C277tArgSetValue^.L253id;
   HIVAR1.DISCR:=U144tKey;
end;
U289tArgValues:begin
   HIVAR1.C144tKey:=HIVAR1.C290tArgValue^.L253id;
   HIVAR1.DISCR:=U144tKey;
end;
end;

(*&END GEN INCLUDE*)

      L2.HEAD := LL;
      UNIQUE := not KEYINLIST(HIVAR1,L2,KEYDISCR)
    end
  end;
  UNIQUEKEYS := UNIQUE
end;

(*end of KEY-list functions*)

(*end of list functions*)

function REPETITION (LNODE :  NODEPTR) : integer;
       (*==========*)

var I : integer;

begin
   I := 0;
   LNODE := LNODE^.ELEMS;
   while LNODE <> nil do
   begin
      I := I + 1;
      LNODE := LNODE^.BROTHER;
   end;
   REPETITION := I;

end; (* REPETITION *)

function GENNUM : integer;
begin
  GENNUMCOUNTER := GENNUMCOUNTER + 1;
  GENNUM := GENNUMCOUNTER
end (*GENNUM*);

function GENSYMB : SYMB;
begin
  if GENSYMBCOUNTER = MAXSYMB
  then MESSAGE(SYSLIMIT,GENSYMBFULLMSG,0,GLOBPOS.LINE,GLOBPOS.COL)
  else GENSYMBCOUNTER := GENSYMBCOUNTER + 1;
  GENSYMB := GENSYMBCOUNTER
end (*GENSYMB*);


function F161GetaKind(X162key:T144tKey;
          X163default:T147tObjKind):T147tObjKind;
forward;
function F164SetaKind(X162key:T144tKey;
          X165added:T147tObjKind;
          X166changed:T147tObjKind):T147tObjKind;
forward;
function F167GetaTypeKind(X162key:T144tKey;
          X163default:T149tTypeKind):T149tTypeKind;
forward;
function F168SetaTypeKind(X162key:T144tKey;
          X165added:T149tTypeKind;
          X166changed:T149tTypeKind):T149tTypeKind;
forward;
function F169GetaOpKind(X162key:T144tKey;
          X163default:T151tOpKind):T151tOpKind;
forward;
function F170SetaOpKind(X162key:T144tKey;
          X165added:T151tOpKind;
          X166changed:T151tOpKind):T151tOpKind;
forward;
function F171GetaValue(X162key:T144tKey;
          X163default:T87INT):T87INT;
forward;
function F172SetaValue(X162key:T144tKey;
          X165added:T87INT;
          X166changed:T87INT):T87INT;
forward;
function F173GetaClassId(X162key:T144tKey;
          X163default:T154tOilClass):T154tOilClass;
forward;
function F174SetaClassId(X162key:T144tKey;
          X165added:T154tOilClass;
          X166changed:T154tOilClass):T154tOilClass;
forward;
function F175GetaTypeId(X162key:T144tKey;
          X163default:T156tOilType):T156tOilType;
forward;
function F176SetaTypeId(X162key:T144tKey;
          X165added:T156tOilType;
          X166changed:T156tOilType):T156tOilType;
forward;
function F177GetaOpId(X162key:T144tKey;
          X163default:T158tOilOp):T158tOilOp;
forward;
function F178SetaOpId(X162key:T144tKey;
          X165added:T158tOilOp;
          X166changed:T158tOilOp):T158tOilOp;
forward;
function F179GetaSetValue(X162key:T144tKey;
          X163default:T160tStructTypeSet):T160tStructTypeSet;
forward;
function F180SetaSetValue(X162key:T144tKey;
          X165added:T160tStructTypeSet;
          X166changed:T160tStructTypeSet):T160tStructTypeSet;
forward;
function F183dbfNull:T144tKey;
forward;
function F186dbFind(X187relId:T87INT;
          X188roleId1:T87INT;
          X162key:T144tKey;
          X189roleId2:T87INT):T184tKeyList;
forward;
function F190dbOlReset(X191keyList:T184tKeyList):T184tKeyList;
forward;
function F192dbOlNext(X191keyList:T184tKeyList):T144tKey;
forward;
function F193dbOlFirst(X191keyList:T184tKeyList):T144tKey;
forward;
function F194dbNewObject(X195otype:T87INT):T144tKey;
forward;
function F196dbGetObjectType(X162key:T144tKey):T87INT;
forward;
function F197dbSetObjectType(X162key:T144tKey;
          X195otype:T87INT):T88BOOL;
forward;
function F198dbTestObjectType(X162key:T144tKey;
          X195otype:T87INT;
          X199msg:T87INT):T88BOOL;
forward;
function F200NewDef:T144tKey;
forward;
function F201NoDef:T144tKey;
forward;
function F202DefInit:T88BOOL;
forward;
function F203DefClass(X204name:T90SYMB;
          X205numArgs:T87INT):T154tOilClass;
forward;
function F206DefType(X204name:T90SYMB):T156tOilType;
forward;
function F207DefOp(X204name:T90SYMB;
          X208sig:T209tOilArgSig;
          X210cost:T87INT):T158tOilOp;
forward;
function F211DefSetOp(X204name:T90SYMB;
          X208sig:T209tOilArgSig;
          X210cost:T87INT):T158tOilOp;
forward;
function F212DefClassOp(X204name:T90SYMB;
          X208sig:T213tOilClassArgSig;
          X210cost:T87INT;
          X214class:T154tOilClass):T215tOilClassOp;
forward;
function F228ObjKindCheck(X195otype:T147tObjKind;
          X229typeWanted:T147tObjKind):T88BOOL;
forward;
procedure P238SetUnion(X239left:T232tTypeSet;
          X240right:T232tTypeSet;
          var F238SetUnion:UNIONTYPE);
forward;
procedure P243SetIntersect(X239left:T232tTypeSet;
          X240right:T232tTypeSet;
          var F243SetIntersect:UNIONTYPE);
forward;
procedure P244SetDifference(X239left:T232tTypeSet;
          X240right:T232tTypeSet;
          var F244SetDifference:UNIONTYPE);
forward;
function F251AddIdentification(X252Op:T245tAnyOp;
          X214class:T154tOilClass;
          X253id:T90SYMB;
          X254identMap:T250tIdentMap):T88BOOL;
forward;
function F257OilAddIdentification(X253id:T158tOilOp;
          X248op:T158tOilOp):T88BOOL;
forward;
function F258OilAddClassOpId(X391ind:T158tOilOp;
          X248op:T215tOilClassOp):T88BOOL;
forward;
function F259AddSetOpId(X253id:T158tOilOp;
          X248op:T246tSetOp):T88BOOL;
forward;
function F260PrimSig(X261argSig:T231tArgSig):T209tOilArgSig;
forward;
function F262OilNewArgSig(X316dummy:T88BOOL):T209tOilArgSig;
forward;
function F263OilAddArgSig(X267arg:T156tOilType;
          X208sig:T209tOilArgSig):T209tOilArgSig;
forward;
function F264cErrorType:T156tOilType;
forward;
function F265ClassSig(X261argSig:T231tArgSig):T213tOilClassArgSig;
forward;
function F266OilNewClassSigArg(X316dummy:T88BOOL):
T213tOilClassArgSig;
forward;
function F274OilAddClassSigArg(X269td:T87INT;
          X272st:T156tOilType;
          X273pi:T87INT;
          X387cs:T213tOilClassArgSig):T213tOilClassArgSig;
forward;
procedure P278SetSig(X261argSig:T231tArgSig;
          var F278SetSig:UNIONTYPE);
forward;
procedure P280UniqueIds(X279uids:T276tArgSetValues;
          X285actualSig:T231tArgSig;
          var F280UniqueIds:UNIONTYPE);
forward;
procedure P282UniqueValues(X279uids:T276tArgSetValues;
          var F282UniqueValues:UNIONTYPE);
forward;
procedure P283UniqueSigs(X279uids:T291tArgValueList;
          X285actualSig:T231tArgSig;
          var F283UniqueSigs:UNIONTYPE);
forward;
procedure P288MapIdToSet(X286aid:T144tKey;
          X279uids:T276tArgSetValues;
          var F288MapIdToSet:UNIONTYPE);
forward;
procedure P292ConsValueS(X253id:T144tKey;
          X233value:T232tTypeSet;
          X293others:T291tArgValueList;
          var F292ConsValueS:UNIONTYPE);
forward;
procedure P294ConsValue(X253id:T144tKey;
          X233value:T232tTypeSet;
          X293others:T289tArgValues;
          var F294ConsValue:UNIONTYPE);
forward;
function F295UniqueSig(X296avs:T289tArgValues;
          X285actualSig:T231tArgSig):T209tOilArgSig;
forward;
procedure P298AddSetOp(X253id:T90SYMB;
          X208sig:T275tSetSig;
          X210cost:T87INT;
          var F298AddSetOp:UNIONTYPE);
forward;
function F299AddSetCoercion(X248op:T246tSetOp):T88BOOL;
forward;
function F300OilAddCoercion(X248op:T158tOilOp):T88BOOL;
forward;
function F301cErrorOp:T158tOilOp;
forward;
function F302cErrorClass:T154tOilClass;
forward;
function F309NewEnv:T307tEnv;
forward;
function F319DefineIdn(X406e:T307tEnv;
          X407i:T90SYMB):T144tKey;
forward;
function F322KeyInScope(X406e:T307tEnv;
          X407i:T90SYMB):T144tKey;
forward;
function F323NewScope(X406e:T307tEnv):T307tEnv;
forward;
function F325KeyInEnv(X406e:T307tEnv;
          X407i:T90SYMB):T144tKey;
forward;
function F341OilAddClassCoercion(X248op:T215tOilClassOp):T88BOOL;
forward;
function F366OilNewSetSig(X316dummy:T88BOOL):T209tOilArgSig;
forward;
function F367OilAddSetSig(X267arg:T357tOilTypeSet;
          X208sig:T209tOilArgSig):T209tOilArgSig;
forward;
function F368OilNewOp(X253id:T87INT;
          X210cost:T87INT;
          X208sig:T209tOilArgSig):T158tOilOp;
forward;
function F369OilErrorOp:T158tOilOp;
forward;
function F370OilNewType(X253id:T87INT):T156tOilType;
forward;
function F371OilErrorType:T156tOilType;
forward;
function F372OilNewTypeInClass(X321c:T154tOilClass;
          X373as:T209tOilArgSig;
          X253id:T87INT):T156tOilType;
forward;
function F374OilSetIncludes(X375t1:T357tOilTypeSet;
          X376t2:T156tOilType):T88BOOL;
forward;
function F377OilIsCoercibleTo(X375t1:T156tOilType;
          X376t2:T156tOilType):T88BOOL;
forward;
function F378OilCanIdSigs(X379src:T356tOilSetSig;
          X380dest:T209tOilArgSig):T88BOOL;
forward;
function F381OilIsValidCS(X382ccs:T364tOilCoercionSeq):T88BOOL;
forward;
function F383OilErrorCS:T364tOilCoercionSeq;
forward;
function F384OilIsValidOp(X248op:T158tOilOp):T88BOOL;
forward;
function F385OilCoerce(X375t1:T156tOilType;
          X376t2:T156tOilType):T364tOilCoercionSeq;
forward;
function F386OilEmptyCS(X387cs:T364tOilCoercionSeq):T88BOOL;
forward;
function F388OilHeadCS(X387cs:T364tOilCoercionSeq):T158tOilOp;
forward;
function F389OilTailCS(X387cs:T364tOilCoercionSeq):
T364tOilCoercionSeq;
forward;
function F390OilIdResultSet(X391ind:T158tOilOp;
          X392setsig:T356tOilSetSig):T357tOilTypeSet;
forward;
function F393OilTypeToSet(X394t:T156tOilType):T357tOilTypeSet;
forward;
function F395OilBalance(X396ts1:T357tOilTypeSet;
          X397ts2:T357tOilTypeSet):T156tOilType;
forward;
function F398OilSelectTypeFromTS(X399ts:T357tOilTypeSet):
T156tOilType;
forward;
function F400OilNewClass(X253id:T87INT;
          X401argNum:T87INT):T154tOilClass;
forward;
function F402OilAddClassOp(X253id:T87INT;
          X208sig:T213tOilClassArgSig;
          X210cost:T87INT;
          X321c:T154tOilClass):T215tOilClassOp;
forward;
function F403OilGetArgType(X248op:T158tOilOp;
          X404n:T87INT):T156tOilType;
forward;
function F408AddIdn(X406e:T307tEnv;
          X407i:T90SYMB;
          X349k:T144tKey):T144tKey;
forward;
(*&END GEN INCLUDE*)



(*  19,  10 *)
function F161GetaKind(*(X162key:T144tKey;
          X163default:T147tObjKind):T147tObjKind;*);
begin
   F161GetaKind:=GetaKind(X162key,X163default)
end(*GetaKind*);
(*  20,  10 *)
function F164SetaKind(*(X162key:T144tKey;
          X165added:T147tObjKind;
          X166changed:T147tObjKind):T147tObjKind;*);
begin
   F164SetaKind:=SetaKind(X162key,X165added,X166changed)
end(*SetaKind*);
(*  22,  10 *)
function F167GetaTypeKind(*(X162key:T144tKey;
          X163default:T149tTypeKind):T149tTypeKind;*);
begin
   F167GetaTypeKind:=GetaTypeKind(X162key,X163default)
end(*GetaTypeKind*);
(*  23,  10 *)
function F168SetaTypeKind(*(X162key:T144tKey;
          X165added:T149tTypeKind;
          X166changed:T149tTypeKind):T149tTypeKind;*);
begin
   F168SetaTypeKind:=SetaTypeKind(X162key,X165added,X166changed)
end(*SetaTypeKind*);
(*  25,  10 *)
function F169GetaOpKind(*(X162key:T144tKey;
          X163default:T151tOpKind):T151tOpKind;*);
begin
   F169GetaOpKind:=GetaOpKind(X162key,X163default)
end(*GetaOpKind*);
(*  26,  10 *)
function F170SetaOpKind(*(X162key:T144tKey;
          X165added:T151tOpKind;
          X166changed:T151tOpKind):T151tOpKind;*);
begin
   F170SetaOpKind:=SetaOpKind(X162key,X165added,X166changed)
end(*SetaOpKind*);
(*  28,  10 *)
function F171GetaValue(*(X162key:T144tKey;
          X163default:T87INT):T87INT;*);
begin
   F171GetaValue:=GetaValue(X162key,X163default)
end(*GetaValue*);
(*  29,  10 *)
function F172SetaValue(*(X162key:T144tKey;
          X165added:T87INT;
          X166changed:T87INT):T87INT;*);
begin
   F172SetaValue:=SetaValue(X162key,X165added,X166changed)
end(*SetaValue*);
(*  31,  10 *)
function F173GetaClassId(*(X162key:T144tKey;
          X163default:T154tOilClass):T154tOilClass;*);
begin
   F173GetaClassId:=GetaClassId(X162key,X163default)
end(*GetaClassId*);
(*  32,  10 *)
function F174SetaClassId(*(X162key:T144tKey;
          X165added:T154tOilClass;
          X166changed:T154tOilClass):T154tOilClass;*);
begin
   F174SetaClassId:=SetaClassId(X162key,X165added,X166changed)
end(*SetaClassId*);
(*  34,  10 *)
function F175GetaTypeId(*(X162key:T144tKey;
          X163default:T156tOilType):T156tOilType;*);
begin
   F175GetaTypeId:=GetaTypeId(X162key,X163default)
end(*GetaTypeId*);
(*  35,  10 *)
function F176SetaTypeId(*(X162key:T144tKey;
          X165added:T156tOilType;
          X166changed:T156tOilType):T156tOilType;*);
begin
   F176SetaTypeId:=SetaTypeId(X162key,X165added,X166changed)
end(*SetaTypeId*);
(*  37,  10 *)
function F177GetaOpId(*(X162key:T144tKey;
          X163default:T158tOilOp):T158tOilOp;*);
begin
   F177GetaOpId:=GetaOpId(X162key,X163default)
end(*GetaOpId*);
(*  38,  10 *)
function F178SetaOpId(*(X162key:T144tKey;
          X165added:T158tOilOp;
          X166changed:T158tOilOp):T158tOilOp;*);
begin
   F178SetaOpId:=SetaOpId(X162key,X165added,X166changed)
end(*SetaOpId*);
(*  40,  10 *)
function F179GetaSetValue(*(X162key:T144tKey;
          X163default:T160tStructTypeSet):T160tStructTypeSet;*);
begin
   F179GetaSetValue:=GetaSetValue(X162key,X163default)
end(*GetaSetValue*);
(*  41,  10 *)
function F180SetaSetValue(*(X162key:T144tKey;
          X165added:T160tStructTypeSet;
          X166changed:T160tStructTypeSet):T160tStructTypeSet;*);
begin
   F180SetaSetValue:=SetaSetValue(X162key,X165added,X166changed)
end(*SetaSetValue*);
(*  68,  18 *)
function F183dbfNull(*:T144tKey;*);
begin
   F183dbfNull:=dbfNull
end(*dbfNull*);
(*  85,  10 *)
function F186dbFind(*(X187relId:T87INT;
          X188roleId1:T87INT;
          X162key:T144tKey;
          X189roleId2:T87INT):T184tKeyList;*);
begin
   F186dbFind:=dbFind(X187relId,X188roleId1,X162key,X189roleId2)
end(*dbFind*);
(*  97,  10 *)
function F190dbOlReset(*(X191keyList:T184tKeyList):T184tKeyList;*)
;
begin
   F190dbOlReset:=dbOlReset(X191keyList)
end(*dbOlReset*);
(*  109,  10 *)
function F192dbOlNext(*(X191keyList:T184tKeyList):T144tKey;*);
begin
   F192dbOlNext:=dbOlNext(X191keyList)
end(*dbOlNext*);
(*  117,  10 *)
function F193dbOlFirst(*(X191keyList:T184tKeyList):T144tKey;*);
begin
   
   F193dbOlFirst:=F192dbOlNext(F190dbOlReset(X191keyList))
end(*dbOlFirst*);

(*  132,  10 *)
function F194dbNewObject(*(X195otype:T87INT):T144tKey;*);
begin
   F194dbNewObject:=dbNewObject(X195otype)
end(*dbNewObject*);
(*  139,  10 *)
function F196dbGetObjectType(*(X162key:T144tKey):T87INT;*);
begin
   F196dbGetObjectType:=dbGetObjectType(X162key)
end(*dbGetObjectType*);
(*  152,  10 *)
function F197dbSetObjectType(*(X162key:T144tKey;
          X195otype:T87INT):T88BOOL;*);
begin
   F197dbSetObjectType:=dbSetObjectType(X162key,X195otype)
end(*dbSetObjectType*);
(*  169,  10 *)
function F198dbTestObjectType(*(X162key:T144tKey;
          X195otype:T87INT;
          X199msg:T87INT):T88BOOL;*);
begin
   F198dbTestObjectType:=dbTestObjectType(X162key,X195otype,
   X199msg)
end(*dbTestObjectType*);
(*  183,  10 *)
function F200NewDef(*:T144tKey;*);
begin
   F200NewDef:=NewDef
end(*NewDef*);
(*  189,  10 *)
function F201NoDef(*:T144tKey;*);
begin
   F201NoDef:=NoDef
end(*NoDef*);
(*  195,  10 *)
function F202DefInit(*:T88BOOL;*);
begin
   F202DefInit:=DefInit
end(*DefInit*);
(*  212,  10 *)
function F203DefClass(*(X204name:T90SYMB;
          X205numArgs:T87INT):T154tOilClass;*);
begin
   F203DefClass:=DefClass(X204name,X205numArgs)
end(*DefClass*);
(*  214,  10 *)
function F206DefType(*(X204name:T90SYMB):T156tOilType;*);
begin
   F206DefType:=DefType(X204name)
end(*DefType*);
(*  216,  10 *)
function F207DefOp(*(X204name:T90SYMB;
          X208sig:T209tOilArgSig;
          X210cost:T87INT):T158tOilOp;*);
begin
   F207DefOp:=DefOp(X204name,X208sig,X210cost)
end(*DefOp*);
(*  218,  10 *)
function F211DefSetOp(*(X204name:T90SYMB;
          X208sig:T209tOilArgSig;
          X210cost:T87INT):T158tOilOp;*);
begin
   F211DefSetOp:=DefSetOp(X204name,X208sig,X210cost)
end(*DefSetOp*);
(*  220,  10 *)
function F212DefClassOp(*(X204name:T90SYMB;
          X208sig:T213tOilClassArgSig;
          X210cost:T87INT;
          X214class:T154tOilClass):T215tOilClassOp;*);
begin
   F212DefClassOp:=DefClassOp(X204name,X208sig,X210cost,X214class
   )
end(*DefClassOp*);
(*  240,  10 *)
function F228ObjKindCheck(*(X195otype:T147tObjKind;
          X229typeWanted:T147tObjKind):T88BOOL;*);
var HIVAR1:UNIONTYPE;
begin
   if X195otype<>S219eErrorObj
   then begin
        HIVAR1.C88BOOL:=X195otype=X229typeWanted
   end else begin
        HIVAR1.C88BOOL:=true
   end;
   
   F228ObjKindCheck:=HIVAR1.C88BOOL
end(*ObjKindCheck*);

(*  271,  10 *)
procedure P238SetUnion(*(X239left:T232tTypeSet;
          X240right:T232tTypeSet;
          var F238SetUnion:UNIONTYPE);*);
label 1;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6:UNIONTYPE;
begin
1:
   if(X239left.HEAD=nil)
   then begin
        HIVAR1.COLIST:=X240right
   end else begin
        HEAD(X239left,HIVAR3);
        HIVAR2.C156tOilType:=HIVAR3.C156tOilType;
        HIVAR4.C156tOilType:=HIVAR2.C156tOilType;
        HIVAR4.DISCR:=U156tOilType;
        if ELEMINLIST(HIVAR4,X240right)
        then begin
             HIVAR4.COLIST:=X240right
        end else begin
             new(HIVAR6.COLIST.HEAD);
             HIVAR6.COLIST.LAST:=HIVAR6.COLIST.HEAD;
             HIVAR6.COLIST.LAST^.NEXT:=nil;
             new(HIVAR6.COLIST.HEAD^.ELEMENT);
             HIVAR6.COLIST.HEAD^.ELEMENT^.DISCR:=U156tOilType;
             HIVAR6.COLIST.HEAD^.ELEMENT^.C156tOilType:=HIVAR2.
             C156tOilType;
             CONCATELIST(HIVAR6.COLIST,X240right,HIVAR5.COLIST)
             ;
             HIVAR4.COLIST:=HIVAR5.COLIST
        end;
        HIVAR3.COLIST:=HIVAR4.COLIST;
        TAIL(X239left,HIVAR4);
        X239left:=HIVAR4.COLIST;
        X240right:=HIVAR3.COLIST;
        goto 1
   end;
   
   F238SetUnion.COLIST:=HIVAR1.COLIST
end(*SetUnion*);

(*  279,  10 *)
procedure P243SetIntersect(*(X239left:T232tTypeSet;
          X240right:T232tTypeSet;
          var F243SetIntersect:UNIONTYPE);*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6:UNIONTYPE;
begin
   if(X239left.HEAD=nil)
   then begin
        HIVAR1.COLIST:=EMPTY
   end else begin
        HEAD(X239left,HIVAR3);
        HIVAR2.C156tOilType:=HIVAR3.C156tOilType;
        TAIL(X239left,HIVAR5);
        P243SetIntersect(HIVAR5.COLIST,X240right,HIVAR4);
        HIVAR5.C156tOilType:=HIVAR2.C156tOilType;
        HIVAR5.DISCR:=U156tOilType;
        if ELEMINLIST(HIVAR5,X240right)
        then begin
             new(HIVAR6.COLIST.HEAD);
             HIVAR6.COLIST.LAST:=HIVAR6.COLIST.HEAD;
             HIVAR6.COLIST.LAST^.NEXT:=nil;
             new(HIVAR6.COLIST.HEAD^.ELEMENT);
             HIVAR6.COLIST.HEAD^.ELEMENT^.DISCR:=U156tOilType;
             HIVAR6.COLIST.HEAD^.ELEMENT^.C156tOilType:=HIVAR2.
             C156tOilType;
             HIVAR5.COLIST:=HIVAR6.COLIST
        end else begin
             HIVAR5.COLIST:=EMPTY
        end;
        CONCATELIST(HIVAR5.COLIST,HIVAR4.COLIST,HIVAR3.COLIST
        );
        HIVAR1.COLIST:=HIVAR3.COLIST
   end;
   
   F243SetIntersect.COLIST:=HIVAR1.COLIST
end(*SetIntersect*);

(*  290,  10 *)
procedure P244SetDifference(*(X239left:T232tTypeSet;
          X240right:T232tTypeSet;
          var F244SetDifference:UNIONTYPE);*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6:UNIONTYPE;
begin
   if(X239left.HEAD=nil)
   then begin
        HIVAR1.COLIST:=EMPTY
   end else begin
        HEAD(X239left,HIVAR3);
        HIVAR2.C156tOilType:=HIVAR3.C156tOilType;
        TAIL(X239left,HIVAR5);
        P244SetDifference(HIVAR5.COLIST,X240right,HIVAR4);
        HIVAR5.C156tOilType:=HIVAR2.C156tOilType;
        HIVAR5.DISCR:=U156tOilType;
        if ELEMINLIST(HIVAR5,X240right)
        then begin
             HIVAR5.COLIST:=EMPTY
        end else begin
             new(HIVAR6.COLIST.HEAD);
             HIVAR6.COLIST.LAST:=HIVAR6.COLIST.HEAD;
             HIVAR6.COLIST.LAST^.NEXT:=nil;
             new(HIVAR6.COLIST.HEAD^.ELEMENT);
             HIVAR6.COLIST.HEAD^.ELEMENT^.DISCR:=U156tOilType;
             HIVAR6.COLIST.HEAD^.ELEMENT^.C156tOilType:=HIVAR2.
             C156tOilType;
             HIVAR5.COLIST:=HIVAR6.COLIST
        end;
        CONCATELIST(HIVAR5.COLIST,HIVAR4.COLIST,HIVAR3.COLIST
        );
        HIVAR1.COLIST:=HIVAR3.COLIST
   end;
   
   F244SetDifference.COLIST:=HIVAR1.COLIST
end(*SetDifference*);

(*  318,  10 *)
function F251AddIdentification(*(X252Op:T245tAnyOp;
          X214class:T154tOilClass;
          X253id:T90SYMB;
          X254identMap:T250tIdentMap):T88BOOL;*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6:UNIONTYPE;
begin
   if(X254identMap.HEAD=nil)
   then begin
        HIVAR1.C88BOOL:=true
   end else begin
        HEAD(X254identMap,HIVAR3);
        HIVAR2.C247tIdentPair:=HIVAR3.C247tIdentPair;
        TAIL(X254identMap,HIVAR4);
        HIVAR3.COLIST:=HIVAR4.COLIST;
        if HIVAR2.C247tIdentPair^.L248op=X253id
        then begin
             HIVAR5.C245tAnyOp:=X252Op;
             case HIVAR5.C245tAnyOp^.DISCR of
             U158tOilOp:
             begin
                  HIVAR6.C88BOOL:=F257OilAddIdentification(
                  HIVAR2.C247tIdentPair^.L249indication,HIVAR5
                  .C245tAnyOp^.C158tOilOp)
             end;
             U215tOilClassOp:
             begin
                  HIVAR6.C88BOOL:=F258OilAddClassOpId(HIVAR2.
                  C247tIdentPair^.L249indication,HIVAR5.
                  C245tAnyOp^.C215tOilClassOp)
             end;
             U246tSetOp:
             begin
                  HIVAR6.C88BOOL:=F259AddSetOpId(HIVAR2.
                  C247tIdentPair^.L249indication,HIVAR5.
                  C245tAnyOp^.C246tSetOp)
             end end;
             HIVAR4.C88BOOL:=HIVAR6.C88BOOL
        end else begin
             HIVAR4.C88BOOL:=true
        end;
        HIVAR1.C88BOOL:=F251AddIdentification(X252Op,X214class,
        X253id,HIVAR3.COLIST)and HIVAR4.C88BOOL
   end;
   
   F251AddIdentification:=HIVAR1.C88BOOL
end(*AddIdentification*);

(*  1212,  10 *)
function F257OilAddIdentification(*(X253id:T158tOilOp;
          X248op:T158tOilOp):T88BOOL;*);
begin
   F257OilAddIdentification:=OilAddIdentification(X253id,X248op)
end(*OilAddIdentification*);
(*  1301,  10 *)
function F258OilAddClassOpId(*(X391ind:T158tOilOp;
          X248op:T215tOilClassOp):T88BOOL;*);
begin
   F258OilAddClassOpId:=OilAddClassOpId(X391ind,X248op)
end(*OilAddClassOpId*);
(*  476,  10 *)
function F259AddSetOpId(*(X253id:T158tOilOp;
          X248op:T246tSetOp):T88BOOL;*);
var HIVAR1,HIVAR2,HIVAR3:UNIONTYPE;
begin
   if(X248op.HEAD=nil)
   then begin
        HIVAR1.C88BOOL:=true
   end else begin
        TAIL(X248op,HIVAR2);
        HEAD(X248op,HIVAR3);
        HIVAR1.C88BOOL:=F257OilAddIdentification(X253id,HIVAR3
        .C158tOilOp)and F259AddSetOpId(X253id,HIVAR2.COLIST)
   end;
   
   F259AddSetOpId:=HIVAR1.C88BOOL
end(*AddSetOpId*);

(*  342,  10 *)
function F260PrimSig(*(X261argSig:T231tArgSig):T209tOilArgSig;*);
var HIVAR1,HIVAR2,HIVAR3:UNIONTYPE;
begin
   if(X261argSig.HEAD=nil)
   then begin
        HIVAR1.C209tOilArgSig:=F262OilNewArgSig(true)
   end else begin
        HEAD(X261argSig,HIVAR2);
        TAIL(X261argSig,HIVAR3);
        HIVAR1.C209tOilArgSig:=F263OilAddArgSig(F175GetaTypeId(
        HIVAR2.C144tKey,F264cErrorType),F260PrimSig(HIVAR3.
        COLIST))
   end;
   
   F260PrimSig:=HIVAR1.C209tOilArgSig
end(*PrimSig*);

(*  1195,  10 *)
function F262OilNewArgSig(*(X316dummy:T88BOOL):T209tOilArgSig;*);
begin
   F262OilNewArgSig:=OilNewArgSig(X316dummy)
end(*OilNewArgSig*);
(*  1197,  10 *)
function F263OilAddArgSig(*(X267arg:T156tOilType;
          X208sig:T209tOilArgSig):T209tOilArgSig;*);
begin
   F263OilAddArgSig:=OilAddArgSig(X267arg,X208sig)
end(*OilAddArgSig*);
(*  501,  10 *)
function F264cErrorType(*:T156tOilType;*);
begin
   F264cErrorType:=cErrorType
end(*cErrorType*);
(*  350,  10 *)
function F265ClassSig(*(X261argSig:T231tArgSig):
T213tOilClassArgSig;*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6,HIVAR7:
    UNIONTYPE;
begin
   if(X261argSig.HEAD=nil)
   then begin
        HIVAR1.C213tOilClassArgSig:=F266OilNewClassSigArg(true)
   end else begin
        HEAD(X261argSig,HIVAR3);
        HIVAR2.C144tKey:=HIVAR3.C144tKey;
        HIVAR3.C88BOOL:=F167GetaTypeKind(HIVAR2.C144tKey,
        S220ePrimType)=S221eParamType;
        if HIVAR3.C88BOOL
        then begin
             HIVAR5.C87INT:=C270eParamRef
        end else begin
             HIVAR5.C87INT:=C271eSpecTypeRef
        end;
        HIVAR4.C87INT:=HIVAR5.C87INT;
        if HIVAR3.C88BOOL
        then begin
             HIVAR6.C156tOilType:=F264cErrorType
        end else begin
             HIVAR6.C156tOilType:=F175GetaTypeId(HIVAR2.
             C144tKey,F264cErrorType)
        end;
        HIVAR5.C156tOilType:=HIVAR6.C156tOilType;
        if HIVAR3.C88BOOL
        then begin
             HIVAR7.C87INT:=F171GetaValue(HIVAR2.C144tKey,0)
        end else begin
             HIVAR7.C87INT:=0
        end;
        HIVAR6.C87INT:=HIVAR7.C87INT;
        TAIL(X261argSig,HIVAR7);
        HIVAR1.C213tOilClassArgSig:=F274OilAddClassSigArg(
        HIVAR4.C87INT,HIVAR5.C156tOilType,HIVAR6.C87INT,
        F265ClassSig(HIVAR7.COLIST))
   end;
   
   F265ClassSig:=HIVAR1.C213tOilClassArgSig
end(*ClassSig*);

(*  1285,  10 *)
function F266OilNewClassSigArg(*(X316dummy:T88BOOL):
T213tOilClassArgSig;*);
begin
   F266OilNewClassSigArg:=OilNewClassSigArg(X316dummy)
end(*OilNewClassSigArg*);
(*  1287,  10 *)
function F274OilAddClassSigArg(*(X269td:T87INT;
          X272st:T156tOilType;
          X273pi:T87INT;
          X387cs:T213tOilClassArgSig):T213tOilClassArgSig;*);
begin
   F274OilAddClassSigArg:=OilAddClassSigArg(X269td,X272st,X273pi,
   X387cs)
end(*OilAddClassSigArg*);
(*  382,  10 *)
procedure P278SetSig(*(X261argSig:T231tArgSig;
          var F278SetSig:UNIONTYPE);*);
var HIVAR1,HIVAR2,HIVAR3:UNIONTYPE;
begin
   P280UniqueIds(EMPTY,X261argSig,HIVAR2);
   HIVAR1.COLIST:=HIVAR2.COLIST;
   P282UniqueValues(HIVAR1.COLIST,HIVAR3);
   HIVAR2.COLIST:=HIVAR3.COLIST;
   P283UniqueSigs(HIVAR2.COLIST,X261argSig,HIVAR3);
   
   F278SetSig.COLIST:=HIVAR3.COLIST
end(*SetSig*);

(*  390,  10 *)
procedure P280UniqueIds(*(X279uids:T276tArgSetValues;
          X285actualSig:T231tArgSig;
          var F280UniqueIds:UNIONTYPE);*);
label 1;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4:UNIONTYPE;
begin
1:
   if(X285actualSig.HEAD=nil)
   then begin
        HIVAR1.COLIST:=X279uids
   end else begin
        HEAD(X285actualSig,HIVAR3);
        HIVAR2.C144tKey:=HIVAR3.C144tKey;
        P288MapIdToSet(HIVAR2.C144tKey,X279uids,HIVAR4);
        HIVAR3.COLIST:=HIVAR4.COLIST;
        TAIL(X285actualSig,HIVAR4);
        X279uids:=HIVAR3.COLIST;
        X285actualSig:=HIVAR4.COLIST;
        goto 1
   end;
   
   F280UniqueIds.COLIST:=HIVAR1.COLIST
end(*UniqueIds*);

(*  415,  10 *)
procedure P282UniqueValues(*(X279uids:T276tArgSetValues;
          var F282UniqueValues:UNIONTYPE);*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5:UNIONTYPE;
begin
   if(X279uids.HEAD=nil)
   then begin
        HIVAR1.COLIST:=EMPTY
   end else begin
        HEAD(X279uids,HIVAR3);
        HIVAR2.C277tArgSetValue:=HIVAR3.C277tArgSetValue;
        TAIL(X279uids,HIVAR5);
        P282UniqueValues(HIVAR5.COLIST,HIVAR4);
        P292ConsValueS(HIVAR2.C277tArgSetValue^.L253id,HIVAR2
        .C277tArgSetValue^.L233value,HIVAR4.COLIST,HIVAR3);
        HIVAR1.COLIST:=HIVAR3.COLIST
   end;
   
   F282UniqueValues.COLIST:=HIVAR1.COLIST
end(*UniqueValues*);

(*  447,  10 *)
procedure P283UniqueSigs(*(X279uids:T291tArgValueList;
          X285actualSig:T231tArgSig;
          var F283UniqueSigs:UNIONTYPE);*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5:UNIONTYPE;
begin
   if(X279uids.HEAD=nil)
   then begin
        HIVAR1.COLIST:=EMPTY
   end else begin
        HEAD(X279uids,HIVAR4);
        new(HIVAR3.COLIST.HEAD);
        HIVAR3.COLIST.LAST:=HIVAR3.COLIST.HEAD;
        HIVAR3.COLIST.LAST^.NEXT:=nil;
        new(HIVAR3.COLIST.HEAD^.ELEMENT);
        HIVAR3.COLIST.HEAD^.ELEMENT^.DISCR:=U209tOilArgSig;
        HIVAR3.COLIST.HEAD^.ELEMENT^.C209tOilArgSig:=
        F295UniqueSig(HIVAR4.COLIST,X285actualSig);
        TAIL(X279uids,HIVAR5);
        P283UniqueSigs(HIVAR5.COLIST,X285actualSig,HIVAR4);
        CONCATELIST(HIVAR4.COLIST,HIVAR3.COLIST,HIVAR2.COLIST
        );
        HIVAR1.COLIST:=HIVAR2.COLIST
   end;
   
   F283UniqueSigs.COLIST:=HIVAR1.COLIST
end(*UniqueSigs*);

(*  398,  10 *)
procedure P288MapIdToSet(*(X286aid:T144tKey;
          X279uids:T276tArgSetValues;
          var F288MapIdToSet:UNIONTYPE);*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5:UNIONTYPE;
begin
   HIVAR1.C144tKey:=X286aid;
   HIVAR1.DISCR:=U144tKey;
   if KEYINLIST(HIVAR1,X279uids,U276tArgSetValues)
   then begin
        HIVAR1.COLIST:=X279uids
   end else begin
        HIVAR3.C149tTypeKind:=F167GetaTypeKind(X286aid,
        S220ePrimType);
        if HIVAR3.C149tTypeKind in[S220ePrimType,S223ePrimSet,
        S222eForType]then
        case HIVAR3.C149tTypeKind of
        S220ePrimType:
        begin
             new(HIVAR5.COLIST.HEAD);
             HIVAR5.COLIST.LAST:=HIVAR5.COLIST.HEAD;
             HIVAR5.COLIST.LAST^.NEXT:=nil;
             new(HIVAR5.COLIST.HEAD^.ELEMENT);
             HIVAR5.COLIST.HEAD^.ELEMENT^.DISCR:=U156tOilType;
             HIVAR5.COLIST.HEAD^.ELEMENT^.C156tOilType:=
             F175GetaTypeId(X286aid,F264cErrorType);
             HIVAR4.COLIST:=HIVAR5.COLIST
        end;
        S223ePrimSet:
        begin
             HIVAR5.C160tStructTypeSet:=F179GetaSetValue(X286aid
             ,C284cErrorTypeSet);
             HIVAR4.COLIST:=HIVAR5.C160tStructTypeSet^.
             L233value
        end;
        S222eForType:
        begin
             HIVAR5.C160tStructTypeSet:=F179GetaSetValue(X286aid
             ,C284cErrorTypeSet);
             HIVAR4.COLIST:=HIVAR5.C160tStructTypeSet^.
             L233value
        end end
        else begin
             HIVAR4.COLIST:=C284cErrorTypeSet^.L233value
        end;
        HIVAR2.COLIST:=HIVAR4.COLIST;
        new(HIVAR5.C277tArgSetValue);
        with HIVAR5.C277tArgSetValue^do
        begin
             L253id:=X286aid;
             L233value:=HIVAR2.COLIST
        end;
        new(HIVAR4.COLIST.HEAD);
        HIVAR4.COLIST.LAST:=HIVAR4.COLIST.HEAD;
        HIVAR4.COLIST.LAST^.NEXT:=nil;
        new(HIVAR4.COLIST.HEAD^.ELEMENT);
        HIVAR4.COLIST.HEAD^.ELEMENT^.DISCR:=U277tArgSetValue;
        HIVAR4.COLIST.HEAD^.ELEMENT^.C277tArgSetValue:=HIVAR5.
        C277tArgSetValue;
        CONCATELIST(X279uids,HIVAR4.COLIST,HIVAR3.COLIST);
        HIVAR1.COLIST:=HIVAR3.COLIST
   end;
   
   F288MapIdToSet.COLIST:=HIVAR1.COLIST
end(*MapIdToSet*);

(*  423,  10 *)
procedure P292ConsValueS(*(X253id:T144tKey;
          X233value:T232tTypeSet;
          X293others:T291tArgValueList;
          var F292ConsValueS:UNIONTYPE);*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6:UNIONTYPE;
begin
   if(X293others.HEAD=nil)
   then begin
        P294ConsValue(X253id,X233value,EMPTY,HIVAR2);
        HIVAR1.COLIST:=HIVAR2.COLIST
   end else begin
        HEAD(X293others,HIVAR4);
        P294ConsValue(X253id,X233value,HIVAR4.COLIST,HIVAR3);
        TAIL(X293others,HIVAR4);
        if(HIVAR4.COLIST.HEAD=nil)
        then begin
             HIVAR4.COLIST:=EMPTY
        end else begin
             TAIL(X293others,HIVAR6);
             P292ConsValueS(X253id,X233value,HIVAR6.COLIST,
             HIVAR5);
             HIVAR4.COLIST:=HIVAR5.COLIST
        end;
        CONCATELIST(HIVAR4.COLIST,HIVAR3.COLIST,HIVAR2.COLIST
        );
        HIVAR1.COLIST:=HIVAR2.COLIST
   end;
   
   F292ConsValueS.COLIST:=HIVAR1.COLIST
end(*ConsValueS*);

(*  434,  10 *)
procedure P294ConsValue(*(X253id:T144tKey;
          X233value:T232tTypeSet;
          X293others:T289tArgValues;
          var F294ConsValue:UNIONTYPE);*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6,HIVAR7,
    HIVAR8:UNIONTYPE;
begin
   if(X233value.HEAD=nil)
   then begin
        HIVAR1.COLIST:=EMPTY
   end else begin
        TAIL(X233value,HIVAR4);
        P294ConsValue(X253id,HIVAR4.COLIST,X293others,HIVAR3);
        new(HIVAR7.C290tArgValue);
        with HIVAR7.C290tArgValue^do
        begin
             HEAD(X233value,HIVAR8);
             L253id:=X253id;
             L233value:=HIVAR8.C156tOilType
        end;
        new(HIVAR6.COLIST.HEAD);
        HIVAR6.COLIST.LAST:=HIVAR6.COLIST.HEAD;
        HIVAR6.COLIST.LAST^.NEXT:=nil;
        new(HIVAR6.COLIST.HEAD^.ELEMENT);
        HIVAR6.COLIST.HEAD^.ELEMENT^.DISCR:=U290tArgValue;
        HIVAR6.COLIST.HEAD^.ELEMENT^.C290tArgValue:=HIVAR7.
        C290tArgValue;
        CONCATELIST(HIVAR6.COLIST,X293others,HIVAR5.COLIST);
        new(HIVAR4.COLIST.HEAD);
        HIVAR4.COLIST.LAST:=HIVAR4.COLIST.HEAD;
        HIVAR4.COLIST.LAST^.NEXT:=nil;
        new(HIVAR4.COLIST.HEAD^.ELEMENT);
        HIVAR4.COLIST.HEAD^.ELEMENT^.DISCR:=U289tArgValues;
        HIVAR4.COLIST.HEAD^.ELEMENT^.COLIST:=HIVAR5.COLIST;
        CONCATELIST(HIVAR4.COLIST,HIVAR3.COLIST,HIVAR2.COLIST
        );
        HIVAR1.COLIST:=HIVAR2.COLIST
   end;
   
   F294ConsValue.COLIST:=HIVAR1.COLIST
end(*ConsValue*);

(*  452,  10 *)
function F295UniqueSig(*(X296avs:T289tArgValues;
          X285actualSig:T231tArgSig):T209tOilArgSig;*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5:UNIONTYPE;
begin
   if(X285actualSig.HEAD=nil)
   then begin
        HIVAR1.C209tOilArgSig:=F262OilNewArgSig(true)
   end else begin
        HEAD(X285actualSig,HIVAR3);
        HIVAR2.C144tKey:=HIVAR3.C144tKey;
        HIVAR5.C144tKey:=HIVAR2.C144tKey;
        HIVAR5.DISCR:=U144tKey;
        SELECTBYKEY(HIVAR5,X296avs,U289tArgValues,HIVAR4);
        HIVAR3.C290tArgValue:=HIVAR4.C290tArgValue;
        HIVAR4.C156tOilType:=HIVAR3.C290tArgValue^.L233value;
        TAIL(X285actualSig,HIVAR5);
        HIVAR1.C209tOilArgSig:=F263OilAddArgSig(HIVAR4.
        C156tOilType,F295UniqueSig(X296avs,HIVAR5.COLIST))
   end;
   
   F295UniqueSig:=HIVAR1.C209tOilArgSig
end(*UniqueSig*);

(*  464,  10 *)
procedure P298AddSetOp(*(X253id:T90SYMB;
          X208sig:T275tSetSig;
          X210cost:T87INT;
          var F298AddSetOp:UNIONTYPE);*);
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5:UNIONTYPE;
begin
   if(X208sig.HEAD=nil)
   then begin
        HIVAR1.COLIST:=EMPTY
   end else begin
        TAIL(X208sig,HIVAR4);
        P298AddSetOp(X253id,HIVAR4.COLIST,X210cost,HIVAR3);
        HEAD(X208sig,HIVAR5);
        new(HIVAR4.COLIST.HEAD);
        HIVAR4.COLIST.LAST:=HIVAR4.COLIST.HEAD;
        HIVAR4.COLIST.LAST^.NEXT:=nil;
        new(HIVAR4.COLIST.HEAD^.ELEMENT);
        HIVAR4.COLIST.HEAD^.ELEMENT^.DISCR:=U158tOilOp;
        HIVAR4.COLIST.HEAD^.ELEMENT^.C158tOilOp:=F211DefSetOp(
        X253id,HIVAR5.C209tOilArgSig,X210cost);
        CONCATELIST(HIVAR4.COLIST,HIVAR3.COLIST,HIVAR2.COLIST
        );
        HIVAR1.COLIST:=HIVAR2.COLIST
   end;
   
   F298AddSetOp.COLIST:=HIVAR1.COLIST
end(*AddSetOp*);

(*  487,  10 *)
function F299AddSetCoercion(*(X248op:T246tSetOp):T88BOOL;*);
var HIVAR1,HIVAR2,HIVAR3:UNIONTYPE;
begin
   if(X248op.HEAD=nil)
   then begin
        HIVAR1.C88BOOL:=true
   end else begin
        TAIL(X248op,HIVAR2);
        HEAD(X248op,HIVAR3);
        HIVAR1.C88BOOL:=F300OilAddCoercion(HIVAR3.C158tOilOp)
        and F299AddSetCoercion(HIVAR2.COLIST)
   end;
   
   F299AddSetCoercion:=HIVAR1.C88BOOL
end(*AddSetCoercion*);

(*  1255,  10 *)
function F300OilAddCoercion(*(X248op:T158tOilOp):T88BOOL;*);
begin
   F300OilAddCoercion:=OilAddCoercion(X248op)
end(*OilAddCoercion*);
(*  503,  10 *)
function F301cErrorOp(*:T158tOilOp;*);
begin
   F301cErrorOp:=cErrorOp
end(*cErrorOp*);
(*  505,  10 *)
function F302cErrorClass(*:T154tOilClass;*);
begin
   F302cErrorClass:=cErrorClass
end(*cErrorClass*);
(*  1338,  10 *)
function F309NewEnv(*:T307tEnv;*);
begin
   F309NewEnv:=NewEnv
end(*NewEnv*);
(*  1402,  10 *)
function F319DefineIdn(*(X406e:T307tEnv;
          X407i:T90SYMB):T144tKey;*);
begin
   F319DefineIdn:=DefineIdn(X406e,X407i)
end(*DefineIdn*);
(*  1385,  10 *)
function F322KeyInScope(*(X406e:T307tEnv;
          X407i:T90SYMB):T144tKey;*);
begin
   F322KeyInScope:=KeyInScope(X406e,X407i)
end(*KeyInScope*);
(*  1352,  10 *)
function F323NewScope(*(X406e:T307tEnv):T307tEnv;*);
begin
   F323NewScope:=NewScope(X406e)
end(*NewScope*);
(*  1368,  10 *)
function F325KeyInEnv(*(X406e:T307tEnv;
          X407i:T90SYMB):T144tKey;*);
begin
   F325KeyInEnv:=KeyInEnv(X406e,X407i)
end(*KeyInEnv*);
(*  1306,  10 *)
function F341OilAddClassCoercion(*(X248op:T215tOilClassOp):T88BOOL
;*);
begin
   F341OilAddClassCoercion:=OilAddClassCoercion(X248op)
end(*OilAddClassCoercion*);
(*  1199,  10 *)
function F366OilNewSetSig(*(X316dummy:T88BOOL):T209tOilArgSig;*);
begin
   F366OilNewSetSig:=OilNewSetSig(X316dummy)
end(*OilNewSetSig*);
(*  1200,  10 *)
function F367OilAddSetSig(*(X267arg:T357tOilTypeSet;
          X208sig:T209tOilArgSig):T209tOilArgSig;*);
begin
   F367OilAddSetSig:=OilAddSetSig(X267arg,X208sig)
end(*OilAddSetSig*);
(*  1202,  10 *)
function F368OilNewOp(*(X253id:T87INT;
          X210cost:T87INT;
          X208sig:T209tOilArgSig):T158tOilOp;*);
begin
   F368OilNewOp:=OilNewOp(X253id,X210cost,X208sig)
end(*OilNewOp*);
(*  1208,  10 *)
function F369OilErrorOp(*:T158tOilOp;*);
begin
   F369OilErrorOp:=OilErrorOp
end(*OilErrorOp*);
(*  1216,  10 *)
function F370OilNewType(*(X253id:T87INT):T156tOilType;*);
begin
   F370OilNewType:=OilNewType(X253id)
end(*OilNewType*);
(*  1218,  10 *)
function F371OilErrorType(*:T156tOilType;*);
begin
   F371OilErrorType:=OilErrorType
end(*OilErrorType*);
(*  1221,  10 *)
function F372OilNewTypeInClass(*(X321c:T154tOilClass;
          X373as:T209tOilArgSig;
          X253id:T87INT):T156tOilType;*);
begin
   F372OilNewTypeInClass:=OilNewTypeInClass(X321c,X373as,X253id)
end(*OilNewTypeInClass*);
(*  1230,  11 *)
function F374OilSetIncludes(*(X375t1:T357tOilTypeSet;
          X376t2:T156tOilType):T88BOOL;*);
begin
   F374OilSetIncludes:=OilSetIncludes(X375t1,X376t2)
end(*OilSetIncludes*);
(*  1235,  10 *)
function F377OilIsCoercibleTo(*(X375t1:T156tOilType;
          X376t2:T156tOilType):T88BOOL;*);
begin
   F377OilIsCoercibleTo:=OilIsCoercibleTo(X375t1,X376t2)
end(*OilIsCoercibleTo*);
(*  1239,  10 *)
function F378OilCanIdSigs(*(X379src:T356tOilSetSig;
          X380dest:T209tOilArgSig):T88BOOL;*);
begin
   F378OilCanIdSigs:=OilCanIdSigs(X379src,X380dest)
end(*OilCanIdSigs*);
(*  1245,  10 *)
function F381OilIsValidCS(*(X382ccs:T364tOilCoercionSeq):T88BOOL;
*);
begin
   F381OilIsValidCS:=OilIsValidCS(X382ccs)
end(*OilIsValidCS*);
(*  1247,  10 *)
function F383OilErrorCS(*:T364tOilCoercionSeq;*);
begin
   F383OilErrorCS:=OilErrorCS
end(*OilErrorCS*);
(*  1250,  10 *)
function F384OilIsValidOp(*(X248op:T158tOilOp):T88BOOL;*);
begin
   F384OilIsValidOp:=OilIsValidOp(X248op)
end(*OilIsValidOp*);
(*  1253,  10 *)
function F385OilCoerce(*(X375t1:T156tOilType;
          X376t2:T156tOilType):T364tOilCoercionSeq;*);
begin
   F385OilCoerce:=OilCoerce(X375t1,X376t2)
end(*OilCoerce*);
(*  1257,  10 *)
function F386OilEmptyCS(*(X387cs:T364tOilCoercionSeq):T88BOOL;*);
begin
   F386OilEmptyCS:=OilEmptyCS(X387cs)
end(*OilEmptyCS*);
(*  1259,  10 *)
function F388OilHeadCS(*(X387cs:T364tOilCoercionSeq):T158tOilOp;*)
;
begin
   F388OilHeadCS:=OilHeadCS(X387cs)
end(*OilHeadCS*);
(*  1261,  10 *)
function F389OilTailCS(*(X387cs:T364tOilCoercionSeq):
T364tOilCoercionSeq;*);
begin
   F389OilTailCS:=OilTailCS(X387cs)
end(*OilTailCS*);
(*  1267,  10 *)
function F390OilIdResultSet(*(X391ind:T158tOilOp;
          X392setsig:T356tOilSetSig):T357tOilTypeSet;*);
begin
   F390OilIdResultSet:=OilIdResultSet(X391ind,X392setsig)
end(*OilIdResultSet*);
(*  1272,  10 *)
function F393OilTypeToSet(*(X394t:T156tOilType):T357tOilTypeSet;*)
;
begin
   F393OilTypeToSet:=OilTypeToSet(X394t)
end(*OilTypeToSet*);
(*  1274,  10 *)
function F395OilBalance(*(X396ts1:T357tOilTypeSet;
          X397ts2:T357tOilTypeSet):T156tOilType;*);
begin
   F395OilBalance:=OilBalance(X396ts1,X397ts2)
end(*OilBalance*);
(*  1276,  10 *)
function F398OilSelectTypeFromTS(*(X399ts:T357tOilTypeSet):
T156tOilType;*);
begin
   
   F398OilSelectTypeFromTS:=F395OilBalance(X399ts,X399ts)
end(*OilSelectTypeFromTS*);

(*  1279,  10 *)
function F400OilNewClass(*(X253id:T87INT;
          X401argNum:T87INT):T154tOilClass;*);
begin
   F400OilNewClass:=OilNewClass(X253id,X401argNum)
end(*OilNewClass*);
(*  1294,  10 *)
function F402OilAddClassOp(*(X253id:T87INT;
          X208sig:T213tOilClassArgSig;
          X210cost:T87INT;
          X321c:T154tOilClass):T215tOilClassOp;*);
begin
   F402OilAddClassOp:=OilAddClassOp(X253id,X208sig,X210cost,X321c
   )
end(*OilAddClassOp*);
(*  1312,  10 *)
function F403OilGetArgType(*(X248op:T158tOilOp;
          X404n:T87INT):T156tOilType;*);
begin
   F403OilGetArgType:=OilGetArgType(X248op,X404n)
end(*OilGetArgType*);
(*  1421,  10 *)
function F408AddIdn(*(X406e:T307tEnv;
          X407i:T90SYMB;
          X349k:T144tKey):T144tKey;*);
begin
   F408AddIdn:=AddIdn(X406e,X407i,X349k)
end(*AddIdn*);
(*&END GEN INCLUDE*)



procedure SEMANALYSE;
        (*==========*)

const



MAXSEMCODE=77;
MINSEMRELCODE=10;
MAXVSTAB=85;
MAXSECTTAB=36;
MAXVSSYMBNO=3;
MAXVSNUMBER=3;
VISITSTOROOT=1;

(*&END GEN INCLUDE*)

type


SEMCODERANGE=0..MAXSEMCODE;

(*&END GEN INCLUDE*)

VSELEMRANGE   = 0..255;
VSTABRANGE    = 0..MAXVSTAB;

var


HIVAR0,HIVAR1,HIVAR2:UNIONTYPE;

(*&END GEN INCLUDE*)

VSELEM      : VSELEMRANGE;
VSDESCIND   : 0..MAXVSSYMBNO;
VSNUMBER    : 0..MAXVSNUMBER;
SEMCODE     : SEMCODERANGE;
I           : integer;   (* COMPUTE TOPINDEX *)

RETURNSTACK      : array [ 1..MAXTREEDEPTH ] of VSTABRANGE;
VSINDEX          : VSTABRANGE;


procedure SEMINIT;
         (*======*)
var I  : integer;
    RI : RULENRS;
begin
  VSFILE(succ(EMPTYRULE));




     C182dbNull:=F183dbfNull;
     new(HIVAR1.C160tStructTypeSet);
     with HIVAR1.C160tStructTypeSet^do
     begin
          new(HIVAR2.COLIST.HEAD);
          HIVAR2.COLIST.LAST:=HIVAR2.COLIST.HEAD;
          HIVAR2.COLIST.LAST^.NEXT:=nil;
          new(HIVAR2.COLIST.HEAD^.ELEMENT);
          HIVAR2.COLIST.HEAD^.ELEMENT^.DISCR:=U156tOilType;
          HIVAR2.COLIST.HEAD^.ELEMENT^.C156tOilType:=
          F264cErrorType;
          L233value:=HIVAR2.COLIST
     end;
     C284cErrorTypeSet:=HIVAR1.C160tStructTypeSet;
     
     

(*&END GEN INCLUDE*)

end; (*SEMINIT*)



procedure SEM0;
begin
with CURRNODE^ do
begin
  (*  525,  9 *)
  A304305defEnv:=F309NewEnv;
  
end
end;(*SEM0*)

procedure SEM1;
begin
with CURRNODE^ do
begin
  (*  527,  9 *)
  A304306refEnv:=A342305defEnv;
  (*  528,  15 *)
  A342305defEnv:=A304306refEnv;
  
end
end;(*SEM1*)

procedure SEM2;
begin
with CURRNODE^ do
begin
  (*  529,  9 *)
  A304254identMap:=A351461GEN;
  (*  526,  15 *)
  SONS^.A308214class:=F302cErrorClass;
  
end
end;(*SEM2*)

procedure SEM3;
var HIVAR1,HIVAR2:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  543,  15 *)
  FIRSTTIME:=true;
  FIRSTELEM:=nil;
  LASTELEM:=nil;
  AUXPTR:=SONS^.ELEMS;
  while AUXPTR<>nil do
  begin
       new(AUXELEMPTR);
       new(AUXELEMPTR^.ELEMENT);
       with AUXELEMPTR^,ELEMENT^do
       begin
            DISCR:=U307tEnv;
            C307tEnv:=AUXPTR^.A312305defEnv;
            NEXT:=nil;
       end;
       if FIRSTTIME
       then begin
            FIRSTTIME:=false;
            FIRSTELEM:=AUXELEMPTR;
            LASTELEM:=AUXELEMPTR;
       end
       else begin
            LASTELEM^.NEXT:=AUXELEMPTR;
            LASTELEM:=LASTELEM^.NEXT;
       end;
       AUXPTR:=AUXPTR^.BROTHER;
  end;
  HIVAR2.DISCR:=U453GEN;
  HIVAR2.COLIST.HEAD:=FIRSTELEM;
  HIVAR2.COLIST.LAST:=LASTELEM;
  HIVAR1.COLIST:=HIVAR2.COLIST;
  INCLUDING(1,HIVAR2);
  A342305defEnv:=HIVAR2.C307tEnv;
  
end
end;(*SEM3*)

procedure SEM4;
var HIVAR1:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  542,  14 *)
  HIVAR1.C307tEnv:=A342305defEnv;
  AUXPTR:=SONS^.ELEMS;
  while AUXPTR<>nil do
  begin
       AUXPTR^.A312306refEnv:=HIVAR1.C307tEnv;
       AUXPTR:=AUXPTR^.BROTHER;
       
  end;
  
end
end;(*SEM4*)

procedure SEM5;
var HIVAR1:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  540,  3 *)
  HIVAR1.DISCR:=U452GEN;
  HIVAR1.COLIST.HEAD:=nil;
  HIVAR1.COLIST.LAST:=nil;
  AUXPTR:=SONS^.ELEMS;
  while AUXPTR<>nil do begin
       CONCATELIST(HIVAR1.COLIST,AUXPTR^.A312461GEN,HIVAR1.
       COLIST);
       AUXPTR:=AUXPTR^.BROTHER
  end;
  A351461GEN:=HIVAR1.COLIST;
  
end
end;(*SEM5*)

procedure SEM6;
begin
with CURRNODE^ do
begin
  (*  579,  19 *)
  A314205numArgs:=SONS^.BROTHER^.A315317len;
  
end
end;(*SEM6*)

procedure SEM7;
var HIVAR1:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  578,  11 *)
  HIVAR1.C307tEnv:=SONS^.A314305defEnv;
  A312305defEnv:=A342305defEnv;
  
end
end;(*SEM7*)

procedure SEM8;
begin
with CURRNODE^ do
begin
  (*  580,  16 *)
  SONS^.BROTHER^.A315305defEnv:=A342305defEnv;
  
end
end;(*SEM8*)

procedure SEM9;
begin
with CURRNODE^ do
begin
  (*  576,  3 *)
  A312461GEN:=A351461GEN;
  
end
end;(*SEM9*)

procedure SEM10;
begin
with CURRNODE^ do
begin
  (*  582,  15 *)
  SONS^.BROTHER^.BROTHER^.A308214class:=SONS^.A314214class;
  
end
end;(*SEM10*)

procedure SEM11;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  596,  17 *)
  INCLUDING(1,HIVAR2);
  HIVAR1.C307tEnv:=HIVAR2.C307tEnv;
  HIVAR2.C144tKey:=F319DefineIdn(HIVAR1.C307tEnv,SONS^.TERMAT
  .id);
  HIVAR3.C147tObjKind:=F164SetaKind(HIVAR2.C144tKey,
  S218eClass,S219eErrorObj);
  HIVAR4.C87INT:=F172SetaValue(HIVAR2.C144tKey,
  A314205numArgs,0);
  HIVAR5.C154tOilClass:=F203DefClass(SONS^.TERMAT.id,HIVAR4.
  C87INT);
  HIVAR6.C154tOilClass:=F174SetaClassId(HIVAR2.C144tKey,
  HIVAR5.C154tOilClass,HIVAR5.C154tOilClass);
  A314305defEnv:=HIVAR1.C307tEnv;
  
end
end;(*SEM11*)

procedure SEM12;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  620,  13 *)
  
  MC:=MC+1;
  INCLUDING(3,HIVAR2);
  HIVAR1.C144tKey:=F325KeyInEnv(HIVAR2.C307tEnv,SONS^.TERMAT.
  id);
  if not(F161GetaKind(HIVAR1.C144tKey,S219eErrorObj)<>
  S219eErrorObj)
  then MESSAGE(CONDFAILS,30,620,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  (*  605,  17 *)
  HIVAR1.C144tKey:=F322KeyInScope(A314305defEnv,SONS^.TERMAT.id)
  ;
  A314214class:=F173GetaClassId(HIVAR1.C144tKey,F302cErrorClass
  );
  (*  609,  17 *)
  INCLUDING(3,HIVAR2);
  HIVAR1.C307tEnv:=F323NewScope(HIVAR2.C307tEnv);
  HIVAR2.C144tKey:=F319DefineIdn(HIVAR1.C307tEnv,SONS^.TERMAT
  .id);
  HIVAR3.C147tObjKind:=F164SetaKind(HIVAR2.C144tKey,
  S216eType,S219eErrorObj);
  HIVAR4.C149tTypeKind:=F168SetaTypeKind(HIVAR2.C144tKey,
  S221eParamType,S221eParamType);
  HIVAR5.C87INT:=F172SetaValue(HIVAR2.C144tKey,0,0);
  A342305defEnv:=HIVAR1.C307tEnv;
  
end
end;(*SEM12*)

procedure SEM13;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  631,  12 *)
  INCLUDING(5,HIVAR2);
  HIVAR1.C307tEnv:=HIVAR2.C307tEnv;
  HIVAR2.C144tKey:=F319DefineIdn(HIVAR1.C307tEnv,SONS^.TERMAT
  .id);
  HIVAR3.C147tObjKind:=F164SetaKind(HIVAR2.C144tKey,
  S216eType,S219eErrorObj);
  HIVAR4.C149tTypeKind:=F168SetaTypeKind(HIVAR2.C144tKey,
  S221eParamType,S221eParamType);
  HIVAR5.C87INT:=F172SetaValue(HIVAR2.C144tKey,
  A314205numArgs,A314205numArgs);
  A350162key:=HIVAR2.C144tKey;
  (*  639,  13 *)
  
  MC:=MC+1;
  if not(F161GetaKind(A350162key,S219eErrorObj)<>S219eErrorObj)
  then MESSAGE(CONDFAILS,30,639,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  
end
end;(*SEM13*)

procedure SEM14;
begin
with CURRNODE^ do
begin
  (*  655,  16 *)
  A315317len:=0;
  
end
end;(*SEM14*)

procedure SEM15;
begin
with CURRNODE^ do
begin
  (*  656,  16 *)
  A342305defEnv:=A315305defEnv;
  
end
end;(*SEM15*)

procedure SEM16;
begin
with CURRNODE^ do
begin
  (*  662,  16 *)
  A315317len:=1;
  
end
end;(*SEM16*)

procedure SEM17;
begin
with CURRNODE^ do
begin
  (*  663,  14 *)
  A314205numArgs:=1;
  
end
end;(*SEM17*)

procedure SEM18;
begin
with CURRNODE^ do
begin
  (*  664,  16 *)
  A342305defEnv:=A315305defEnv;
  
end
end;(*SEM18*)

procedure SEM19;
begin
with CURRNODE^ do
begin
  (*  671,  19 *)
  A315317len:=SONS^.A315317len+1;
  
end
end;(*SEM19*)

procedure SEM20;
begin
with CURRNODE^ do
begin
  (*  670,  13 *)
  SONS^.A315305defEnv:=A315305defEnv;
  
end
end;(*SEM20*)

procedure SEM21;
begin
with CURRNODE^ do
begin
  (*  672,  14 *)
  A314205numArgs:=A315317len;
  
end
end;(*SEM21*)

procedure SEM22;
begin
with CURRNODE^ do
begin
  (*  682,  11 *)
  A312305defEnv:=A342305defEnv;
  
end
end;(*SEM22*)

procedure SEM23;
begin
with CURRNODE^ do
begin
  (*  686,  12 *)
  A347233value:=A329233value^[Q329233value].COLIST;
  (*  686,  12 *)
  ATPOP(Q329233value,A329233value);
  
end
end;(*SEM23*)

procedure SEM24;
begin
with CURRNODE^ do
begin
  (*  685,  15 *)
  HIVAR0.C90SYMB:=A350253id;
  (*  685,  15 *)
  ATPUSH(HIVAR0,Q329330definingId,A329330definingId);
  
end
end;(*SEM24*)

procedure SEM25;
begin
with CURRNODE^ do
begin
  (*  680,  3 *)
  A312461GEN:=A351461GEN;
  
end
end;(*SEM25*)

procedure SEM26;
var HIVAR1:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  684,  15 *)
  INCLUDING(6,HIVAR1);
  SONS^.BROTHER^.BROTHER^.A308214class:=HIVAR1.C154tOilClass;
  
end
end;(*SEM26*)

procedure SEM27;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  708,  10 *)
  A350253id:=SONS^.TERMAT.id;
  (*  700,  10 *)
  INCLUDING(3,HIVAR2);
  HIVAR1.C307tEnv:=F323NewScope(HIVAR2.C307tEnv);
  HIVAR2.C144tKey:=F319DefineIdn(HIVAR1.C307tEnv,SONS^.TERMAT
  .id);
  HIVAR3.C147tObjKind:=F164SetaKind(HIVAR2.C144tKey,
  S216eType,S219eErrorObj);
  HIVAR4.C149tTypeKind:=F168SetaTypeKind(HIVAR2.C144tKey,
  S222eForType,S222eForType);
  new(HIVAR6.C160tStructTypeSet);
  with HIVAR6.C160tStructTypeSet^do
  begin
       L233value:=A347233value
  end;
  HIVAR5.C160tStructTypeSet:=HIVAR6.C160tStructTypeSet;
  HIVAR6.C160tStructTypeSet:=F180SetaSetValue(HIVAR2.C144tKey
  ,HIVAR5.C160tStructTypeSet,HIVAR5.C160tStructTypeSet);
  A342305defEnv:=HIVAR1.C307tEnv;
  
end
end;(*SEM27*)

procedure SEM28;
begin
with CURRNODE^ do
begin
  (*  719,  11 *)
  A312305defEnv:=A342305defEnv;
  
end
end;(*SEM28*)

procedure SEM29;
begin
with CURRNODE^ do
begin
  (*  720,  17 *)
  A347233value:=A329233value^[Q329233value].COLIST;
  (*  720,  17 *)
  ATPOP(Q329233value,A329233value);
  
end
end;(*SEM29*)

procedure SEM30;
begin
with CURRNODE^ do
begin
  (*  718,  15 *)
  HIVAR0.C90SYMB:=A350253id;
  (*  718,  15 *)
  ATPUSH(HIVAR0,Q329330definingId,A329330definingId);
  
end
end;(*SEM30*)

procedure SEM31;
begin
with CURRNODE^ do
begin
  (*  716,  3 *)
  A312461GEN:=EMPTY;
  
end
end;(*SEM31*)

procedure SEM32;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  734,  15 *)
  INCLUDING(1,HIVAR2);
  HIVAR1.C307tEnv:=HIVAR2.C307tEnv;
  HIVAR2.C144tKey:=F319DefineIdn(HIVAR1.C307tEnv,SONS^.TERMAT
  .id);
  HIVAR3.C147tObjKind:=F164SetaKind(HIVAR2.C144tKey,
  S216eType,S219eErrorObj);
  HIVAR4.C149tTypeKind:=F168SetaTypeKind(HIVAR2.C144tKey,
  S223ePrimSet,S223ePrimSet);
  A342305defEnv:=HIVAR1.C307tEnv;
  
end
end;(*SEM32*)

procedure SEM33;
var HIVAR1,HIVAR2,HIVAR3:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  750,  13 *)
  
  MC:=MC+1;
  INCLUDING(3,HIVAR2);
  HIVAR1.C144tKey:=F325KeyInEnv(HIVAR2.C307tEnv,SONS^.TERMAT.
  id);
  if not(F161GetaKind(HIVAR1.C144tKey,S219eErrorObj)<>
  S219eErrorObj)
  then MESSAGE(CONDFAILS,30,750,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  (*  741,  15 *)
  A350253id:=SONS^.TERMAT.id;
  (*  742,  15 *)
  INCLUDING(3,HIVAR2);
  HIVAR1.C144tKey:=F325KeyInEnv(HIVAR2.C307tEnv,SONS^.TERMAT.
  id);
  new(HIVAR3.C160tStructTypeSet);
  with HIVAR3.C160tStructTypeSet^do
  begin
       L233value:=A347233value
  end;
  HIVAR2.C160tStructTypeSet:=HIVAR3.C160tStructTypeSet;
  HIVAR3.C160tStructTypeSet:=F180SetaSetValue(HIVAR1.C144tKey
  ,HIVAR2.C160tStructTypeSet,HIVAR2.C160tStructTypeSet);
  A347233value:=HIVAR3.C160tStructTypeSet^.L233value;
  
end
end;(*SEM33*)

procedure SEM34;
var HIVAR1,HIVAR2:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  760,  11 *)
  HIVAR1.C307tEnv:=A342305defEnv;
  INCLUDING(1,HIVAR2);
  A312305defEnv:=HIVAR2.C307tEnv;
  
end
end;(*SEM34*)

procedure SEM35;
begin
with CURRNODE^ do
begin
  (*  758,  3 *)
  A312461GEN:=EMPTY;
  
end
end;(*SEM35*)

procedure SEM36;
begin
with CURRNODE^ do
begin
  (*  761,  14 *)
  A314205numArgs:=SONS^.BROTHER^.A335210cost;
  
end
end;(*SEM36*)

procedure SEM37;
var HIVAR1,HIVAR2:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  774,  14 *)
  HIVAR1.C144tKey:=SONS^.A337162key;
  INCLUDING(1,HIVAR2);
  A342305defEnv:=HIVAR2.C307tEnv;
  
end
end;(*SEM37*)

procedure SEM38;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  776,  12 *)
  if Q338162key>1 then
  HIVAR4:=A338162key^[Q338162key-1]else
  HIVAR4:=A338162key^[0].COARRAY^[Q338162key-1+10];
  HIVAR2.C144tKey:=A338162key^[Q338162key].C144tKey;
  HIVAR3.C144tKey:=HIVAR4.C144tKey;
  new(AUXELEMPTR);
  FIRSTELEM:=AUXELEMPTR;
  new(AUXELEMPTR^.ELEMENT);
  AUXELEMPTR^.ELEMENT^.DISCR:=U144tKey;
  AUXELEMPTR^.ELEMENT^.C144tKey:=HIVAR2.C144tKey;
  new(AUXELEMPTR^.NEXT);
  AUXELEMPTR:=AUXELEMPTR^.NEXT;
  new(AUXELEMPTR^.ELEMENT);
  AUXELEMPTR^.ELEMENT^.DISCR:=U144tKey;
  AUXELEMPTR^.ELEMENT^.C144tKey:=HIVAR3.C144tKey;
  AUXELEMPTR^.NEXT:=nil;
  HIVAR1.COLIST.HEAD:=FIRSTELEM;
  HIVAR1.COLIST.LAST:=AUXELEMPTR;
  A337208sig:=HIVAR1.COLIST;
  (*  776,  12 *)
  ATPOP(Q338162key,A338162key);
  (*  776,  12 *)
  ATPOP(Q338162key,A338162key);
  (*  777,  12 *)
  if Q338324tkind>1 then
  HIVAR1:=A338324tkind^[Q338324tkind-1]else
  HIVAR1:=A338324tkind^[0].COARRAY^[Q338324tkind-1+10];
  A337339sigDesc:=[A338324tkind^[Q338324tkind].C149tTypeKind,
  HIVAR1.C149tTypeKind];
  (*  777,  12 *)
  ATPOP(Q338324tkind,A338324tkind);
  (*  777,  12 *)
  ATPOP(Q338324tkind,A338324tkind);
  
end
end;(*SEM38*)

procedure SEM39;
var HIVAR1,HIVAR2:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  779,  14 *)
  HIVAR1.C245tAnyOp:=A337340oid;
  case HIVAR1.C245tAnyOp^.DISCR of
  U158tOilOp:
  begin
       HIVAR2.C88BOOL:=F300OilAddCoercion(HIVAR1.C245tAnyOp^.
       C158tOilOp)
  end;
  U215tOilClassOp:
  begin
       HIVAR2.C88BOOL:=F341OilAddClassCoercion(HIVAR1.
       C245tAnyOp^.C215tOilClassOp)
  end;
  U246tSetOp:
  begin
       HIVAR2.C88BOOL:=F299AddSetCoercion(HIVAR1.C245tAnyOp^.
       C246tSetOp)
  end end;
  A337311identification:=HIVAR2.C88BOOL;
  
end
end;(*SEM39*)

procedure SEM40;
var HIVAR1,HIVAR2:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  795,  11 *)
  HIVAR1.C307tEnv:=A342305defEnv;
  INCLUDING(1,HIVAR2);
  A312305defEnv:=HIVAR2.C307tEnv;
  
end
end;(*SEM40*)

procedure SEM41;
begin
with CURRNODE^ do
begin
  (*  793,  3 *)
  A312461GEN:=EMPTY;
  
end
end;(*SEM41*)

procedure SEM42;
begin
with CURRNODE^ do
begin
  (*  796,  14 *)
  HIVAR0.C87INT:=SONS^.BROTHER^.A335210cost;
  (*  796,  14 *)
  ATPUSH(HIVAR0,Q342210cost,A342210cost);
  
end
end;(*SEM42*)

procedure SEM43;
var HIVAR1,HIVAR2:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  810,  14 *)
  HIVAR1.C144tKey:=SONS^.A337162key;
  INCLUDING(1,HIVAR2);
  A342305defEnv:=HIVAR2.C307tEnv;
  
end
end;(*SEM43*)

procedure SEM44;
var HIVAR1,HIVAR2:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  811,  14 *)
  new(HIVAR2.COLIST.HEAD);
  HIVAR2.COLIST.LAST:=HIVAR2.COLIST.HEAD;
  HIVAR2.COLIST.LAST^.NEXT:=nil;
  new(HIVAR2.COLIST.HEAD^.ELEMENT);
  HIVAR2.COLIST.HEAD^.ELEMENT^.DISCR:=U144tKey;
  HIVAR2.COLIST.HEAD^.ELEMENT^.C144tKey:=A338162key^[Q338162key]
  .C144tKey;
  CONCATELIST(HIVAR2.COLIST,A343208sig,HIVAR1.COLIST);
  A343208sig:=HIVAR1.COLIST;
  (*  811,  14 *)
  ATPOP(Q338162key,A338162key);
  (*  812,  14 *)
  A343339sigDesc:=A343339sigDesc+[A338324tkind^[Q338324tkind].
  C149tTypeKind];
  (*  812,  14 *)
  ATPOP(Q338324tkind,A338324tkind);
  (*  814,  12 *)
  A337208sig:=A343208sig;
  (*  815,  12 *)
  A337339sigDesc:=A343339sigDesc;
  (*  809,  18 *)
  A314205numArgs:=A342210cost^[Q342210cost].C87INT;
  (*  809,  18 *)
  ATPOP(Q342210cost,A342210cost);
  
end
end;(*SEM44*)

procedure SEM45;
var HIVAR1,HIVAR2,HIVAR3:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  830,  17 *)
  HIVAR1.C307tEnv:=A342305defEnv;
  HIVAR2.C144tKey:=SONS^.A337162key;
  INCLUDING(1,HIVAR3);
  A342305defEnv:=HIVAR3.C307tEnv;
  
end
end;(*SEM45*)

procedure SEM46;
begin
with CURRNODE^ do
begin
  (*  824,  17 *)
  HIVAR0.C87INT:=A342210cost^[Q342210cost].C87INT;
  (*  824,  17 *)
  ATPUSH(HIVAR0,Q342210cost,A342210cost);
  
end
end;(*SEM46*)

procedure SEM47;
begin
with CURRNODE^ do
begin
  (*  826,  12 *)
  A337208sig:=A343208sig;
  (*  827,  12 *)
  A337339sigDesc:=A343339sigDesc;
  (*  828,  12 *)
  A314205numArgs:=A342210cost^[Q342210cost].C87INT;
  (*  828,  12 *)
  ATPOP(Q342210cost,A342210cost);
  
end
end;(*SEM47*)

procedure SEM48;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  848,  16 *)
  HIVAR1.C234tTypeSetOp:=A345346setOp^[Q345346setOp].
  C234tTypeSetOp;
  case HIVAR1.C234tTypeSetOp of
  S235eTSunion:
  begin
       if Q329233value>1 then
       HIVAR4:=A329233value^[Q329233value-1]else
       HIVAR4:=A329233value^[0].COARRAY^[Q329233value-1+10];
       P238SetUnion(HIVAR4.COLIST,A329233value^[Q329233value].
       COLIST,HIVAR3);
       HIVAR2.COLIST:=HIVAR3.COLIST
  end;
  S236eTSintersect:
  begin
       if Q329233value>1 then
       HIVAR4:=A329233value^[Q329233value-1]else
       HIVAR4:=A329233value^[0].COARRAY^[Q329233value-1+10];
       P243SetIntersect(HIVAR4.COLIST,A329233value^[Q329233value
       ].COLIST,HIVAR3);
       HIVAR2.COLIST:=HIVAR3.COLIST
  end;
  S237eTSdiff:
  begin
       if Q329233value>1 then
       HIVAR4:=A329233value^[Q329233value-1]else
       HIVAR4:=A329233value^[0].COARRAY^[Q329233value-1+10];
       P244SetDifference(HIVAR4.COLIST,A329233value^[
       Q329233value].COLIST,HIVAR3);
       HIVAR2.COLIST:=HIVAR3.COLIST
  end end;
  HIVAR0.COLIST:=HIVAR2.COLIST;
  (*  848,  16 *)
  ATPOP(Q345346setOp,A345346setOp);
  (*  848,  16 *)
  ATPOP(Q329233value,A329233value);
  (*  848,  16 *)
  ATPOP(Q329233value,A329233value);
  (*  848,  16 *)
  ATPUSH(HIVAR0,Q329233value,A329233value);
  
end
end;(*SEM48*)

procedure SEM49;
begin
with CURRNODE^ do
begin
  (*  847,  12 *)
  HIVAR0.C90SYMB:=A329330definingId^[Q329330definingId].C90SYMB
  ;
  (*  847,  12 *)
  ATPUSH(HIVAR0,Q329330definingId,A329330definingId);
  
end
end;(*SEM49*)

procedure SEM50;
begin
with CURRNODE^ do
begin
  (*  858,  8 *)
  HIVAR0.COLIST:=A347233value;
  (*  858,  8 *)
  ATPUSH(HIVAR0,Q329233value,A329233value);
  
end
end;(*SEM50*)

procedure SEM51;
begin
with CURRNODE^ do
begin
  (*  0,  1 *)
  ATPOP(Q329330definingId,A329330definingId);
  
end
end;(*SEM51*)

procedure SEM52;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  867,  13 *)
  HIVAR1.C144tKey:=A338162key^[Q338162key].C144tKey;
  HIVAR2.C149tTypeKind:=A338324tkind^[Q338324tkind].
  C149tTypeKind;
  if HIVAR2.C149tTypeKind in[S220ePrimType,S223ePrimSet]then
  case HIVAR2.C149tTypeKind of
  S220ePrimType:
  begin
       new(HIVAR4.COLIST.HEAD);
       HIVAR4.COLIST.LAST:=HIVAR4.COLIST.HEAD;
       HIVAR4.COLIST.LAST^.NEXT:=nil;
       new(HIVAR4.COLIST.HEAD^.ELEMENT);
       HIVAR4.COLIST.HEAD^.ELEMENT^.DISCR:=U156tOilType;
       HIVAR4.COLIST.HEAD^.ELEMENT^.C156tOilType:=F175GetaTypeId(
       HIVAR1.C144tKey,F264cErrorType);
       HIVAR3.COLIST:=HIVAR4.COLIST
  end;
  S223ePrimSet:
  begin
       HIVAR4.C160tStructTypeSet:=F179GetaSetValue(HIVAR1.
       C144tKey,C284cErrorTypeSet);
       HIVAR3.COLIST:=HIVAR4.C160tStructTypeSet^.L233value
  end end
  else begin
       HIVAR4.COLIST:=C284cErrorTypeSet^.L233value;
       
       MC:=MC+1;
       if not false
       then MESSAGE(CONDFAILS,44,872,GLOBPOS.LINE,GLOBPOS.COL);
       MC:=MC-1;
       ;
       HIVAR3.COLIST:=HIVAR4.COLIST
  end;
  HIVAR0.COLIST:=HIVAR3.COLIST;
  (*  867,  13 *)
  ATPOP(Q338324tkind,A338324tkind);
  (*  867,  13 *)
  ATPOP(Q338162key,A338162key);
  (*  867,  13 *)
  ATPUSH(HIVAR0,Q329233value,A329233value);
  
end
end;(*SEM52*)

procedure SEM53;
begin
with CURRNODE^ do
begin
  (*  865,  17 *)
  
  MC:=MC+1;
  if not(A329330definingId^[Q329330definingId].C90SYMB<>SONS^.
  A338253id)
  then MESSAGE(CONDFAILS,43,865,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  (*  865,  17 *)
  ATPOP(Q329330definingId,A329330definingId);
  
end
end;(*SEM53*)

procedure SEM54;
begin
with CURRNODE^ do
begin
  (*  880,  13 *)
  HIVAR0.COLIST:=C284cErrorTypeSet^.L233value;
  (*  880,  13 *)
  ATPUSH(HIVAR0,Q329233value,A329233value);
  
end
end;(*SEM54*)

procedure SEM55;
begin
with CURRNODE^ do
begin
  (*  0,  1 *)
  ATPOP(Q329330definingId,A329330definingId);
  
end
end;(*SEM55*)

procedure SEM56;
begin
with CURRNODE^ do
begin
  (*  889,  10 *)
  HIVAR0.C234tTypeSetOp:=S236eTSintersect;
  (*  889,  10 *)
  ATPUSH(HIVAR0,Q345346setOp,A345346setOp);
  
end
end;(*SEM56*)

procedure SEM57;
begin
with CURRNODE^ do
begin
  (*  896,  10 *)
  HIVAR0.C234tTypeSetOp:=S236eTSintersect;
  (*  896,  10 *)
  ATPUSH(HIVAR0,Q345346setOp,A345346setOp);
  
end
end;(*SEM57*)

procedure SEM58;
begin
with CURRNODE^ do
begin
  (*  903,  10 *)
  HIVAR0.C234tTypeSetOp:=S236eTSintersect;
  (*  903,  10 *)
  ATPUSH(HIVAR0,Q345346setOp,A345346setOp);
  
end
end;(*SEM58*)

procedure SEM59;
begin
with CURRNODE^ do
begin
  (*  910,  10 *)
  HIVAR0.C234tTypeSetOp:=S235eTSunion;
  (*  910,  10 *)
  ATPUSH(HIVAR0,Q345346setOp,A345346setOp);
  
end
end;(*SEM59*)

procedure SEM60;
begin
with CURRNODE^ do
begin
  (*  917,  10 *)
  HIVAR0.C234tTypeSetOp:=S237eTSdiff;
  (*  917,  10 *)
  ATPUSH(HIVAR0,Q345346setOp,A345346setOp);
  
end
end;(*SEM60*)

procedure SEM61;
begin
with CURRNODE^ do
begin
  (*  929,  15 *)
  A347233value:=EMPTY;
  
end
end;(*SEM61*)

procedure SEM62;
var HIVAR1:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  0,  1 *)
  ATPOP(Q338162key,A338162key);
  (*  936,  17 *)
  
  MC:=MC+1;
  if not(A338324tkind^[Q338324tkind].C149tTypeKind=S220ePrimType)
  then MESSAGE(CONDFAILS,51,936,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  (*  936,  17 *)
  ATPOP(Q338324tkind,A338324tkind);
  (*  938,  15 *)
  new(HIVAR1.COLIST.HEAD);
  HIVAR1.COLIST.LAST:=HIVAR1.COLIST.HEAD;
  HIVAR1.COLIST.LAST^.NEXT:=nil;
  new(HIVAR1.COLIST.HEAD^.ELEMENT);
  HIVAR1.COLIST.HEAD^.ELEMENT^.DISCR:=U156tOilType;
  HIVAR1.COLIST.HEAD^.ELEMENT^.C156tOilType:=A338348tid;
  A347233value:=HIVAR1.COLIST;
  
end
end;(*SEM62*)

procedure SEM63;
var HIVAR1,HIVAR2:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  0,  1 *)
  ATPOP(Q338162key,A338162key);
  (*  945,  17 *)
  
  MC:=MC+1;
  if not(A338324tkind^[Q338324tkind].C149tTypeKind=S220ePrimType)
  then MESSAGE(CONDFAILS,51,945,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  (*  945,  17 *)
  ATPOP(Q338324tkind,A338324tkind);
  (*  947,  18 *)
  new(HIVAR2.COLIST.HEAD);
  HIVAR2.COLIST.LAST:=HIVAR2.COLIST.HEAD;
  HIVAR2.COLIST.LAST^.NEXT:=nil;
  new(HIVAR2.COLIST.HEAD^.ELEMENT);
  HIVAR2.COLIST.HEAD^.ELEMENT^.DISCR:=U156tOilType;
  HIVAR2.COLIST.HEAD^.ELEMENT^.C156tOilType:=A338348tid;
  P238SetUnion(HIVAR2.COLIST,A347233value,HIVAR1);
  A347233value:=HIVAR1.COLIST;
  
end
end;(*SEM63*)

procedure SEM64;
begin
with CURRNODE^ do
begin
  (*  961,  13 *)
  A343339sigDesc:=[];
  (*  960,  13 *)
  A343208sig:=EMPTY;
  
end
end;(*SEM64*)

procedure SEM65;
var HIVAR1:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  968,  13 *)
  A343339sigDesc:=[A338324tkind^[Q338324tkind].C149tTypeKind];
  (*  968,  13 *)
  ATPOP(Q338324tkind,A338324tkind);
  (*  967,  13 *)
  new(HIVAR1.COLIST.HEAD);
  HIVAR1.COLIST.LAST:=HIVAR1.COLIST.HEAD;
  HIVAR1.COLIST.LAST^.NEXT:=nil;
  new(HIVAR1.COLIST.HEAD^.ELEMENT);
  HIVAR1.COLIST.HEAD^.ELEMENT^.DISCR:=U144tKey;
  HIVAR1.COLIST.HEAD^.ELEMENT^.C144tKey:=A338162key^[Q338162key]
  .C144tKey;
  A343208sig:=HIVAR1.COLIST;
  (*  967,  13 *)
  ATPOP(Q338162key,A338162key);
  
end
end;(*SEM65*)

procedure SEM66;
var HIVAR1,HIVAR2:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  975,  16 *)
  A343339sigDesc:=A343339sigDesc+[A338324tkind^[Q338324tkind].
  C149tTypeKind];
  (*  975,  16 *)
  ATPOP(Q338324tkind,A338324tkind);
  (*  974,  16 *)
  new(HIVAR2.COLIST.HEAD);
  HIVAR2.COLIST.LAST:=HIVAR2.COLIST.HEAD;
  HIVAR2.COLIST.LAST^.NEXT:=nil;
  new(HIVAR2.COLIST.HEAD^.ELEMENT);
  HIVAR2.COLIST.HEAD^.ELEMENT^.DISCR:=U144tKey;
  HIVAR2.COLIST.HEAD^.ELEMENT^.C144tKey:=A338162key^[Q338162key]
  .C144tKey;
  CONCATELIST(A343208sig,HIVAR2.COLIST,HIVAR1.COLIST);
  A343208sig:=HIVAR1.COLIST;
  (*  974,  16 *)
  ATPOP(Q338162key,A338162key);
  
end
end;(*SEM66*)

procedure SEM67;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6,HIVAR7:
UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  991,  11 *)
  A338253id:=SONS^.TERMAT.id;
  (*  992,  11 *)
  INCLUDING(3,HIVAR2);
  HIVAR1.C307tEnv:=HIVAR2.C307tEnv;
  if E144tKey(F325KeyInEnv(HIVAR1.C307tEnv,A338253id),
  C182dbNull)
  then begin
       INCLUDING(17,HIVAR4);
       HIVAR3.C144tKey:=F319DefineIdn(HIVAR4.C307tEnv,
       A338253id);
       HIVAR4.C147tObjKind:=F164SetaKind(HIVAR3.C144tKey,
       S216eType,S216eType);
       HIVAR5.C149tTypeKind:=F168SetaTypeKind(HIVAR3.C144tKey
       ,S220ePrimType,S220ePrimType);
       HIVAR6.C156tOilType:=F206DefType(A338253id);
       HIVAR7.C156tOilType:=F176SetaTypeId(HIVAR3.C144tKey,
       HIVAR6.C156tOilType,HIVAR6.C156tOilType);
       HIVAR2.C144tKey:=HIVAR3.C144tKey
  end else begin
       HIVAR2.C144tKey:=F325KeyInEnv(HIVAR1.C307tEnv,
       A338253id)
  end;
  HIVAR0.C144tKey:=HIVAR2.C144tKey;
  (*  992,  11 *)
  ATPUSH(HIVAR0,Q338162key,A338162key);
  (*  1005,  11 *)
  A338348tid:=F175GetaTypeId(A338162key^[Q338162key].C144tKey,
  F264cErrorType);
  (*  1004,  11 *)
  A350320okind:=F161GetaKind(A338162key^[Q338162key].C144tKey,
  S219eErrorObj);
  (*  1007,  17 *)
  
  MC:=MC+1;
  if not F228ObjKindCheck(A350320okind,S216eType)
  then MESSAGE(CONDFAILS,52,1007,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  (*  1008,  11 *)
  HIVAR0.C149tTypeKind:=F167GetaTypeKind(A338162key^[Q338162key
  ].C144tKey,S220ePrimType);
  (*  1008,  11 *)
  ATPUSH(HIVAR0,Q338324tkind,A338324tkind);
  
end
end;(*SEM67*)

procedure SEM68;
var HIVAR1:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  1019,  11 *)
  INCLUDING(1,HIVAR1);
  A312305defEnv:=HIVAR1.C307tEnv;
  
end
end;(*SEM68*)

procedure SEM69;
begin
with CURRNODE^ do
begin
  (*  1017,  3 *)
  A312461GEN:=A351461GEN;
  
end
end;(*SEM69*)

procedure SEM70;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  1034,  11 *)
  A350253id:=SONS^.TERMAT.id;
  (*  1035,  11 *)
  INCLUDING(3,HIVAR2);
  HIVAR1.C307tEnv:=HIVAR2.C307tEnv;
  if E144tKey(F325KeyInEnv(HIVAR1.C307tEnv,A350253id),
  C182dbNull)
  then begin
       HIVAR3.C144tKey:=F319DefineIdn(HIVAR1.C307tEnv,
       A350253id);
       HIVAR4.C147tObjKind:=F164SetaKind(HIVAR3.C144tKey,
       S217eOp,S217eOp);
       HIVAR5.C151tOpKind:=F170SetaOpKind(HIVAR3.C144tKey,
       S225ePrimOp,S225ePrimOp);
       HIVAR2.C144tKey:=HIVAR3.C144tKey
  end else begin
       HIVAR2.C144tKey:=F325KeyInEnv(HIVAR1.C307tEnv,
       A350253id)
  end;
  A350162key:=HIVAR2.C144tKey;
  (*  1045,  11 *)
  HIVAR1.C158tOilOp:=F177GetaOpId(A350162key,F301cErrorOp);
  if not E158tOilOp(HIVAR1.C158tOilOp,F301cErrorOp)
  then begin
       HIVAR2.C158tOilOp:=HIVAR1.C158tOilOp
  end else begin
       HIVAR3.C158tOilOp:=F207DefOp(A350253id,F262OilNewArgSig(
       true),0);
       HIVAR2.C158tOilOp:=F178SetaOpId(A350162key,HIVAR3.
       C158tOilOp,HIVAR3.C158tOilOp)
  end;
  A351249indication:=HIVAR2.C158tOilOp;
  (*  1053,  11 *)
  A350320okind:=F161GetaKind(A350162key,S219eErrorObj);
  (*  1055,  17 *)
  
  MC:=MC+1;
  if not F228ObjKindCheck(A350320okind,S217eOp)
  then MESSAGE(CONDFAILS,54,1055,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  (*  1056,  11 *)
  A350324tkind:=F167GetaTypeKind(A350162key,S220ePrimType);
  
end
end;(*SEM70*)

procedure SEM71;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  1073,  10 *)
  INCLUDING(1,HIVAR2);
  HIVAR1.C307tEnv:=HIVAR2.C307tEnv;
  HIVAR2.C144tKey:=F319DefineIdn(HIVAR1.C307tEnv,SONS^.TERMAT
  .id);
  HIVAR3.C147tObjKind:=F164SetaKind(HIVAR2.C144tKey,S217eOp,
  S219eErrorObj);
  HIVAR4.C151tOpKind:=F170SetaOpKind(HIVAR2.C144tKey,
  S225ePrimOp,S225ePrimOp);
  A337162key:=HIVAR2.C144tKey;
  
end
end;(*SEM71*)

procedure SEM72;
var HIVAR1,HIVAR2,HIVAR3,HIVAR4,HIVAR5,HIVAR6,HIVAR7,
HIVAR8,HIVAR9:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  1102,  13 *)
  
  MC:=MC+1;
  INCLUDING(3,HIVAR2);
  HIVAR1.C144tKey:=F325KeyInEnv(HIVAR2.C307tEnv,SONS^.TERMAT.
  id);
  if not(F161GetaKind(HIVAR1.C144tKey,S219eErrorObj)<>
  S219eErrorObj)
  then MESSAGE(CONDFAILS,30,1102,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  (*  1080,  10 *)
  INCLUDING(6,HIVAR2);
  HIVAR1.C154tOilClass:=HIVAR2.C154tOilClass;
  HIVAR2.C87INT:=A314205numArgs;
  HIVAR3.C230tTypeKindSet:=A337339sigDesc;
  HIVAR4.COLIST:=A337208sig;
  if S221eParamType in HIVAR3.C230tTypeKindSet
  then begin
       new(HIVAR6.C245tAnyOp);
       with HIVAR6.C245tAnyOp^do
       begin
            DISCR:=U215tOilClassOp;
            C215tOilClassOp:=F212DefClassOp(SONS^.TERMAT.id,
            F265ClassSig(HIVAR4.COLIST),HIVAR2.C87INT,HIVAR1
            .C154tOilClass)
       end;
       HIVAR5.C245tAnyOp:=HIVAR6.C245tAnyOp
  end else begin
       if(S222eForType in HIVAR3.C230tTypeKindSet)or(
       S223ePrimSet in HIVAR3.C230tTypeKindSet)
       then begin
            P278SetSig(HIVAR4.COLIST,HIVAR9);
            P298AddSetOp(SONS^.TERMAT.id,HIVAR9.COLIST,HIVAR2.
            C87INT,HIVAR8);
            new(HIVAR7.C245tAnyOp);
            with HIVAR7.C245tAnyOp^do
            begin
                 DISCR:=U246tSetOp;
                 C246tSetOp:=HIVAR8.COLIST
            end;
            HIVAR6.C245tAnyOp:=HIVAR7.C245tAnyOp
       end else begin
            if S224eParamSet in HIVAR3.C230tTypeKindSet
            then begin
                 HIVAR9.C158tOilOp:=F301cErrorOp;
                 
                 MC:=MC+1;
                 if not false
                 then MESSAGE(CONDFAILS,55,1093,GLOBPOS.LINE,GLOBPOS.
                 COL);
                 MC:=MC-1;
                 ;
                 HIVAR8.C158tOilOp:=HIVAR9.C158tOilOp
            end else begin
                 HIVAR9.C158tOilOp:=F207DefOp(SONS^.TERMAT.id,
                 F260PrimSig(HIVAR4.COLIST),HIVAR2.C87INT);
                 HIVAR8.C158tOilOp:=F178SetaOpId(A337162key,
                 HIVAR9.C158tOilOp,HIVAR9.C158tOilOp)
            end;
            new(HIVAR7.C245tAnyOp);
            with HIVAR7.C245tAnyOp^do
            begin
                 DISCR:=U158tOilOp;
                 C158tOilOp:=HIVAR8.C158tOilOp
            end;
            HIVAR6.C245tAnyOp:=HIVAR7.C245tAnyOp
       end;
       HIVAR5.C245tAnyOp:=HIVAR6.C245tAnyOp
  end;
  A337340oid:=HIVAR5.C245tAnyOp;
  (*  1104,  10 *)
  INCLUDING(6,HIVAR1);
  INCLUDING(24,HIVAR2);
  A337311identification:=F251AddIdentification(A337340oid,HIVAR1
  .C154tOilClass,SONS^.TERMAT.id,HIVAR2.COLIST);
  
end
end;(*SEM72*)

procedure SEM73;
var HIVAR1:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  1120,  12 *)
  HIVAR1.C158tOilOp:=A351249indication;
  AUXPTR:=SONS^.ELEMS;
  while AUXPTR<>nil do
  begin
       AUXPTR^.A310249indication:=HIVAR1.C158tOilOp;
       AUXPTR:=AUXPTR^.BROTHER;
       
  end;
  
end
end;(*SEM73*)

procedure SEM74;
var HIVAR1:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  1118,  3 *)
  FIRSTTIME:=true;
  FIRSTELEM:=nil;
  LASTELEM:=nil;
  AUXPTR:=SONS^.ELEMS;
  while AUXPTR<>nil do
  begin
       new(AUXELEMPTR);
       new(AUXELEMPTR^.ELEMENT);
       with AUXELEMPTR^,ELEMENT^do
       begin
            DISCR:=U247tIdentPair;
            C247tIdentPair:=AUXPTR^.A310311identification;
            NEXT:=nil;
       end;
       if FIRSTTIME
       then begin
            FIRSTTIME:=false;
            FIRSTELEM:=AUXELEMPTR;
            LASTELEM:=AUXELEMPTR;
       end
       else begin
            LASTELEM^.NEXT:=AUXELEMPTR;
            LASTELEM:=LASTELEM^.NEXT;
       end;
       AUXPTR:=AUXPTR^.BROTHER;
  end;
  HIVAR1.DISCR:=U452GEN;
  HIVAR1.COLIST.HEAD:=FIRSTELEM;
  HIVAR1.COLIST.LAST:=LASTELEM;
  A351461GEN:=HIVAR1.COLIST;
  
end
end;(*SEM74*)

procedure SEM75;
var HIVAR1:UNIONTYPE;
begin
with CURRNODE^ do
begin
  (*  1141,  10 *)
  new(HIVAR1.C247tIdentPair);
  with HIVAR1.C247tIdentPair^do
  begin
       L248op:=SONS^.TERMAT.id;
       L249indication:=A310249indication
  end;
  A310311identification:=HIVAR1.C247tIdentPair;
  (*  1134,  10 *)
  INCLUDING(3,HIVAR1);
  A310162key:=F325KeyInEnv(HIVAR1.C307tEnv,SONS^.TERMAT.id);
  (*  1136,  17 *)
  
  MC:=MC+1;
  if not(not E144tKey(A310162key,C182dbNull))
  then MESSAGE(CONDFAILS,56,1136,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  (*  1137,  10 *)
  A310195otype:=F161GetaKind(A310162key,S219eErrorObj);
  (*  1139,  17 *)
  
  MC:=MC+1;
  if not F228ObjKindCheck(A310195otype,S217eOp)
  then MESSAGE(CONDFAILS,57,1139,GLOBPOS.LINE,GLOBPOS.COL);
  MC:=MC-1;
  ;
  (*  1140,  10 *)
  A310352operkind:=F169GetaOpKind(A310162key,S225ePrimOp);
  
end
end;(*SEM75*)

procedure SEM76;
begin
with CURRNODE^ do
begin
  (*  1156,  11 *)
  A335210cost:=1;
  
end
end;(*SEM76*)

procedure SEM77;
begin
with CURRNODE^ do
begin
  (*  1162,  11 *)
  A335210cost:=SONS^.TERMAT.value;
  
end
end;(*SEM77*)

(*&END GEN INCLUDE*)


begin (* SEMANALYSE *)

  SEMINIT;



  RETURNSTACK [ NODESTACKTOP ] := ANCESTORVISIT; (* DUMMY FOR STOP CONDITION *)

  TREENEXT;                  (* get first tree *)

  while CURRNODE <> nil      (* there is a tree to be attributed *)
  do begin                   (* CURRNODE is its root *)

  VSINDEX  :=                (* index of next VS-action*)
       SECTTAB ( CURRNODE^.RULE , 0 (* ROOTCOUNT *));
                             (* pass eval not yet implemented *)

  (* THE STATE OF THE EVALUATOR IS DETERMINED BY THE PAIR            *)
  (* (CURRNODE, VSINDEX) AND THE STACK OF SUCH PAIRS IMPLEMENTED BY  *)
  (* THE TWO STACKS NODESTACK (in tree module) AND RETURNSTACK       *)

  repeat


    VSELEM := VSTAB ( VSINDEX );
                                                (* decode next action *)
    if VSELEM = ANCESTORVISIT
    then begin                                  (* ancestor visit     *)


      TREEANCESTOR;

      if CURRNODE <> nil  
      then begin                             (* still in the tree *)

      VSINDEX  := RETURNSTACK [ NODESTACKTOP+1 ];

      if CURRNODE^.RULE = LISTRULE
      then begin                              (* evaluating a list*)
        TREEBROTHER;
        if CURRNODE <> nil                    (* more elems in list *)
        then begin
          VSELEM := VSTAB ( VSINDEX );
          VSNUMBER  := (VSELEM-1) div MAXVSSYMBNO + 1;
          VSINDEX := SECTTAB( CURRNODE^.RULE, VSNUMBER - 1 );


        end else begin                        (* list is completed *)


          TREEANCESTOR;			     (* pop list node *)
          VSINDEX  := RETURNSTACK [ NODESTACKTOP ];
          TREEANCESTOR;			     (* pop ancest. of list *)
        end;
      end;                                        (* end list node *)
    end                                         (* end CURRNODE<>nil*)
    end                                         (* end ANCESTOR VISIT*)
    else
    if VSELEM < MINSEMRELCODE
    then begin                                  (*   DESCENDANT VISIT *)

      VSDESCIND := (VSELEM-1) mod MAXVSSYMBNO + 1; (* NO. SUCCESSOR   *)
      VSNUMBER  := (VSELEM-1) div MAXVSSYMBNO + 1; (* NO. VISIT TO IT *)


      TREEDESCENDANT (VSDESCIND);
      RETURNSTACK [ NODESTACKTOP ] := VSINDEX + 1;

      if CURRNODE^.RULE = LISTRULE                 (* VISIT TO A LIST *)
      then begin


        if CURRNODE^.ELEMS = nil
        then begin              (* EMPTY LIST: VISIT ANCS IMMEDIATELY *)
          VSINDEX  := RETURNSTACK [ NODESTACKTOP ];
          TREEANCESTOR;
        end else begin
          TREEFIRSTELEM;			(* PUSH LIST ANCHOR *)
          RETURNSTACK [ NODESTACKTOP ] := VSINDEX;
          (* ASSERT(CURRNODE^.RULE IS AG-RULE) *)
          VSINDEX := SECTTAB( CURRNODE^.RULE, VSNUMBER - 1 );
        end;

      end else                               (*end visit to a list*)
      if CURRNODE^.RULE = EMPTYRULE
      then begin                          (* IMMEDIATE ANCESTOR VISIT *)


        VSINDEX  := RETURNSTACK [ NODESTACKTOP ];
        TREEANCESTOR;                                   (* POP A NODE *)

      end else                                             (* AG-RULE *)
        VSINDEX := SECTTAB( CURRNODE^.RULE, VSNUMBER - 1 );

    end                                     (*end of DESCENDANT VISIT *)
    else begin                        (* EVALUATION OF SEMANTIC RULES *)
      SEMCODE := VSELEM - MINSEMRELCODE
                 + RULEFIRSTSEMCODE ( CURRNODE^.RULE );
      GLOBPOS:=CURRNODE^.POS;


      VSINDEX := VSINDEX + 1;




case SEMCODE of
0:SEM0;
1:SEM1;
2:SEM2;
3:SEM3;
4:SEM4;
5:SEM5;
6:SEM6;
7:SEM7;
8:SEM8;
9:SEM9;
10:SEM10;
11:SEM11;
12:SEM12;
13:SEM13;
14:SEM14;
15:SEM15;
16:SEM16;
17:SEM17;
18:SEM18;
19:SEM19;
20:SEM20;
21:SEM21;
22:SEM22;
23:SEM23;
24:SEM24;
25:SEM25;
26:SEM26;
27:SEM27;
28:SEM28;
29:SEM29;
30:SEM30;
31:SEM31;
32:SEM32;
33:SEM33;
34:SEM34;
35:SEM35;
36:SEM36;
37:SEM37;
38:SEM38;
39:SEM39;
40:SEM40;
41:SEM41;
42:SEM42;
43:SEM43;
44:SEM44;
45:SEM45;
46:SEM46;
47:SEM47;
48:SEM48;
49:SEM49;
50:SEM50;
51:SEM51;
52:SEM52;
53:SEM53;
54:SEM54;
55:SEM55;
56:SEM56;
57:SEM57;
58:SEM58;
59:SEM59;
60:SEM60;
61:SEM61;
62:SEM62;
63:SEM63;
64:SEM64;
65:SEM65;
66:SEM66;
67:SEM67;
68:SEM68;
69:SEM69;
70:SEM70;
71:SEM71;
72:SEM72;
73:SEM73;
74:SEM74;
75:SEM75;
76:SEM76;
77:SEM77;
end(*case SEMCODE*);

(*&END GEN INCLUDE*)


    end; (* EVALUATION OF SEMANTIC RULES *)

  until CURRNODE = nil;    (*this tree is evaluated, last action
                             TREEANCESTOR yielded NIL *)

  TREENEXT;

  end; (* while CURRNODE <> nil *)


end; (* SEMANALYSE *)


begin (* ATTREVAL *)


   INIT;       

   SEMANALYSE;



end; (* ATTREVAL *)
(*==================================================================*)

(*&END INCLUDE*)



begin (*GAGPGM*)



if argc<2 then begin message('No source file specified'); halt end;
argv(1,filearg);

SCANINIT(filearg,0);


SourceInit;



Zerteiler;


(* initialize database *)
dbInitDummy := dbInit;

(*		begin OIL.pp INIT
  $Id: oil.pp,v 1.7 89/10/06 11:44:46 swain Exp $
  Copyright, 1989, The Regents of the University of Colorado
  *)

  InitCompilerAdt;

(*		end of OIL.pp INIT		*)



ATTREVAL;



(*              begin OIL.pp FINL               *)

  EmitCompilerAdt;

(*		* *  the end of OIL(2).pp  * *			*)




    WRAPUP;


end.

