(* $Id: tree_h.pp,v 1.4 91/06/23 16:24:34 waite Exp $ *)
(* Copyright, 1989, Universitaet Paderborn *)

const


MAXINCLKEY=24;

(*&END GEN INCLUDE*)


type


INCLRANGE=1..MAXINCLKEY;

(*&END GEN INCLUDE*)

GRUNDSYMBOLDESKRIPTOR = record POS        : POSITION;
                               SYNTAXCODE : integer;
                               ATTR       : integer;
                        end;

var

  CURRNODE : NODEPTR;
  NODESTACKTOP : 0..MAXTREEDEPTH;


(* for tree construction with a stack           *)
(*PRE: NODESTACKTOP=1; NODESTACK[1]=NIL (dummy) *)
(*INV: NODESTACKTOP=topmost entry               *)
(*POST:NODESTACK[2]=root of tree                *)

procedure PUSHNODE (PTR : NODEPTR); external;
function POPNODE : NODEPTR; external;

(* tree movements for attribute evaluation*)
(* PRE: stack as above, call TREENEXT to start with first tree*)
(* INV: CURRNODE->current node or CURRNODE=nil, see below *)
(*      CURRNODE^.SONS resp. CURRNODE^.ELEMS are accessible *)

procedure TREENEXT; external;
(* Move to root of next tree to be evaluated.
   If nil evaluation stops *)

procedure TREEANCESTOR; external;
(*  move to ancestor *)

procedure TREEDESCENDANT (I : integer); external;
(*  move to I-th descendant *)

procedure TREEFIRSTELEM; external;
(*  move to first element of a listnode *)

procedure TREEBROTHER; external;
(* PRE: CURRNODE is list node, reached by an immediately
        preceeding TREEANCESTOR form an element *)
(*  move to next element of the listnode *)

procedure EMPTYLIST   (ELZAHL:integer) ; external;
procedure ANFLIST   ( ELZAHL : integer )  ; external;
procedure CONTLIST   ( ELZAHL : integer )  ; external;
procedure EMPTYNODE   (I : integer)  ; external;

(* reaching up in the tree:*)
procedure INCLUDING (     INCLKEY : INCLRANGE;
                      var HIVAR   : UNIONTYPE ); external;
function ANCRULETEST : RULENRS ; external;

procedure MAKENODE   (RULEIND: RULENRS;
                      NTIND  : NTNRS;
                      SUCCS  : POSINT)  ; external;

procedure SourceInit; external;

	(* Functions to construct new trees *)

function Leaf(a: integer): NODEPTR; external;
function Link(f,r: NODEPTR): NODEPTR; external;
function Rule(r: integer; s: NODEPTR): NODEPTR; external;
function Tree(n: integer; t: NODEPTR): boolean; external;
function Bottom: NODEPTR; external;
function Empty: NODEPTR; external;
function EmptyL: NODEPTR; external;
function List(l: NODEPTR): NODEPTR; external;

