(* $Id: envmod.ext.h,v 1.7 90/04/04 17:41:13 waite Exp $ *)
(* Copyright, 1989, The Regents of the University of Colorado *)


(* functions imported from environment module *)


(* NewEnv: obtain a new environment
   On exit -
      NewEnv returns an environment consisting of an empty scope
*) 

function NewEnv: Environment; external;



(* NewScope: create a new scope within a given environment
   on entry -
      e = environment in which to create the new scope
   on exit-
      a new empty scope is created in e on top of the previously
      current scope in e;
      the new scope is made the current scope of the environment;
      NewScope returns the updated environment
*)

function NewScope (e: Environment): Environment; external;




(* KeyInEnv: obtain the definition of an identifier in a given environment
   on entry -
      e = environment in which the definition is sought
      i = identifier whose definition is sought
   on exit -
      if i is defined in e
         the definition table key of i is returned,
      otherwise,
         the reserved key NoDef() is returned
*)

function KeyInEnv (e: Environment; i: integer): exttKey; external;




(* KeyInScope: obtain a definition from the current scope of an environment
   on entry -
      e = environment in which the definition is sought
      i = identifier whose definition is sought
   on exit -
      if i is defined in the current scope of e
         the definition table key of i (in the current scope of e)
         is returned,
      otherwise,
         the reserved key NoDef() is returned
*)

function KeyInScope (e: Environment; i: integer): exttKey; external;




(* DefineIdn: define an identifier in the inner scope of an environment --
   on entry -
      e = environment in which to define the identifier
      i = identifier to be defined
   on exit -
      if i was already defined in the inner scope of e,
      the corresponding definition table key is returned
      otherwise,
      a new definition table key is returned and entered
      into the inner scope of e
*)

function DefineIdn (e: Environment; i: integer): exttKey; external;




(* AddIdn: define an identifier in the inner scope of an environment
   with a given key --
   on entry -
      e = environment in which to define the identifier
      i = identifier to be defined
      k = definition table key
   on exit -
      if i was already defined in the inner scope of e,
	 the corresponding definition table key is returned
      otherwise,
	 i becomes defined in the inner scope of e with the
	 given definition table key k
*)

function AddIdn (e: Environment; i: integer; k: exttKey): exttKey; external;

