/* $Id: dbtypes.h,v 1.7 91/03/27 14:51:27 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#ifndef DBTYPES_DEF
#define DBTYPES_DEF

/* dbtypes.h: database implementation types */
/* ---------------------------------------- */


/* representation of attribute values */
typedef union {
	int   		  ival;	/* ALADIN primitive types, enumerated types */
	char 		 *pval;	/* ALADIN composite types */
	struct db_object *oval;	/* database objects' surrogates */
} dbAtVal;


/* representation of an attribute */
typedef struct atrep {
	short 	      id;	/* attribute id */
	dbAtVal       val;	/* attribute value */
	struct atrep *nxt;	/* next attribute */
} db_atrep;


/* representation of an object in the database */
typedef struct db_object {
        short      otid;        /* object type id */
	db_atrep  *atlist;	/* attributes of this object */
} tKey, *surrogate;


/* representation of an object within a tuple */
typedef struct relobj {
	short          role;	/* role_id of this component */
	tKey          *object;	/* object as a component of a tuple */
	struct relobj *nxt;	/* next object in this tuple */
} db_relobj;


/* representation of a tuple in a relation */
typedef struct tuple {
	db_relobj    *firsto;	/* first object in this tuple */
	struct tuple *nxt;	/* next tuple in this relation */
} db_tuple;


/* representation of a relation */
typedef struct relhdr {
	short     id;		/* name of this relation */
	short     arity;	/* number of roles */
	db_tuple *firstt;	/* first tuple in this relation */
} dbRelation;


/* representation of an object within an object list */
typedef struct olistmem {
	tKey 	        *object;	/* the object */
	struct olistmem *nxt;		/* next object in this list */
} db_olistmem;


/* representation of an object list (aka "cursor") */
typedef struct {
	db_olistmem *first;	/* first object in this list */
	db_olistmem *pos;	/* current position within this list */
} tKeyList, *cursor;



/* end of dbtypes.h */
/* ---------------- */

#endif
