SHELL	= /bin/sh

#ifdef _AIX
CC	= cc -qlanglvl=ansi
#endif

CFLAGS	= -I../../..

OBJS    = SourceNode.o auxScanEOL.o csm.o cstsupp.o db.o dbdefs.o \
	dbgen.o deftbl.o envmod.o err.o glahead.o idn.o int.o oil.o \
	oiladt2a.o oiladt2b.o parse.o source.o tree.o vsfile.o walk.o \
	p2clib.o

oil.exe:	$(OBJS)
	$(CC) -o oil.exe $(CFLAGS) $(OBJS) 

clean:
	rm -f a.out *.o *.a core ERRS oil.exe

SourceNode.o:   SourceNode.c frame.h attr.h tree.h conn.ext.h
auxScanEOL.o:   auxScanEOL.c err.h gla.h source.h 
csm.o:  csm.c csm.h err.h csmtbl.h 
csm.o:  csm.c csm.h err.h csmtbl.h 
cstsupp.o:      cstsupp.c err.h csm.h idn.h 
db.o:   db.c dbconst.h dbtypes.h dbgen.h 
dbdefs.o:       dbdefs.c dbtypes.h 
dbgen.o:        dbgen.c err.h dbtypes.h 
deftbl.o:       deftbl.c dbtypes.h dbgen.h dbconst.h 
envmod.o:       envmod.c err.h envmod.h 
err.o:  err.c err.h source.h 
glahead.o:      glahead.c err.h source.h xtables.h xcode.h 
idn.o:  idn.c err.h idn.h csm.h idntbl.h 
idn.o:  idn.c err.h idn.h csm.h idntbl.h 
int.o:  int.c int.h 
oil.o:  oil.c oiladt2.h oiladt2a.h 
oiladt2a.o:     oiladt2a.c oiladt2.h 
oiladt2b.o:     oiladt2b.c oiladt2.h 
parse.o:        parse.c err.h gla.h parse.h 
source.o:       source.c source.h 
tree.o: tree.c frame.h attr.h tree.h conn.ext.h
vsfile.o:       vsfile.c vsfile.h 
walk.o: walk.c vsfile.ext.h frame.h attr.h tree.h dbgen.ext.h \
	deftbl.ext.h envmod.ext.h cstsupp.h
p2clib.o:    p2c.h
