
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "show_ptg_gen.h"

void _PrPTGNULL(n)
_PPTG0 n;{/* function printing nothing */}

static struct _SPTG0   _PTGNULL = { _PrPTGNULL };
PTGNode PTGNULL =  & _PTGNULL;

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

PTGNode PTGOut (r)
PTGNode r;
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: output file can't be open.\n");
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGName *_PPTGName;
struct _SPTGName{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGNumb *_PPTGNumb;
struct _SPTGNumb{
  _PTGProc _print;
  int _t0;
};

void _PrPTGAttrListHead(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (":", f);
}

void _PrPTGAttrDecl(n)
_PPTG4 n;
{
  fputs ("\n	", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (": ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  (* (n->_desc [3]->_print))(n->_desc[3]);
}

void _PrPTGAttrInfo(n)
_PPTG4 n;
{
  fputs ("/*  visit: ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" store: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" origin: ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (" */", f);
}

void _PrPTGTreeStore(n)
_PPTG0 n;
{
  fputs (" TREE ", f);
}

void _PrPTGStackStore(n)
_PPTG0 n;
{
  fputs (" STACK ", f);
}

void _PrPTGVarStore(n)
_PPTG1 n;
{
  fputs (" VARIABLE ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
}

void _PrPTGOrigChain(n)
_PPTG0 n;
{
  fputs (" CHAIN ", f);
}

void _PrPTGOrigRule(n)
_PPTG1 n;
{
  fputs (" RULE ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGOrigConst(n)
_PPTG0 n;
{
  fputs (" CONSTITUENT(S) ", f);
}

void _PrPTGOrigIncl(n)
_PPTG0 n;
{
  fputs (" INCLUDING ", f);
}

void _PrPTGUnknown(n)
_PPTG0 n;
{
  fputs (" UNKNOWN ", f);
}

void _PrPTGNONTERM(n)
_PPTG0 n;
{
  fputs ("\nNONTERM ", f);
}

void _PrPTGTERM(n)
_PPTG0 n;
{
  fputs ("\nTERM ", f);
}

void _PrPTGINH(n)
_PPTG0 n;
{
  fputs ("INH  ", f);
}

void _PrPTGSYNT(n)
_PPTG0 n;
{
  fputs ("SYNT ", f);
}

void _PrPTGVisitRule(n)
_PPTG3 n;
{
  fputs ("\nRULE ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (":\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" ::= ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("\n", f);
}

void _PrPTGSymbolIndex(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("[", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("] ", f);
}

void _PrPTGLiteral(n)
_PPTG1 n;
{
  fputs ("'", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("' ", f);
}

void _PrPTGVisit(n)
_PPTG2 n;
{
  fputs ("\n	visit no. ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" to [", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("]", f);
}

void _PrPTGLeave(n)
_PPTG1 n;
{
  fputs ("\n	leave no. ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGAttrCmp(n)
_PPTG3 n;
{
  fputs ("\n	[", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("].", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" = computation in ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
}

void _PrPTGPushCmp(n)
_PPTG3 n;
{
  fputs ("\n	[", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("].", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" = push computation in ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
}

void _PrPTGPlainCmp(n)
_PPTG1 n;
{
  fputs ("\n	computation in ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGTransfer(n)
_PPTG1 n;
{
  fputs ("\n	TRANSFER ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGChainStart(n)
_PPTG1 n;
{
  fputs ("\n	CHAINSTART ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGFileList(n)
_PPTG1 n;
{
  fputs ("/* Coordinates are denoted (Fi:line:col) with", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n*/\n", f);
}

void _PrPTGFileAssoc(n)
_PPTG2 n;
{
  fputs ("\n	", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (":  ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGCoord(n)
_PPTG3 n;
{
  fputs ("(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (":", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (":", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (")", f);
}

void _PrPTGFileRef(n)
_PPTG1 n;
{
  fputs ("F", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGComma(n)
_PPTG0 n;
{
  fputs (", ", f);
}

void _PrPTGSemicol(n)
_PPTG0 n;
{
  fputs ("; ", f);
}

void _PrPTGColSemi(n)
_PPTG0 n;
{
  fputs ("\n: ;\n", f);
}

void _PrPTGNewLine(n)
_PPTG0 n;
{
  fputs ("\n", f);
}

void _PrPTGSpace2(n)
_PPTG0 n;
{
  fputs ("  ", f);
}

void _PrPTGName(n)
_PPTGName n;
{
  fprintf (f, "%s",n->_t0);
}

void _PrPTGNumb(n)
_PPTGNumb n;
{
  fprintf (f, "%d",n->_t0);
}

void _PrPTGSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

PTGNode PTGAttrListHead(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGAttrListHead;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGAttrDecl(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGAttrDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGAttrInfo(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = _PrPTGAttrInfo;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

PTGNode PTGTreeStore()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGTreeStore;
  return ((PTGNode) n);
}

PTGNode PTGStackStore()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGStackStore;
  return ((PTGNode) n);
}

PTGNode PTGVarStore(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGVarStore;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGOrigChain()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGOrigChain;
  return ((PTGNode) n);
}

PTGNode PTGOrigRule(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGOrigRule;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGOrigConst()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGOrigConst;
  return ((PTGNode) n);
}

PTGNode PTGOrigIncl()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGOrigIncl;
  return ((PTGNode) n);
}

PTGNode PTGUnknown()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGUnknown;
  return ((PTGNode) n);
}

PTGNode PTGNONTERM()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGNONTERM;
  return ((PTGNode) n);
}

PTGNode PTGTERM()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGTERM;
  return ((PTGNode) n);
}

PTGNode PTGINH()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGINH;
  return ((PTGNode) n);
}

PTGNode PTGSYNT()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGSYNT;
  return ((PTGNode) n);
}

PTGNode PTGVisitRule(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGVisitRule;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGSymbolIndex(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSymbolIndex;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGLiteral(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGLiteral;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGVisit(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGVisit;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGLeave(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGLeave;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGAttrCmp(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGAttrCmp;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGPushCmp(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGPushCmp;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGPlainCmp(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGPlainCmp;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGTransfer(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGTransfer;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGChainStart(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGChainStart;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGFileList(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGFileList;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGFileAssoc(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGFileAssoc;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGCoord(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = _PrPTGCoord;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

PTGNode PTGFileRef(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGFileRef;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGComma()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGComma;
  return ((PTGNode) n);
}

PTGNode PTGSemicol()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGSemicol;
  return ((PTGNode) n);
}

PTGNode PTGColSemi()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGColSemi;
  return ((PTGNode) n);
}

PTGNode PTGNewLine()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGNewLine;
  return ((PTGNode) n);
}

PTGNode PTGSpace2()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGSpace2;
  return ((PTGNode) n);
}

PTGNode PTGName(_t0)
  char *_t0;
{
  _PPTGName n;

  if ((n = (_PPTGName) malloc (sizeof (struct _SPTGName)))  ==  (_PPTGName)NULL)
	MEMERR
  n->_print = _PrPTGName;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGNumb(_t0)
  int _t0;
{
  _PPTGNumb n;

  if ((n = (_PPTGNumb) malloc (sizeof (struct _SPTGNumb)))  ==  (_PPTGNumb)NULL)
	MEMERR
  n->_print = _PrPTGNumb;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

