
#include "HEAD.h"

#include "node.h"

#include "visitprocs.h"

#include "gsdescr.h"

extern void free();

extern char *malloc();

#include "obstack.h"

static struct obstack TreeSpace;

#define obstack_chunk_alloc malloc

#define obstack_chunk_free free

char* TreeNodeAlloc(size) int size;

{return (obstack_alloc(&TreeSpace, size));}

void InitTree() { obstack_init(&TreeSpace); }

NODEPTR MkIdentifier(_coordref,_tr1)
POSITION *_coordref;
SYMB _tr1;
{
_TSPIdentifier n;
n = (_TSPIdentifier) TreeNodeAlloc (sizeof (struct _TSIdentifier));
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;

n->_ATId=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkIntNumber(_coordref,_tr1)
POSITION *_coordref;
INT _tr1;
{
_TSPIntNumber n;
n = (_TSPIntNumber) TreeNodeAlloc (sizeof (struct _TSIntNumber));
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;

n->_ATValue=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkSTART(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSTART n;
n = (_TPPSTART) TreeNodeAlloc (sizeof (struct _TPSTART));
n->_proc =_VS1START;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOptions)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkOPTIONS1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPOPTIONS1 n;
n = (_TPPOPTIONS1) TreeNodeAlloc (sizeof (struct _TPOPTIONS1));
n->_proc =_VS1OPTIONS1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOption)_tr1;
n->_desc2= (_TSPOptions)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkOPTIONS2(_coordref)
POSITION *_coordref;
{_TPPOPTIONS2 n;
n = (_TPPOPTIONS2) TreeNodeAlloc (sizeof (struct _TPOPTIONS2));
n->_proc =_VS1OPTIONS2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkOPTEXP(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPOPTEXP n;
n = (_TPPOPTEXP) TreeNodeAlloc (sizeof (struct _TPOPTEXP));
n->_proc =_VS1OPTEXP;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPExpandOpts)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkOPTORD(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPOPTORD n;
n = (_TPPOPTORD) TreeNodeAlloc (sizeof (struct _TPOPTORD));
n->_proc =_VS1OPTORD;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOrderOpts)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkOPTOPT(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPOPTOPT n;
n = (_TPPOPTOPT) TreeNodeAlloc (sizeof (struct _TPOPTOPT));
n->_proc =_VS1OPTOPT;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOptimOpts)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkOPTBACK(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPOPTBACK n;
n = (_TPPOPTBACK) TreeNodeAlloc (sizeof (struct _TPOPTBACK));
n->_proc =_VS1OPTBACK;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPBackendOpts)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkIDENTS1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPIDENTS1 n;
n = (_TPPIDENTS1) TreeNodeAlloc (sizeof (struct _TPIDENTS1));
n->_proc =_VS1IDENTS1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPIdentList)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkIDENTS2(_coordref)
POSITION *_coordref;
{_TPPIDENTS2 n;
n = (_TPPIDENTS2) TreeNodeAlloc (sizeof (struct _TPIDENTS2));
n->_proc =_VS1IDENTS2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkEXPANDS1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPEXPANDS1 n;
n = (_TPPEXPANDS1) TreeNodeAlloc (sizeof (struct _TPEXPANDS1));
n->_proc =_VS1EXPANDS1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPExpandOpt)_tr1;
n->_desc2= (_TSPExpandOpts)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkEXPANDS2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPEXPANDS2 n;
n = (_TPPEXPANDS2) TreeNodeAlloc (sizeof (struct _TPEXPANDS2));
n->_proc =_VS1EXPANDS2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPExpandOpt)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkORDERS1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPORDERS1 n;
n = (_TPPORDERS1) TreeNodeAlloc (sizeof (struct _TPORDERS1));
n->_proc =_VS1ORDERS1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOrderOpt)_tr1;
n->_desc2= (_TSPOrderOpts)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkORDERS2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPORDERS2 n;
n = (_TPPORDERS2) TreeNodeAlloc (sizeof (struct _TPORDERS2));
n->_proc =_VS1ORDERS2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOrderOpt)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkOPTIMS1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPOPTIMS1 n;
n = (_TPPOPTIMS1) TreeNodeAlloc (sizeof (struct _TPOPTIMS1));
n->_proc =_VS1OPTIMS1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOptimOpt)_tr1;
n->_desc2= (_TSPOptimOpts)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkOPTIMS2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPOPTIMS2 n;
n = (_TPPOPTIMS2) TreeNodeAlloc (sizeof (struct _TPOPTIMS2));
n->_proc =_VS1OPTIMS2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPOptimOpt)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkBACKS1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPBACKS1 n;
n = (_TPPBACKS1) TreeNodeAlloc (sizeof (struct _TPBACKS1));
n->_proc =_VS1BACKS1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPBackendOpt)_tr1;
n->_desc2= (_TSPBackendOpts)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkBACKS2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPBACKS2 n;
n = (_TPPBACKS2) TreeNodeAlloc (sizeof (struct _TPBACKS2));
n->_proc =_VS1BACKS2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPBackendOpt)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkEXPAND1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPEXPAND1 n;
n = (_TPPEXPAND1) TreeNodeAlloc (sizeof (struct _TPEXPAND1));
n->_proc =_VS1EXPAND1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPIdentifier)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkEXPAND3(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPEXPAND3 n;
n = (_TPPEXPAND3) TreeNodeAlloc (sizeof (struct _TPEXPAND3));
n->_proc =_VS1EXPAND3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkEXPAND2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPEXPAND2 n;
n = (_TPPEXPAND2) TreeNodeAlloc (sizeof (struct _TPEXPAND2));
n->_proc =_VS1EXPAND2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkORDER1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPORDER1 n;
n = (_TPPORDER1) TreeNodeAlloc (sizeof (struct _TPORDER1));
n->_proc =_VS1ORDER1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPIdentifier)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkORDER2(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPORDER2 n;
n = (_TPPORDER2) TreeNodeAlloc (sizeof (struct _TPORDER2));
n->_proc =_VS1ORDER2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPIdentList)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkORDER3(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPORDER3 n;
n = (_TPPORDER3) TreeNodeAlloc (sizeof (struct _TPORDER3));
n->_proc =_VS1ORDER3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkORDER4(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPORDER4 n;
n = (_TPPORDER4) TreeNodeAlloc (sizeof (struct _TPORDER4));
n->_proc =_VS1ORDER4;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPArrangeType)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkARRANGE1(_coordref)
POSITION *_coordref;
{_TPPARRANGE1 n;
n = (_TPPARRANGE1) TreeNodeAlloc (sizeof (struct _TPARRANGE1));
n->_proc =_VS1ARRANGE1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkARRANGE4(_coordref)
POSITION *_coordref;
{_TPPARRANGE4 n;
n = (_TPPARRANGE4) TreeNodeAlloc (sizeof (struct _TPARRANGE4));
n->_proc =_VS1ARRANGE4;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkARRANGE2(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPARRANGE2 n;
n = (_TPPARRANGE2) TreeNodeAlloc (sizeof (struct _TPARRANGE2));
n->_proc =_VS1ARRANGE2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPIdentifier)_tr2;
n->_desc3= (_TSPIdentifier)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkARRANGE3(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPARRANGE3 n;
n = (_TPPARRANGE3) TreeNodeAlloc (sizeof (struct _TPARRANGE3));
n->_proc =_VS1ARRANGE3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPAttrSpec)_tr2;
n->_desc3= (_TSPAttrSpec)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkATTR1(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPATTR1 n;
n = (_TPPATTR1) TreeNodeAlloc (sizeof (struct _TPATTR1));
n->_proc =_VS1ATTR1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPIntNumber)_tr2;
n->_desc3= (_TSPIdentifier)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkOPTIM1(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPOPTIM1 n;
n = (_TPPOPTIM1) TreeNodeAlloc (sizeof (struct _TPOPTIM1));
n->_proc =_VS1OPTIM1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkOPTIM2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPOPTIM2 n;
n = (_TPPOPTIM2) TreeNodeAlloc (sizeof (struct _TPOPTIM2));
n->_proc =_VS1OPTIM2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkOPTIM3(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPOPTIM3 n;
n = (_TPPOPTIM3) TreeNodeAlloc (sizeof (struct _TPOPTIM3));
n->_proc =_VS1OPTIM3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPAttrType)_tr1;
n->_desc2= (_TSPAttrList)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkATTRTYPE1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPATTRTYPE1 n;
n = (_TPPATTRTYPE1) TreeNodeAlloc (sizeof (struct _TPATTRTYPE1));
n->_proc =_VS1ATTRTYPE1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPIdentifier)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkATTRTYPE2(_coordref)
POSITION *_coordref;
{_TPPATTRTYPE2 n;
n = (_TPPATTRTYPE2) TreeNodeAlloc (sizeof (struct _TPATTRTYPE2));
n->_proc =_VS1ATTRTYPE2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkATTRS1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPATTRS1 n;
n = (_TPPATTRS1) TreeNodeAlloc (sizeof (struct _TPATTRS1));
n->_proc =_VS1ATTRS1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPAttrNames)_tr1;
n->_desc2= (_TSPAttrList)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkATTRS2(_coordref)
POSITION *_coordref;
{_TPPATTRS2 n;
n = (_TPPATTRS2) TreeNodeAlloc (sizeof (struct _TPATTRS2));
n->_proc =_VS1ATTRS2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkATTRNAMES(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPATTRNAMES n;
n = (_TPPATTRNAMES) TreeNodeAlloc (sizeof (struct _TPATTRNAMES));
n->_proc =_VS1ATTRNAMES;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPNamesList)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkNAMESL1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPNAMESL1 n;
n = (_TPPNAMESL1) TreeNodeAlloc (sizeof (struct _TPNAMESL1));
n->_proc =_VS1NAMESL1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPNamesList)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkNAMESL2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPNAMESL2 n;
n = (_TPPNAMESL2) TreeNodeAlloc (sizeof (struct _TPNAMESL2));
n->_proc =_VS1NAMESL2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkBACKEND1(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPBACKEND1 n;
n = (_TPPBACKEND1) TreeNodeAlloc (sizeof (struct _TPBACKEND1));
n->_proc =_VS1BACKEND1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkBACKEND2(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPBACKEND2 n;
n = (_TPPBACKEND2) TreeNodeAlloc (sizeof (struct _TPBACKEND2));
n->_proc =_VS1BACKEND2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPIdentifier)_tr1;
n->_desc2= (_TSPIntNumber)_tr2;
return ( (NODEPTR) n);
}

#ifndef GETIdentifierId
#define GETIdentifierId(x) (x)
#endif

#ifndef GETIntNumberValue
#define GETIntNumberValue(x) (x)
#endif

void SourceLeaf(d) GRUNDSYMBOLDESKRIPTOR *d;
{_incrnodestack ();
switch (d->SyntaxCode) {

case 2: _nst[_nsp] =MkIdentifier(&(d->Pos),GETIdentifierId (d->Attr)); break;

case 3: _nst[_nsp] =MkIntNumber(&(d->Pos),GETIntNumberValue (d->Attr)); break;
}}


