SHELL	= /bin/sh

CFLAGS	= 

OBJS    = driver.o opt_liga.o keywords.o various.o err.o source.o csm.o \
	optlists.o clp.o pdl_gen.o deftbl.o clplib.o tdcore.o treecon.o \
	visitprocs.o conflicts.o output.o obstack.o treestack.o glahead.o idn.o \
	int.o Ccomment.o attrmain.o clpintf.o

EXE	= option.exe

$(EXE):	$(OBJS)
	$(CC) -o $(EXE) $(CFLAGS) $(OBJS)

objects: $(OBJS)

clean:
	rm -f a.out *.o *.a *~ core ERRS $(EXE)

tidy:
	rm -f core a.out *.o *~ *.a ERRS

driver.o:       driver.c HEAD.h INIT.h FINL.h treecon.h pdl_gen.h \
deftbl.h clp.h csm.h option_enums.h option_types.h keywords.h various.h \
optlists.h output.h conflicts.h err.h err.h treestack.h clplib.h \
deftbl.h pdl_gen.h lists.h 
opt_liga.o:     opt_liga.c opt_liga.h csm.h option_enums.h \
option_types.h keywords.h various.h optlists.h output.h conflicts.h 
keywords.o:     keywords.c keywords.h 
various.o:      various.c err.h opt_liga.h csm.h option_enums.h \
option_types.h keywords.h various.h optlists.h output.h conflicts.h 
err.o:  err.c err.h source.h 
source.o:       source.c source.h 
csm.o:  csm.c csm.h err.h csmtbl.h 
optlists.o:     optlists.c opt_liga.h csm.h option_enums.h \
option_types.h keywords.h various.h optlists.h output.h conflicts.h 
clp.o:  clp.c clplib.h pdl_gen.h deftbl.h pdl_gen.h lists.h 
pdl_gen.o:      pdl_gen.c deftbl.h pdl_gen.h 
deftbl.o:       deftbl.c err.h deftbl.h 
clplib.o:       clplib.c csm.h 
tdcore.o:       tdcore.c ptabs.h tdframe.h parser.h semprods.h err.h \
treecon.h err.h treestack.h 
treecon.o:      treecon.c HEAD.h node.h visitprocs.h gsdescr.h \
obstack.h treecon.h pdl_gen.h deftbl.h clp.h csm.h option_enums.h \
option_types.h keywords.h various.h optlists.h output.h conflicts.h \
err.h err.h treestack.h clplib.h deftbl.h pdl_gen.h lists.h err.h 
visitprocs.o:   visitprocs.c HEAD.h err.h node.h visitprocs.h glattr.h \
attrpredef.h treecon.h pdl_gen.h deftbl.h clp.h csm.h option_enums.h \
option_types.h keywords.h various.h optlists.h output.h conflicts.h \
err.h err.h treestack.h clplib.h deftbl.h pdl_gen.h lists.h err.h 
conflicts.o:    conflicts.c opt_liga.h csm.h option_enums.h \
option_types.h keywords.h various.h optlists.h output.h conflicts.h 
output.o:       output.c opt_liga.h csm.h option_enums.h option_types.h \
keywords.h various.h optlists.h output.h conflicts.h 
obstack.o:      obstack.c obstack.h 
treestack.o:    treestack.c err.h treecon.h treestack.h err.h \
treestack.h 
glahead.o:      glahead.c err.h source.h xtables.h xcode.h 
idn.o:  idn.c err.h idn.h csm.h idntbl.h 
int.o:  int.c int.h 
Ccomment.o:     Ccomment.c err.h gla.h source.h 
attrmain.o:     attrmain.c treecon.h visitprocs.h err.h treestack.h 
clpintf.o:      clpintf.c clp.h csm.h pdl_gen.h clplib.h deftbl.h \
pdl_gen.h lists.h 
