/* $Id: err.h,v 1.1 1991/09/11 10:02:09 cogito Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#ifndef ERR_DEF
#define ERR_DEF

	/* Error report classification */

#define NOTE	0	/* Nonstandard construct */
#define COMMENT	1	/* Criticism of programming style */
#define WARNING	2	/* Possible error */
#define ERROR	3	/* Repairable error */
#define FATAL	4	/* Unrepairable error */
#define DEADLY	5	/* Compiler error */


	/* Types exported by the Error Module */

typedef struct {	/* Source listing coordinates */
	int line;	   /* Line number */
	int col;	   /* Character position */
} POSITION;


	/* Variables exported by the Error Module */

extern int ErrorCount[];
extern POSITION curpos;	/* Current source text position */


	/* Routines exported by the Error Module */

#if defined(__cplusplus) || defined(__STDC__) 
extern void ErrorInit(int ImmOut, int AGout, int ErrLimit);
#else
extern ErrorInit();
#endif 
/* Initialize the error module 
 *    On entry- 
 *       ImmOut=1 if immediate error output required 
 *       AGout=1 to print AG line number on error reports 
 *       ErrLimit=1 to limit the number of errors reported
 ***/



#if defined(__cplusplus) || defined(__STDC__)
extern void message(int severity, char *Msgtext, int grammar, POSITION *source);
#else
extern void message();
#endif
/* Report an error
 *    On entry-
 *      severity=error severity
 *      Msgtext=message text
 *      grammar=identification of the test that failed
 *      source=source coordinates at which the error was detected
 ***/

#endif
