/* $Id: OutStr.c,v 3.1 1992/03/04 16:26:52 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include <stdio.h>
#include "OutStr.h"

#define	SQ	'\''

void C_outstr(fs, s)
  FILE *fs;
  char *s;
{
	char c;

	(void)fprintf(fs,"\"");

	while (c = *s++ & 0377) {
		if (c >= '\177') (void)fprintf(fs, "\\%3o", c);
		else if (c == '\\') (void)fputs("\\\\", fs);
		else if (c == '"') (void)fputs("\\\"", fs);
		else if (c >= ' ') (void)fputc(c, fs);
		else switch (c) {
		case '\n': (void)fputs("\\n", fs); break;
		case '\t': (void)fputs("\\t", fs); break;
		case '\b': (void)fputs("\\b", fs); break;
		case '\r': (void)fputs("\\r", fs); break;
		case '\f': (void)fputs("\\f", fs); break;
		default: (void)fprintf(fs, "\\%3o", c); }
	}

	(void)fprintf(fs,"\"");
	return;
}

void C_outchar(fs, s)
  FILE *fs;
  char *s;
{
        char c;

        (void)fputc(SQ, fs);

	if (c = *s & 0377) {
		if (c >= '\177') (void)fprintf(fs, "\\%3o", c);
		else if (c == '\\') (void)fputs("\\\\", fs);
		else if (c == '"') (void)fputs("\\\"", fs);
		else if (c >= ' ') (void)fputc(c, fs);
		else switch (c) {
		case '\n': (void)fputs("\\n", fs); break;
		case '\t': (void)fputs("\\t", fs); break;
		case '\b': (void)fputs("\\b", fs); break;
		case '\r': (void)fputs("\\r", fs); break;
		case '\f': (void)fputs("\\f", fs); break;
		default: (void)fprintf(fs, "\\%3o", c); }
	}

	(void)fputc(SQ, fs);
	return;
}

void P_outstr(fs, s)
  FILE *fs;
  char *s;
{
	char c;

	(void)fputc(SQ, fs);

	while (c = *s++ & 0177) {
		if (c == '\'') (void)fputs("''", fs);
		else (void)fputc(c, fs);
	}

	(void)fputc(SQ, fs);
	return;
}

void outstr(fs, s)
  FILE *fs;
  char *s;
{
        fprintf(fs,"%s",s);
        return;
}
