# $Id: Makefile.cpp,v 1.6 1992/11/11 14:20:52 cogito Exp $
#
# sceleton for the Makefile of a LIGA pass
# (-: or Makefile for the sceleton of a LIGA pass)
#

SHELL		= /bin/sh

# directories
DISTRIB 	= /tmp
IDL		= ../idl
OPTHANDLER	= ../option

# compiler options

CFLAGS		= -I$(IDL) -I$(OPTHANDLER)
COFLAGS		= -q

EXE		= ../liga_pass.exe

SOURCES		= ligascel.c err.c source.c OutStr.c

INCL		= ligaconsts.h ligascel.h err.h source.h OutStr.h
EXTINCL		= $(OPTHANDLER)/opt_input.h \
		  $(OPTHANDLER)/option_enums.h \
		  $(OPTHANDLER)/option_types.h

OBJ		= ligascel.o err.o source.o OutStr.o
EXTOBJ		= $(IDL)/lookup_idl.o \
		  $(IDL)/LIGA.o \
	 	  $(OPTHANDLER)/opt_input.o \
		  $(IDL)/libidl.a

TIDY		= *.o *~ a.out core
CLEAN		= $(TIDY) $(EXE)
CLOBBER		= $(CLEAN) Makefile
RCS		= $(SOURCES) $(INCL) README

# MAKE

all: ligaconsts.h $(EXE)

$(EXE): $(OBJ)
#	$(CC) $(CFLAGS) $(OBJ) $(EXTOBJ) -o $@

ligascel.o: ligascel.c ligaconsts.h ligascel.h $(EXTOBJ) $(EXTINCL) err.h
	$(CC) $(CFLAGS) -c ligascel.c
err.o:  err.h source.h
source.o:	source.h
OutStr.o:	OutStr.h

# checkout

checkout:
	-co $(COFLAGS) $(RCS)

# installation

install:
#	rm -f $(DESTDIR)/Tool/liga/$(EXE)
#	cp ligascel $(DESTDIR)/Tool/liga/$(EXE)
#	chmod 755 $(DESTDIR)/Tool/liga/$(EXE)

SourceDistr:	$(SOURCES) $(INCL)

# distribution

distrib:	$(SOURCES) $(INCL)
	- rm -rf $(DISTRIB)/ligascel
	mkdir $(DISTRIB)/ligascel
	cp $(SOURCES) $(INCL) Makefile.cpp README $(DISTRIB)/ligascel
	cd $(DISTRIB)/ligascel; chmod 0644 $(SOURCES) $(INCL) Makefile.cpp README 

# cleaning targets

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean $(COFLAGS) $(RCS)
	rm -rf $(CLEAN) Makefile

.PRECIOUS:	ligaconsts.h
