# $Id: Makefile.cpp,v 1.6 1992/11/11 15:06:42 cogito Exp $

# Makefile to produce the IDL-library "libidl.a": kalle 08.01.90 


INCDIR = ..

SHELL	= /bin/sh
CFLAGS	= -I$(INCDIR)
COFLAGS	= -q

DECLINC = $(INCDIR)/global.h
CODEINC = $(INCDIR)/writer.h
READINC = $(INCDIR)/reader.h

LIBDIR	= ..
DISTRIB	= /tmp

SRC    = nextOne.c  rmisc.c reader.c scanner.c labels.c wmisc.c \
	init.c list.c debug.c MsgChar.c \
	array.c wrat.c string.c basics.c alloc.c
OFILES = nextOne.o  rmisc.o reader.o scanner.o labels.o wmisc.o \
	init.o list.o debug.o MsgChar.o \
	array.o wrat.o string.o basics.o alloc.o
RCS	= $(SRC) README

TIDY= *.o *.a
CLEAN= $(TIDY) $(LIBDIR)/libidl.a
CLOBBER= $(CLEAN)

# generates libidl.a

all: $(LIBDIR)/libidl.a

#if defined(NO_RANLIB)
$(LIBDIR)/libidl.a: $(OFILES)
	ar rcus $(LIBDIR)/libidl.a $(OFILES)
#else
$(LIBDIR)/libidl.a: $(OFILES)
	ar rcu $(LIBDIR)/libidl.a $(OFILES)
	ranlib $(LIBDIR)/libidl.a
#endif

array.o inseq.o tester.o rmisc.o reader.o labels.o: $(DECLINC) $(READINC)

wmisc.o: $(DECLINC) $(CODEINC)

# SourceDistr

SourceDistr: $(SRC)

# checkout

checkout:      
	co $(COFLAGS) $(RCS)  

# distribution

distrib:	$(SRC)
	- rm -rf $(DISTRIB)/idl/idllib
	mkdir $(DISTRIB)/idl/idllib
	cp $(SRC) Makefile.cpp $(DISTRIB)/idl/idllib
	cd $(DISTRIB)/idl/idllib; chmod 0644 $(SRC) Makefile.cpp

# clean

tidy:
	rm -f $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -f $(CLOBBER)

# cleanall

cleanall:
	rcsclean -q $(SRC)

rcsclean:	clean
	rm -f Makefile
	rcsclean $(COFLAGS) $(RCS) Makefile.cpp
