/* $Id: Main.h,v 1.4 1991/12/18 16:02:28 cogito Exp $ */

/*======================================================================*
 *									*
 *	FILE:		Main/Main.h					*
 *									*
 *	CONTENTS:	Shared Header-File for the directory Main	*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/


/************************************************************************
 *				Actions.c				*
 ************************************************************************/

EXTERN void ActionMenuPopup();
	/* Action */

EXTERN void ActionCloseWindow();
	/* Action */


/************************************************************************
 *				MainList.c				*
 ************************************************************************/

EXTERN void ProdUpdateList();
EXTERN void SymbUpdateList();

EXTERN void ProdCreateList();
	/* Widget	hpaned, father;	*/

EXTERN void SymbCreateList();
	/* Widget	hpaned, father;	*/

EXTERN void SetListMasks();


/************************************************************************
 *			       MainWindow.c				*
 ************************************************************************/

EXTERN Widget Toplevel, StateLabel, LidoMenuItem;

EXTERN void CreateWidgets();


/************************************************************************
 *				 Order.c				*
 ************************************************************************/

/* Possible states of this tool */
typedef enum {
	DirectRules,		/* Constructing direct rule graphs	*/
	DirectSymbols,		/* Constructing direct symbol graphs	*/
	ReadOrderOptions,	/* Reading order options		*/
	TransitiveGraphs,	/* Constructing transitive graphs	*/
	InducedGraphs,		/* Constructing induced graphs		*/
	ArrangeOptions,		/* Introducing arrange options		*/
	ArrangedGraphs,		/* Computing arranged graphs		*/
	Partitions,		/* Computing partitions			*/
	PartitionedGraphs,	/* Constructing partitioned graphs	*/
	VisitSequences,		/* Constructing visit sequences		*/
	Lifetimes,		/* Computing attribute lifetimes	*/
	ReftabAdditions,	/* Computing ref_tab additions		*/

	HideAttribute,		/* Awaiting an attribute name to hide	*/
	UnHideAttribute,	/* Awaiting an attribute name to unhide	*/
	
	DpyDirectGraphs,	/* Displaying direct graphs		*/
	DpyTransitiveGraphs,	/* Displaying transitive graphs		*/
	DpyInducedGraphs,	/* Displaying induced graphs		*/
	DpyArrangedGraphs,	/* Displaying arranged graphs		*/
	DpyPartitionedGraphs,	/* Displaying partitioned graphs	*/
	DpyVisitSequences,	/* Displaying visit sequences		*/

	ConstructOutput,	/* Constructing IDL output structure	*/
	Output,			/* Writing output files			*/
} STATE;

EXTERN FILE *LCL;
EXTERN STATE state;
EXTERN Boolean Cyclic, DepRemoved;

EXTERN void SetState();

EXTERN void CallOrder();

EXTERN void RecomputeCB();
	/* Callback		*/

EXTERN void UpdatePartition();
	/* SYMBENTRY	*symb;	*/

EXTERN void UpdateVisitSequence();
	/* PRODENTRY	*prod;	*/

EXTERN void QuitCB();
	/* Callback		*/


/************************************************************************
 *			     OrderStrategy.c				*
 ************************************************************************/

EXTERN	bool	AUTOMATICALLY, ARRANGE, PARSE_TIME,
		TREE_BOTTOM_UP, TREE_TOP_DOWN, TREE_COMPLETE;
EXTERN	bool	PART_EARLY, PART_LATE, PART_BRANCH_AND_BOUND;

EXTERN void CreateTopoMenu();
	/* Widget	father;	*/

EXTERN void CreatePartMenu();
	/* Widget	father;	*/


/************************************************************************
 *			         Reftab.c				*
 ************************************************************************/

EXTERN void ComputeRefTabAdditions();
