/* $Id: Create.h,v 1.3 1991/12/18 16:02:28 cogito Exp $ */

/*======================================================================*
 *									*
 *	FILE:		Misc/Create.h					*
 *									*
 *	CONTENTS:	Makros useful for Widget Creation		*
 *									*
 *	AUTHOR:		Volker Niepel					*
 *									*
 *======================================================================*/

#define CreateBox(name,father) \
	XtCreateManagedWidget(name,boxWidgetClass,father,args,n)

#define CreateCommand(command,name,father,callback,closure) \
	{ \
		command = XtCreateManagedWidget (name, commandWidgetClass, \
					father, args, n); \
		XtAddCallback (command,XtNcallback,callback,(caddr_t)closure); \
	}

#define CreateDialog(name,father) \
	XtCreateManagedWidget(name,dialogWidgetClass,father,args,n)

#define CreateForm(name,father) \
	XtCreateManagedWidget(name,formWidgetClass,father,args,n)

#define CreateToggle(toggle,name,father,callback,closure) \
	{ \
		toggle = XtCreateManagedWidget (name, toggleWidgetClass, \
					father, args, n); \
		XtAddCallback (toggle,XtNcallback,callback,(caddr_t)closure); \
	}

#define CreateMItem(item,name,father,callback,closure) \
	{ \
		item = XtCreateManagedWidget(name,smeBSBObjectClass, \
						father,args,n); \
		XtAddCallback (item,XtNcallback,callback,(caddr_t) closure); \
	}

#define CreateMLine(line,name,father) \
	line = XtCreateManagedWidget(name,smeLineObjectClass,father,args,n)

#define CreateView(name,father) \
	XtCreateManagedWidget(name,viewportWidgetClass,father,args,n)

#define CreateList(name,father) \
	XtCreateManagedWidget(name,listWidgetClass,father,args,n)

#define CreateMButton(name,father) \
	XtCreateManagedWidget(name,menuButtonWidgetClass,father,args,n)

#define CreateMenu(name,father) \
	XtCreatePopupShell(name,simpleMenuWidgetClass,father,args,n)

#define CreateLabel(name,father) \
	XtCreateManagedWidget(name,labelWidgetClass,father,args,n)

#define CreatePaned(name,father) \
	XtCreateManagedWidget(name,panedWidgetClass,father,args,n)

#define CreateGraph(graph,name,father,expose,resize,select,closure) \
	{ \
		graph = XtCreateManagedWidget (name, graphWidgetClass, \
					father, args, n); \
		XtAddCallback (graph, XtNexpose, expose, (caddr_t) closure); \
		XtAddCallback (graph, XtNresize, resize, (caddr_t) closure); \
		XtAddCallback (graph, XtNselect, select, (caddr_t) closure); \
	}
