/* $Id: SymInh.c,v 3.3 1992/09/16 15:28:56 cogito Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "HEAD.h"

int InheritsFrom (Key, FromList)
	DefTableKey	Key;
	TList	FromList;
{	DefTableKey	FromKey;
	TList	ItsList;

while (FromList != NullList) {
	FromKey = (DefTableKey)HeadList (FromList);
	if (Key == FromKey) return (true);
	ItsList = GetInhFrom (FromKey, NullList);
	if (InheritsFrom (Key, ItsList))
		return (true);
	FromList = TailList (FromList);
}
return (false);
}/*InheritsFrom*/

int EnterInherit (To, From, Coord)
	DefTableKey		To, From;
	POSITION	*Coord;
{	TList	ToFrom, newToFrom, FromTo, FromFrom;

if (From == To) {
	message (ERROR, "inheritance to itself", 0, Coord);
	return (false);
}
FromFrom = GetInhFrom (From, NullList);
if (InheritsFrom (To, FromFrom)) {
	message (ERROR, "cyclic inheritance", 0, Coord);
	return (false);
}

ToFrom = GetInhTo (From, NullList);
newToFrom = AddToSetList (To, ToFrom);
if (newToFrom == ToFrom) return (true);
SetInhTo (From, newToFrom, newToFrom);

FromTo = ConsList (From, GetInhFrom (To, NullList));
SetInhFrom (To, FromTo, FromTo);
return (true);
}/*EnterInherit*/

POSITION	NoPos;
Environment	toscope;
int		toroot;

void InheritAttrsFromSymb (fromkey)
	DefTableKey		fromkey;
{	Scope		scdefs;
	Environment	env;
	DefTableKey	k;
	int		id, tp, cl;
	POSITION	*pos;

env = GetAttrScope (fromkey, NoEnv);
scdefs = DefinitionsOf (env);
while (scdefs != NoScope) {
	k = KeyOf (scdefs);
	id = IdnOf (scdefs);
	tp = GetAttrType (k, DIDNON);
	cl = GetAttrClass (k, ATCLUNKN);
	if (toroot) cl = ATCLSYNT;
	pos = GetCoord (k, &NoPos);
	DeclareExplAttr (toscope, id, tp, cl, pos);	
	scdefs = NextDefinition (scdefs);
}
}/*InheritAttrsFromSymb*/

void InheritAllAttrs (inhlist)
	TList	inhlist;
{	DefTableKey	fromkey;
while (inhlist != NullList) {
	fromkey = (DefTableKey)HeadList (inhlist);
	InheritAttrsFromSymb (fromkey);
	InheritAllAttrs (GetInhFrom (fromkey, NullList));
	inhlist = TailList (inhlist);
}
}/*InheritAllAttrs*/


void InheritAttrs (symkey)
	DefTableKey	symkey;
{	
NoPos.line = 0;
NoPos.col = 0;

toroot = GetIsRoot (symkey, false);
toscope = GetAttrScope (symkey, NoEnv);
InheritAllAttrs (GetInhFrom (symkey, NullList));
}/*InheritAttrs*/


int InSymbattrs (symdid, atdid, attrlist, coord)
	int		symdid, atdid;
	SEQSymbattr	attrlist;
	POSITION	*coord;
{	Symbattr	syat;

foreachinSEQSymbattr (attrlist, attrlist, syat) {
	if (symdid == symbdefOfSymbattr (syat)) {
		if (atdid != attrdefOfSymbattr (syat)) {
			message (ERROR,		
	"remote access to two attributes of one symbol", 0, coord);
		}
		return (true);
	}
}
return (false);
}/*InSymbattrs*/


SEQSymbattr MapToRealSymbattrs (symkey, attrid, attrlist,coord)
	DefTableKey	symkey;
	int 		attrid;
	SEQSymbattr	attrlist;
	POSITION	*coord;
{	TList		inhto;
	int		symdid, atdid, attp, atcl;
	POSITION	*atcoord;
	Environment	attrscope;
	DefTableKey	attrkey;

/* symkey has attrid in its attrscope */
attrscope = GetAttrScope (symkey, NoEnv);
attrkey = KeyInScope (attrscope, attrid);
attp = GetAttrType (attrkey, DIDNON);
atcl = GetAttrClass (attrkey, ATCLUNKN);
atcoord = GetCoord (attrkey, coord);

if (GetRealSym (symkey, false)) {
	symdid = GetDid (symkey, DIDNON);
	atdid = GetDid (attrkey, DIDNON);
	if (!InSymbattrs (symdid, atdid, attrlist, coord))
		attrlist =
		AppFrontSEQSymbattr (MkSymbattr (
			symdid, atdid),
			attrlist);
}
inhto = GetInhTo (symkey, NullList);
while (inhto != NullList) {
	symkey = (DefTableKey)HeadList (inhto);
	attrscope = GetAttrScope (symkey, NoEnv);
	(void)DeclareExplAttr (attrscope, attrid, attp, atcl, atcoord);
	attrlist =
	MapToRealSymbattrs (symkey, attrid, attrlist, coord);
	inhto = TailList (inhto);
}
return (attrlist);
}/*MapToRealSymbattrs*/

int InSymbExprs (symdid, exprs)
	int		symdid;
	SEQExpr		exprs;
{	Expr		exp;

foreachinSEQExpr (exprs, exprs, exp) {
	if (symdid == vOfVal (ExprToVal (exp)))
		return (true);
}
return (false);
}/*InSymbExprs*/


SEQExpr MapToRealSyms (symkey, exprs, coord)
	DefTableKey	symkey;
	SEQExpr		exprs;
	POSITION	*coord;
{	TList		inhto;
	int		symdid;

if (GetRealSym (symkey, false)) {
	symdid = GetDid (symkey, DIDNON);
	if (!InSymbExprs (symdid, exprs))
		exprs =
		AppFrontSEQExpr (ValToExpr (MkVal (
			symdid, coord->line, coord->col)),
			exprs);
}
inhto = GetInhTo (symkey, NullList);
while (inhto != NullList) {
	symkey = (DefTableKey)HeadList (inhto);
	exprs =
	MapToRealSyms (symkey, exprs, coord);
	inhto = TailList (inhto);
}
return (exprs);
}/*MapToRealSyms*/

