/* $Id: ligaback.c,v 3.1 1992/03/04 17:10:19 uwe Exp $ */

static char rcs_id[]= "$Id: ligaback.c,v 3.1 1992/03/04 17:10:19 uwe Exp $";

/***********************************************************************\
*									*
*		Implementation of LIGA backend				*
*									*
*	Module:		ligaback.c					*
*	File:		ligaBack.c					*
*	Contents:	main function of backend			*
*	Author:		U. Kastens					*
*									*
\***********************************************************************/

#include <stdio.h>

/*
#include "LIGA.h"
#include "LIGAMacros.h"
*/
#include "lookup_idl.h"

#include "err.h"

#include "option_enums.h"
#include "option_types.h"
#include "opt_input.h"

#include "ligaback.h"

/*
** GLOBAL VARIABLES
*/

AttrEval IdlStruct;

OptCollect scel_opts;

FILE	*InputFile;
FILE	*ProtocolFile;
FILE	*OptFile;

/*
** LOCAL VARIABLES
*/

char	*InputFName;
char	*ProtocolFName;
char	*OptFName;

/*
** LOCAL FUNCTIONS
*/

#ifdef __STDC__
void usage (char *progname)
#else
void usage (progname)
char *progname;
#endif
/* tell users how to use this program					*/
{
	(void) printf ("usage: %s [-i in][-o out][-p prot][-c ctl]\n",
		progname);
	exit (1);
} /* usage() */


/*
** GLOBAL FUNCTIONS
*/

#ifdef __STDC__
void deadly (char *msg)
#else
void deadly (msg)
char *msg;
#endif
/* print deadly error message and terminate program			*/
{
	curpos.line= 0;
	curpos.col= 0;
	message (DEADLY, msg, 0, &curpos);
} /* deadly() */

#ifdef __STDC__
int main (int argc, char *argv[])
#else
int main (argc, argv)
int argc;
char *argv[];
#endif
/* main program of liga backend module					*/
{
	char *progname;

	InputFName= "in";
	ProtocolFName= "proto";
	OptFName= "option";

	progname= *argv;
	argv++;

	/* evaluate arguments */
	for ( ; argc>1; argc--, argv++)
	{
		if ((*argv)[0] == '-')
		{
		  switch ((*argv)[1])
		  {
			case 'i':
				argv++;
				argc--;
				InputFName= *argv;
				break;
			case 'p':
				argv++;
				argc--;
				ProtocolFName= *argv;
				break;
			case 'c':
				argv++;
				argc--;
				OptFName= *argv;
				break;
			default:
				usage (progname);
				break;
		  } /* switch */
		}
		else
			usage (progname);
	} /* for */

	/* open input file */
	InputFile= fopen (InputFName, "r");
	if (!InputFile)
		deadly ("Can't read input file\n");

	/* open protocol file */
	ProtocolFile= fopen (ProtocolFName, "w");
	if (!ProtocolFile)
		deadly ("Can't create protocol file\n");

	/* open expand option file */
	OptFile= fopen (OptFName, "r");
	if (!OptFile)
		deadly ("Can't read option file\n");

	/* print header for protocol */
	(void) fprintf (ProtocolFile, "\n-------------------------------------");
	(void) fprintf (ProtocolFile, "-----------------------------------------\n");
	(void) fprintf (ProtocolFile, "\tPROTOCOL OF THE LIGA PASS BACKEND\n");
	(void) fprintf (ProtocolFile, "-------------------------------------");
	(void) fprintf (ProtocolFile, "-----------------------------------------\n\n");

	/* read files for option handling */
	scel_opts= (OptCollect) malloc (sizeof (struct _optcollect));
	OptionInput (scel_opts, OptFile);
	(void) fclose (OptFile);

	/* read input file */
	IdlStruct= ligain (InputFile);

	/* close input file */
	(void) fclose (InputFile);

/* call of central backend functions: */

	init_did_table (defseqOfAttrEval (IdlStruct));

	/* generation of files
		node.h		tree node types
		attr.gl		declaration of global variables
	*/
	/* must be before TrSEQAttribution */
	TrSeqDef (IdlStruct);

	/* generation of files
		visitprocs.c	procedures for visit-sequences
		visitprocs.h	header of procedures for visit-sequences
	*/
	TrSEQAttribution (attrrulesOfAttrEval (IdlStruct));


/* end of central backend functions */

	/* print trailer for protocol */
	(void) fprintf (ProtocolFile, "\n\n-------------------------------------");
	(void) fprintf (ProtocolFile, "-----------------------------------------\n");
	(void) fprintf (ProtocolFile, "\tBackend ");
	if (!ErrorCount[ERROR] && ! ErrorCount[WARNING])
	{
		(void) fprintf (ProtocolFile,
			"SUCCESSFULLY TERMINATED\n");
	} /* if */
	else
	{
	    (void) fprintf (ProtocolFile, "FAILED: ");
	    switch (ErrorCount[ERROR])
	    {
		case 0:
			(void) fprintf (ProtocolFile,
				"no ERROR messages, ");
			break;
		case 1:
			(void) fprintf (ProtocolFile, "one ERROR message, ");
			break;
		default:
			(void) fprintf (ProtocolFile,
				"%d ERROR messages, ", ErrorCount[ERROR]);
	    } /* switch */
	    switch (ErrorCount[WARNING])
	    {
		case 0:
			(void) fprintf (ProtocolFile,
				"no warnings\n");
			break;
		case 1:
			(void) fprintf (ProtocolFile, "one warning\n");
			break;
		default:
			(void) fprintf (ProtocolFile,
				"%d warnings\n", ErrorCount[WARNING]);
	    } /* switch */
	} /* else */
	(void) fprintf (ProtocolFile, "--------------------------------------");
	(void) fprintf (ProtocolFile, "----------------------------------------\n\n");
	/* close protocol file */
	(void) fclose (ProtocolFile);

	/* successful termination */
	return (ErrorCount[ERROR] || ErrorCount[WARNING]);
} /* main() */

/***********************\
* end of ligaback.c	*
\***********************/

