/* $Id: incl.c,v 3.1 1992/03/05 17:34:31 uwe Exp $ */

/* LIGA backend module		*/
/* including translation	*/
/* U. Kastens, 30. 12. 91	*/
/* including source access corrected */

#include "global.h"
/*
#include "LIGA.h"
#include "LIGAMacros.h"
*/
#include "lookup_idl.h"
#include "ligaconsts.h"
#include "backptg_gen.h"

#include "incl.h"
#include "bool.h"

Attrdef	tmpAttrdef;
Def	tmpDef;

SEQExpr incllist = NULL;

void InsertIncl (inc)
	Including	inc;
{	bool	found = false;
	SEQExpr	se;
	Expr	ex;
	Symbattr	sa;

retrievefirstSEQSymbattr (inclattrsOfIncluding (inc), sa);
tmpAttrdef = lookup_attrdef (attrdefOfSymbattr (sa));
if (typeidOfAttrdef (tmpAttrdef)
	== DIDVOID)
	return;

foreachinSEQExpr (incllist, se, ex) {
	if (strcmp (genattrOfIncluding (inc),
			genattrOfIncluding (ExprToIncluding (ex))) == 0)
		found = true;
}
ex = IncludingToExpr (inc);
if (!found) incllist = appendfrontSEQExpr (incllist, ex);
}/*InsertIncl*/

PTGNode GenVarDecls ()
{	SEQExpr 	se;
	Expr    	ex;
	PTGNode		res;
	char		*tp;
	Symbattr 	sa;
	Including	inc;

res = PTGEmpty ();

foreachinSEQExpr (incllist, se, ex) {
	inc = ExprToIncluding (ex);
	retrievefirstSEQSymbattr (inclattrsOfIncluding (inc), sa);

	tmpAttrdef = lookup_attrdef (attrdefOfSymbattr (sa));
	tmpDef = lookup_def (typeidOfAttrdef (tmpAttrdef));
	tp = dnameOfDef (tmpDef);

	res = PTGSeq (res,
		PTGDecl (PTGPtrTo (PTGAsIs (tp)),
		PTGInclGlobName (PTGAsIs (genattrOfIncluding (inc)))));
}
return (res);
}/*GenVarDecls*/

void FindInclExprSeq (se)
	SEQExpr	se;
{	SEQExpr	ses;
	Expr	ex;

foreachinSEQExpr (se, ses, ex)
	if (typeof (ex) == KIncluding)
		InsertIncl (ExprToIncluding (ex));
	else if (typeof (ex) == KCall)
		FindInclExprSeq (paramsOfCall (ExprToCall (ex)));
}/*FindInclExprSeq*/
		
PTGNode TrInclVars (ae)
	AttrEval	ae;
{	SEQAttribution	as;
	Attribution	ab;
	SEQAttrrule	ats;
	Attrrule	ar;

foreachinSEQAttribution (attrrulesOfAttrEval (ae), as, ab)
foreachinSEQAttrrule (attrrulesOfAttribution (ab), ats, ar)
if (typeof (ar) == KCall)
	FindInclExprSeq (paramsOfCall (AttrruleToCall (ar)));

return (GenVarDecls ());
}/*TrInclVars*/

int	currlhs;	/* both set by TrInclSect */
int	currsectno;	/* used by CurrAttrDid in TrIncluding */

int CurrAttrDid (inc)
	Including       inc;
{	SEQSymbattr     sas;
	Symbattr        sa;
	Attrdef		ad;

foreachinSEQSymbattr (inclattrsOfIncluding (inc), sas, sa) {
	ad = lookup_attrdef (attrdefOfSymbattr (sa));
	if ((currlhs == symbdefOfSymbattr (sa)) &&
	    (currsectno >= partOfAttrdef (ad)))
		return (attrdefOfSymbattr (sa));
}
return (DIDNON);
}/*CurrAttrDid*/

void TrInclSect (sydef, sectno, decls, pre, post)
	Symb		sydef;
	int		sectno;
	PTGNode		*decls, *pre, *post;
/* must be called before any TrIncluding of this section */
{	SEQExpr 	se;
	Expr    	ex;
	char		*tp;
	Attrdef		ad;
	int		attrdid;
	Including	inc;
	PTGNode		loc, glob;

currlhs = didOfSymb (sydef);
currsectno = sectno;

foreachinSEQExpr (incllist, se, ex) {
	inc = ExprToIncluding (ex);
	attrdid = CurrAttrDid (inc);
	if (attrdid != DIDNON) {
		ad = lookup_attrdef (attrdid);
		tmpDef = lookup_def (typeidOfAttrdef (ad));
		tp = dnameOfDef (tmpDef);
		loc = PTGInclLocName (PTGAsIs (genattrOfIncluding (inc)));
		glob = PTGInclGlobName (PTGAsIs (genattrOfIncluding (inc)));

		(*decls) = PTGSeq (*decls,
			PTGDecl (PTGPtrTo (PTGAsIs (tp)), loc));

		(*pre) = PTGSeq (*pre,
			PTGInclPre (loc, glob, glob,
				PTGTreeAttrName (
					PTGAsIs (nameOfAttrdef (ad)))));

		(*post) = PTGSeq (*post,
			PTGInclPost (glob, loc));
	}
}
}/*TrInclSect*/

PTGNode TrIncluding (inc)
	Including	inc;
{	int		attrdid;

attrdid = CurrAttrDid (inc);
if (attrdid != DIDNON)
	return (PTGContent (
		PTGInclLocName (PTGAsIs (genattrOfIncluding (inc)))));
else
	return (PTGContent (
		PTGInclGlobName (PTGAsIs (genattrOfIncluding (inc)))));
}/*TrIncluding*/


