/* $Id: expr.c,v 3.2 1992/09/16 14:43:22 cogito Exp $ */

/* LIGA backend module		*/
/* expression translation	*/
/* U. Kastens, 5. 11. 91	*/

#include "err.h"
#include "global.h"
/*
#include "LIGA.h"
#include "LIGAMacros.h"
*/
#include "ligaconsts.h"
#include "lookup_idl.h"
#include "backptg_gen.h"

#include "expr.h"
#include "attr.h"
#include "attrdecl.h"
#include "incl.h"
#include "bool.h"

POSITION coord;

PTGNode pppNoVal;

#define MANY 100

bool CheckArgNr (c, l, u)
	Call	c;
	int	l, u;
{	int	i = 0;
	SEQExpr params, es;
	Expr	e;

foreachinSEQExpr (paramsOfCall (c), es, e) i++;

if (i < l) {
	coord.line = rowOfCall (c);
	coord.col = colOfCall (c);
	message (DEADLY, "argument(s) missing", 0, &coord);
	return (true);
} else if (i > u) {
	coord.line = rowOfCall (c);
	coord.col = colOfCall (c);
	message (FATAL, "too many arguments", 0, &coord);
	return (true);
}
return (false);
}/*CheckArgNr*/


PTGNode TrCall (c, context)
	Call	c;
	int	context;
{	SEQExpr params;
	Expr	e1, e2, e3;

params = paramsOfCall (c);
if (strcmp (ASSIGNFCT, nameOfCall (c)) == 0) {
	if (CheckArgNr (c, 2, MANY)) return (PTGNULL);
	retrievefirstSEQExpr(params, e1);
	retrievefirstSEQExpr(tailSEQExpr (params), e2);
	if (!emptySEQExpr(tailSEQExpr (tailSEQExpr (params)))) {
		retrievefirstSEQExpr(tailSEQExpr (tailSEQExpr (params)), e3);
		if ((typeof (e3) == KName) &&
			(strcmp (nOfName (ExprToName (e3)), "VOID") == 0))
			return (PTGNULL);
	}
	if ((typeof (e1) == KAttracc) &&
	    (IsVoidAttr (lookup_attrdef (
			attridOfAttracc (ExprToAttracc (e1))))))
		return (TrExpr (e2, isstmt));
	else	return (PTGAssign (TrExpr (e1, isval), TrExpr (e2, isval)));
} else
if (strcmp (PUSHFCT, nameOfCall (c)) == 0) {
	if (CheckArgNr (c, 3, MANY)) return (PTGNULL); /* last added attr acc */
	retrievelastSEQExpr(params, e1);

	if ((typeof (e1) == KName) &&
			(strcmp (nOfName (ExprToName (e1)), "VOID") == 0))
		return (PTGNULL);

	retrievefirstSEQExpr(tailSEQExpr (params), e2);
	if ((typeof (e1) == KAttracc) &&
		(IsVoidAttr (lookup_attrdef (
			attridOfAttracc (ExprToAttracc (e1))))))
		return (TrExpr (e2, isstmt));
	else	return (PTGAssign (TrExpr (e1, isval), TrExpr (e2, isval)));
} else
if (strcmp (CLOBFCT, nameOfCall (c)) == 0) {
	if (CheckArgNr (c, 4, MANY)) return (PTGNULL); /* last added attr acc */
	retrievelastSEQExpr(params, e1);

	if ((typeof (e1) == KName) &&
			(strcmp (nOfName (ExprToName (e1)), "VOID") == 0))
		return (PTGNULL);

	retrievefirstSEQExpr(tailSEQExpr (tailSEQExpr (params)), e2);
	if ((typeof (e1) == KAttracc) &&
		(IsVoidAttr (lookup_attrdef (
			attridOfAttracc (ExprToAttracc (e1))))))
		return (TrExpr (e2, isstmt));
	else	return (PTGAssign (TrExpr (e1, isval), TrExpr (e2, isval)));
} else
if (strcmp (POPFCT, nameOfCall (c)) == 0) {
	return (PTGNULL);
} else
if (strcmp (SWAPFCT, nameOfCall (c)) == 0) {
	return (PTGNULL);
} else
if (strcmp (TOPFCT, nameOfCall (c)) == 0) {
	if (CheckArgNr (c, 3, 3)) return (PTGNULL); /* last added attr acc */
	retrievelastSEQExpr(params, e1);
	if (context == isstmt)
		return (PTGNULL);
	else	return (TrExpr (e1, context));
} else
if (strcmp (DEPFCT, nameOfCall (c)) == 0) {
	if (CheckArgNr (c, 1, MANY)) return (PTGNULL);
	retrievefirstSEQExpr(params, e1);
	return (TrExpr (e1, context));
} else
if (strcmp (ORDERFCT, nameOfCall (c)) == 0) {
	if (context == isstmt) {
		if (CheckArgNr (c, 0, MANY)) return (PTGNULL);
		return (TrSeqStmt (params));
	} else {
		if (CheckArgNr (c, 1, MANY)) return (PTGNULL);
		return (TrOrdSeq (params, context));
	}
} else
if (strcmp (VOIDFCT, nameOfCall (c)) == 0) {
/* VOIDFCT indicates dummy dependency argument */
	CheckArgNr (c, 1, 1);
	if (context == isval) {
		coord.line = rowOfCall (c);
		coord.col = colOfCall (c);
		message (FATAL,
		"internal error: VOID in value context", 0, &coord);
	} else if (context == isvoid)
		return (pppNoVal);
	return (PTGNULL);
} else
if (strcmp (IDFCT, nameOfCall (c)) == 0) {
/* IDFCT inserted by frontend for expressions on outmost level */
	CheckArgNr (c, 1, 1);
	retrievefirstSEQExpr(params, e1);
	return (TrExpr (e1, context));
} else
if (strcmp (IFFCT, nameOfCall (c)) == 0) {
	if (context == isstmt) {
		if (CheckArgNr (c, 2, 3)) return (PTGNULL);
		retrievefirstSEQExpr(params, e1);
		retrievefirstSEQExpr(tailSEQExpr (params), e2);
		if (emptySEQExpr (tailSEQExpr (tailSEQExpr (params))))
			return (PTGIfStmt (
					TrExpr (e1, isval),
					PTGStmt (TrExpr (e2, isstmt)),
					PTGNULL));
		else {
			retrievefirstSEQExpr(
				tailSEQExpr (tailSEQExpr (params)), e3);
			return (PTGIfStmt (
					TrExpr (e1, isval),
					PTGStmt (TrExpr (e2, isstmt)),
					PTGStmt (TrExpr (e3, isstmt))));
		}
	} else	if (context == isval) {
		if (CheckArgNr (c, 3, 3)) return (PTGNULL);
		retrievefirstSEQExpr(params, e1);
		retrievefirstSEQExpr(tailSEQExpr (params), e2);
		retrievefirstSEQExpr (tailSEQExpr (tailSEQExpr (params)), e3);
		return (PTGIfExpr (
				TrExpr (e1, isval),
				TrExpr (e2, isval),
				TrExpr (e3, isval)));
	} else { /* context == isvoid */
		if (CheckArgNr (c, 2, 3)) return (PTGNULL);
		retrievefirstSEQExpr(params, e1);
		retrievefirstSEQExpr(tailSEQExpr (params), e2);
		if (emptySEQExpr (tailSEQExpr (tailSEQExpr (params))))
			return (PTGIfExpr (
					TrExpr (e1, isval),
					PTGToNoVal (TrExpr (e2, isvoid)),
					pppNoVal));
		else {
			retrievefirstSEQExpr(
				tailSEQExpr (tailSEQExpr (params)), e3);
			return (PTGIfExpr (
					TrExpr (e1, isval),
					PTGToNoVal (TrExpr (e2, isvoid)),
					PTGToNoVal (TrExpr (e3, isvoid))));
		}
	}
} else {
	return (PTGCall (
		PTGAsIs (nameOfCall (c)), TrSeqExpr (params)));
}
}/*TrCall*/

PTGNode TrExpr (e, context)
	Expr	e;
	int	context;
{

switch (typeof (e)) {

case KLiteral:
if (context == isstmt) return (PTGNULL);
return (PTGC_Str (strOfLiteral (ExprToLiteral (e))));

case KVal:
if (context == isstmt) return (PTGNULL);
return (PTGNumb (vOfVal (ExprToVal (e))));

case KName:
return (PTGAsIs (nOfName(ExprToName (e))));

case KAttracc:
if (context == isstmt) return (PTGNULL);
if (context == isvoid) return (pppNoVal);
/* context == isval */
if (IsVoidAttr (lookup_attrdef (
		attridOfAttracc (ExprToAttracc (e))))) {
	coord.line = rowOfAttracc (ExprToAttracc (e));
	coord.col = colOfAttracc (ExprToAttracc (e));
	message (FATAL,
		"internal error: VOID attribute in value context", 0, &coord);
	return (PTGNULL);
}
return (TrAttracc (ExprToAttracc (e)));

case KCall:
return (TrCall (ExprToCall (e), context));

case KIncluding:
if (context == isstmt) return (PTGNULL);
if (context == isvoid) return (pppNoVal);
/* context == isval */
return (TrIncluding (ExprToIncluding (e)));

default: /* Chainacc or Constit should be removed by expand */
return (PTGNULL);
}
}/*TrExpr*/

PTGNode TrSeqExpr (s)
	SEQExpr s;
{	SEQExpr es;
	Expr	e;
	PTGNode res;

if (emptySEQExpr (s)) return (PTGNULL);

retrievefirstSEQExpr(s, e);
res = TrExpr (e, isval);

foreachinSEQExpr (tailSEQExpr (s), es, e)
	res = PTGSeqCom (res, TrExpr (e, isval));

return (res);
}/*TrSeqExpr*/

PTGNode TrSeqStmt (s)
	SEQExpr s;
{	SEQExpr es;
	Expr	e;
	PTGNode res;

res = PTGNULL;

foreachinSEQExpr (s, es, e)
	res = PTGSeq (res, PTGStmt (TrExpr (e, isstmt)));

return (res);
}/*TrSeqExpr*/

PTGNode TrOrdSeq (params, context)
	SEQExpr	params;
	int	context;
{	Expr	e1;
	PTGNode	res;

retrievefirstSEQExpr(params, e1);
params = tailSEQExpr (params);

if (emptySEQExpr (params))	/* the only argument */
	return (TrExpr (e1, context));

res = TrExpr (e1, isvoid);	/* the first of several args */
retrievefirstSEQExpr(params, e1); /* the second argument */
params = tailSEQExpr (params);

while (!emptySEQExpr (params)) {	/* more than 2 args, */
					/* more after e1, */
					/* e1 has to be translated */
	res = PTGSeqCom (res, TrExpr (e1, isvoid));
	retrievefirstSEQExpr(params, e1);
	params = tailSEQExpr (params);
}
/* e1 is last arg */
if (context == isval)
	return (PTGParen (PTGSeqCom (res, TrExpr (e1, isval))));
else /* context == isvoid */
	return (PTGParen (PTGSeqCom (res,
			PTGSeqCom (TrExpr (e1, isvoid), pppNoVal))));
}/* TrOrdSeq */