
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "backptg_gen.h"

#if defined(__STDC__) || defined (__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { _PrPTGNULL };

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGout (PTGNode r)
#else
PTGNode PTGOut (r)
PTGNode r;
#endif
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
#endif
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
#endif
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGNumb *_PPTGNumb;
struct _SPTGNumb{
  _PTGProc _print;
  int _t0;
};

typedef struct _SPTGAsIs *_PPTGAsIs;
struct _SPTGAsIs{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGC_Str *_PPTGC_Str;
struct _SPTGC_Str{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGP_Str *_PPTGP_Str;
struct _SPTGP_Str{
  _PTGProc _print;
  char *_t0;
};

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGDescName(_PPTG1 n)
#else
static void _PrPTGDescName(n)
_PPTG1 n;
#endif
{
  fputs ("_desc", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGVisitProcName(_PPTG2 n)
#else
static void _PrPTGVisitProcName(n)
_PPTG2 n;
#endif
{
  fputs ("_VS", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGInclGlobName(_PPTG1 n)
#else
static void _PrPTGInclGlobName(n)
_PPTG1 n;
#endif
{
  fputs ("_IG", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGInclLocName(_PPTG1 n)
#else
static void _PrPTGInclLocName(n)
_PPTG1 n;
#endif
{
  fputs ("_IL", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSymbStructName(_PPTG1 n)
#else
static void _PrPTGSymbStructName(n)
_PPTG1 n;
#endif
{
  fputs ("struct _TS", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSymbPtrTypeName(_PPTG1 n)
#else
static void _PrPTGSymbPtrTypeName(n)
_PPTG1 n;
#endif
{
  fputs ("_TSP", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGProdStructName(_PPTG1 n)
#else
static void _PrPTGProdStructName(n)
_PPTG1 n;
#endif
{
  fputs ("struct _TP", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGProdPtrTypeName(_PPTG1 n)
#else
static void _PrPTGProdPtrTypeName(n)
_PPTG1 n;
#endif
{
  fputs ("_TPP", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGMkProcName(_PPTG1 n)
#else
static void _PrPTGMkProcName(n)
_PPTG1 n;
#endif
{
  fputs ("Mk", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNullNodePtr(_PPTG0 n)
#else
static void _PrPTGNullNodePtr(n)
_PPTG0 n;
#endif
{
  fputs ("NULLNODEPTR ", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGMkParmName(_PPTG1 n)
#else
static void _PrPTGMkParmName(n)
_PPTG1 n;
#endif
{
  fputs ("_tr", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTermGetName(_PPTG2 n)
#else
static void _PrPTGTermGetName(n)
_PPTG2 n;
#endif
{
  fputs ("GET", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGLhsStackAttrName(_PPTG1 n)
#else
static void _PrPTGLhsStackAttrName(n)
_PPTG1 n;
#endif
{
  fputs ("_AS0", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGRhsStackAttrName(_PPTG2 n)
#else
static void _PrPTGRhsStackAttrName(n)
_PPTG2 n;
#endif
{
  fputs ("_AS", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGVarAttrName(_PPTG1 n)
#else
static void _PrPTGVarAttrName(n)
_PPTG1 n;
#endif
{
  fputs ("_AV", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTreeAttrName(_PPTG1 n)
#else
static void _PrPTGTreeAttrName(n)
_PPTG1 n;
#endif
{
  fputs ("_AT", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGRuleAttrName(_PPTG2 n)
#else
static void _PrPTGRuleAttrName(n)
_PPTG2 n;
#endif
{
  fputs ("_AR", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGStmt(_PPTG1 n)
#else
static void _PrPTGStmt(n)
_PPTG1 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGCall(_PPTG2 n)
#else
static void _PrPTGCall(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGAssign(_PPTG2 n)
#else
static void _PrPTGAssign(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGIfStmt(_PPTG3 n)
#else
static void _PrPTGIfStmt(n)
_PPTG3 n;
#endif
{
  fputs ("\nif (", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (") {\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n} else {\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("\n}", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGIfExpr(_PPTG3 n)
#else
static void _PrPTGIfExpr(n)
_PPTG3 n;
#endif
{
  fputs ("\n((", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n) ? (", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n) : (", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("))\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGParen(_PPTG1 n)
#else
static void _PrPTGParen(n)
_PPTG1 n;
#endif
{
  fputs ("\n(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPtrTo(_PPTG1 n)
#else
static void _PrPTGPtrTo(n)
_PPTG1 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("*", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSelectPtr(_PPTG2 n)
#else
static void _PrPTGSelectPtr(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("->", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGContent(_PPTG1 n)
#else
static void _PrPTGContent(n)
_PPTG1 n;
#endif
{
  fputs ("(* ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGAddr(_PPTG1 n)
#else
static void _PrPTGAddr(n)
_PPTG1 n;
#endif
{
  fputs ("(& ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNoVal(_PPTG0 n)
#else
static void _PrPTGNoVal(n)
_PPTG0 n;
#endif
{
  fputs ("(0)", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGToNoVal(_PPTG1 n)
#else
static void _PrPTGToNoVal(n)
_PPTG1 n;
#endif
{
  fputs ("(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (", 0)", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGDecl(_PPTG2 n)
#else
static void _PrPTGDecl(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSeq(_PPTG2 n)
#else
static void _PrPTGSeq(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGComElem(_PPTG1 n)
#else
static void _PrPTGComElem(n)
_PPTG1 n;
#endif
{
  fputs (",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGComSeq(_PPTG2 n)
#else
static void _PrPTGComSeq(n)
_PPTG2 n;
#endif
{
  fputs (",", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSeqCom(_PPTG2 n)
#else
static void _PrPTGSeqCom(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (",", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGEmpty(_PPTG0 n)
#else
static void _PrPTGEmpty(n)
_PPTG0 n;
#endif
{
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSep(_PPTG1 n)
#else
static void _PrPTGSep(n)
_PPTG1 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGFile(_PPTG1 n)
#else
static void _PrPTGFile(n)
_PPTG1 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNumb(_PPTGNumb n)
#else
static void _PrPTGNumb(n)
_PPTGNumb n;
#endif
{
  fprintf (f, "%d",n->_t0);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGAsIs(_PPTGAsIs n)
#else
static void _PrPTGAsIs(n)
_PPTGAsIs n;
#endif
{
  fprintf (f, "%s",n->_t0);
}

#if defined(__STDC__) || defined(__cplusplus)
extern void C_outstr(FILE *, char *);
#else
extern void C_outstr();
#endif

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGC_Str(_PPTGC_Str n)
#else
static void _PrPTGC_Str(n)
_PPTGC_Str n;
#endif
{
  C_outstr(f,n->_t0);
}

#if defined(__STDC__) || defined(__cplusplus)
extern void P_outstr(FILE *, char *);
#else
extern void P_outstr();
#endif

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGP_Str(_PPTGP_Str n)
#else
static void _PrPTGP_Str(n)
_PPTGP_Str n;
#endif
{
  P_outstr(f,n->_t0);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGVisitProcFileHead(_PPTG0 n)
#else
static void _PrPTGVisitProcFileHead(n)
_PPTG0 n;
#endif
{
  fputs ("\n#include \"HEAD.h\"\
\n#include \"err.h\"\
\n#include \"node.h\"\
\n#include \"visitprocs.h\"\
\n#include \"glattr.h\"\
\n#include \"attrpredef.h\"\n\
\n#ifndef _VisitVarDecl\
\n#define _VisitVarDecl()\
\n#endif\n\
\n#ifndef _VisitEntry\
\n#define _VisitEntry()\
\n#endif\n\
\n#ifndef _VisitExit\
\n#define _VisitExit()\
\n#endif\n\
\nvoid LIGA_ATTREVAL (n) NODEPTR n;\n\
\n{(*(n->_proc)) (n);}\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGVisitHeaderHead(_PPTG0 n)
#else
static void _PrPTGVisitHeaderHead(n)
_PPTG0 n;
#endif
{
  fputs ("\nextern void LIGA_ATTREVAL ();\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGVisitProcHeader(_PPTG1 n)
#else
static void _PrPTGVisitProcHeader(n)
_PPTG1 n;
#endif
{
  fputs ("\nextern void ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("( );\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGVisitProcHead(_PPTG4 n)
#else
static void _PrPTGVisitProcHead(n)
_PPTG4 n;
#endif
{
  fputs ("\nvoid ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("(_currn ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (")\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (" _currn;\n", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs ("{  _VisitVarDecl()\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGVisitEntry(_PPTG0 n)
#else
static void _PrPTGVisitEntry(n)
_PPTG0 n;
#endif
{
  fputs ("\n\n_VisitEntry();\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGVisitProcTail(_PPTG1 n)
#else
static void _PrPTGVisitProcTail(n)
_PPTG1 n;
#endif
{
  fputs ("_currn->_proc =", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";\n}\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGVisitProcEnd(_PPTG0 n)
#else
static void _PrPTGVisitProcEnd(n)
_PPTG0 n;
#endif
{
  fputs ("\n_VisitExit();\n}\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGDescVisit(_PPTG3 n)
#else
static void _PrPTGDescVisit(n)
_PPTG3 n;
#endif
{
  fputs ("(*(_currn->", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("->_proc)) (_currn->", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGInclPre(_PPTG4 n)
#else
static void _PrPTGInclPre(n)
_PPTG4 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("= &(_currn->", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (");\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGInclPost(_PPTG2 n)
#else
static void _PrPTGInclPost(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTypeFileHead(_PPTG0 n)
#else
static void _PrPTGTypeFileHead(n)
_PPTG0 n;
#endif
{
  fputs ("\n#include \"err.h\"\n\
\ntypedef int INT;\n\
\n#ifndef BOOL\
\ntypedef int BOOL;\
\n#endif\
\ntypedef int SYMB;\n\
\ntypedef void (* __VPROCPTR) ();\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPtrTypedef(_PPTG2 n)
#else
static void _PrPTGPtrTypedef(n)
_PPTG2 n;
#endif
{
  fputs ("\ntypedef ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("* ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (";\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGStructDecl(_PPTG2 n)
#else
static void _PrPTGStructDecl(n)
_PPTG2 n;
#endif
{
  fputs ("\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("{\n", f);
  fputs ("POSITION _pos; __VPROCPTR _proc;\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n};\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTermStructDecl(_PPTG2 n)
#else
static void _PrPTGTermStructDecl(n)
_PPTG2 n;
#endif
{
  fputs ("\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("{", f);
  fputs ("\nPOSITION _pos;\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n};\n", f);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGDescName(PTGNode _t0)
#else
PTGNode PTGDescName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGDescName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGVisitProcName(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGVisitProcName(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGVisitProcName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGInclGlobName(PTGNode _t0)
#else
PTGNode PTGInclGlobName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGInclGlobName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGInclLocName(PTGNode _t0)
#else
PTGNode PTGInclLocName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGInclLocName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSymbStructName(PTGNode _t0)
#else
PTGNode PTGSymbStructName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSymbStructName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSymbPtrTypeName(PTGNode _t0)
#else
PTGNode PTGSymbPtrTypeName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSymbPtrTypeName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGProdStructName(PTGNode _t0)
#else
PTGNode PTGProdStructName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGProdStructName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGProdPtrTypeName(PTGNode _t0)
#else
PTGNode PTGProdPtrTypeName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGProdPtrTypeName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGMkProcName(PTGNode _t0)
#else
PTGNode PTGMkProcName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGMkProcName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNullNodePtr()
#else
PTGNode PTGNullNodePtr()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNullNodePtr;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGMkParmName(PTGNode _t0)
#else
PTGNode PTGMkParmName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGMkParmName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTermGetName(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGTermGetName(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTermGetName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGLhsStackAttrName(PTGNode _t0)
#else
PTGNode PTGLhsStackAttrName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGLhsStackAttrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGRhsStackAttrName(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGRhsStackAttrName(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGRhsStackAttrName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGVarAttrName(PTGNode _t0)
#else
PTGNode PTGVarAttrName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGVarAttrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTreeAttrName(PTGNode _t0)
#else
PTGNode PTGTreeAttrName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTreeAttrName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGRuleAttrName(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGRuleAttrName(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGRuleAttrName;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGStmt(PTGNode _t0)
#else
PTGNode PTGStmt(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGStmt;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGCall(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGCall(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGCall;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGAssign(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGAssign(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGAssign;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGIfStmt(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGIfStmt(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGIfStmt;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGIfExpr(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGIfExpr(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGIfExpr;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGParen(PTGNode _t0)
#else
PTGNode PTGParen(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGParen;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPtrTo(PTGNode _t0)
#else
PTGNode PTGPtrTo(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPtrTo;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSelectPtr(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGSelectPtr(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSelectPtr;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGContent(PTGNode _t0)
#else
PTGNode PTGContent(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGContent;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGAddr(PTGNode _t0)
#else
PTGNode PTGAddr(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGAddr;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNoVal()
#else
PTGNode PTGNoVal()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNoVal;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGToNoVal(PTGNode _t0)
#else
PTGNode PTGToNoVal(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGToNoVal;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGDecl(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGDecl(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSeq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGComElem(PTGNode _t0)
#else
PTGNode PTGComElem(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGComElem;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGComSeq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGComSeq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGComSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSeqCom(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGSeqCom(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSeqCom;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGEmpty()
#else
PTGNode PTGEmpty()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGEmpty;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSep(PTGNode _t0)
#else
PTGNode PTGSep(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSep;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGFile(PTGNode _t0)
#else
PTGNode PTGFile(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGFile;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNumb(int _t0)
#else
PTGNode PTGNumb(_t0)
  int _t0;
#endif
{
  _PPTGNumb n;

  if ((n = (_PPTGNumb) malloc (sizeof (struct _SPTGNumb)))  ==  (_PPTGNumb)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNumb;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGAsIs(char *_t0)
#else
PTGNode PTGAsIs(_t0)
  char *_t0;
#endif
{
  _PPTGAsIs n;

  if ((n = (_PPTGAsIs) malloc (sizeof (struct _SPTGAsIs)))  ==  (_PPTGAsIs)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGAsIs;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGC_Str(char *_t0)
#else
PTGNode PTGC_Str(_t0)
  char *_t0;
#endif
{
  _PPTGC_Str n;

  if ((n = (_PPTGC_Str) malloc (sizeof (struct _SPTGC_Str)))  ==  (_PPTGC_Str)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGC_Str;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGP_Str(char *_t0)
#else
PTGNode PTGP_Str(_t0)
  char *_t0;
#endif
{
  _PPTGP_Str n;

  if ((n = (_PPTGP_Str) malloc (sizeof (struct _SPTGP_Str)))  ==  (_PPTGP_Str)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGP_Str;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGVisitProcFileHead()
#else
PTGNode PTGVisitProcFileHead()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGVisitProcFileHead;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGVisitHeaderHead()
#else
PTGNode PTGVisitHeaderHead()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGVisitHeaderHead;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGVisitProcHeader(PTGNode _t0)
#else
PTGNode PTGVisitProcHeader(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGVisitProcHeader;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGVisitProcHead(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3)
#else
PTGNode PTGVisitProcHead(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
#endif
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGVisitProcHead;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGVisitEntry()
#else
PTGNode PTGVisitEntry()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGVisitEntry;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGVisitProcTail(PTGNode _t0)
#else
PTGNode PTGVisitProcTail(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGVisitProcTail;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGVisitProcEnd()
#else
PTGNode PTGVisitProcEnd()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGVisitProcEnd;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGDescVisit(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGDescVisit(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGDescVisit;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGInclPre(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3)
#else
PTGNode PTGInclPre(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
#endif
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGInclPre;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGInclPost(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGInclPost(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGInclPost;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTypeFileHead()
#else
PTGNode PTGTypeFileHead()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTypeFileHead;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPtrTypedef(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGPtrTypedef(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPtrTypedef;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGStructDecl(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGStructDecl(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGStructDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTermStructDecl(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGTermStructDecl(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTermStructDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

