# $Id: Makefile.cpp,v 1.19 1993/01/05 10:54:58 cogito Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# hack for Sun auto-mounter
PWD	= pwd | sed 's,^/tmp_mnt,,'

# Default master cache location
DESTDIR	= `expr \`$(PWD)\`'/' : '\(.*[^/]\)/[^/]*/[^/]*/'`

COFLAGS = -q

DISTRIB = /tmp

#if !defined(XINC) || !defined(XAWINC)
SUBDIR 	= Cmd Frames Info \
	  idl ligascel option frontend expand replincl order nogorto \
          optim backend show
DISTRIBDIR	= $(SUBDIR) gorto
#else
SUBDIR 	= Cmd Frames Info \
	  idl ligascel option frontend expand replincl order gorto \
          optim backend show
DISTRIBDIR	= $(SUBDIR) nogorto
#endif

INSTDIR	= Cmd Frames Info
SKEL    = 
AUX	= 
EXE	= ligaBack.exe ligaExp.exe ligaFe.exe ligaGorto \
	ligaOptim.exe ligaOption.exe ligaOrd.exe ligaRepl.exe ligaShow.exe

TIDY    = core a.out  *% lintmsg *.p *.o ERRS
CLEAN   = $(TIDY) *.exe
CLOBBER = $(CLEAN) Makefile

all:	$(SKEL) $(AUX)
	@for dir in $(SUBDIR) ; do echo; echo "Making Tool/liga/$$dir"; \
		(cd $$dir; make CC="$(CC)" all); \
		done

install:
	@if test ! -d $(DESTDIR)/Tool/liga; \
		then umask 002; mkdir $(DESTDIR)/Tool/liga; \
		else :; \
		fi
	@for f in $(EXE) ; do \
		echo install -c -m 755 $$f $(DESTDIR)/Tool/liga; \
		rm -f $(DESTDIR)/Tool/liga/$$f; \
		cp $$f $(DESTDIR)/Tool/liga; \
		chmod 755 $(DESTDIR)/Tool/liga/$$f; \
	done
	-@for dir in $(INSTDIR); do \
		if test ! -d $(DESTDIR)/Tool/liga/$$dir; \
			then umask 002; mkdir $(DESTDIR)/Tool/liga/$$dir; \
			else :; \
			fi; \
		done
	@for dir in $(INSTDIR); do echo; echo "Install Tool/liga/$$dir"; \
		(cd $$dir; make DESTDIR=$(DESTDIR) install); \
		done
	@if test ! -d $(DESTDIR)/bin; \
		then umask 002; mkdir $(DESTDIR)/bin; \
		else :; \
		fi

executable:
	@for i in $(INSTDIR); do echo; echo Making Tool/liga/$$i executable; \
		cd $$i; make executable; cd ..; done
	rm -rf $(TIDY) $(AUX) idl option frontend expand order optim \
		backend replincl gorto nogorto ligascel show README \
		Makefile.cpp Makefile

SourceDistr: $(SKEL) $(AUX)
	@for i in $(SUBDIR); do echo; echo Source Tool/liga/$$i; mkdir $$i; \
		cd $$i; ln -s $(ELI)/$$i/RCS; co $(COFLAGS) Makefile.cpp; \
                make -u -f Makefile.cpp ELI=$(ELI)/$$i COFLAGS=$(COFLAGS) \
			SourceDistr; \
                rm RCS; cd ..; done

distrib:	
	-mkdir $(DISTRIB)
	cp README Makefile.cpp $(SKEL) $(DISTRIB)
	cd $(DISTRIB); chmod 0644 README Makefile.cpp $(SKEL)
	@for dir in $(DISTRIBDIR) ; do \
	  ( echo; echo "Distributing $$dir"; echo; cd $$dir; \
		 make distrib DISTRIB=$(DISTRIB)); \
	done

#  generates sources from specifications:
gen:
	(cd frontend; make gen );
	(cd option; make gen );

tidy:
	rm -rf $(TIDY)
	-@for i in $(SUBDIR); do echo; echo Tidying Tool/liga/$$i; cd $$i; \
		make tidy; cd ..; done

clean:
	rm -f $(CLEAN)
	-@for i in $(SUBDIR); do echo; echo Cleaning Tool/liga/$$i; cd $$i; \
		make clean; cd ..; done

clobber:
	rm -rf $(CLOBBER)
	-@for i in $(SUBDIR); do echo; echo Clobbering Tool/liga/$$i; cd $$i; \
		make clobber; cd ..; done

makefiles:	
	-@for i in $(SUBDIR); do \
		echo prepare Makefile in liga/$$i; \
		(cd $$i; \
		co $(COFLAGS) Makefile.cpp; \
		Configure; \
		chmod ug+w Makefile); \
	done
	(cd idl/idllib; \
	echo prepare Makefile in liga/idl/idllib; \
	co $(COFLAGS) Makefile.cpp; \
	Configure; \
	chmod ug+w Makefile)

checkout:
	-co $(COFLAGS) $(SKEL) $(AUX)
	-@for i in $(SUBDIR); do echo; echo RCS checkout Tool/liga/$$i; \
		(cd $$i; make COFLAGS=$(COFLAGS) checkout); done

rcsclean:
	rm -f $(CLEAN) Makefile
	-rcsclean $(COFLAGS) $(SKEL) $(AUX) Makefile.cpp
	-@for i in $(SUBDIR); do echo; echo RCScleaning Tool/liga/$$i; \
		(cd $$i; make COFLAGS=$(COFLAGS) rcsclean); done

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp README $(SKEL) $(AUX) \
		$(CMD)
	-rcs -bOriginal.1 -q Makefile.cpp README $(SKEL) $(AUX)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q README $(SKEL) $(AUX)

.PRECIOUS:	$(SKEL) $(AUX)






