# $Id: Makefile.cpp,v 1.20 1992/11/20 14:02:01 cogito Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# hack for Sun auto-mounter
PWD	= pwd | sed 's,^/tmp_mnt,,'

# Default master cache location
DESTDIR	= `expr \`$(PWD)\`'/' : '\(.*[^/]\)/[^/]*/[^/]*/'`

DISTRIB = /tmp
COFLAGS = -q

SKEL    = frontend.err expand.err order.err optim.err \
	  backend.err option.err psfig.tex 

PS	= struktur.ps verfolgung.ps hierarchy.ps rule.ps symbol.ps \
	  symbol-rule.ps hide.ps visitseq.ps lidow.ps message.ps \
	  lidfig22.ps sagfig31.ps sagfig33.ps sagfig35a.ps sagfig35b.ps
AUX	= lidoshort.tnf lcl.tnf lido.tnf gorto.tnf show.tnf
RCS	= $(SKEL) $(AUX) $(PS)
TIDY    = core a.out  *% lintmsg *.p *.o ERRS
CLEAN   = $(TIDY) *.exe
CLOBBER = $(CLEAN) Makefile

all:	$(SKEL) $(AUX) $(PS)
	@echo

install: $(SKEL) $(PS)
	@for f in $(SKEL) $(PS); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/liga/Info; \
		rm -f $(DESTDIR)/Tool/liga/Info/$$f; \
		cp $$f $(DESTDIR)/Tool/liga/Info; \
		chmod 644 $(DESTDIR)/Tool/liga/Info/$$f; \
	done

executable:
	rm -rf $(TIDY) $(AUX) Makefile.cpp Makefile

SourceDistr: $(SKEL) $(AUX) $(PS)

distrib:	$(SKEL) $(AUX) $(PS)
	- rm -rf $(DISTRIB)/Info
	mkdir $(DISTRIB)/Info
	cp $(SKEL) $(AUX) $(PS) Makefile.cpp Makefile $(DISTRIB)/Info
	cd $(DISTRIB)/Info; chmod 0644 $(SKEL) $(AUX) $(PS) Makefile.cpp Makefile

checkout:
	co $(COFLAGS) $(RCS)

# Cleaning Targets
tidy:
	rm -rf $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	rm -f $(CLEAN) Makefile
	-rcsclean $(COFLAGS) $(SKEL) $(AUX) $(PS) Makefile.cpp

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp README $(SKEL) $(AUX) $(PS)
	-rcs -bOriginal.1 -q Makefile.cpp README $(SKEL) $(AUX) $(PS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q README $(SKEL) $(AUX) $(PS)

.PRECIOUS:	$(SKEL) $(AUX) $(PS)



