#!/bin/sh
# $Id: gorto.cmd,v 1.2 1992/03/10 16:24:21 cogito Exp $
#gorto 'Graphical dependence analysis possibly with output of arrange options' :
#        BROWSER
#                : (:level_4_specs:ctl.cmpd)
#                : (:level_4_specs:ctl.cmpd :labels)
#                : (:level_4_specs:lido.cmpd:cpp)
#                : (:level_4_specs:exp_idl)
#                : (:level_4_specs:ord_option)

umask 0
cd (|<RUNDIR|)

if ( test -n "$DISPLAY" )
then
	xrdb -merge (|$/Tool/liga/Frames/Gorto.ad|)
	(|$/Tool/liga/ligaGorto|) \
		-input (|<(:level_4_specs:exp_idl)|) \
		-output ord_idl \
		-lido (|<(:level_4_specs:lido.cmpd :cpp)|) \
		-ctrl (|<(:level_4_specs:ord_option)|) \
		-lcl options > /dev/null 2> ERRORS
else
	echo "FATAL: GORTO works only under X11!"
	exit 0
fi

if test -s ERRORS
then
        cat ERRORS
        echo; echo "Because of the above ERRORS"
fi

if test ! -s options
then
	echo "GORTO exits without any results!"
        exit 0
fi

if test -s (|<CURDIR|)/GORTO.ctl
then
	mv (|<CURDIR|)/GORTO.ctl (|<CURDIR|)/GORTO.bak
	echo "The non empty file \"GORTO.ctl\" in your current working directory"
	echo "has been overwritten with the results of GORTO and will be used"
	echo "now for further derivations, if it is part of your specifications."
	echo "The previous content of \"GORTO.ctl\" has been saved in \"GORTO.bak\""
else
	echo "In your current working directory you will find a file"
	echo "\"GORTO.ctl\" containing LIGA options for further derivations."
	echo " You should add this file to your specifications!"
fi

mv options (|<CURDIR|)/GORTO.ctl
echo (|<CURDIR|)/GORTO.ctl > (|>gorto|)

exit 0
