# $Id: Makefile.cpp,v 1.26 1991/07/17 17:22:15 waite Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

DESTDIR	= /tmp

HDRS	= dj.h err.h
SRCS	= gla_be.c bvectors.c gencode.c part.c djset.c misc.c print.c
OBJS    = gla_be.o bvectors.o gencode.o part.o djset.o misc.o print.o

RCS	= $(SRCS) $(HDRS) 
TIDY	= $(OBJS) 
CLEAN	= $(TIDY) gla_be ../gla_be *~
CLOBBER	= $(CLEAN) Makefile

all:	gla_be

gla_be:	$(OBJS) $(MISC)
	$(CC) -o $@ $(CFLAGS) $(OBJS)
	-rm -f ../gla_be
	-ln gla_be ..

$(OBJS): $(HDRS)

install:
	rm -f $(DESTDIR)/Tool/gla/gla_be
	cp gla_be $(DESTDIR)/Tool/gla/gla_be
	chmod 755 $(DESTDIR)/Tool/gla/gla_be

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(SRCS) $(HDRS)

SourceDistr:	$(RCS)

lint: $(SRCS) $(HDRS)
	lint -a -b -c -h -I. -I../.. $(SRCS) y.tab.c 2>&1 | grep -v RCS

tidy:
	rm -f $(TIDY)

clean:
	rm -f $(CLEAN)

clobber:
	rm -f $(CLOBBER)

rcsclean:
	-rcsclean -q $(RCS) Makefile.cpp
	rm -f $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(RCS)

