
#include "HEAD.h"

#include "node.h"

#include "visitprocs.h"

#include "gsdescr.h"

extern void free();

extern char *malloc();

#include "obstack.h"

static struct obstack TreeSpace;

#define obstack_chunk_alloc malloc

#define obstack_chunk_free free

char* TreeNodeAlloc(size) int size;

{return (obstack_alloc(&TreeSpace, size));}

void InitTree() { obstack_init(&TreeSpace); }

NODEPTR MkxIdent(_coordref,_tr1)
POSITION *_coordref;
SYMB _tr1;
{
_TSPxIdent n;
n = (_TSPxIdent) TreeNodeAlloc (sizeof (struct _TSxIdent));
n->_pos = *_coordref;

n->_ATid=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkxLit(_coordref,_tr1)
POSITION *_coordref;
SYMB _tr1;
{
_TSPxLit n;
n = (_TSPxLit) TreeNodeAlloc (sizeof (struct _TSxLit));
n->_pos = *_coordref;

n->_ATid=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkxNum(_coordref,_tr1)
POSITION *_coordref;
INT _tr1;
{
_TSPxNum n;
n = (_TSPxNum) TreeNodeAlloc (sizeof (struct _TSxNum));
n->_pos = *_coordref;

n->_ATval=_tr1;
return ((NODEPTR) n);
}

NODEPTR MkxCLit(_coordref)
POSITION *_coordref;
{
_TSPxCLit n;
n = (_TSPxCLit) TreeNodeAlloc (sizeof (struct _TSxCLit));
n->_pos = *_coordref;

return ((NODEPTR) n);
}

NODEPTR MkxChar(_coordref)
POSITION *_coordref;
{
_TSPxChar n;
n = (_TSPxChar) TreeNodeAlloc (sizeof (struct _TSxChar));
n->_pos = *_coordref;

return ((NODEPTR) n);
}

NODEPTR MkxFloat(_coordref)
POSITION *_coordref;
{
_TSPxFloat n;
n = (_TSPxFloat) TreeNodeAlloc (sizeof (struct _TSxFloat));
n->_pos = *_coordref;

return ((NODEPTR) n);
}

NODEPTR MkStartRule(_coordref,_tr1,_tr2,_tr3,_tr4,_tr5)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
NODEPTR _tr4;
NODEPTR _tr5;
{_TPPStartRule n;
n = (_TPPStartRule) TreeNodeAlloc (sizeof (struct _TPStartRule));
n->_proc =_VS1StartRule;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPCODE_PART)_tr1;
n->_desc2= (_TSPSTOP_PART)_tr2;
n->_desc3= (_TSPERR_PART)_tr3;
n->_desc4= (_TSPMETA_PART)_tr4;
n->_desc5= (_TSPGRAMMAR_PART)_tr5;
return ( (NODEPTR) n);
}

NODEPTR MkCode_1(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPCode_1 n;
n = (_TPPCode_1) TreeNodeAlloc (sizeof (struct _TPCode_1));
n->_proc =_VS1Code_1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPCODE_LIST)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkCode_2(_coordref)
POSITION *_coordref;
{_TPPCode_2 n;
n = (_TPPCode_2) TreeNodeAlloc (sizeof (struct _TPCode_2));
n->_proc =_VS1Code_2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkCode_3(_coordref)
POSITION *_coordref;
{_TPPCode_3 n;
n = (_TPPCode_3) TreeNodeAlloc (sizeof (struct _TPCode_3));
n->_proc =_VS1Code_3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkCode_4(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPCode_4 n;
n = (_TPPCode_4) TreeNodeAlloc (sizeof (struct _TPCode_4));
n->_proc =_VS1Code_4;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPCODE_LIST)_tr1;
n->_desc2= (_TSPsymbol)_tr2;
n->_desc3= (_TSPxNum)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkStop_1(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPStop_1 n;
n = (_TPPStop_1) TreeNodeAlloc (sizeof (struct _TPStop_1));
n->_proc =_VS1Stop_1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPsymbol)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkStop_2(_coordref)
POSITION *_coordref;
{_TPPStop_2 n;
n = (_TPPStop_2) TreeNodeAlloc (sizeof (struct _TPStop_2));
n->_proc =_VS1Stop_2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkStop_3(_coordref)
POSITION *_coordref;
{_TPPStop_3 n;
n = (_TPPStop_3) TreeNodeAlloc (sizeof (struct _TPStop_3));
n->_proc =_VS1Stop_3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkError_1(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPError_1 n;
n = (_TPPError_1) TreeNodeAlloc (sizeof (struct _TPError_1));
n->_proc =_VS1Error_1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPSEPA_PART)_tr1;
n->_desc2= (_TSPBRACKET_PART)_tr2;
n->_desc3= (_TSPSKIP_PART)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkError_2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPError_2 n;
n = (_TPPError_2) TreeNodeAlloc (sizeof (struct _TPError_2));
n->_proc =_VS1Error_2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPSEPA_LIST)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkError_3(_coordref)
POSITION *_coordref;
{_TPPError_3 n;
n = (_TPPError_3) TreeNodeAlloc (sizeof (struct _TPError_3));
n->_proc =_VS1Error_3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkError_4(_coordref)
POSITION *_coordref;
{_TPPError_4 n;
n = (_TPPError_4) TreeNodeAlloc (sizeof (struct _TPError_4));
n->_proc =_VS1Error_4;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkError_5(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPError_5 n;
n = (_TPPError_5) TreeNodeAlloc (sizeof (struct _TPError_5));
n->_proc =_VS1Error_5;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPSEPA_LIST)_tr1;
n->_desc2= (_TSPsymbol)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkError_6(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPError_6 n;
n = (_TPPError_6) TreeNodeAlloc (sizeof (struct _TPError_6));
n->_proc =_VS1Error_6;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPBRACKET_LIST)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkError_7(_coordref)
POSITION *_coordref;
{_TPPError_7 n;
n = (_TPPError_7) TreeNodeAlloc (sizeof (struct _TPError_7));
n->_proc =_VS1Error_7;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkError_8(_coordref)
POSITION *_coordref;
{_TPPError_8 n;
n = (_TPPError_8) TreeNodeAlloc (sizeof (struct _TPError_8));
n->_proc =_VS1Error_8;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkError_9(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPError_9 n;
n = (_TPPError_9) TreeNodeAlloc (sizeof (struct _TPError_9));
n->_proc =_VS1Error_9;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPBRACKET_LIST)_tr1;
n->_desc2= (_TSPsymbol)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkError_10(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPError_10 n;
n = (_TPPError_10) TreeNodeAlloc (sizeof (struct _TPError_10));
n->_proc =_VS1Error_10;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPSKIP_LIST)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkError_11(_coordref)
POSITION *_coordref;
{_TPPError_11 n;
n = (_TPPError_11) TreeNodeAlloc (sizeof (struct _TPError_11));
n->_proc =_VS1Error_11;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkError_12(_coordref)
POSITION *_coordref;
{_TPPError_12 n;
n = (_TPPError_12) TreeNodeAlloc (sizeof (struct _TPError_12));
n->_proc =_VS1Error_12;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkError_13(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPError_13 n;
n = (_TPPError_13) TreeNodeAlloc (sizeof (struct _TPError_13));
n->_proc =_VS1Error_13;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPSKIP_LIST)_tr1;
n->_desc2= (_TSPsymbol)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkMeta_1(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPMeta_1 n;
n = (_TPPMeta_1) TreeNodeAlloc (sizeof (struct _TPMeta_1));
n->_proc =_VS1Meta_1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPMETA_LIST)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkMeta_2(_coordref)
POSITION *_coordref;
{_TPPMeta_2 n;
n = (_TPPMeta_2) TreeNodeAlloc (sizeof (struct _TPMeta_2));
n->_proc =_VS1Meta_2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkMeta_3(_coordref)
POSITION *_coordref;
{_TPPMeta_3 n;
n = (_TPPMeta_3) TreeNodeAlloc (sizeof (struct _TPMeta_3));
n->_proc =_VS1Meta_3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkMeta_4(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPMeta_4 n;
n = (_TPPMeta_4) TreeNodeAlloc (sizeof (struct _TPMeta_4));
n->_proc =_VS1Meta_4;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPMETA_LIST)_tr1;
n->_desc2= (_TSPNAME)_tr2;
n->_desc3= (_TSPTERMINAL_LIST)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkMeta_5(_coordref)
POSITION *_coordref;
{_TPPMeta_5 n;
n = (_TPPMeta_5) TreeNodeAlloc (sizeof (struct _TPMeta_5));
n->_proc =_VS1Meta_5;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkMeta_6(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPMeta_6 n;
n = (_TPPMeta_6) TreeNodeAlloc (sizeof (struct _TPMeta_6));
n->_proc =_VS1Meta_6;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPTERMINAL_LIST)_tr1;
n->_desc2= (_TSPMETA_TERMINAL)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkMeta_7(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPMeta_7 n;
n = (_TPPMeta_7) TreeNodeAlloc (sizeof (struct _TPMeta_7));
n->_proc =_VS1Meta_7;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPsymbol)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkProd_1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPProd_1 n;
n = (_TPPProd_1) TreeNodeAlloc (sizeof (struct _TPProd_1));
n->_proc =_VS1Prod_1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPNAME)_tr1;
n->_desc2= (_TSPPROD_LIST)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkProd_2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPProd_2 n;
n = (_TPPProd_2) TreeNodeAlloc (sizeof (struct _TPProd_2));
n->_proc =_VS1Prod_2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPPROD_LIST)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkProd_3(_coordref)
POSITION *_coordref;
{_TPPProd_3 n;
n = (_TPPProd_3) TreeNodeAlloc (sizeof (struct _TPProd_3));
n->_proc =_VS1Prod_3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkProd_4(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPProd_4 n;
n = (_TPPProd_4) TreeNodeAlloc (sizeof (struct _TPProd_4));
n->_proc =_VS1Prod_4;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPPROD_LIST)_tr1;
n->_desc2= (_TSPPROD)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkProd_5(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPProd_5 n;
n = (_TPPProd_5) TreeNodeAlloc (sizeof (struct _TPProd_5));
n->_proc =_VS1Prod_5;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPsymbol)_tr1;
n->_desc2= (_TSPCOLON)_tr2;
n->_desc3= (_TSPELEM)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkProd_6(_coordref,_tr1,_tr2,_tr3,_tr4)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
NODEPTR _tr4;
{_TPPProd_6 n;
n = (_TPPProd_6) TreeNodeAlloc (sizeof (struct _TPProd_6));
n->_proc =_VS1Prod_6;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPNAME)_tr1;
n->_desc2= (_TSPsymbol)_tr2;
n->_desc3= (_TSPCOLON)_tr3;
n->_desc4= (_TSPELEM)_tr4;
return ( (NODEPTR) n);
}

NODEPTR MkProd_7(_coordref)
POSITION *_coordref;
{_TPPProd_7 n;
n = (_TPPProd_7) TreeNodeAlloc (sizeof (struct _TPProd_7));
n->_proc =_VS1Prod_7;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkProd_8(_coordref)
POSITION *_coordref;
{_TPPProd_8 n;
n = (_TPPProd_8) TreeNodeAlloc (sizeof (struct _TPProd_8));
n->_proc =_VS1Prod_8;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPRhs_1 n;
n = (_TPPRhs_1) TreeNodeAlloc (sizeof (struct _TPRhs_1));
n->_proc =_VS1Rhs_1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPELEM)_tr1;
n->_desc2= (_TSPsymbol)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_2(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPRhs_2 n;
n = (_TPPRhs_2) TreeNodeAlloc (sizeof (struct _TPRhs_2));
n->_proc =_VS1Rhs_2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPELEM)_tr1;
n->_desc2= (_TSPELEM)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_3(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPRhs_3 n;
n = (_TPPRhs_3) TreeNodeAlloc (sizeof (struct _TPRhs_3));
n->_proc =_VS1Rhs_3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPELEM)_tr1;
n->_desc2= (_TSPELEM)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_4(_coordref)
POSITION *_coordref;
{_TPPRhs_4 n;
n = (_TPPRhs_4) TreeNodeAlloc (sizeof (struct _TPRhs_4));
n->_proc =_VS1Rhs_4;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_8(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPRhs_8 n;
n = (_TPPRhs_8) TreeNodeAlloc (sizeof (struct _TPRhs_8));
n->_proc =_VS1Rhs_8;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPrhselt)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_9(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPRhs_9 n;
n = (_TPPRhs_9) TreeNodeAlloc (sizeof (struct _TPRhs_9));
n->_proc =_VS1Rhs_9;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPCONNECTION)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_5(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPRhs_5 n;
n = (_TPPRhs_5) TreeNodeAlloc (sizeof (struct _TPRhs_5));
n->_proc =_VS1Rhs_5;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPELEM)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_6(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPRhs_6 n;
n = (_TPPRhs_6) TreeNodeAlloc (sizeof (struct _TPRhs_6));
n->_proc =_VS1Rhs_6;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPELEM)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_7(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPRhs_7 n;
n = (_TPPRhs_7) TreeNodeAlloc (sizeof (struct _TPRhs_7));
n->_proc =_VS1Rhs_7;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPELEM)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_10(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPRhs_10 n;
n = (_TPPRhs_10) TreeNodeAlloc (sizeof (struct _TPRhs_10));
n->_proc =_VS1Rhs_10;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPsymbol)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkRhs_11(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPRhs_11 n;
n = (_TPPRhs_11) TreeNodeAlloc (sizeof (struct _TPRhs_11));
n->_proc =_VS1Rhs_11;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPsymbol)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkSymbol_1(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSymbol_1 n;
n = (_TPPSymbol_1) TreeNodeAlloc (sizeof (struct _TPSymbol_1));
n->_proc =_VS1Symbol_1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkSymbol_2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSymbol_2 n;
n = (_TPPSymbol_2) TreeNodeAlloc (sizeof (struct _TPSymbol_2));
n->_proc =_VS1Symbol_2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkSymbol_3(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSymbol_3 n;
n = (_TPPSymbol_3) TreeNodeAlloc (sizeof (struct _TPSymbol_3));
n->_proc =_VS1Symbol_3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxLit)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkSymbol_4(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSymbol_4 n;
n = (_TPPSymbol_4) TreeNodeAlloc (sizeof (struct _TPSymbol_4));
n->_proc =_VS1Symbol_4;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxLit)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkSymbol_5(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPSymbol_5 n;
n = (_TPPSymbol_5) TreeNodeAlloc (sizeof (struct _TPSymbol_5));
n->_proc =_VS1Symbol_5;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPsymbol)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpRoot(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpRoot n;
n = (_TPPpRoot) TreeNodeAlloc (sizeof (struct _TPpRoot));
n->_proc =_VS1pRoot;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPAbstract)_tr1;
n->_desc2= (_TSPSTART)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpAbstract(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpAbstract n;
n = (_TPPpAbstract) TreeNodeAlloc (sizeof (struct _TPpAbstract));
n->_proc =_VS1pAbstract;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAG)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpNull(_coordref)
POSITION *_coordref;
{_TPPpNull n;
n = (_TPPpNull) TreeNodeAlloc (sizeof (struct _TPpNull));
n->_proc =_VS1pNull;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpRule(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPpRule n;
n = (_TPPpRule) TreeNodeAlloc (sizeof (struct _TPpRule));
n->_proc =_VS1pRule;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRuleDefId)_tr1;
n->_desc2= (_TSPxProd)_tr2;
n->_desc3= (_TSPxCompPart)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkpProd(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpProd n;
n = (_TPPpProd) TreeNodeAlloc (sizeof (struct _TPpProd));
n->_proc =_VS1pProd;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxProdId)_tr1;
n->_desc2= (_TSPxSyntUnits)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpChainProd(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpChainProd n;
n = (_TPPpChainProd) TreeNodeAlloc (sizeof (struct _TPpChainProd));
n->_proc =_VS1pChainProd;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSyntId)_tr1;
n->_desc2= (_TSPxSyntId)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpListProd(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpListProd n;
n = (_TPPpListProd) TreeNodeAlloc (sizeof (struct _TPpListProd));
n->_proc =_VS1pListProd;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSyntId)_tr1;
n->_desc2= (_TSPxList)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpTopList(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpTopList n;
n = (_TPPpTopList) TreeNodeAlloc (sizeof (struct _TPpTopList));
n->_proc =_VS1pTopList;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAlts)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpnoAlt(_coordref)
POSITION *_coordref;
{_TPPpnoAlt n;
n = (_TPPpnoAlt) TreeNodeAlloc (sizeof (struct _TPpnoAlt));
n->_proc =_VS1pnoAlt;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpIdAlt(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpIdAlt n;
n = (_TPPpIdAlt) TreeNodeAlloc (sizeof (struct _TPpIdAlt));
n->_proc =_VS1pIdAlt;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSyntId)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpProdId(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpProdId n;
n = (_TPPpProdId) TreeNodeAlloc (sizeof (struct _TPpProdId));
n->_proc =_VS1pProdId;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSyntId)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpIdUnit(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpIdUnit n;
n = (_TPPpIdUnit) TreeNodeAlloc (sizeof (struct _TPpIdUnit));
n->_proc =_VS1pIdUnit;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSyntId)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpLitUnit(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpLitUnit n;
n = (_TPPpLitUnit) TreeNodeAlloc (sizeof (struct _TPpLitUnit));
n->_proc =_VS1pLitUnit;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxLit)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpSyntId(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpSyntId n;
n = (_TPPpSyntId) TreeNodeAlloc (sizeof (struct _TPpSyntId));
n->_proc =_VS1pSyntId;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpAG(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpAG n;
n = (_TPPpAG) TreeNodeAlloc (sizeof (struct _TPpAG));
n->_proc =_VS1pAG;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxDefs)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp1(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp1 n;
n = (_TPPp1) TreeNodeAlloc (sizeof (struct _TPp1));
n->_proc =_VS1p1;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxDefs)_tr1;
n->_desc2= (_TSPxDef)_tr2;
return ( (NODEPTR) n);
}

NODEPTR Mkp2(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp2 n;
n = (_TPPp2) TreeNodeAlloc (sizeof (struct _TPp2));
n->_proc =_VS1p2;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxDef)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp3(_coordref)
POSITION *_coordref;
{_TPPp3 n;
n = (_TPPp3) TreeNodeAlloc (sizeof (struct _TPp3));
n->_proc =_VS1p3;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp4(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp4 n;
n = (_TPPp4) TreeNodeAlloc (sizeof (struct _TPp4));
n->_proc =_VS1p4;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTypeDef)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp5(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp5 n;
n = (_TPPp5) TreeNodeAlloc (sizeof (struct _TPp5));
n->_proc =_VS1p5;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymDef)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp6(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp6 n;
n = (_TPPp6) TreeNodeAlloc (sizeof (struct _TPp6));
n->_proc =_VS1p6;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxChainDef)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp7(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp7 n;
n = (_TPPp7) TreeNodeAlloc (sizeof (struct _TPp7));
n->_proc =_VS1p7;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRuleDef)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp8(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp8 n;
n = (_TPPp8) TreeNodeAlloc (sizeof (struct _TPp8));
n->_proc =_VS1p8;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymComp)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpAttrNameDef(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPpAttrNameDef n;
n = (_TPPpAttrNameDef) TreeNodeAlloc (sizeof (struct _TPpAttrNameDef));
n->_proc =_VS1pAttrNameDef;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrNames)_tr1;
n->_desc2= (_TSPxTypeId)_tr2;
n->_desc3= (_TSPxClass)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkpChainNameDef(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpChainNameDef n;
n = (_TPPpChainNameDef) TreeNodeAlloc (sizeof (struct _TPpChainNameDef));
n->_proc =_VS1pChainNameDef;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrNames)_tr1;
n->_desc2= (_TSPxTypeId)_tr2;
return ( (NODEPTR) n);
}

NODEPTR Mkp9(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp9 n;
n = (_TPPp9) TreeNodeAlloc (sizeof (struct _TPp9));
n->_proc =_VS1p9;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrNames)_tr1;
n->_desc2= (_TSPxAttrName)_tr2;
return ( (NODEPTR) n);
}

NODEPTR Mkp10(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp10 n;
n = (_TPPp10) TreeNodeAlloc (sizeof (struct _TPp10));
n->_proc =_VS1p10;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrName)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpAttrName(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpAttrName n;
n = (_TPPpAttrName) TreeNodeAlloc (sizeof (struct _TPpAttrName));
n->_proc =_VS1pAttrName;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpClass(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpClass n;
n = (_TPPpClass) TreeNodeAlloc (sizeof (struct _TPpClass));
n->_proc =_VS1pClass;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpNoClass(_coordref)
POSITION *_coordref;
{_TPPpNoClass n;
n = (_TPPpNoClass) TreeNodeAlloc (sizeof (struct _TPpNoClass));
n->_proc =_VS1pNoClass;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpSymDef(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPpSymDef n;
n = (_TPPpSymDef) TreeNodeAlloc (sizeof (struct _TPpSymDef));
n->_proc =_VS1pSymDef;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymClass)_tr1;
n->_desc2= (_TSPxSymDefIds)_tr2;
n->_desc3= (_TSPxAttrDefsOpt)_tr3;
return ( (NODEPTR) n);
}

NODEPTR Mkp0(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp0 n;
n = (_TPPp0) TreeNodeAlloc (sizeof (struct _TPp0));
n->_proc =_VS1p0;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymDefId)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp11(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp11 n;
n = (_TPPp11) TreeNodeAlloc (sizeof (struct _TPp11));
n->_proc =_VS1p11;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymDefIds)_tr1;
n->_desc2= (_TSPxSymDefId)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpSymDefId(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpSymDefId n;
n = (_TPPpSymDefId) TreeNodeAlloc (sizeof (struct _TPpSymDefId));
n->_proc =_VS1pSymDefId;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpSymb(_coordref)
POSITION *_coordref;
{_TPPpSymb n;
n = (_TPPpSymb) TreeNodeAlloc (sizeof (struct _TPpSymb));
n->_proc =_VS1pSymb;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpNont(_coordref)
POSITION *_coordref;
{_TPPpNont n;
n = (_TPPpNont) TreeNodeAlloc (sizeof (struct _TPpNont));
n->_proc =_VS1pNont;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpTerm(_coordref)
POSITION *_coordref;
{_TPPpTerm n;
n = (_TPPpTerm) TreeNodeAlloc (sizeof (struct _TPpTerm));
n->_proc =_VS1pTerm;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp15(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp15 n;
n = (_TPPp15) TreeNodeAlloc (sizeof (struct _TPp15));
n->_proc =_VS1p15;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrDefs)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp16(_coordref)
POSITION *_coordref;
{_TPPp16 n;
n = (_TPPp16) TreeNodeAlloc (sizeof (struct _TPp16));
n->_proc =_VS1p16;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp17(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp17 n;
n = (_TPPp17) TreeNodeAlloc (sizeof (struct _TPp17));
n->_proc =_VS1p17;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrDef)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp18(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp18 n;
n = (_TPPp18) TreeNodeAlloc (sizeof (struct _TPp18));
n->_proc =_VS1p18;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrDefs)_tr1;
n->_desc2= (_TSPxAttrDef)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpAttrDef(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPpAttrDef n;
n = (_TPPpAttrDef) TreeNodeAlloc (sizeof (struct _TPpAttrDef));
n->_proc =_VS1pAttrDef;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrDefIds)_tr1;
n->_desc2= (_TSPxTypeId)_tr2;
n->_desc3= (_TSPxClass)_tr3;
return ( (NODEPTR) n);
}

NODEPTR Mkp19(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp19 n;
n = (_TPPp19) TreeNodeAlloc (sizeof (struct _TPp19));
n->_proc =_VS1p19;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrDefId)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp20(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp20 n;
n = (_TPPp20) TreeNodeAlloc (sizeof (struct _TPp20));
n->_proc =_VS1p20;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrDefIds)_tr1;
n->_desc2= (_TSPxAttrDefId)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpAttrDefId(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpAttrDefId n;
n = (_TPPpAttrDefId) TreeNodeAlloc (sizeof (struct _TPpAttrDefId));
n->_proc =_VS1pAttrDefId;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpOldTypeDef(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPpOldTypeDef n;
n = (_TPPpOldTypeDef) TreeNodeAlloc (sizeof (struct _TPpOldTypeDef));
n->_proc =_VS1pOldTypeDef;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTypeId)_tr1;
n->_desc2= (_TSPxExtName)_tr2;
n->_desc3= (_TSPxListTo)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkpTypeId(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpTypeId n;
n = (_TPPpTypeId) TreeNodeAlloc (sizeof (struct _TPpTypeId));
n->_proc =_VS1pTypeId;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpOldExtName(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpOldExtName n;
n = (_TPPpOldExtName) TreeNodeAlloc (sizeof (struct _TPpOldExtName));
n->_proc =_VS1pOldExtName;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxLit)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp23(_coordref)
POSITION *_coordref;
{_TPPp23 n;
n = (_TPPp23) TreeNodeAlloc (sizeof (struct _TPp23));
n->_proc =_VS1p23;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpOldListTo(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpOldListTo n;
n = (_TPPpOldListTo) TreeNodeAlloc (sizeof (struct _TPpOldListTo));
n->_proc =_VS1pOldListTo;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTypeId)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp25(_coordref)
POSITION *_coordref;
{_TPPp25 n;
n = (_TPPp25) TreeNodeAlloc (sizeof (struct _TPp25));
n->_proc =_VS1p25;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpSymComp(_coordref,_tr1,_tr2,_tr3,_tr4)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
NODEPTR _tr4;
{_TPPpSymComp n;
n = (_TPPpSymComp) TreeNodeAlloc (sizeof (struct _TPpSymComp));
n->_proc =_VS1pSymComp;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymClass)_tr1;
n->_desc2= (_TSPxSymDefId)_tr2;
n->_desc3= (_TSPxInheritOpt)_tr3;
n->_desc4= (_TSPxCompPart)_tr4;
return ( (NODEPTR) n);
}

NODEPTR Mkp28(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp28 n;
n = (_TPPp28) TreeNodeAlloc (sizeof (struct _TPp28));
n->_proc =_VS1p28;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxInheritSyms)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp29(_coordref)
POSITION *_coordref;
{_TPPp29 n;
n = (_TPPp29) TreeNodeAlloc (sizeof (struct _TPp29));
n->_proc =_VS1p29;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp30(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp30 n;
n = (_TPPp30) TreeNodeAlloc (sizeof (struct _TPp30));
n->_proc =_VS1p30;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxInheritSyms)_tr1;
n->_desc2= (_TSPxInheritSym)_tr2;
return ( (NODEPTR) n);
}

NODEPTR Mkp31(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp31 n;
n = (_TPPp31) TreeNodeAlloc (sizeof (struct _TPp31));
n->_proc =_VS1p31;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxInheritSym)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpInhSym(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpInhSym n;
n = (_TPPpInhSym) TreeNodeAlloc (sizeof (struct _TPpInhSym));
n->_proc =_VS1pInhSym;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymId)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpRuleDefId(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpRuleDefId n;
n = (_TPPpRuleDefId) TreeNodeAlloc (sizeof (struct _TPpRuleDefId));
n->_proc =_VS1pRuleDefId;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpAlts(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpAlts n;
n = (_TPPpAlts) TreeNodeAlloc (sizeof (struct _TPpAlts));
n->_proc =_VS1pAlts;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAlts)_tr1;
n->_desc2= (_TSPxAlt)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpAlt(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpAlt n;
n = (_TPPpAlt) TreeNodeAlloc (sizeof (struct _TPpAlt));
n->_proc =_VS1pAlt;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAlt)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpSyntUnits(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpSyntUnits n;
n = (_TPPpSyntUnits) TreeNodeAlloc (sizeof (struct _TPpSyntUnits));
n->_proc =_VS1pSyntUnits;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSyntUnit)_tr1;
n->_desc2= (_TSPxSyntUnits)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpgenUnit(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpgenUnit n;
n = (_TPPpgenUnit) TreeNodeAlloc (sizeof (struct _TPpgenUnit));
n->_proc =_VS1pgenUnit;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSyntId)_tr1;
n->_desc2= (_TSPxSyntUnits)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpNoSyntUnit(_coordref)
POSITION *_coordref;
{_TPPpNoSyntUnit n;
n = (_TPPpNoSyntUnit) TreeNodeAlloc (sizeof (struct _TPpNoSyntUnit));
n->_proc =_VS1pNoSyntUnit;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp37(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp37 n;
n = (_TPPp37) TreeNodeAlloc (sizeof (struct _TPp37));
n->_proc =_VS1p37;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxCompSymbol)_tr1;
n->_desc2= (_TSPxComputations)_tr2;
return ( (NODEPTR) n);
}

NODEPTR Mkp38(_coordref)
POSITION *_coordref;
{_TPPp38 n;
n = (_TPPp38) TreeNodeAlloc (sizeof (struct _TPp38));
n->_proc =_VS1p38;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpOldStatic(_coordref)
POSITION *_coordref;
{_TPPpOldStatic n;
n = (_TPPpOldStatic) TreeNodeAlloc (sizeof (struct _TPpOldStatic));
n->_proc =_VS1pOldStatic;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp40(_coordref)
POSITION *_coordref;
{_TPPp40 n;
n = (_TPPp40) TreeNodeAlloc (sizeof (struct _TPp40));
n->_proc =_VS1p40;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpOldAssign(_coordref)
POSITION *_coordref;
{_TPPpOldAssign n;
n = (_TPPpOldAssign) TreeNodeAlloc (sizeof (struct _TPpOldAssign));
n->_proc =_VS1pOldAssign;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp42(_coordref)
POSITION *_coordref;
{_TPPp42 n;
n = (_TPPp42) TreeNodeAlloc (sizeof (struct _TPp42));
n->_proc =_VS1p42;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp43(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp43 n;
n = (_TPPp43) TreeNodeAlloc (sizeof (struct _TPp43));
n->_proc =_VS1p43;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxComputation)_tr1;
n->_desc2= (_TSPxComputations)_tr2;
return ( (NODEPTR) n);
}

NODEPTR Mkp44(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp44 n;
n = (_TPPp44) TreeNodeAlloc (sizeof (struct _TPp44));
n->_proc =_VS1p44;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxComputation)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp45(_coordref)
POSITION *_coordref;
{_TPPp45 n;
n = (_TPPp45) TreeNodeAlloc (sizeof (struct _TPp45));
n->_proc =_VS1p45;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpOldChainStart(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpOldChainStart n;
n = (_TPPpOldChainStart) TreeNodeAlloc (sizeof (struct _TPpOldChainStart));
n->_proc =_VS1pOldChainStart;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrName)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpChainStart(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpChainStart n;
n = (_TPPpChainStart) TreeNodeAlloc (sizeof (struct _TPpChainStart));
n->_proc =_VS1pChainStart;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrComp)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpCmpAttrComp(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpCmpAttrComp n;
n = (_TPPpCmpAttrComp) TreeNodeAlloc (sizeof (struct _TPpCmpAttrComp));
n->_proc =_VS1pCmpAttrComp;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttrComp)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpAttrComp(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPpAttrComp n;
n = (_TPPpAttrComp) TreeNodeAlloc (sizeof (struct _TPpAttrComp));
n->_proc =_VS1pAttrComp;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxDefAttr)_tr1;
n->_desc2= (_TSPxAssignSymbol)_tr2;
n->_desc3= (_TSPxExprDep)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkpDefAttr(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpDefAttr n;
n = (_TPPpDefAttr) TreeNodeAlloc (sizeof (struct _TPpDefAttr));
n->_proc =_VS1pDefAttr;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymOcc)_tr1;
n->_desc2= (_TSPxIdent)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpDefLocAttr(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpDefLocAttr n;
n = (_TPPpDefLocAttr) TreeNodeAlloc (sizeof (struct _TPpDefLocAttr));
n->_proc =_VS1pDefLocAttr;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpExprComp(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpExprComp n;
n = (_TPPpExprComp) TreeNodeAlloc (sizeof (struct _TPpExprComp));
n->_proc =_VS1pExprComp;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxExprDep)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpOldCond(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpOldCond n;
n = (_TPPpOldCond) TreeNodeAlloc (sizeof (struct _TPpOldCond));
n->_proc =_VS1pOldCond;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxExprDep)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpTransfer(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpTransfer n;
n = (_TPPpTransfer) TreeNodeAlloc (sizeof (struct _TPpTransfer));
n->_proc =_VS1pTransfer;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTransAttrOpt)_tr1;
n->_desc2= (_TSPxTransSymOpt)_tr2;
return ( (NODEPTR) n);
}

NODEPTR Mkp50(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp50 n;
n = (_TPPp50) TreeNodeAlloc (sizeof (struct _TPp50));
n->_proc =_VS1p50;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTransAttrs)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpOldTrans(_coordref)
POSITION *_coordref;
{_TPPpOldTrans n;
n = (_TPPpOldTrans) TreeNodeAlloc (sizeof (struct _TPpOldTrans));
n->_proc =_VS1pOldTrans;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp52(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp52 n;
n = (_TPPp52) TreeNodeAlloc (sizeof (struct _TPp52));
n->_proc =_VS1p52;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTransAttrId)_tr1;
n->_desc2= (_TSPxTransAttrs)_tr2;
return ( (NODEPTR) n);
}

NODEPTR Mkp53(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp53 n;
n = (_TPPp53) TreeNodeAlloc (sizeof (struct _TPp53));
n->_proc =_VS1p53;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTransAttrId)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpTransAttrId(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpTransAttrId n;
n = (_TPPpTransAttrId) TreeNodeAlloc (sizeof (struct _TPpTransAttrId));
n->_proc =_VS1pTransAttrId;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp54(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp54 n;
n = (_TPPp54) TreeNodeAlloc (sizeof (struct _TPp54));
n->_proc =_VS1p54;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTransSyms)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp55(_coordref)
POSITION *_coordref;
{_TPPp55 n;
n = (_TPPp55) TreeNodeAlloc (sizeof (struct _TPp55));
n->_proc =_VS1p55;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpTransSym(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpTransSym n;
n = (_TPPpTransSym) TreeNodeAlloc (sizeof (struct _TPpTransSym));
n->_proc =_VS1pTransSym;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymOcc)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp56(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp56 n;
n = (_TPPp56) TreeNodeAlloc (sizeof (struct _TPp56));
n->_proc =_VS1p56;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymOcc)_tr1;
n->_desc2= (_TSPxTransSyms)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpAttr(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpAttr n;
n = (_TPPpAttr) TreeNodeAlloc (sizeof (struct _TPpAttr));
n->_proc =_VS1pAttr;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymOcc)_tr1;
n->_desc2= (_TSPxIdent)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpLocAttr(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpLocAttr n;
n = (_TPPpLocAttr) TreeNodeAlloc (sizeof (struct _TPpLocAttr));
n->_proc =_VS1pLocAttr;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpSymOcc(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpSymOcc n;
n = (_TPPpSymOcc) TreeNodeAlloc (sizeof (struct _TPpSymOcc));
n->_proc =_VS1pSymOcc;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymId)_tr1;
n->_desc2= (_TSPxIndex)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpSymId(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpSymId n;
n = (_TPPpSymId) TreeNodeAlloc (sizeof (struct _TPpSymId));
n->_proc =_VS1pSymId;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpIndex(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpIndex n;
n = (_TPPpIndex) TreeNodeAlloc (sizeof (struct _TPpIndex));
n->_proc =_VS1pIndex;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxNum)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpNoIndex(_coordref)
POSITION *_coordref;
{_TPPpNoIndex n;
n = (_TPPpNoIndex) TreeNodeAlloc (sizeof (struct _TPpNoIndex));
n->_proc =_VS1pNoIndex;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpAttrExpr(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpAttrExpr n;
n = (_TPPpAttrExpr) TreeNodeAlloc (sizeof (struct _TPpAttrExpr));
n->_proc =_VS1pAttrExpr;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpLocAttrExpr(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpLocAttrExpr n;
n = (_TPPpLocAttrExpr) TreeNodeAlloc (sizeof (struct _TPpLocAttrExpr));
n->_proc =_VS1pLocAttrExpr;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxLocAttr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpCall(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpCall n;
n = (_TPPpCall) TreeNodeAlloc (sizeof (struct _TPpCall));
n->_proc =_VS1pCall;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
n->_desc2= (_TSPxParamsOpt)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpRemoteExpr(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpRemoteExpr n;
n = (_TPPpRemoteExpr) TreeNodeAlloc (sizeof (struct _TPpRemoteExpr));
n->_proc =_VS1pRemoteExpr;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRemoteExpr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpExprId(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpExprId n;
n = (_TPPpExprId) TreeNodeAlloc (sizeof (struct _TPpExprId));
n->_proc =_VS1pExprId;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxIdent)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpLit(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpLit n;
n = (_TPPpLit) TreeNodeAlloc (sizeof (struct _TPpLit));
n->_proc =_VS1pLit;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxLit)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpCLit(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpCLit n;
n = (_TPPpCLit) TreeNodeAlloc (sizeof (struct _TPpCLit));
n->_proc =_VS1pCLit;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxCLit)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpChar(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpChar n;
n = (_TPPpChar) TreeNodeAlloc (sizeof (struct _TPpChar));
n->_proc =_VS1pChar;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxChar)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpFloat(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpFloat n;
n = (_TPPpFloat) TreeNodeAlloc (sizeof (struct _TPpFloat));
n->_proc =_VS1pFloat;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxFloat)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpNum(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpNum n;
n = (_TPPpNum) TreeNodeAlloc (sizeof (struct _TPpNum));
n->_proc =_VS1pNum;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxNum)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpExprWDep(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpExprWDep n;
n = (_TPPpExprWDep) TreeNodeAlloc (sizeof (struct _TPpExprWDep));
n->_proc =_VS1pExprWDep;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxExpr)_tr1;
n->_desc2= (_TSPxDepClause)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpExprWODep(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpExprWODep n;
n = (_TPPpExprWODep) TreeNodeAlloc (sizeof (struct _TPpExprWODep));
n->_proc =_VS1pExprWODep;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxExpr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpDepClause(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpDepClause n;
n = (_TPPpDepClause) TreeNodeAlloc (sizeof (struct _TPpDepClause));
n->_proc =_VS1pDepClause;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxDependence)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp71(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp71 n;
n = (_TPPp71) TreeNodeAlloc (sizeof (struct _TPp71));
n->_proc =_VS1p71;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxDepAttr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp72(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp72 n;
n = (_TPPp72) TreeNodeAlloc (sizeof (struct _TPp72));
n->_proc =_VS1p72;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxDepAttrs)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp73(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp73 n;
n = (_TPPp73) TreeNodeAlloc (sizeof (struct _TPp73));
n->_proc =_VS1p73;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxDepAttr)_tr1;
n->_desc2= (_TSPxDepAttrs)_tr2;
return ( (NODEPTR) n);
}

NODEPTR Mkp74(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp74 n;
n = (_TPPp74) TreeNodeAlloc (sizeof (struct _TPp74));
n->_proc =_VS1p74;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxDepAttr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpRemoteDep(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpRemoteDep n;
n = (_TPPpRemoteDep) TreeNodeAlloc (sizeof (struct _TPpRemoteDep));
n->_proc =_VS1pRemoteDep;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRemoteExpr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpAttrDep(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpAttrDep n;
n = (_TPPpAttrDep) TreeNodeAlloc (sizeof (struct _TPpAttrDep));
n->_proc =_VS1pAttrDep;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxAttr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpLocDep(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpLocDep n;
n = (_TPPpLocDep) TreeNodeAlloc (sizeof (struct _TPpLocDep));
n->_proc =_VS1pLocDep;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxLocAttr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp78(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp78 n;
n = (_TPPp78) TreeNodeAlloc (sizeof (struct _TPp78));
n->_proc =_VS1p78;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxParams)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp79(_coordref)
POSITION *_coordref;
{_TPPp79 n;
n = (_TPPp79) TreeNodeAlloc (sizeof (struct _TPp79));
n->_proc =_VS1p79;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp80(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp80 n;
n = (_TPPp80) TreeNodeAlloc (sizeof (struct _TPp80));
n->_proc =_VS1p80;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxParam)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp81(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp81 n;
n = (_TPPp81) TreeNodeAlloc (sizeof (struct _TPp81));
n->_proc =_VS1p81;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxParam)_tr1;
n->_desc2= (_TSPxParams)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpParam(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpParam n;
n = (_TPPpParam) TreeNodeAlloc (sizeof (struct _TPpParam));
n->_proc =_VS1pParam;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxExprDep)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpIncluding(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpIncluding n;
n = (_TPPpIncluding) TreeNodeAlloc (sizeof (struct _TPpIncluding));
n->_proc =_VS1pIncluding;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRemoteClause)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp84(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp84 n;
n = (_TPPp84) TreeNodeAlloc (sizeof (struct _TPp84));
n->_proc =_VS1p84;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRemoteAttr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp85(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp85 n;
n = (_TPPp85) TreeNodeAlloc (sizeof (struct _TPp85));
n->_proc =_VS1p85;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRemoteAttrs)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp86(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp86 n;
n = (_TPPp86) TreeNodeAlloc (sizeof (struct _TPp86));
n->_proc =_VS1p86;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRemoteAttr)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp87(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp87 n;
n = (_TPPp87) TreeNodeAlloc (sizeof (struct _TPp87));
n->_proc =_VS1p87;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxRemoteAttr)_tr1;
n->_desc2= (_TSPxRemoteAttrs)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpRemoteAttr(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPpRemoteAttr n;
n = (_TPPpRemoteAttr) TreeNodeAlloc (sizeof (struct _TPpRemoteAttr));
n->_proc =_VS1pRemoteAttr;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymId)_tr1;
n->_desc2= (_TSPxIdent)_tr2;
return ( (NODEPTR) n);
}

NODEPTR MkpConstituents(_coordref,_tr1,_tr2,_tr3,_tr4)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
NODEPTR _tr4;
{_TPPpConstituents n;
n = (_TPPpConstituents) TreeNodeAlloc (sizeof (struct _TPpConstituents));
n->_proc =_VS1pConstituents;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSubtree)_tr1;
n->_desc2= (_TSPxRemoteClause)_tr2;
n->_desc3= (_TSPxShield)_tr3;
n->_desc4= (_TSPxExpandOpt)_tr4;
return ( (NODEPTR) n);
}

NODEPTR MkpConstituent(_coordref,_tr1,_tr2,_tr3)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
{_TPPpConstituent n;
n = (_TPPpConstituent) TreeNodeAlloc (sizeof (struct _TPpConstituent));
n->_proc =_VS1pConstituent;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSubtree)_tr1;
n->_desc2= (_TSPxRemoteClause)_tr2;
n->_desc3= (_TSPxShield)_tr3;
return ( (NODEPTR) n);
}

NODEPTR MkpExpandWith(_coordref,_tr1,_tr2,_tr3,_tr4)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
NODEPTR _tr3;
NODEPTR _tr4;
{_TPPpExpandWith n;
n = (_TPPpExpandWith) TreeNodeAlloc (sizeof (struct _TPpExpandWith));
n->_proc =_VS1pExpandWith;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxTypeId)_tr1;
n->_desc2= (_TSPxIdent)_tr2;
n->_desc3= (_TSPxIdent)_tr3;
n->_desc4= (_TSPxIdent)_tr4;
return ( (NODEPTR) n);
}

NODEPTR MkpNoWith(_coordref)
POSITION *_coordref;
{_TPPpNoWith n;
n = (_TPPpNoWith) TreeNodeAlloc (sizeof (struct _TPpNoWith));
n->_proc =_VS1pNoWith;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpSubtree(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpSubtree n;
n = (_TPPpSubtree) TreeNodeAlloc (sizeof (struct _TPpSubtree));
n->_proc =_VS1pSubtree;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymOcc)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpNoSubtree(_coordref)
POSITION *_coordref;
{_TPPpNoSubtree n;
n = (_TPPpNoSubtree) TreeNodeAlloc (sizeof (struct _TPpNoSubtree));
n->_proc =_VS1pNoSubtree;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR MkpShield(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpShield n;
n = (_TPPpShield) TreeNodeAlloc (sizeof (struct _TPpShield));
n->_proc =_VS1pShield;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxShClause)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpnoShield(_coordref)
POSITION *_coordref;
{_TPPpnoShield n;
n = (_TPPpnoShield) TreeNodeAlloc (sizeof (struct _TPpnoShield));
n->_proc =_VS1pnoShield;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp88(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp88 n;
n = (_TPPp88) TreeNodeAlloc (sizeof (struct _TPp88));
n->_proc =_VS1p88;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxShSym)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp89(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp89 n;
n = (_TPPp89) TreeNodeAlloc (sizeof (struct _TPp89));
n->_proc =_VS1p89;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxShSyms)_tr1;
return ( (NODEPTR) n);
}

NODEPTR Mkp90(_coordref)
POSITION *_coordref;
{_TPPp90 n;
n = (_TPPp90) TreeNodeAlloc (sizeof (struct _TPp90));
n->_proc =_VS1p90;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
return ( (NODEPTR) n);
}

NODEPTR Mkp91(_coordref,_tr1,_tr2)
POSITION *_coordref;
NODEPTR _tr1;
NODEPTR _tr2;
{_TPPp91 n;
n = (_TPPp91) TreeNodeAlloc (sizeof (struct _TPp91));
n->_proc =_VS1p91;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxShSyms)_tr1;
n->_desc2= (_TSPxShSym)_tr2;
return ( (NODEPTR) n);
}

NODEPTR Mkp92(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPp92 n;
n = (_TPPp92) TreeNodeAlloc (sizeof (struct _TPp92));
n->_proc =_VS1p92;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxShSym)_tr1;
return ( (NODEPTR) n);
}

NODEPTR MkpShSym(_coordref,_tr1)
POSITION *_coordref;
NODEPTR _tr1;
{_TPPpShSym n;
n = (_TPPpShSym) TreeNodeAlloc (sizeof (struct _TPpShSym));
n->_proc =_VS1pShSym;
n->_pos.line = _coordref->line; n->_pos.col = _coordref->col;
n->_desc1= (_TSPxSymId)_tr1;
return ( (NODEPTR) n);
}

#ifndef GETxIdentid
#define GETxIdentid(x) (x)
#endif

#ifndef GETxLitid
#define GETxLitid(x) (x)
#endif

#ifndef GETxNumval
#define GETxNumval(x) (x)
#endif

void SourceLeaf(d) GRUNDSYMBOLDESKRIPTOR *d;
{_incrnodestack ();
switch (d->SyntaxCode) {

case 2: _nst[_nsp] =MkxIdent(&(d->Pos),GETxIdentid (d->Attr)); break;

case 3: _nst[_nsp] =MkxLit(&(d->Pos),GETxLitid (d->Attr)); break;

case 4: _nst[_nsp] =MkxNum(&(d->Pos),GETxNumval (d->Attr)); break;

case 5: _nst[_nsp] =MkxCLit(&(d->Pos)); break;

case 6: _nst[_nsp] =MkxChar(&(d->Pos)); break;

case 7: _nst[_nsp] =MkxFloat(&(d->Pos)); break;
}}


