
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "ptg_gen.h"

#if defined(__STDC__) || defined (__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { _PrPTGNULL };

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOut (PTGNode r)
#else
PTGNode PTGOut (r)
PTGNode r;
#endif
{
  f = stdout;
  if (r) {
     (* (r->_print)) (r);
     fputs("\n", f);
  }
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
#endif
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
	exit(1);
  }
  if (r) {
    (* (r->_print)) (r);
    fputs("\n", f);
  }
  fclose(f);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
#endif
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
    exit(1);
  }
  if (r) {
    (* (r->_print)) (r);
    fputs("\n", f);
  }
  return (r);
}

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGSymbol *_PPTGSymbol;
struct _SPTGSymbol{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGString *_PPTGString;
struct _SPTGString{
  _PTGProc _print;
  char *_t0;
};

#if defined(__STDC__) || defined(__cplusplus)
extern void FSymbol(FILE *, char *);
#else
extern void FSymbol();
#endif

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSymbol(_PPTGSymbol n)
#else
static void _PrPTGSymbol(n)
_PPTGSymbol n;
#endif
{
  FSymbol(f,n->_t0);
}

#if defined(__STDC__) || defined(__cplusplus)
extern void FString(FILE *, char *);
#else
extern void FString();
#endif

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGString(_PPTGString n)
#else
static void _PrPTGString(n)
_PPTGString n;
#endif
{
  FString(f,n->_t0);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNewline(_PPTG1 n)
#else
static void _PrPTGNewline(n)
_PPTG1 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSpcSeq(_PPTG2 n)
#else
static void _PrPTGSpcSeq(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSeq(_PPTG2 n)
#else
static void _PrPTGSeq(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGComSeq(_PPTG2 n)
#else
static void _PrPTGComSeq(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (",", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGHead(_PPTG1 n)
#else
static void _PrPTGHead(n)
_PPTG1 n;
#endif
{
  fputs ("%\n%   LIDO generated for grammar ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" \n%\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGRule(_PPTG3 n)
#else
static void _PrPTGRule(n)
_PPTG3 n;
#endif
{
  fputs ("RULE ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" : \n  ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" ::= ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("\nCOMPUTE\nEND;\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNonterm(_PPTG1 n)
#else
static void _PrPTGNonterm(n)
_PPTG1 n;
#endif
{
  fputs ("NONTERM ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" : ;\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTerm(_PPTG1 n)
#else
static void _PrPTGTerm(n)
_PPTG1 n;
#endif
{
  fputs ("TERM ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" : ;\n", f);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSymbol(char *_t0)
#else
PTGNode PTGSymbol(_t0)
  char *_t0;
#endif
{
  _PPTGSymbol n;

  if ((n = (_PPTGSymbol) malloc (sizeof (struct _SPTGSymbol)))  ==  (_PPTGSymbol)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSymbol;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGString(char *_t0)
#else
PTGNode PTGString(_t0)
  char *_t0;
#endif
{
  _PPTGString n;

  if ((n = (_PPTGString) malloc (sizeof (struct _SPTGString)))  ==  (_PPTGString)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGString;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNewline(PTGNode _t0)
#else
PTGNode PTGNewline(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNewline;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSpcSeq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGSpcSeq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSpcSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSeq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGComSeq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGComSeq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGComSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGHead(PTGNode _t0)
#else
PTGNode PTGHead(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGHead;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGRule(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGRule(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGRule;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNonterm(PTGNode _t0)
#else
PTGNode PTGNonterm(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNonterm;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTerm(PTGNode _t0)
#else
PTGNode PTGTerm(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTerm;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}


