# $Id: Makefile.cpp,v 1.3 1992/11/03 21:01:08 kadhim Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/genlido

CFLAGS		= -I..
PFLAGS		= -w -temp=.
COFLAGS		= -q

TOOLNAME	= genlido
ELISRCS 	= mk.genlido genlido.specs genlido.gla mkstrsupp.c genlido.con \
	 	  lido.con genlido.sym genlido.cull genlido.ptg genlido.lido \
		  genlido.ctl genlido.head genlido.ddl genlido.c gen_ins.c \
		  comp.lido lido.lido support.c support.h 
AUX		= genlido.dg
SYS		= genlido.err grammar.txt
CMD		= gldGenIn.cmd genlidoGen.cmd genlidoOut.cmd absplan.cmd \
		  abscomplete.cmd
SRCS		= $(ELISRCS) $(SYS) $(AUX) $(CMD)
EXE		= $(TOOLNAME).exe

ODIN		= eli

DERIVEDSRCS	= derivedSrcs
TESTDIR		= test

TIDY		= a.out *.o *.README *.a ELI $(TESTDIR)
CLEAN		= $(TIDY) $(EXE)
CLOBBER		= $(CLEAN) $(DERIVEDSRCS) Makefile

all:	$(EXE) $(AUX) $(SYS) $(CMD)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/genlido; \
		rm -f $(DESTDIR)/Tool/genlido/$$f; \
		cp $$f $(DESTDIR)/Tool/genlido/$$f; \
		chmod 644 $(DESTDIR)/Tool/genlido/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/genlido/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for i in $(SYS); do \
		echo install -c -m 644 $$i $(DESTDIR)/Tool/genlido; \
		rm -f $(DESTDIR)/Tool/genlido/$$i; \
		cp $$i $(DESTDIR)/Tool/genlido/$$i; \
		chmod 644 $(DESTDIR)/Tool/genlido/$$i; \
	done
	rm -f $(DESTDIR)/Tool/genlido/genlido.exe
	cp genlido.exe $(DESTDIR)/Tool/genlido
	chmod 755 $(DESTDIR)/Tool/genlido/genlido.exe

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(DERIVEDSRCS) $(ELISRCS) $(AUX)

SourceDistr:	$(SRCS)
		-mkdir $(DERIVEDSRCS)
		cp $(ELI)/$(DERIVEDSRCS)/* $(DERIVEDSRCS)
		cd $(DERIVEDSRCS); make clean

tidy:
		rm -rf $(TIDY)

clean:
		rm -rf $(CLEAN)
		-cd $(DERIVEDSRCS); make clean

clobber:
		rm -rf $(CLOBBER)
		-cd $(DERIVEDSRCS); make clean

rcsclean:
		rm -rf $(CLEAN) Makefile
		-cd $(DERIVEDSRCS); make clean
		-rcsclean $(COFLAGS) $(SRCS) Makefile.cpp

$(TOOLNAME).exe:	$(DERIVEDSRCS)/Makefile
		cd $(DERIVEDSRCS); make PFLAGS="$(PFLAGS)" CC="$(CC)" $(EXE)
		rm -f $(EXE); ln $(DERIVEDSRCS)/$(EXE) .

$(DERIVEDSRCS):	$(ELISRCS)
		-mkdir $(DERIVEDSRCS)
		-if test ! -d ELI; \
			then $(ODIN) -c $(DESTDIR) -n ELI -q; \
			else :; \
			fi
		$(ODIN) -c ELI <mk.$(TOOLNAME)

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(SRCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(SRCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(SRCS)

.PRECIOUS:	$(SRCS)

testSourceDistr:
		rm -rf $(TESTDIR)
		mkdir $(TESTDIR)
		cd $(TESTDIR); ln -s ../RCS .; co Makefile.cpp; \
			make -f Makefile.cpp ELI=`$(PWD)`/.. SourceDistr; \
			rm RCS
