#!/bin/sh
# $Id: fwTangle.cmd,v 1.2 1993/01/05 21:00:51 kadhim Exp $
# Copyright 1992, The Regents of the University of Colorado

#fwTangle <
#  fwGen[.none] 'Objects generated from a FunnelWeb specification'*
#  fwMap 'Mapping from output objects to FunnelWeb specification'*
#  > 'Generate products from a FunnelWeb specification'* :
#	USER
#		: fw_srcs
#		: (:fw_srcs :labels)

umask 0
cd (|<<fw_srcs|)
for f in `ls`
do
	(|$/Tool/fw/eliexpand|) $f > $f.new
	mv $f.new $f
done
source=`ls *.fw`

cd (|>fwGen|)
ln -s (|<<fw_srcs|)/$source i$$.fw
(|$/Tool/fw/fw|) -I(|<<fw_srcs|)/ +Q +U i$$.fw \
	1>/dev/null 2>&1
if test $? -ne 0
then
 	sed -n 's;^"'i$$.fw'";"(|<<fw_srcs|)/'$source'";
		s;^"(|<<fw_srcs|)/\([^"]*\)", line \([0-9]*\):\([0-9]*\);\1 \2 \3;
		/WARNING/{
			s/WARNING: //
			w (|<RUNDIR|)/WARNING
			d
		}
		/ERROR/{
			s/ERROR: //
			w (|<RUNDIR|)/ERROR
			d
		}
		/DEADLY/{
			s/DEADLY: //
			w (|<RUNDIR|)/ERROR
			d
		}' i$$.lis
fi

sed "s;^i$$.fw;(|<<fw_srcs|)/$source;
		s;^(|<<fw_srcs|)/\([^ ]*\);\1;" i$$.map \
	> (|<RUNDIR|)/map
rm -f i$$.*

cd (|<RUNDIR|)

(|$/Tool/skeleton/err_map.exe|) (|<(:fw_srcs :labels)|) (|<fw_srcs|) map \
	| sed -e 's/^\([^ ]* [^ ]* [^ ]*\) \(.*\)/\2 \1/' \
	> (|>fwMap|)

if test -s ERROR
then (|$/Tool/skeleton/err_map.exe|) (|<(:fw_srcs :labels)|) (|<fw_srcs|) ERROR >>(|>ERROR|)
fi

if test -s WARNING
then (|$/Tool/skeleton/err_map.exe|) (|<(:fw_srcs :labels)|) (|<fw_srcs|) WARNING >>(|>WARNING|)
fi

exit 0
