#!/bin/sh
# $Id: usedcode.cmd,v 1.2 1992/08/02 21:38:15 kadhim Exp $
# Copyright 1992, The Regents of the University of Colorado

#usedcode <
#   sources(.none) 'Source files'*
#   objects(.none) 'Object files'*
#   > 'Files actually used in the generated program'* :
#	USER
#		: (:all_c +incl=(:includes) ::o)
#		: (:all_c :names)
#		: (:genlib +incl=(:includes) ::o)
#		: (:genlib :names)
#		: (:.compound Extract(reqsym) :.cat)
#		+ debug
#		+ prof
#		+ nomain

umask 0
cd (|<RUNDIR|)

if test -s (|<(:.compound +typekey=reqsym :extract :.cat)|)
then reqsym=(|<(:.compound +typekey=reqsym :extract :.cat)|)
else reqsym=/dev/null
fi

if test -f (|<nomain|)
then cp $reqsym symbols
else echo 'main' | cat - $reqsym > symbols
fi

if test -f (|<debug|)
then command='s;.*;(|$/Tool/frame_g|)/&.o;'
elif test -f (|<prof|)  
then command='s;.*;(|$/Tool/frame_pg|)/&.o;'
else command='s;.*;(|$/Tool/frame|)/&.o;'
fi

sed -e $command (|$/Tool/frame.specs:level_0_specs+typekey=c:extract:labels|) \
   >frameobj

ln -s (|>sources|) source
ln -s (|>objects|) object
(|$/Tool/eli/loaded.exe|) \
      symbols \
      frameobj (|$/Tool/frame.specs:level_0_specs+typekey=c:extract:names|) \
      (|<(:genlib +incl=(:includes) ::o)|) (|<(:genlib :names)|) \
      (|<(:all_c +incl=(:includes) ::o)|) (|<(:all_c :names)|) \
   2>(|>ERROR|)

exit 0
