/* $Id: prop.h,v 1.1 1991/10/31 19:31:39 waite Exp $ */
/* Property query and update module interface */

#define ProgramProp 1
#define SourceProp 2
#define ObjectProp 3
#define UsesProp 4
#define MemberProp 5


#define GetSource(x,y) GetFile(x,SourceProp,y)
#define SetSource(x,y) SetFile(x,SourceProp,y)
#define GetObject(x,y) GetFile(x,ObjectProp,y)
#define SetObject(x,y) SetFile(x,ObjectProp,y)


extern int GetMember(/* DefTableKey key; */);
/* Query the member property
 *    If the member property is set then on exit-
 *       GetMember=1
 *    Else on exit-
 *       GetMember=0
 ***/


extern void SetMember(/* DefTableKey key; */);
/* Set the member property
 ***/


extern char * GetFile(/* DefTableKey key; char *dfltval; */);
/* Query the file property
 *    On exit-
 *       GetFile=source file containing this program
 ***/


extern void SetFile(/* DefTableKey key; int prop; char *add; */);
/* Update the file property
 *    On entry-
 *       add=source file containing this program
 ***/


extern int * GetUses(/* DefTableKey key; int *dfltval; */);
/* Query the uses property
 *    On exit-
 *       GetUses=identifiers used in this program
 ***/


extern void SetUses(/* DefTableKey key; int *add; */);
/* Update the uses property
 *    On entry-
 *       add=identifiers used in this program
 ***/


extern DefTableKey GetProgram(/* DefTableKey key; DefTableKey dfltval; */);
/* Query the program property of a symbol
 *    On exit-
 *       GetProgram=key for the program containing this symbol
 ***/


extern void SetProgram(/* DefTableKey key, add; char *errsym; */);
/* Update the program property of a symbol
 *    On entry-
 *       add=key for the program containing this symbol
 *       errsym=symbol being entered
 ***/
