static char rcsid[] = "$Id: prop.c,v 1.3 1992/11/15 05:52:26 waite Exp $";
/* Property query and update module */

#include "deftbl.h"
#include "prop.h"

/***/
int
GetMember(key)
DefTableKey key;
/* Query the member property
 *    If the member property is set then on exit-
 *       GetMember=1
 *    Else on exit-
 *       GetMember=0
 ***/
{
   Entry r;

   return (find(key,MemberProp,&r,0));
}

/***/
void
SetMember(key)
DefTableKey key;
/* Set the member property
 ***/
{
   Entry r;

   if (key != NoKey) (void)find(key,MemberProp,&r,sizeof(struct PropElt));
}


typedef struct {		/* Properties of a defined entity */
   struct PropElt *next;	   /* The next property */
   int selector;		   /* Which property */
   char *PropVal;		   /* Property value */
} StringElt;

/***/
char *
GetFile(key, prop, dfltval)
DefTableKey key; int prop; char *dfltval;
/* Query the file property
 *    On exit-
 *       GetFile=source file containing this program
 ***/
{
   Entry r;

   if (find(key,prop,&r,0)) return ((StringElt *)r)->PropVal;
   return dfltval;
}

/***/
void
SetFile(key, prop, add)
DefTableKey key; int prop; char *add;
/* Update the file property
 *    On entry-
 *       add=source file containing this program
 ***/
{
   Entry r;

   if (key == NoKey) return;
   if (!find(key,prop,&r,sizeof(StringElt)))
      ((StringElt *)r)->PropVal = add;
}


typedef struct {		/* Properties of a defined entity */
   struct PropElt *next;	   /* The next property */
   int selector;		   /* Which property */
   int *PropVal;		   /* Property value */
} UsesElt;

/***/
int *
GetUses(key, dfltval)
DefTableKey key; int *dfltval;
/* Query the uses property
 *    On exit-
 *       GetUses=identifiers used in this program
 ***/
{
   Entry r;

   if (find(key,UsesProp,&r,0)) return ((UsesElt *)r)->PropVal;
   return dfltval;
}

/***/
void
SetUses(key, add)
DefTableKey key; int *add;
/* Update the uses property
 *    On entry-
 *       add=identifiers used in this program
 ***/
{
   Entry r;

   if (key == NoKey) return;
   (void)find(key,UsesProp,&r,sizeof(UsesElt));
   ((UsesElt *)r)->PropVal = add;
}


typedef struct {		/* Properties of a defined entity */
   struct PropElt *next;	   /* The next property */
   int selector;		   /* Which property */
   DefTableKey PropVal;		   /* Property value */
} DefTableElt;

/***/
DefTableKey
GetProgram(key, dfltval)
DefTableKey key; DefTableKey dfltval;
/* Query the program property of a symbol
 *    On exit-
 *       GetProgram=key for the program containing this symbol
 ***/
{
   Entry r;

   if (find(key,ProgramProp,&r,0)) return ((DefTableElt *)r)->PropVal;
   return dfltval;
}

/***/
void
SetProgram(key, add)
DefTableKey key, add;
/* Update the program property of a symbol
 *    On entry-
 *       add=key for the program containing this symbol
 ***/
{
   Entry r;

   if (key == NoKey) return;
   if (!find(key, ProgramProp, &r, sizeof(DefTableElt))) 
      ((DefTableElt *)r)->PropVal = add;
}
