static char rcsid[] = "$Id: loaded.c,v 1.13 1992/11/18 22:31:54 tony Exp $";
/* Program to print out the object files necessary to resolve undefined
 * references in a given object file.
 * Tony Sloane, June 1991.
 * read_symbols is based on code from Jim Larus' AE.
 */

#include "system.h"
#include "symbinfo.h"
#include "obstack.h"

static struct obstack text;	/* Character forms of the file names */
static struct obstack files;	/* Pointers to file names on the current contour */

/**/
static char **
GetFiles(list)
char *list;
/* Get a list of files
 *    On entry-
 *       list=name of the file containing the list of files
 *    On exit-
 *       GetFiles points to an array of the file names
 **/
{
   char *empty = NULL;
   int c;
   FILE *f;

   if ((f = fopen(list, "r")) == (FILE *)NULL) {
      (void)fprintf(stderr, "loaded: Could not open file %s for reading\n",
		    list);
      exit(1);
   }

   while ((c = getc(f)) != EOF) {
      if (c != '\n') obstack_1grow(&text, c);
      else {
         char *name;

         obstack_1grow(&text, 0); name = obstack_finish(&text);
         obstack_grow(&files, &name, sizeof(char *));
      }
   }

   return (char **)obstack_copy(&files, &empty, sizeof(char *));
}

int main (argc, argv)
int argc;
char *argv[];
{
	int i;

	/* check args */
	if (argc < 4) {
		(void)fprintf (stderr, "usage: %s symbols obj src [obj src]...\n",
			argv[0]);
		exit(1);
	}

	ErrorInit(1,0,0);
	SymbInit();
	obstack_init(&files); obstack_init(&text);

	for (i = 2; i < argc; i += 2) {
		char **objfile, **srcfile;

		objfile = GetFiles(argv[i]); srcfile = GetFiles(argv[i+1]);
		AddFiles(objfile, srcfile);
		obstack_free(&files, objfile);
	}

	OutFiles(argv[1]);

	return 0;
}
