static char RCSid[] = "$Id: err.c,v 1.1 1991/11/03 10:47:10 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

#include <stdio.h>
#include <string.h>
#include "err.h"


	/* The following variables are exported by the Error Reporting
	   Module */

POSITION curpos = { 0, 0}; /* Current source Msgtext position */
int ErrorCount[] = {0, 0, 0, 0, 0, 0}; /* Counts at each severity level */

static char *key[]= {"NOTE", "COMMENT", "WARNING", "ERROR", "FATAL", "DEADLY"};

struct msg {
        int severity;
        POSITION loc;
        int grammar;
        char *Msgtext;
        struct msg *forward, *back;
};


static struct msg reports = {   /* Error report list */
        DEADLY, 0, 0, 0, "",
        &reports, &reports};

static struct msg emergency;    /* In case malloc fails */

static int ImmediateOutput = 1;	/* 1 if immediate error output required */
static int GrammarLine = 1;	/* 1 to print AG line number */
static int ErrorLimit = 1;	/* 1 to abort after too many errors */

#if defined(__cplusplus) || defined(__STDC__)
void
ErrorInit(int ImmOut, int AGout, int ErrLimit)
#else
ErrorInit(ImmOut, AGout, ErrLimit)
int ImmOut, AGout, ErrLimit;
#endif
/* Initialize the error module
 *    On entry-
 *       ImmOut=1 if immediate error output required
 *       AGout=1 to print AG line number on error reports
 *       ErrLimit=1 to limit the number of errors reported
 ***/
{
	ImmediateOutput = ImmOut;
	GrammarLine = AGout; 
	ErrorLimit = ErrLimit;

	reports.severity = DEADLY;
	reports.loc.line = reports.loc.col = 0;
	reports.grammar = 0; reports.Msgtext = "";
	reports.forward = reports.back = &reports;
}

#if defined(__cplusplus) || defined(__STDC__)
void
dmperr(FILE *d)
#else
void
dmperr(d)
FILE *d;
#endif
/* Dump the error reports to a Msgtext file
 ***/
{
        struct msg *r;
 
        r = reports.forward;
        while (r->loc.line != 0) {
                (void)fprintf(d, "%d", r->severity);
		(void)fprintf(d," (%d,%d)",r->loc.line,r->loc.col);
                (void)fprintf(d, " %d %s\n", r->grammar, r->Msgtext);
                r = r->forward;
        }
}
 

#if defined(__cplusplus) || defined(__STDC__) 
int
earlier(POSITION *p, POSITION *q)
#else
int
earlier(p,q)
POSITION *p, *q;
#endif
/* Check relative position
 *    On exit-
 *       earlier != 0 if p defines a position in the source Msgtext that
 *          preceeds the position defined by q
 ***/
{
        if (p->line != q->line) return(p->line < q->line);
        return(p->col < q->col);
}

#if defined(__cplusplus) || defined(__STDC__) 
void
message(int severity, char *Msgtext, int grammar, POSITION *source)
#else
void
message(severity, Msgtext, grammar, source)
int severity; char *Msgtext; int grammar; POSITION *source;
#endif
/* Report an error
 *    On entry-
 *      severity=error severity
 *      Msgtext=message text
 *      grammar=identification of the test that failed
 *      source=source coordinates at which the error was detected
 ***/
{
        int fail = 0;
        struct msg *r, *c;

	if (severity < NOTE || severity > DEADLY) {
		(void)fprintf(stderr, "Invalid severity code %d for \"%s\"\n",
			severity, Msgtext);
		severity = DEADLY;
		}

	if (source == NULL) source = &curpos;

	if (ImmediateOutput) {
		(void)fprintf(stderr, "\"%s\", line %d:%d %s: %s",
	  		"INPUT", source->line,source->col,
			key[severity], Msgtext);
		if (grammar>0 && GrammarLine)
			(void)fprintf(stderr," AG=%d\n", grammar);
		else
			(void)putc('\n', stderr);
	}

	ErrorCount[severity]++;
	
        if ((r = (struct msg *) malloc(sizeof(struct msg))) == NULL) {
                r = &emergency;
                (void)fprintf(stderr, "No storage for error report at");
                fail = 1;
		}
        r->loc = *source;
        r->severity = severity;
        r->Msgtext = Msgtext;
        r->grammar = grammar;

        c = reports.back; while (earlier(&r->loc,&c->loc)) c = c->back;
        r->forward = c->forward; c->forward = r;
        r->back = c; (r->forward)->back = r;

	
	if (severity == DEADLY || fail ) {
		(void)fprintf(stderr," (%d,%d)",source->line,source->col);
		(void)putc('\n', stderr);
                exit(1);
		}
}
