# $Id: Makefile.cpp,v 1.13 1991/09/04 13:00:40 waite Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh

CFLAGS	= -I../err
COFLAGS	= -q

RCS 	= csm.specs csm.c csm.h csmtbl.h
SYS	= $(RCS)

TIDY	= core a.out *.o
CLEAN	= $(TIDY)
CLOBBER	= $(CLEAN) Makefile

all:	$(SYS) 

.PRECIOUS:	$(SYS)

install:
	@for f in $(SYS); do \
		echo install -m 644 $$f $(DESTDIR)/Tool/csm; \
		rm -f $(DESTDIR)/Tool/csm/$$f; \
		cp $$f $(DESTDIR)/Tool/csm/$$f; \
		chmod 644 $(DESTDIR)/Tool/csm/$$f; \
		done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp

SourceDistr: $(RCS)

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	-rcsclean $(COFLAGS) $(RCS) Makefile.cpp
	rm -rf $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(RCS)
