
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "ptg_gen.h"

#if defined(__STDC__) || defined (__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { _PrPTGNULL };

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGout (PTGNode r)
#else
PTGNode PTGOut (r)
PTGNode r;
#endif
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
#endif
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
#endif
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGIdent *_PPTGIdent;
struct _SPTGIdent{
  _PTGProc _print;
  int _t0;
};

typedef struct _SPTGInt *_PPTGInt;
struct _SPTGInt{
  _PTGProc _print;
  int _t0;
};

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGAxiom(_PPTG4 n)
#else
static void _PrPTGAxiom(n)
_PPTG4 n;
#endif
{
  fputs ("$CODE\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("$GRAMMAR\n<$START_SYMBOL>: ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (".\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  (* (n->_desc [3]->_print))(n->_desc[3]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGCoding(_PPTG2 n)
#else
static void _PrPTGCoding(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("=", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (".\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGProd(_PPTG2 n)
#else
static void _PrPTGProd(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (":\n\t", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (".\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGStkProd(_PPTG2 n)
#else
static void _PrPTGStkProd(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (":\n\t", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" &'SourceLeaf(ZAttributKeller);' .\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSepList(_PPTG2 n)
#else
static void _PrPTGSepList(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" // ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGAlt(_PPTG2 n)
#else
static void _PrPTGAlt(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" /\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGAltNull(_PPTG1 n)
#else
static void _PrPTGAltNull(n)
_PPTG1 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" / ", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSeq(_PPTG2 n)
#else
static void _PrPTGSeq(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGConnect(_PPTG1 n)
#else
static void _PrPTGConnect(n)
_PPTG1 n;
#endif
{
  fputs ("\n&", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGAtMod(_PPTG1 n)
#else
static void _PrPTGAtMod(n)
_PPTG1 n;
#endif
{
  fputs ("\n@", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGDolMod(_PPTG1 n)
#else
static void _PrPTGDolMod(n)
_PPTG1 n;
#endif
{
  fputs ("\n$", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGOpt(_PPTG1 n)
#else
static void _PrPTGOpt(n)
_PPTG1 n;
#endif
{
  fputs ("[", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("]", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGGroup(_PPTG1 n)
#else
static void _PrPTGGroup(n)
_PPTG1 n;
#endif
{
  fputs ("(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPlus(_PPTG1 n)
#else
static void _PrPTGPlus(n)
_PPTG1 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("+", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGStar(_PPTG1 n)
#else
static void _PrPTGStar(n)
_PPTG1 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("*", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGStack(_PPTG1 n)
#else
static void _PrPTGStack(n)
_PPTG1 n;
#endif
{
  fputs ("'", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("'", f);
}

#if defined(__STDC__) || defined(__cplusplus)
extern void OutSym(FILE *, int);
#else
extern void OutSym();
#endif

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGIdent(_PPTGIdent n)
#else
static void _PrPTGIdent(n)
_PPTGIdent n;
#endif
{
  OutSym(f,n->_t0);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGInt(_PPTGInt n)
#else
static void _PrPTGInt(n)
_PPTGInt n;
#endif
{
  fprintf (f, "%d",n->_t0);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGEof(_PPTG0 n)
#else
static void _PrPTGEof(n)
_PPTG0 n;
#endif
{
  fputs ("EOF", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGLines(_PPTG2 n)
#else
static void _PrPTGLines(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGAxiom(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3)
#else
PTGNode PTGAxiom(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
#endif
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGAxiom;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGCoding(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGCoding(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGCoding;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGProd(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGProd(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGProd;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGStkProd(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGStkProd(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGStkProd;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSepList(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGSepList(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSepList;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGAlt(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGAlt(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGAlt;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGAltNull(PTGNode _t0)
#else
PTGNode PTGAltNull(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGAltNull;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSeq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGConnect(PTGNode _t0)
#else
PTGNode PTGConnect(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGConnect;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGAtMod(PTGNode _t0)
#else
PTGNode PTGAtMod(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGAtMod;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGDolMod(PTGNode _t0)
#else
PTGNode PTGDolMod(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGDolMod;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOpt(PTGNode _t0)
#else
PTGNode PTGOpt(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGOpt;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGGroup(PTGNode _t0)
#else
PTGNode PTGGroup(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGGroup;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPlus(PTGNode _t0)
#else
PTGNode PTGPlus(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPlus;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGStar(PTGNode _t0)
#else
PTGNode PTGStar(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGStar;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGStack(PTGNode _t0)
#else
PTGNode PTGStack(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGStack;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGIdent(int _t0)
#else
PTGNode PTGIdent(_t0)
  int _t0;
#endif
{
  _PPTGIdent n;

  if ((n = (_PPTGIdent) malloc (sizeof (struct _SPTGIdent)))  ==  (_PPTGIdent)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGIdent;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGInt(int _t0)
#else
PTGNode PTGInt(_t0)
  int _t0;
#endif
{
  _PPTGInt n;

  if ((n = (_PPTGInt) malloc (sizeof (struct _SPTGInt)))  ==  (_PPTGInt)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGInt;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGEof()
#else
PTGNode PTGEof()
#endif
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGEof;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGLines(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGLines(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGLines;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

